/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozone.shaded.org.apache.ratis.util;

import java.util.concurrent.Callable;
import java.util.function.Supplier;
import org.apache.ozone.shaded.org.apache.ratis.util.ReflectionUtils;
import org.apache.ozone.shaded.org.apache.ratis.util.function.CheckedRunnable;
import org.apache.ozone.shaded.org.apache.ratis.util.function.CheckedSupplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface LogUtils {
    public static final Logger LOG = LoggerFactory.getLogger(LogUtils.class);

    public static <THROWABLE extends Throwable> void runAndLog(Logger log, CheckedRunnable<THROWABLE> op, Supplier<String> opName) throws THROWABLE {
        try {
            op.run();
        }
        catch (Throwable t2) {
            if (log.isTraceEnabled()) {
                log.trace("Failed to " + opName.get(), t2);
            } else if (log.isWarnEnabled()) {
                log.warn("Failed to " + opName.get() + ": " + t2);
            }
            throw t2;
        }
        if (log.isTraceEnabled()) {
            log.trace("Successfully ran " + opName.get());
        }
    }

    public static <OUTPUT, THROWABLE extends Throwable> OUTPUT supplyAndLog(Logger log, CheckedSupplier<OUTPUT, THROWABLE> supplier, Supplier<String> name) throws THROWABLE {
        OUTPUT output;
        try {
            output = supplier.get();
        }
        catch (Exception e) {
            if (log.isTraceEnabled()) {
                log.trace("Failed to " + name.get(), (Throwable)e);
            } else if (log.isWarnEnabled()) {
                log.warn("Failed to " + name.get() + ": " + e);
            }
            throw e;
        }
        if (log.isTraceEnabled()) {
            log.trace("Successfully supplied " + name.get() + ": " + output);
        }
        return output;
    }

    public static Runnable newRunnable(final Logger log, final Runnable runnable2, final Supplier<String> name) {
        return new Runnable(){

            @Override
            public void run() {
                LogUtils.runAndLog(log, runnable2::run, name);
            }

            public String toString() {
                return (String)name.get();
            }
        };
    }

    public static <T> Callable<T> newCallable(final Logger log, final Callable<T> callable, final Supplier<String> name) {
        return new Callable<T>(){

            @Override
            public T call() throws Exception {
                return LogUtils.supplyAndLog(log, callable::call, name);
            }

            public String toString() {
                return (String)name.get();
            }
        };
    }

    public static <OUTPUT, THROWABLE extends Throwable> CheckedSupplier<OUTPUT, THROWABLE> newCheckedSupplier(final Logger log, final CheckedSupplier<OUTPUT, THROWABLE> supplier, final Supplier<String> name) {
        return new CheckedSupplier<OUTPUT, THROWABLE>(){

            @Override
            public OUTPUT get() throws Throwable {
                return LogUtils.supplyAndLog(log, supplier, name);
            }

            public String toString() {
                return (String)name.get();
            }
        };
    }

    public static void warn(Logger log, Supplier<String> message, Throwable t2, Class<?> ... exceptionClasses) {
        if (log.isWarnEnabled()) {
            if (ReflectionUtils.isInstance(t2, exceptionClasses)) {
                StringBuilder b = new StringBuilder().append(message.get()).append(": ").append(t2);
                for (Throwable cause = t2.getCause(); cause != null; cause = cause.getCause()) {
                    b.append("\n  Caused by: ").append(cause);
                }
                log.warn(b.toString());
            } else {
                log.warn(message.get(), t2);
            }
        }
    }

    public static void infoOrTrace(Logger log, String message, Throwable t2) {
        LogUtils.infoOrTrace(log, () -> message, t2);
    }

    public static void infoOrTrace(Logger log, Supplier<String> message, Throwable t2) {
        if (log.isTraceEnabled()) {
            log.trace(message.get(), t2);
        } else if (log.isInfoEnabled()) {
            log.info("{}: {}", (Object)message.get(), (Object)String.valueOf(t2));
        }
    }
}

