/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozone.shaded.org.apache.ratis.util;

import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import org.apache.ozone.shaded.org.apache.ratis.thirdparty.com.google.common.collect.MapMaker;

public final class BiWeakValueCache<OUTER, INNER, T> {
    private final String outerName;
    private final String innerName;
    private final String name;
    private final BiFunction<OUTER, INNER, T> constructor;
    private final AtomicInteger valueCount = new AtomicInteger(0);
    private final ConcurrentMap<OUTER, ConcurrentMap<INNER, T>> map = new ConcurrentHashMap<OUTER, ConcurrentMap<INNER, T>>();

    static <K, V> ConcurrentMap<K, V> newMap() {
        return new MapMaker().weakValues().makeMap();
    }

    public BiWeakValueCache(String outerName, String innerName, BiFunction<OUTER, INNER, T> constructor) {
        this.outerName = outerName;
        this.innerName = innerName;
        this.name = "(" + outerName + ", " + innerName + ")-cache";
        this.constructor = constructor;
    }

    private T construct(OUTER outer, INNER inner) {
        T constructed = this.constructor.apply(outer, inner);
        Objects.requireNonNull(constructed, "constructed == null");
        this.valueCount.incrementAndGet();
        return constructed;
    }

    public T getOrCreate(OUTER outer, INNER inner) {
        Objects.requireNonNull(outer, () -> this.outerName + " (outer) == null");
        Objects.requireNonNull(inner, () -> this.innerName + " (inner) == null");
        ConcurrentMap innerMap = this.map.computeIfAbsent(outer, k -> BiWeakValueCache.newMap());
        Object computed = innerMap.computeIfAbsent(inner, i -> this.construct(outer, i));
        if ((this.valueCount.get() & 0xFFF) == 0) {
            this.cleanupEmptyInnerMaps();
        }
        return (T)computed;
    }

    int count(OUTER outer) {
        ConcurrentMap innerMap = (ConcurrentMap)this.map.get(outer);
        if (innerMap == null) {
            return 0;
        }
        int n = 0;
        for (Object ignored : innerMap.keySet()) {
            ++n;
        }
        return n;
    }

    void cleanupEmptyInnerMaps() {
        this.map.values().removeIf(e -> !e.entrySet().iterator().hasNext());
    }

    public String toString() {
        return this.name;
    }

    int dump(Consumer<String> out) {
        out.accept(this.name + ":\n");
        int emptyCount = 0;
        for (Map.Entry entry : this.map.entrySet()) {
            Object outer = entry.getKey();
            ConcurrentMap innerMap = (ConcurrentMap)entry.getValue();
            int count = this.count(outer);
            if (count == 0) {
                ++emptyCount;
            }
            out.accept("  " + this.outerName + ":" + outer);
            out.accept(", " + this.innerName + ":" + innerMap.keySet());
            out.accept(", count=" + count);
            out.accept(", size=" + innerMap.size());
            out.accept("\n");
        }
        out.accept("  emptyCount=" + emptyCount);
        out.accept("\n");
        return emptyCount;
    }
}

