/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozone.shaded.org.apache.ratis.util;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.ozone.shaded.org.apache.ratis.util.JavaUtils;

public class AwaitForSignal {
    private final String name;
    private final Lock lock = new ReentrantLock();
    private final Condition condition = this.lock.newCondition();
    private final AtomicReference<AtomicBoolean> signaled = new AtomicReference<AtomicBoolean>(new AtomicBoolean());

    public AwaitForSignal(Object name) {
        this.name = name + "-" + JavaUtils.getClassSimpleName(this.getClass());
    }

    public void await() throws InterruptedException {
        this.lock.lock();
        try {
            AtomicBoolean s2 = this.signaled.get();
            while (!s2.get()) {
                this.condition.await();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean await(long time, TimeUnit unit) throws InterruptedException {
        if (time <= 0L) {
            return false;
        }
        this.lock.lock();
        try {
            if (this.signaled.get().get()) {
                boolean bl = true;
                return bl;
            }
            boolean bl = this.condition.await(time, unit);
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void signal() {
        this.lock.lock();
        try {
            this.signaled.getAndSet(new AtomicBoolean()).set(true);
            this.condition.signalAll();
        }
        finally {
            this.lock.unlock();
        }
    }

    public String toString() {
        return this.name;
    }
}

