/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozone.shaded.org.apache.ratis.metrics.dropwizard3;

import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.apache.ozone.shaded.com.codahale.metrics.ConsoleReporter;
import org.apache.ozone.shaded.com.codahale.metrics.JmxReporter;
import org.apache.ozone.shaded.com.codahale.metrics.ScheduledReporter;
import org.apache.ozone.shaded.org.apache.ratis.metrics.RatisMetricRegistry;
import org.apache.ozone.shaded.org.apache.ratis.metrics.dropwizard3.Dm3RatisMetricRegistryImpl;
import org.apache.ozone.shaded.org.apache.ratis.metrics.dropwizard3.Dm3RatisObjectNameFactory;
import org.apache.ozone.shaded.org.apache.ratis.util.TimeDuration;

final class Dm3MetricsReporting {
    private Dm3MetricsReporting() {
    }

    static Consumer<RatisMetricRegistry> consoleReporter(TimeDuration rate) {
        return registry -> Dm3MetricsReporting.consoleReporter(rate, registry);
    }

    private static void consoleReporter(TimeDuration rate, RatisMetricRegistry registry) {
        Dm3RatisMetricRegistryImpl impl = Dm3RatisMetricRegistryImpl.cast(registry);
        ConsoleReporter reporter = ConsoleReporter.forRegistry(impl.getDropWizardMetricRegistry()).convertRatesTo(TimeUnit.SECONDS).convertDurationsTo(TimeUnit.MILLISECONDS).build();
        reporter.start(rate.getDuration(), rate.getUnit());
        impl.setConsoleReporter(reporter);
    }

    static Consumer<RatisMetricRegistry> stopConsoleReporter() {
        return Dm3MetricsReporting::stopConsoleReporter;
    }

    private static void stopConsoleReporter(RatisMetricRegistry registry) {
        Dm3RatisMetricRegistryImpl impl = Dm3RatisMetricRegistryImpl.cast(registry);
        Optional.ofNullable(impl.getConsoleReporter()).ifPresent(ScheduledReporter::close);
    }

    static Consumer<RatisMetricRegistry> jmxReporter() {
        return Dm3MetricsReporting::jmxReporter;
    }

    private static void jmxReporter(RatisMetricRegistry registry) {
        Dm3RatisMetricRegistryImpl impl = Dm3RatisMetricRegistryImpl.cast(registry);
        JmxReporter reporter = JmxReporter.forRegistry(impl.getDropWizardMetricRegistry()).inDomain(registry.getMetricRegistryInfo().getApplicationName()).createsObjectNamesWith(new Dm3RatisObjectNameFactory()).build();
        reporter.start();
        impl.setJmxReporter(reporter);
    }

    static Consumer<RatisMetricRegistry> stopJmxReporter() {
        return Dm3MetricsReporting::stopJmxReporter;
    }

    private static void stopJmxReporter(RatisMetricRegistry registry) {
        Dm3RatisMetricRegistryImpl impl = Dm3RatisMetricRegistryImpl.cast(registry);
        Optional.ofNullable(impl.getJmxReporter()).ifPresent(JmxReporter::close);
    }
}

