/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozone.shaded.org.apache.commons.validator.routines;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Locale;
import org.apache.ozone.shaded.org.apache.commons.validator.routines.CodeValidator;
import org.apache.ozone.shaded.org.apache.commons.validator.routines.checkdigit.ISINCheckDigit;

public class ISINValidator
implements Serializable {
    private static final long serialVersionUID = -5964391439144260936L;
    private static final String ISIN_REGEX = "([A-Z]{2}[A-Z0-9]{9}[0-9])";
    private static final CodeValidator VALIDATOR = new CodeValidator("([A-Z]{2}[A-Z0-9]{9}[0-9])", 12, ISINCheckDigit.ISIN_CHECK_DIGIT);
    private static final ISINValidator ISIN_VALIDATOR_FALSE = new ISINValidator(false);
    private static final ISINValidator ISIN_VALIDATOR_TRUE = new ISINValidator(true);
    private static final String[] CCODES = Locale.getISOCountries();
    private static final String[] SPECIALS = new String[]{"AA", "AC", "AD", "AE", "AF", "AG", "AI", "AL", "AM", "AN", "AO", "AP", "AQ", "AR", "AS", "AT", "AU", "AW", "AX", "AZ", "BA", "BB", "BD", "BE", "BF", "BG", "BH", "BI", "BJ", "BL", "BM", "BN", "BO", "BQ", "BR", "BS", "BT", "BU", "BV", "BW", "BX", "BY", "BZ", "CA", "CC", "CD", "CF", "CG", "CH", "CI", "CK", "CL", "CM", "CN", "CO", "CP", "CQ", "CR", "CS", "CT", "CU", "CV", "CW", "CX", "CY", "CZ", "DD", "DE", "DG", "DJ", "DK", "DM", "DO", "DY", "DZ", "EA", "EC", "EE", "EF", "EG", "EH", "EM", "EP", "ER", "ES", "ET", "EU", "EV", "EW", "EZ", "FI", "FJ", "FK", "FL", "FM", "FO", "FQ", "FR", "FX", "GA", "GB", "GC", "GD", "GE", "GF", "GG", "GH", "GI", "GL", "GM", "GN", "GP", "GQ", "GR", "GS", "GT", "GU", "GW", "GY", "HK", "HM", "HN", "HR", "HT", "HU", "HV", "IB", "IC", "ID", "IE", "IL", "IM", "IN", "IO", "IQ", "IR", "IS", "IT", "JA", "JE", "JM", "JO", "JP", "JT", "KE", "KG", "KH", "KI", "KM", "KN", "KP", "KR", "KW", "KY", "KZ", "LA", "LB", "LC", "LF", "LI", "LK", "LR", "LS", "LT", "LU", "LV", "LY", "MA", "MC", "MD", "ME", "MF", "MG", "MH", "MI", "MK", "ML", "MM", "MN", "MO", "MP", "MQ", "MR", "MS", "MT", "MU", "MV", "MW", "MX", "MY", "MZ", "NA", "NC", "NE", "NF", "NG", "NH", "NI", "NL", "NO", "NP", "NQ", "NR", "NT", "NU", "NZ", "OA", "OM", "PA", "PC", "PE", "PF", "PG", "PH", "PI", "PK", "PL", "PM", "PN", "PR", "PS", "PT", "PU", "PW", "PY", "PZ", "QA", "QM", "QN", "QO", "QP", "QQ", "QR", "QS", "QT", "QU", "QV", "QW", "QX", "QY", "QZ", "RA", "RB", "RC", "RE", "RH", "RI", "RL", "RM", "RN", "RO", "RP", "RS", "RU", "RW", "SA", "SB", "SC", "SD", "SE", "SF", "SG", "SH", "SI", "SJ", "SK", "SL", "SM", "SN", "SO", "SR", "SS", "ST", "SU", "SV", "SX", "SY", "SZ", "TA", "TC", "TD", "TF", "TG", "TH", "TJ", "TK", "TL", "TM", "TN", "TO", "TP", "TR", "TT", "TV", "TW", "TZ", "UA", "UG", "UK", "UM", "UN", "US", "UY", "UZ", "VA", "VC", "VD", "VE", "VG", "VI", "VN", "VU", "WF", "WG", "WK", "WL", "WO", "WS", "WV", "XA", "XB", "XC", "XD", "XE", "XF", "XG", "XH", "XI", "XJ", "XK", "XL", "XM", "XN", "XO", "XP", "XQ", "XR", "XS", "XT", "XU", "XV", "XW", "XX", "XY", "XZ", "YD", "YE", "YT", "YU", "YV", "ZA", "ZM", "ZR", "ZW", "ZZ"};
    private final boolean checkCountryCode;

    public static ISINValidator getInstance(boolean checkCountryCode) {
        return checkCountryCode ? ISIN_VALIDATOR_TRUE : ISIN_VALIDATOR_FALSE;
    }

    private ISINValidator(boolean checkCountryCode) {
        this.checkCountryCode = checkCountryCode;
    }

    private boolean checkCode(String code) {
        return Arrays.binarySearch(CCODES, code) >= 0 || Arrays.binarySearch(SPECIALS, code) >= 0;
    }

    public boolean isValid(String code) {
        boolean valid = VALIDATOR.isValid(code);
        if (valid && this.checkCountryCode) {
            return this.checkCode(code.substring(0, 2));
        }
        return valid;
    }

    public Object validate(String code) {
        Object validate = VALIDATOR.validate(code);
        if (validate != null && this.checkCountryCode) {
            return this.checkCode(code.substring(0, 2)) ? validate : null;
        }
        return validate;
    }

    static {
        Arrays.sort(CCODES);
        Arrays.sort(SPECIALS);
    }
}

