/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozone.shaded.io.opentelemetry.exporter.internal.otlp;

import java.io.IOException;
import java.util.List;
import org.apache.ozone.shaded.io.opentelemetry.api.common.KeyValue;
import org.apache.ozone.shaded.io.opentelemetry.exporter.internal.marshal.Marshaler;
import org.apache.ozone.shaded.io.opentelemetry.exporter.internal.marshal.MarshalerUtil;
import org.apache.ozone.shaded.io.opentelemetry.exporter.internal.marshal.MarshalerWithSize;
import org.apache.ozone.shaded.io.opentelemetry.exporter.internal.marshal.ProtoFieldInfo;
import org.apache.ozone.shaded.io.opentelemetry.exporter.internal.marshal.Serializer;
import org.apache.ozone.shaded.io.opentelemetry.exporter.internal.otlp.KeyValueMarshaler;
import org.apache.ozone.shaded.io.opentelemetry.proto.common.v1.internal.AnyValue;
import org.apache.ozone.shaded.io.opentelemetry.proto.common.v1.internal.KeyValueList;

final class KeyValueListAnyValueMarshaler
extends MarshalerWithSize {
    private final Marshaler value;

    KeyValueListAnyValueMarshaler(KeyValueListMarshaler value) {
        super(KeyValueListAnyValueMarshaler.calculateSize(value));
        this.value = value;
    }

    static MarshalerWithSize create(List<KeyValue> values2) {
        int len = values2.size();
        KeyValueMarshaler[] marshalers = new KeyValueMarshaler[values2.size()];
        for (int i = 0; i < len; ++i) {
            marshalers[i] = KeyValueMarshaler.createForKeyValue(values2.get(i));
        }
        return new KeyValueListAnyValueMarshaler(new KeyValueListMarshaler(marshalers));
    }

    @Override
    public void writeTo(Serializer output) throws IOException {
        output.serializeMessage(AnyValue.KVLIST_VALUE, this.value);
    }

    private static int calculateSize(Marshaler value) {
        return MarshalerUtil.sizeMessage(AnyValue.KVLIST_VALUE, value);
    }

    static class KeyValueListMarshaler
    extends MarshalerWithSize {
        private final Marshaler[] values;

        KeyValueListMarshaler(KeyValueMarshaler[] values2) {
            super(KeyValueListMarshaler.calculateSize(values2));
            this.values = values2;
        }

        @Override
        public void writeTo(Serializer output) throws IOException {
            output.serializeRepeatedMessage(KeyValueList.VALUES, this.values);
        }

        private static int calculateSize(Marshaler[] values2) {
            return MarshalerUtil.sizeRepeatedMessage((ProtoFieldInfo)KeyValueList.VALUES, (Marshaler[])values2);
        }
    }
}

