/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozone.shaded.io.opentelemetry.exporter.internal.otlp;

import java.nio.ByteBuffer;
import java.util.List;
import org.apache.ozone.shaded.io.opentelemetry.api.common.Value;
import org.apache.ozone.shaded.io.opentelemetry.exporter.internal.marshal.MarshalerWithSize;
import org.apache.ozone.shaded.io.opentelemetry.exporter.internal.otlp.ArrayAnyValueMarshaler;
import org.apache.ozone.shaded.io.opentelemetry.exporter.internal.otlp.BoolAnyValueMarshaler;
import org.apache.ozone.shaded.io.opentelemetry.exporter.internal.otlp.BytesAnyValueMarshaler;
import org.apache.ozone.shaded.io.opentelemetry.exporter.internal.otlp.DoubleAnyValueMarshaler;
import org.apache.ozone.shaded.io.opentelemetry.exporter.internal.otlp.IntAnyValueMarshaler;
import org.apache.ozone.shaded.io.opentelemetry.exporter.internal.otlp.KeyValueListAnyValueMarshaler;
import org.apache.ozone.shaded.io.opentelemetry.exporter.internal.otlp.StringAnyValueMarshaler;

public final class AnyValueMarshaler {
    private AnyValueMarshaler() {
    }

    public static MarshalerWithSize create(Value<?> value) {
        switch (value.getType()) {
            case STRING: {
                return StringAnyValueMarshaler.create((String)value.getValue());
            }
            case BOOLEAN: {
                return BoolAnyValueMarshaler.create((Boolean)value.getValue());
            }
            case LONG: {
                return IntAnyValueMarshaler.create((Long)value.getValue());
            }
            case DOUBLE: {
                return DoubleAnyValueMarshaler.create((Double)value.getValue());
            }
            case ARRAY: {
                return ArrayAnyValueMarshaler.createAnyValue((List)value.getValue());
            }
            case KEY_VALUE_LIST: {
                return KeyValueListAnyValueMarshaler.create((List)value.getValue());
            }
            case BYTES: {
                return BytesAnyValueMarshaler.create((ByteBuffer)value.getValue());
            }
        }
        throw new IllegalArgumentException("Unsupported Value type: " + (Object)((Object)value.getType()));
    }
}

