/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.helpers;

import java.io.IOException;
import java.util.Objects;
import org.apache.hadoop.ozone.om.helpers.BasicOmKeyInfo;
import org.apache.hadoop.ozone.om.helpers.OzoneFileStatus;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;

public class OzoneFileStatusLight {
    private BasicOmKeyInfo keyInfo;
    private boolean isDirectory;
    private long blockSize;

    public OzoneFileStatusLight() {
        this.isDirectory = true;
    }

    public OzoneFileStatusLight(BasicOmKeyInfo keyInfo, long blockSize, boolean isDirectory) {
        this.keyInfo = keyInfo;
        this.isDirectory = isDirectory;
        this.blockSize = blockSize;
    }

    public BasicOmKeyInfo getKeyInfo() {
        return this.keyInfo;
    }

    public long getBlockSize() {
        return this.blockSize;
    }

    public String getTrimmedName() {
        String keyName = this.keyInfo.getKeyName();
        if (keyName.endsWith("/")) {
            return keyName.substring(0, keyName.length() - 1);
        }
        return keyName;
    }

    public String getPath() {
        if (this.keyInfo == null) {
            return "/";
        }
        String path = "/" + this.keyInfo.getKeyName();
        if (path.endsWith("/")) {
            return path.substring(0, path.length() - 1);
        }
        return path;
    }

    public boolean isDirectory() {
        if (this.keyInfo == null) {
            return true;
        }
        return this.isDirectory;
    }

    public boolean isFile() {
        return !this.isDirectory();
    }

    public OzoneManagerProtocolProtos.OzoneFileStatusProtoLight getProtobuf() {
        OzoneManagerProtocolProtos.OzoneFileStatusProtoLight.Builder builder = OzoneManagerProtocolProtos.OzoneFileStatusProtoLight.newBuilder().setBlockSize(this.blockSize).setIsDirectory(this.isDirectory);
        if (this.keyInfo != null) {
            builder.setBasicKeyInfo(this.keyInfo.getProtobuf()).setVolumeName(this.keyInfo.getVolumeName()).setBucketName(this.keyInfo.getBucketName());
        }
        return builder.build();
    }

    public static OzoneFileStatusLight getFromProtobuf(OzoneManagerProtocolProtos.OzoneFileStatusProtoLight status) throws IOException {
        return new OzoneFileStatusLight(BasicOmKeyInfo.getFromProtobuf(status.getVolumeName(), status.getBucketName(), status.getBasicKeyInfo()), status.getBlockSize(), status.getIsDirectory());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof OzoneFileStatusLight)) {
            return false;
        }
        OzoneFileStatusLight that = (OzoneFileStatusLight)o;
        return this.isDirectory == that.isDirectory && this.blockSize == that.blockSize && this.getTrimmedName().equals(that.getTrimmedName());
    }

    public int hashCode() {
        return Objects.hash(this.getTrimmedName());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName());
        sb.append('{');
        if (this.keyInfo == null) {
            sb.append("<root>");
        } else {
            sb.append(this.getTrimmedName());
            if (this.isDirectory) {
                sb.append(" (dir)");
            }
        }
        sb.append('}');
        return sb.toString();
    }

    public static OzoneFileStatusLight fromOzoneFileStatus(OzoneFileStatus ozoneFileStatus) {
        BasicOmKeyInfo basicKeyInfo = BasicOmKeyInfo.fromOmKeyInfo(ozoneFileStatus.getKeyInfo());
        return new OzoneFileStatusLight(basicKeyInfo, ozoneFileStatus.getBlockSize(), ozoneFileStatus.isDirectory());
    }
}

