/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.helpers;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.ozone.om.helpers.OmKeyInfo;
import org.apache.hadoop.ozone.om.helpers.OpenKeySession;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;
import org.apache.ozone.shaded.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.ozone.shaded.com.google.common.base.Preconditions;

public class ListOpenFilesResult {
    @JsonProperty(value="totalOpenKeyCount")
    private final long totalOpenKeyCount;
    @JsonProperty(value="hasMore")
    private final boolean hasMore;
    @JsonProperty(value="contToken")
    private final String continuationToken;
    private final List<OpenKeySession> openKeySessionList;

    public ListOpenFilesResult(long totalOpenKeyCount, boolean hasMore, String continuationToken, List<OpenKeySession> openKeySessionList) {
        this.openKeySessionList = openKeySessionList;
        this.hasMore = hasMore;
        this.continuationToken = continuationToken;
        this.totalOpenKeyCount = totalOpenKeyCount;
    }

    public ListOpenFilesResult(long totalOpenKeyCount, boolean hasMore, String continuationToken, List<Long> clientIDsList, List<OzoneManagerProtocolProtos.KeyInfo> keyInfosList) throws IOException {
        this.openKeySessionList = this.getOpenKeySessionListFromPB(clientIDsList, keyInfosList);
        this.hasMore = hasMore;
        this.continuationToken = continuationToken;
        this.totalOpenKeyCount = totalOpenKeyCount;
    }

    private List<OpenKeySession> getOpenKeySessionListFromPB(List<Long> clientIDsList, List<OzoneManagerProtocolProtos.KeyInfo> keyInfosList) throws IOException {
        Preconditions.checkArgument(clientIDsList.size() == keyInfosList.size(), "clientIDsList size (" + clientIDsList.size() + ") should be the same as keyInfosList's (" + keyInfosList.size() + ")");
        ArrayList<OpenKeySession> res = new ArrayList<OpenKeySession>();
        for (int i = 0; i < clientIDsList.size(); ++i) {
            OmKeyInfo omKeyInfo = OmKeyInfo.getFromProtobuf(keyInfosList.get(i));
            res.add(new OpenKeySession(clientIDsList.get(i), omKeyInfo, omKeyInfo.getLatestVersionLocations().getVersion()));
        }
        return res;
    }

    public long getTotalOpenKeyCount() {
        return this.totalOpenKeyCount;
    }

    public boolean hasMore() {
        return this.hasMore;
    }

    public String getContinuationToken() {
        return this.continuationToken;
    }

    public List<OpenKeySession> getOpenKeys() {
        return this.openKeySessionList;
    }
}

