/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.container.common.helpers;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.Function;
import org.apache.hadoop.hdds.client.BlockID;
import org.apache.hadoop.hdds.protocol.datanode.proto.ContainerProtos;
import org.apache.hadoop.hdds.utils.db.Codec;
import org.apache.hadoop.hdds.utils.db.CodecException;
import org.apache.hadoop.hdds.utils.db.DelegatedCodec;
import org.apache.hadoop.hdds.utils.db.Proto3Codec;
import org.apache.ozone.shaded.org.apache.ratis.thirdparty.com.google.protobuf.TextFormat;

public class BlockData {
    private static final Codec<BlockData> CODEC = new DelegatedCodec<BlockData, ContainerProtos.BlockData>(Proto3Codec.get(ContainerProtos.BlockData.getDefaultInstance(), true), BlockData::getFromProtoBuf, BlockData::getProtoBufMessage, BlockData.class);
    private final BlockID blockID;
    private final Map<String, String> metadata;
    private Object chunkList;
    private long size;

    public BlockData(BlockID blockID) {
        this.blockID = blockID;
        this.metadata = new TreeMap<String, String>();
        this.size = 0L;
    }

    public static Codec<BlockData> getCodec() {
        return CODEC;
    }

    public long getBlockCommitSequenceId() {
        return this.blockID.getBlockCommitSequenceId();
    }

    public void setBlockCommitSequenceId(long blockCommitSequenceId) {
        this.blockID.setBlockCommitSequenceId(blockCommitSequenceId);
    }

    public static BlockData getFromProtoBuf(ContainerProtos.BlockData data) throws CodecException {
        if (data == null) {
            return null;
        }
        BlockData blockData = new BlockData(BlockID.getFromProtobuf(data.getBlockID()));
        for (int x = 0; x < data.getMetadataCount(); ++x) {
            ContainerProtos.KeyValue meta = data.getMetadata(x);
            blockData.addMetadata(meta.getKey(), meta.getValue(), CodecException::new);
        }
        blockData.setChunks(data.getChunksList());
        if (data.hasSize() && data.getSize() != blockData.getSize()) {
            throw new CodecException("Size mismatch: size (=" + data.getSize() + ") != sum of chunks (=" + blockData.getSize() + "), proto: " + TextFormat.shortDebugString(data));
        }
        return blockData;
    }

    public ContainerProtos.BlockData getProtoBufMessage() throws CodecException {
        long sum = BlockData.computeSize(this.getChunks());
        if (sum != this.getSize()) {
            throw new CodecException("Size mismatch: size (=" + this.getSize() + ") != sum of chunks (=" + sum + "), chunks: " + this.chunkList);
        }
        ContainerProtos.BlockData.Builder builder = ContainerProtos.BlockData.newBuilder();
        builder.setBlockID(this.blockID.getDatanodeBlockIDProtobuf());
        for (Map.Entry<String, String> entry : this.metadata.entrySet()) {
            ContainerProtos.KeyValue.Builder keyValBuilder = ContainerProtos.KeyValue.newBuilder();
            builder.addMetadata(keyValBuilder.setKey(entry.getKey()).setValue(entry.getValue()).build());
        }
        builder.addAllChunks(this.getChunks());
        builder.setSize(this.size);
        return builder.build();
    }

    public void addMetadata(String key, String value) throws IOException {
        this.addMetadata(key, value, IOException::new);
    }

    private synchronized <E extends IOException> void addMetadata(String key, String value, Function<String, E> constructor) throws E {
        if (this.metadata.containsKey(key)) {
            throw (IOException)constructor.apply("Key already exists: " + key + " (value: " + value + ")");
        }
        this.metadata.put(key, value);
    }

    public synchronized Map<String, String> getMetadata() {
        return Collections.unmodifiableMap(this.metadata);
    }

    private List<ContainerProtos.ChunkInfo> castChunkList() {
        return (List)this.chunkList;
    }

    public List<ContainerProtos.ChunkInfo> getChunks() {
        return this.chunkList == null ? Collections.emptyList() : (this.chunkList instanceof ContainerProtos.ChunkInfo ? Collections.singletonList((ContainerProtos.ChunkInfo)this.chunkList) : Collections.unmodifiableList(this.castChunkList()));
    }

    public void addChunk(ContainerProtos.ChunkInfo chunkInfo) {
        if (this.chunkList == null) {
            this.chunkList = chunkInfo;
        } else {
            List<ContainerProtos.ChunkInfo> list;
            if (this.chunkList instanceof ContainerProtos.ChunkInfo) {
                list = new ArrayList<ContainerProtos.ChunkInfo>(2);
                list.add((ContainerProtos.ChunkInfo)this.chunkList);
                this.chunkList = list;
            } else {
                list = this.castChunkList();
            }
            list.add(chunkInfo);
        }
        this.size += chunkInfo.getLen();
    }

    public boolean removeChunk(ContainerProtos.ChunkInfo chunkInfo) {
        boolean removed;
        if (this.chunkList instanceof List) {
            List<ContainerProtos.ChunkInfo> list = this.castChunkList();
            removed = list.remove(chunkInfo);
            if (list.size() == 1) {
                this.chunkList = list.get(0);
            }
        } else if (chunkInfo.equals(this.chunkList)) {
            this.chunkList = null;
            removed = true;
        } else {
            removed = false;
        }
        if (removed) {
            this.size -= chunkInfo.getLen();
        }
        return removed;
    }

    public long getContainerID() {
        return this.blockID.getContainerID();
    }

    public long getLocalID() {
        return this.blockID.getLocalID();
    }

    public BlockID getBlockID() {
        return this.blockID;
    }

    public void setChunks(List<ContainerProtos.ChunkInfo> chunks) {
        if (chunks == null) {
            this.chunkList = null;
            this.size = 0L;
        } else {
            int n = chunks.size();
            if (n == 0) {
                this.chunkList = null;
                this.size = 0L;
            } else if (n == 1) {
                ContainerProtos.ChunkInfo singleChunk = chunks.get(0);
                this.chunkList = singleChunk;
                this.size = singleChunk.getLen();
            } else {
                this.chunkList = chunks;
                this.size = BlockData.computeSize(chunks);
            }
        }
    }

    static long computeSize(List<ContainerProtos.ChunkInfo> chunks) {
        return chunks.stream().mapToLong(ContainerProtos.ChunkInfo::getLen).sum();
    }

    public long getSize() {
        return this.size;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(112);
        this.appendTo(sb);
        return sb.toString();
    }

    public void appendTo(StringBuilder sb) {
        sb.append("[blockId=");
        this.blockID.appendTo(sb);
        sb.append(", size=").append(this.size);
        sb.append(']');
    }

    public long getBlockGroupLength() {
        String lenStr = this.getMetadata().get("blockGroupLen");
        return lenStr == null ? 0L : Long.parseLong(lenStr);
    }
}

