/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.utils;

import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.concurrent.TimeUnit;
import org.apache.ozone.shaded.com.google.common.annotations.VisibleForTesting;

public class SlidingWindow {
    private final Object lock = new Object();
    private final int windowSize;
    private final Deque<Long> timestamps;
    private final long expiryDurationMillis;
    private final Clock clock;

    public SlidingWindow(int windowSize, Duration expiryDuration) {
        this(windowSize, expiryDuration, new MonotonicClock());
    }

    public SlidingWindow(int windowSize, Duration expiryDuration, Clock clock) {
        if (windowSize < 0) {
            throw new IllegalArgumentException("Window size must be greater than 0");
        }
        if (expiryDuration.isNegative() || expiryDuration.isZero()) {
            throw new IllegalArgumentException("Expiry duration must be greater than 0");
        }
        this.windowSize = windowSize;
        this.expiryDurationMillis = expiryDuration.toMillis();
        this.clock = clock;
        this.timestamps = new ArrayDeque<Long>(Math.min(windowSize + 1, 100));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add() {
        Object object = this.lock;
        synchronized (object) {
            if (this.isExceeded()) {
                this.timestamps.remove();
            }
            this.timestamps.add(this.getCurrentTime());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isExceeded() {
        Object object = this.lock;
        synchronized (object) {
            this.removeExpired();
            return this.timestamps.size() > this.windowSize;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    public int getNumEvents() {
        Object object = this.lock;
        synchronized (object) {
            this.removeExpired();
            return this.timestamps.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNumEventsInWindow() {
        Object object = this.lock;
        synchronized (object) {
            this.removeExpired();
            return Math.min(this.timestamps.size(), this.windowSize);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeExpired() {
        Object object = this.lock;
        synchronized (object) {
            long currentTime = this.getCurrentTime();
            long expirationThreshold = currentTime - this.expiryDurationMillis;
            while (!this.timestamps.isEmpty() && this.timestamps.peek() < expirationThreshold) {
                this.timestamps.remove();
            }
        }
    }

    public int getWindowSize() {
        return this.windowSize;
    }

    private long getCurrentTime() {
        return this.clock.millis();
    }

    private static final class MonotonicClock
    extends Clock {
        private MonotonicClock() {
        }

        @Override
        public long millis() {
            return TimeUnit.NANOSECONDS.toMillis(System.nanoTime());
        }

        @Override
        public Instant instant() {
            return Instant.ofEpochMilli(this.millis());
        }

        @Override
        public ZoneId getZone() {
            return ZoneOffset.UTC;
        }

        @Override
        public Clock withZone(ZoneId zone) {
            throw new UnsupportedOperationException("Sliding Window class does not allow changing the timezone");
        }
    }
}

