/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.client;

import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.hadoop.hdds.annotation.InterfaceAudience;
import org.apache.hadoop.hdds.annotation.InterfaceStability;
import org.apache.hadoop.hdds.protocol.DatanodeDetails;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.ozone.shaded.com.fasterxml.jackson.core.JsonFactory;
import org.apache.ozone.shaded.com.fasterxml.jackson.core.JsonParser;
import org.apache.ozone.shaded.com.fasterxml.jackson.databind.JsonNode;
import org.apache.ozone.shaded.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.ozone.shaded.com.google.common.base.Strings;
import org.apache.ozone.shaded.jakarta.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
@InterfaceStability.Stable
public final class DecommissionUtils {
    private static final Logger LOG = LoggerFactory.getLogger(DecommissionUtils.class);

    private DecommissionUtils() {
    }

    public static List<HddsProtos.Node> getDecommissioningNodesList(Stream<HddsProtos.Node> allNodes, String uuid, String ipAddress) {
        List<HddsProtos.Node> decommissioningNodes = !Strings.isNullOrEmpty(uuid) ? allNodes.filter(p -> p.getNodeID().getUuid().equals(uuid)).collect(Collectors.toList()) : (!Strings.isNullOrEmpty(ipAddress) ? allNodes.filter(p -> p.getNodeID().getIpAddress().compareToIgnoreCase(ipAddress) == 0).collect(Collectors.toList()) : allNodes.collect(Collectors.toList()));
        return decommissioningNodes;
    }

    public static JsonNode getBeansJsonNode(String metricsJson) throws IOException {
        ObjectMapper objectMapper = new ObjectMapper();
        JsonFactory factory = objectMapper.getFactory();
        JsonParser parser = factory.createParser(metricsJson);
        JsonNode jsonNode = (JsonNode)objectMapper.readTree(parser).get("beans").get(0);
        return jsonNode;
    }

    public static int getNumDecomNodes(JsonNode jsonNode) {
        JsonNode totalDecom = jsonNode.get("DecommissioningMaintenanceNodesTotal");
        int numDecomNodes = totalDecom == null ? -1 : Integer.parseInt(totalDecom.toString());
        return numDecomNodes;
    }

    @Nullable
    public static Map<String, Object> getCountsMap(DatanodeDetails datanode, JsonNode counts, int numDecomNodes, Map<String, Object> countsMap, String errMsg) throws IOException {
        for (int i = 1; i <= numDecomNodes; ++i) {
            String datanodeHostName;
            String string = datanodeHostName = counts.get("tag.datanode." + i) != null ? counts.get("tag.datanode." + i).asText() : "";
            if (!datanode.getHostName().equals(datanodeHostName)) continue;
            JsonNode pipelinesDN = counts.get("PipelinesWaitingToCloseDN." + i);
            JsonNode underReplicatedDN = counts.get("UnderReplicatedDN." + i);
            JsonNode unclosedDN = counts.get("UnclosedContainersDN." + i);
            JsonNode startTimeDN = counts.get("StartTimeDN." + i);
            if (pipelinesDN == null || underReplicatedDN == null || unclosedDN == null || startTimeDN == null) {
                throw new IOException(errMsg);
            }
            int pipelines = Integer.parseInt(pipelinesDN.toString());
            double underReplicated = Double.parseDouble(underReplicatedDN.toString());
            double unclosed = Double.parseDouble(unclosedDN.toString());
            long startTime = Long.parseLong(startTimeDN.toString());
            Date date = new Date(startTime);
            SimpleDateFormat formatter = new SimpleDateFormat("dd/MM/yyyy hh:mm:ss z");
            countsMap.put("decommissionStartTime", formatter.format(date));
            countsMap.put("numOfUnclosedPipelines", pipelines);
            countsMap.put("numOfUnderReplicatedContainers", underReplicated);
            countsMap.put("numOfUnclosedContainers", unclosed);
            return countsMap;
        }
        return null;
    }
}

