/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.debug.om;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.List;
import java.util.concurrent.Callable;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.hdds.utils.MetadataKeyFilters;
import org.apache.hadoop.hdds.utils.db.Table;
import org.apache.hadoop.ozone.debug.om.OMDebug;
import org.apache.hadoop.ozone.om.OMMetadataManager;
import org.apache.hadoop.ozone.om.OmMetadataManagerImpl;
import org.apache.hadoop.ozone.om.OzoneManagerUtils;
import org.apache.hadoop.ozone.om.exceptions.OMException;
import org.apache.hadoop.ozone.om.helpers.BucketLayout;
import org.apache.hadoop.ozone.om.helpers.OmBucketInfo;
import org.apache.hadoop.ozone.om.helpers.OmDirectoryInfo;
import org.apache.hadoop.ozone.om.helpers.WithParentObjectId;
import picocli.CommandLine;

@CommandLine.Command(name="prefix", description={"Parse prefix contents"})
public class PrefixParser
implements Callable<Void> {
    @CommandLine.ParentCommand
    private OMDebug parent;
    private final int[] parserStats = new int[Types.values().length];
    @CommandLine.Option(names={"--path"}, required=true, description={"prefixFile Path"})
    private String filePath;
    @CommandLine.Option(names={"--bucket"}, required=true, description={"bucket name"})
    private String bucket;
    @CommandLine.Option(names={"--volume"}, required=true, description={"volume name"})
    private String volume;

    public String getDbPath() {
        return this.parent.getDbPath();
    }

    @Override
    public Void call() throws Exception {
        this.parse(this.volume, this.bucket, this.getDbPath(), this.filePath);
        return null;
    }

    public static void main(String[] args) throws Exception {
        new PrefixParser().call();
    }

    public void parse(String vol, String buck, String db, String file) throws Exception {
        OmBucketInfo info;
        if (!Files.exists(Paths.get(db, new String[0]), new LinkOption[0])) {
            System.out.println("DB path not exist:" + db);
            return;
        }
        System.out.println("FilePath is:" + file);
        System.out.println("Db Path is:" + db);
        OzoneConfiguration conf = new OzoneConfiguration();
        conf.set("ozone.om.db.dirs", db);
        OmMetadataManagerImpl metadataManager = new OmMetadataManagerImpl(conf, null);
        metadataManager.start(conf);
        Path effectivePath = new Path("/");
        java.nio.file.Path p = Paths.get(file, new String[0]);
        String volumeKey = metadataManager.getVolumeKey(vol);
        if (!metadataManager.getVolumeTable().isExist((Object)volumeKey)) {
            System.out.println("Invalid Volume:" + vol);
            metadataManager.stop();
            return;
        }
        int n = Types.VOLUME.ordinal();
        this.parserStats[n] = this.parserStats[n] + 1;
        try {
            info = OzoneManagerUtils.getResolvedBucketInfo((OMMetadataManager)metadataManager, (String)vol, (String)buck);
        }
        catch (OMException e) {
            System.out.println("Invalid Bucket:" + buck);
            metadataManager.stop();
            return;
        }
        BucketLayout bucketLayout = info.getBucketLayout();
        if (!bucketLayout.isFileSystemOptimized()) {
            System.out.println("Prefix tool only works for FileSystem Optimizedbucket. Bucket Layout is:" + bucketLayout);
            metadataManager.stop();
            return;
        }
        long volumeObjectId = metadataManager.getVolumeId(info.getVolumeName());
        long lastObjectId = info.getObjectID();
        WithParentObjectId objectBucketId = new WithParentObjectId();
        objectBucketId.setObjectID(lastObjectId);
        this.dumpInfo(Types.BUCKET, effectivePath, objectBucketId, metadataManager.getBucketKey(vol, buck));
        for (java.nio.file.Path elem : p) {
            String path = metadataManager.getOzonePathKey(volumeObjectId, info.getObjectID(), lastObjectId, elem.toString());
            OmDirectoryInfo directoryInfo = (OmDirectoryInfo)metadataManager.getDirectoryTable().get((Object)path);
            Path tmpPath = this.getEffectivePath(effectivePath, elem.toString());
            if (directoryInfo == null) {
                System.out.println("Given path contains a non-existent directory at:" + tmpPath);
                System.out.println("Dumping files and dirs at level:" + tmpPath.getParent());
                System.out.println();
                int n2 = Types.NON_EXISTENT_DIRECTORY.ordinal();
                this.parserStats[n2] = this.parserStats[n2] + 1;
                break;
            }
            effectivePath = tmpPath;
            this.dumpInfo(Types.INTERMEDIATE_DIRECTORY, effectivePath, (WithParentObjectId)directoryInfo, path);
            lastObjectId = directoryInfo.getObjectID();
        }
        this.dumpTableInfo(Types.DIRECTORY, effectivePath, metadataManager.getDirectoryTable(), volumeObjectId, info.getObjectID(), lastObjectId);
        this.dumpTableInfo(Types.FILE, effectivePath, metadataManager.getKeyTable(this.getBucketLayout()), volumeObjectId, info.getObjectID(), lastObjectId);
        metadataManager.stop();
    }

    public BucketLayout getBucketLayout() {
        return BucketLayout.FILE_SYSTEM_OPTIMIZED;
    }

    private <T extends WithParentObjectId> void dumpTableInfo(Types type, Path effectivePath, Table<String, T> table, long volumeId, long bucketId, long lastObjectId) throws IOException {
        MetadataKeyFilters.KeyPrefixFilter filter = PrefixParser.getPrefixFilter(volumeId, bucketId, lastObjectId);
        List infoList = table.getRangeKVs(null, 1000, null, filter, false);
        for (Table.KeyValue info : infoList) {
            java.nio.file.Path key = Paths.get((String)info.getKey(), new String[0]);
            this.dumpInfo(type, this.getEffectivePath(effectivePath, key.getName(1).toString()), (WithParentObjectId)info.getValue(), (String)info.getKey());
        }
    }

    private Path getEffectivePath(Path currentPath, String name) {
        return new Path(currentPath, name);
    }

    private void dumpInfo(Types level, Path effectivePath, WithParentObjectId id, String key) {
        int n = level.ordinal();
        this.parserStats[n] = this.parserStats[n] + 1;
        System.out.println("Type:" + (Object)((Object)level));
        System.out.println("Path: " + effectivePath);
        System.out.println("DB Path: " + key);
        System.out.println("Object Id: " + id.getObjectID());
        System.out.println("Parent object Id: " + id.getParentObjectID());
        System.out.println();
    }

    private static MetadataKeyFilters.KeyPrefixFilter getPrefixFilter(long volumeId, long bucketId, long parentId) {
        String key = "/" + volumeId + "/" + bucketId + "/" + parentId;
        return MetadataKeyFilters.KeyPrefixFilter.newFilter((String)key);
    }

    public int getParserStats(Types type) {
        return this.parserStats[type.ordinal()];
    }

    public static enum Types {
        VOLUME,
        BUCKET,
        FILE,
        DIRECTORY,
        INTERMEDIATE_DIRECTORY,
        NON_EXISTENT_DIRECTORY;

    }
}

