/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.debug.logs.container;

import java.nio.file.Path;
import java.util.concurrent.Callable;
import org.apache.hadoop.hdds.cli.AbstractSubcommand;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.scm.container.ReplicationManagerReport;
import org.apache.hadoop.ozone.debug.logs.container.ContainerLogController;
import org.apache.hadoop.ozone.debug.logs.container.utils.ContainerDatanodeDatabase;
import org.apache.hadoop.ozone.shell.ListLimitOptions;
import picocli.CommandLine;

@CommandLine.Command(name="list", description={"Finds containers from the database based on the option provided."})
public class ListContainers
extends AbstractSubcommand
implements Callable<Void> {
    @CommandLine.ArgGroup(multiplicity="1")
    private ExclusiveOptions exclusiveOptions;
    @CommandLine.Mixin
    private ListLimitOptions listOptions;
    @CommandLine.ParentCommand
    private ContainerLogController parent;

    @Override
    public Void call() throws Exception {
        Path dbPath = this.parent.resolveDbPath();
        ContainerDatanodeDatabase cdd = new ContainerDatanodeDatabase(dbPath.toString());
        if (this.exclusiveOptions.lifecycleState != null) {
            cdd.listContainersByState(this.exclusiveOptions.lifecycleState.name(), this.listOptions.getLimit());
        } else if (this.exclusiveOptions.healthState != null) {
            switch (this.exclusiveOptions.healthState) {
                case UNDER_REPLICATED: 
                case OVER_REPLICATED: {
                    cdd.listReplicatedContainers(this.exclusiveOptions.healthState.name(), this.listOptions.getLimit());
                    break;
                }
                case UNHEALTHY: {
                    cdd.listUnhealthyContainers(this.listOptions.getLimit());
                    break;
                }
                case QUASI_CLOSED_STUCK: {
                    cdd.listQuasiClosedStuckContainers(this.listOptions.getLimit());
                    break;
                }
                default: {
                    this.err().println("Unsupported health state: " + this.exclusiveOptions.healthState);
                }
            }
        }
        return null;
    }

    private static final class ExclusiveOptions {
        @CommandLine.Option(names={"--lifecycle"}, description={"Life cycle state of the container."})
        private HddsProtos.LifeCycleState lifecycleState;
        @CommandLine.Option(names={"--health"}, description={"Health state of the container."})
        private ReplicationManagerReport.HealthState healthState;

        private ExclusiveOptions() {
        }
    }
}

