/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.debug.audit.parser.common;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.ozone.debug.audit.parser.model.AuditEntry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DatabaseHelper {
    private static final Logger LOG;
    private static Map<String, String> properties;

    private DatabaseHelper() {
    }

    public static boolean setup(String dbName, String logs) throws Exception {
        if (DatabaseHelper.createAuditTable(dbName)) {
            return DatabaseHelper.insertAudits(dbName, logs);
        }
        return false;
    }

    private static Connection getConnection(String dbName) throws Exception {
        Class.forName("org.sqlite.JDBC");
        return DriverManager.getConnection("jdbc:sqlite:" + dbName);
    }

    private static void loadProperties() {
        Properties props = new Properties();
        try {
            InputStream inputStream = DatabaseHelper.class.getClassLoader().getResourceAsStream("commands.properties");
            if (inputStream == null) {
                throw new FileNotFoundException("property file 'commands.properties' not found in the classpath");
            }
            props.load(inputStream);
            properties = props.entrySet().stream().collect(Collectors.toMap(e -> e.getKey().toString(), e -> e.getValue().toString()));
        }
        catch (Exception e2) {
            LOG.error(e2.getMessage());
        }
    }

    private static boolean createAuditTable(String dbName) throws Exception {
        try (Connection connection = DatabaseHelper.getConnection(dbName);
             Statement st = connection.createStatement();){
            st.executeUpdate(properties.get("createAuditTable"));
        }
        return true;
    }

    private static boolean insertAudits(String dbName, String logs) throws Exception {
        try (Connection connection = DatabaseHelper.getConnection(dbName);
             PreparedStatement preparedStatement = connection.prepareStatement(properties.get("insertAuditEntry"));){
            ArrayList<AuditEntry> auditEntries = DatabaseHelper.parseAuditLogs(logs);
            int batchSize = 1000;
            int count = 0;
            for (AuditEntry audit : auditEntries) {
                preparedStatement.setString(1, audit.getTimestamp());
                preparedStatement.setString(2, audit.getLevel());
                preparedStatement.setString(3, audit.getLogger());
                preparedStatement.setString(4, audit.getUser());
                preparedStatement.setString(5, audit.getIp());
                preparedStatement.setString(6, audit.getOp());
                preparedStatement.setString(7, audit.getParams());
                preparedStatement.setString(8, audit.getResult());
                preparedStatement.setString(9, audit.getException());
                preparedStatement.addBatch();
                if (++count % 1000 != 0) continue;
                preparedStatement.executeBatch();
            }
            if (auditEntries.size() % 1000 != 0) {
                preparedStatement.executeBatch();
            }
        }
        return true;
    }

    private static ArrayList<AuditEntry> parseAuditLogs(String filePath) throws IOException {
        ArrayList<AuditEntry> listResult = new ArrayList<AuditEntry>();
        try (InputStream fis = Files.newInputStream(Paths.get(filePath, new String[0]), new OpenOption[0]);
             InputStreamReader isr = new InputStreamReader(fis, StandardCharsets.UTF_8);
             BufferedReader bReader = new BufferedReader(isr);){
            String currentLine = bReader.readLine();
            String nextLine = bReader.readLine();
            AuditEntry tempEntry = null;
            while (true) {
                if (tempEntry == null) {
                    tempEntry = new AuditEntry();
                }
                if (currentLine == null) {
                    break;
                }
                if (!currentLine.matches("^\\d{4}-\\d{2}-\\d{2}.*$")) {
                    tempEntry.appendException(currentLine);
                } else {
                    String[] entry = StringUtils.stripAll((String[])currentLine.split("\\|"));
                    String[] ops = entry[5].substring(entry[5].indexOf(61) + 1).split(" ", 2);
                    tempEntry = new AuditEntry.Builder().setTimestamp(entry[0]).setLevel(entry[1]).setLogger(entry[2]).setUser(entry[3].substring(entry[3].indexOf(61) + 1)).setIp(entry[4].substring(entry[4].indexOf(61) + 1)).setOp(ops[0]).setParams(ops[1]).setResult(entry[6].substring(entry[6].indexOf(61) + 1)).build();
                    if (entry.length == 8) {
                        tempEntry.setException(entry[7]);
                    }
                }
                if (nextLine == null || nextLine.matches("^\\d{4}-\\d{2}-\\d{2}.*$")) {
                    listResult.add(tempEntry);
                    tempEntry = null;
                }
                currentLine = nextLine;
                nextLine = bReader.readLine();
            }
        }
        return listResult;
    }

    public static String executeCustomQuery(String dbName, String query) throws Exception {
        return DatabaseHelper.executeStatement(dbName, query);
    }

    public static String executeTemplate(String dbName, String template) throws Exception {
        return DatabaseHelper.executeStatement(dbName, properties.get(template));
    }

    private static String executeStatement(String dbName, String sql) throws Exception {
        StringBuilder result = new StringBuilder();
        try (Connection connection = DatabaseHelper.getConnection(dbName);
             PreparedStatement ps = connection.prepareStatement(sql);
             ResultSet rs = ps.executeQuery();){
            if (rs != null) {
                ResultSetMetaData rsm = rs.getMetaData();
                int cols = rsm.getColumnCount();
                while (rs.next()) {
                    for (int index = 1; index <= cols; ++index) {
                        result.append(rs.getObject(index));
                        result.append('\t');
                    }
                    result.append('\n');
                }
            }
        }
        return result.toString();
    }

    public static boolean validateTemplate(String templateName) {
        return properties.get(templateName) != null;
    }

    static {
        DatabaseHelper.loadProperties();
        LOG = LoggerFactory.getLogger(DatabaseHelper.class);
    }
}

