/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.ha;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdds.HddsUtils;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.hdds.ratis.ServerNotLeaderException;
import org.apache.hadoop.hdds.scm.container.ContainerNotFoundException;
import org.apache.hadoop.hdds.scm.exceptions.SCMException;
import org.apache.hadoop.hdds.scm.ha.NonRetriableException;
import org.apache.hadoop.hdds.scm.ha.RetriableWithNoFailoverException;
import org.apache.hadoop.hdds.scm.pipeline.PipelineNotFoundException;
import org.apache.hadoop.hdds.server.ServerUtils;
import org.apache.hadoop.io.retry.RetryPolicy;
import org.apache.hadoop.ipc.RemoteException;
import org.apache.hadoop.ozone.ha.ConfUtils;
import org.apache.hadoop.security.AccessControlException;
import org.apache.ratis.protocol.exceptions.LeaderNotReadyException;
import org.apache.ratis.protocol.exceptions.NotLeaderException;
import org.apache.ratis.protocol.exceptions.ReconfigurationInProgressException;
import org.apache.ratis.protocol.exceptions.ReconfigurationTimeoutException;
import org.apache.ratis.protocol.exceptions.ResourceUnavailableException;
import org.apache.ratis.protocol.exceptions.StateMachineException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SCMHAUtils {
    private static final Logger LOG = LoggerFactory.getLogger(SCMHAUtils.class);
    private static final ImmutableList<Class<? extends Exception>> RETRIABLE_WITH_NO_FAILOVER_EXCEPTION_LIST = ImmutableList.builder().add(LeaderNotReadyException.class).add(ReconfigurationInProgressException.class).add(ReconfigurationTimeoutException.class).add(ResourceUnavailableException.class).build();
    private static final ImmutableList<Class<? extends Exception>> NON_RETRIABLE_EXCEPTION_LIST = ImmutableList.builder().add(SCMException.class).add(NonRetriableException.class).add(PipelineNotFoundException.class).add(ContainerNotFoundException.class).build();

    private SCMHAUtils() {
    }

    public static String getPrimordialSCM(ConfigurationSource conf) {
        return conf.get("ozone.scm.primordial.node.id");
    }

    public static boolean isPrimordialSCM(ConfigurationSource conf, String selfNodeId, String hostName) {
        String primordialNode = SCMHAUtils.getPrimordialSCM(conf);
        return primordialNode != null && (primordialNode.equals(selfNodeId) || primordialNode.equals(hostName));
    }

    public static String getSCMRatisDirectory(ConfigurationSource conf) {
        String scmRatisDirectory = conf.get("ozone.scm.ha.ratis.storage.dir");
        if (Strings.isNullOrEmpty((String)scmRatisDirectory)) {
            scmRatisDirectory = ServerUtils.getDefaultRatisDirectory(conf);
        }
        return scmRatisDirectory;
    }

    public static String getRatisStorageDir(ConfigurationSource conf) {
        String storageDir = conf.get("ozone.scm.ha.ratis.storage.dir");
        if (Strings.isNullOrEmpty((String)storageDir)) {
            File metaDirPath = ServerUtils.getOzoneMetaDirPath(conf);
            storageDir = new File(metaDirPath, "scm-ha").getPath();
        }
        return storageDir;
    }

    public static String getSCMRatisSnapshotDirectory(ConfigurationSource conf) {
        String snapshotDir = conf.get("ozone.scm.ha.ratis.snapshot.dir");
        if (Strings.isNullOrEmpty((String)snapshotDir)) {
            LOG.warn("SCM snapshot dir is not configured. Falling back to {} config", (Object)"ozone.metadata.dirs");
            File metaDirPath = ServerUtils.getOzoneMetaDirPath(conf);
            snapshotDir = Paths.get(metaDirPath.getPath(), "snapshot").toString();
        }
        return snapshotDir;
    }

    public static OzoneConfiguration removeSelfId(OzoneConfiguration configuration, String selfId) {
        OzoneConfiguration conf = new OzoneConfiguration((Configuration)configuration);
        String scmNodesKey = ConfUtils.addKeySuffixes((String)"ozone.scm.nodes", (String[])new String[]{HddsUtils.getScmServiceId((ConfigurationSource)conf)});
        String scmNodes = conf.get(scmNodesKey);
        if (scmNodes != null) {
            String[] parts = scmNodes.split(",");
            ArrayList<String> partsLeft = new ArrayList<String>();
            for (String part : parts) {
                if (part.equals(selfId)) continue;
                partsLeft.add(part);
            }
            conf.set(scmNodesKey, String.join((CharSequence)",", partsLeft));
        }
        return conf;
    }

    public static Throwable unwrapException(Exception e) {
        Throwable cause = e.getCause();
        if (e instanceof RemoteException) {
            return ((RemoteException)e).unwrapRemoteException();
        }
        if (cause instanceof RemoteException) {
            return ((RemoteException)cause).unwrapRemoteException();
        }
        return e;
    }

    public static boolean isNonRetriableException(Exception e) {
        Throwable t = SCMHAUtils.getExceptionForClass(e, StateMachineException.class);
        return t != null;
    }

    public static boolean checkNonRetriableException(Exception e) {
        Throwable t = SCMHAUtils.unwrapException(e);
        for (Class clazz : NON_RETRIABLE_EXCEPTION_LIST) {
            if (!clazz.isInstance(t)) continue;
            return true;
        }
        return false;
    }

    public static boolean isRetriableWithNoFailoverException(Exception e) {
        for (Throwable t = e; t != null; t = t.getCause()) {
            for (Class<? extends Exception> clazz : SCMHAUtils.getRetriableWithNoFailoverExceptionList()) {
                if (!clazz.isInstance(t)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean checkRetriableWithNoFailoverException(Exception e) {
        Throwable t = SCMHAUtils.unwrapException(e);
        return RetriableWithNoFailoverException.class.isInstance(t);
    }

    public static Throwable getNotLeaderException(Exception e) {
        return SCMHAUtils.getExceptionForClass(e, NotLeaderException.class);
    }

    public static Throwable getServerNotLeaderException(Exception e) {
        return SCMHAUtils.getExceptionForClass(e, ServerNotLeaderException.class);
    }

    public static Throwable getExceptionForClass(Exception e, Class<? extends Exception> clazz) {
        Throwable t;
        IOException ioException = null;
        Throwable cause = e.getCause();
        if (cause instanceof RemoteException) {
            ioException = ((RemoteException)cause).unwrapRemoteException();
        }
        Exception exception = t = ioException == null ? e : ioException;
        while (t != null) {
            if (clazz.isInstance(t)) {
                return t;
            }
            t = t.getCause();
        }
        return null;
    }

    private static List<Class<? extends Exception>> getRetriableWithNoFailoverExceptionList() {
        return RETRIABLE_WITH_NO_FAILOVER_EXCEPTION_LIST;
    }

    public static RetryPolicy.RetryAction getRetryAction(int failovers, int retry, Exception e, int maxRetryCount, long retryInterval) {
        Throwable unwrappedException = HddsUtils.getUnwrappedException((Exception)e);
        if (unwrappedException instanceof AccessControlException) {
            return RetryPolicy.RetryAction.FAIL;
        }
        if (HddsUtils.shouldNotFailoverOnRpcException((Throwable)unwrappedException)) {
            return RetryPolicy.RetryAction.FAIL;
        }
        if (SCMHAUtils.checkRetriableWithNoFailoverException(e)) {
            if (retry < maxRetryCount) {
                return new RetryPolicy.RetryAction(RetryPolicy.RetryAction.RetryDecision.RETRY, retryInterval);
            }
            return RetryPolicy.RetryAction.FAIL;
        }
        if (SCMHAUtils.checkNonRetriableException(e)) {
            return RetryPolicy.RetryAction.FAIL;
        }
        if (failovers < maxRetryCount) {
            return new RetryPolicy.RetryAction(RetryPolicy.RetryAction.RetryDecision.FAILOVER_AND_RETRY, retryInterval);
        }
        return RetryPolicy.RetryAction.FAIL;
    }
}

