/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.client;

import java.util.Objects;
import java.util.regex.Pattern;
import org.apache.hadoop.hdds.client.ReplicationConfig;
import org.apache.hadoop.hdds.conf.Config;
import org.apache.hadoop.hdds.conf.ConfigGroup;
import org.apache.hadoop.hdds.conf.ConfigTag;
import org.apache.hadoop.hdds.conf.ConfigType;
import org.apache.hadoop.hdds.conf.PostConstruct;

@ConfigGroup(prefix="ozone.replication")
public class ReplicationConfigValidator {
    @Config(key="allowed-configs", defaultValue="^((STANDALONE|RATIS)/(ONE|THREE))|(EC/(3-2|6-3|10-4)-(512|1024|2048|4096)k)$", type=ConfigType.STRING, description="Regular expression to restrict enabled replication schemes", tags={ConfigTag.STORAGE})
    private String validationPattern;
    private Pattern compiledValidationPattern;

    public void disableValidation() {
        this.setValidationPattern("");
    }

    public void setValidationPattern(String pattern) {
        if (!Objects.equals(pattern, this.validationPattern)) {
            this.validationPattern = pattern;
            this.compilePattern();
        }
    }

    @PostConstruct
    public void init() {
        this.compilePattern();
    }

    private void compilePattern() {
        this.compiledValidationPattern = this.validationPattern != null && !this.validationPattern.equals("") ? Pattern.compile(this.validationPattern) : null;
    }

    public ReplicationConfig validate(ReplicationConfig replicationConfig) {
        if (this.compiledValidationPattern == null) {
            return replicationConfig;
        }
        String input = replicationConfig.configFormat();
        if (!this.compiledValidationPattern.matcher(input).matches()) {
            throw new IllegalArgumentException("Invalid replication config " + input + ". Config must match the pattern defined by ozone.replication.allowed-configs (" + this.validationPattern + ")");
        }
        return replicationConfig;
    }
}

