/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.recon.upgrade;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import org.apache.hadoop.ozone.recon.ReconContext;
import org.apache.hadoop.ozone.recon.ReconSchemaVersionTableManager;
import org.apache.hadoop.ozone.recon.upgrade.ReconLayoutFeature;
import org.apache.hadoop.ozone.recon.upgrade.ReconUpgradeAction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReconLayoutVersionManager {
    private static final Logger LOG = LoggerFactory.getLogger(ReconLayoutVersionManager.class);
    private final ReconSchemaVersionTableManager schemaVersionTableManager;
    private final ReconContext reconContext;
    private final DataSource dataSource;
    private int currentMLV;

    public ReconLayoutVersionManager(ReconSchemaVersionTableManager schemaVersionTableManager, ReconContext reconContext, DataSource dataSource) throws SQLException {
        this.schemaVersionTableManager = schemaVersionTableManager;
        this.currentMLV = this.determineMLV();
        this.reconContext = reconContext;
        this.dataSource = dataSource;
        ReconLayoutFeature.registerUpgradeActions();
    }

    private int determineMLV() throws SQLException {
        return this.schemaVersionTableManager.getCurrentSchemaVersion();
    }

    private int determineSLV() {
        return Arrays.stream(ReconLayoutFeature.values()).mapToInt(ReconLayoutFeature::getVersion).max().orElse(0);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void finalizeLayoutFeatures() {
        List<ReconLayoutFeature> featuresToFinalize = this.getRegisteredFeatures();
        LOG.debug("Starting finalization of {} features.", (Object)featuresToFinalize.size());
        try (Connection connection = this.dataSource.getConnection();){
            connection.setAutoCommit(false);
            for (ReconLayoutFeature feature : featuresToFinalize) {
                LOG.debug("Processing feature version: {}", (Object)feature.getVersion());
                try {
                    Optional<ReconUpgradeAction> action = feature.getAction(ReconUpgradeAction.UpgradeActionType.FINALIZE);
                    if (action.isPresent()) {
                        LOG.debug("Finalize action found for feature version: {}", (Object)feature.getVersion());
                        this.updateSchemaVersion(feature.getVersion(), connection);
                        action.get().execute(this.dataSource);
                        connection.commit();
                        LOG.info("Feature versioned {} finalized successfully.", (Object)feature.getVersion());
                        continue;
                    }
                    LOG.info("No finalize action found for feature version: {}", (Object)feature.getVersion());
                }
                catch (Exception e) {
                    connection.rollback();
                    this.currentMLV = this.determineMLV();
                    LOG.error("Failed to finalize feature {}. Rolling back changes.", (Object)feature.getVersion(), (Object)e);
                    throw e;
                    return;
                }
            }
        }
        catch (Exception e) {
            LOG.error("Failed to finalize layout features: {}", (Object)e.getMessage());
            this.reconContext.updateErrors(ReconContext.ErrorCode.UPGRADE_FAILURE);
            this.reconContext.updateHealthStatus(new AtomicBoolean(false));
            throw new RuntimeException("Recon failed to finalize layout features. Startup halted.", e);
        }
    }

    protected List<ReconLayoutFeature> getRegisteredFeatures() {
        List<ReconLayoutFeature> allFeatures = Arrays.asList(ReconLayoutFeature.values());
        LOG.info("Current MLV: {}. SLV: {}. Checking features for registration...", (Object)this.currentMLV, (Object)this.determineSLV());
        List<ReconLayoutFeature> registeredFeatures = allFeatures.stream().filter(feature -> feature.getVersion() > this.currentMLV).sorted((a, b) -> Integer.compare(a.getVersion(), b.getVersion())).collect(Collectors.toList());
        return registeredFeatures;
    }

    private void updateSchemaVersion(int newVersion, Connection connection) {
        this.schemaVersionTableManager.updateSchemaVersion(newVersion, connection);
        this.currentMLV = newVersion;
        LOG.info("MLV updated to: " + newVersion);
    }

    public int getCurrentMLV() {
        return this.currentMLV;
    }

    public int getCurrentSLV() {
        return this.determineSLV();
    }
}

