/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.recon;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.inject.Singleton;
import jakarta.annotation.Nonnull;
import java.io.File;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.file.Path;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.concurrent.BlockingQueue;
import java.util.stream.Collectors;
import javax.ws.rs.core.Response;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.hdds.scm.ScmUtils;
import org.apache.hadoop.hdds.scm.ha.SCMNodeDetails;
import org.apache.hadoop.hdds.scm.server.OzoneStorageContainerManager;
import org.apache.hadoop.hdds.scm.server.SCMDatanodeHeartbeatDispatcher;
import org.apache.hadoop.hdds.server.ServerUtils;
import org.apache.hadoop.hdds.utils.Archiver;
import org.apache.hadoop.hdds.utils.HddsServerUtil;
import org.apache.hadoop.hdds.utils.db.Table;
import org.apache.hadoop.hdfs.web.URLConnectionFactory;
import org.apache.hadoop.ozone.OmUtils;
import org.apache.hadoop.ozone.om.helpers.BucketLayout;
import org.apache.hadoop.ozone.om.helpers.OmBucketInfo;
import org.apache.hadoop.ozone.om.helpers.OmDirectoryInfo;
import org.apache.hadoop.ozone.om.helpers.OmKeyInfo;
import org.apache.hadoop.ozone.om.helpers.OmVolumeArgs;
import org.apache.hadoop.ozone.recon.ReconConstants;
import org.apache.hadoop.ozone.recon.api.handlers.BucketHandler;
import org.apache.hadoop.ozone.recon.api.handlers.EntityHandler;
import org.apache.hadoop.ozone.recon.api.types.DUResponse;
import org.apache.hadoop.ozone.recon.api.types.NSSummary;
import org.apache.hadoop.ozone.recon.recovery.ReconOMMetadataManager;
import org.apache.hadoop.ozone.recon.scm.ReconContainerReportQueue;
import org.apache.hadoop.ozone.recon.spi.ReconNamespaceSummaryManager;
import org.apache.hadoop.ozone.recon.tasks.NSSummaryTask;
import org.apache.hadoop.security.authentication.client.AuthenticationException;
import org.apache.ozone.recon.schema.generated.tables.daos.GlobalStatsDao;
import org.apache.ozone.recon.schema.generated.tables.pojos.GlobalStats;
import org.jooq.Configuration;
import org.jooq.ResultQuery;
import org.jooq.SelectField;
import org.jooq.impl.DSL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class ReconUtils {
    private static Logger log = LoggerFactory.getLogger(ReconUtils.class);

    public static NSSummaryTask.RebuildState getNSSummaryRebuildState() {
        return NSSummaryTask.getRebuildState();
    }

    public static File getReconScmDbDir(ConfigurationSource conf) {
        return new ReconUtils().getReconDbDir(conf, "ozone.recon.scm.db.dirs");
    }

    @Nonnull
    public static List<BlockingQueue<SCMDatanodeHeartbeatDispatcher.ContainerReport>> initContainerReportQueue(OzoneConfiguration configuration) {
        int threadPoolSize = configuration.getInt(ScmUtils.getContainerReportConfPrefix() + ".thread.pool.size", 10);
        int queueSize = configuration.getInt(ScmUtils.getContainerReportConfPrefix() + ".queue.size", 100000);
        ArrayList<BlockingQueue<SCMDatanodeHeartbeatDispatcher.ContainerReport>> queues = new ArrayList<BlockingQueue<SCMDatanodeHeartbeatDispatcher.ContainerReport>>();
        for (int i = 0; i < threadPoolSize; ++i) {
            queues.add((BlockingQueue<SCMDatanodeHeartbeatDispatcher.ContainerReport>)((Object)new ReconContainerReportQueue(queueSize)));
        }
        return queues;
    }

    public File getReconDbDir(ConfigurationSource conf, String dirConfigKey) {
        File metadataDir = ServerUtils.getDirectoryFromConfig((ConfigurationSource)conf, (String)dirConfigKey, (String)"Recon");
        if (metadataDir != null) {
            return metadataDir;
        }
        log.warn("{} is not configured. We recommend adding this setting. Falling back to {} instead.", (Object)dirConfigKey, (Object)"ozone.metadata.dirs");
        return ServerUtils.getOzoneMetaDirPath((ConfigurationSource)conf);
    }

    public static File createTarFile(Path sourcePath) throws IOException {
        String source = StringUtils.removeEnd((String)sourcePath.toString(), (String)"/");
        File tarFile = new File(source.concat(".tar"));
        Archiver.create((File)tarFile, (Path)sourcePath);
        return tarFile;
    }

    public void untarCheckpointFile(File tarFile, Path destPath) throws IOException {
        Archiver.extract((File)tarFile, (Path)destPath);
    }

    public static String constructFullPath(OmKeyInfo omKeyInfo, ReconNamespaceSummaryManager reconNamespaceSummaryManager) throws IOException {
        return ReconUtils.constructFullPath(omKeyInfo.getKeyName(), omKeyInfo.getParentObjectID(), omKeyInfo.getVolumeName(), omKeyInfo.getBucketName(), reconNamespaceSummaryManager);
    }

    public static String constructFullPath(String keyName, long initialParentId, String volumeName, String bucketName, ReconNamespaceSummaryManager reconNamespaceSummaryManager) throws IOException {
        StringBuilder fullPath = ReconUtils.constructFullPathPrefix(initialParentId, volumeName, bucketName, reconNamespaceSummaryManager);
        if (fullPath.length() == 0) {
            return "";
        }
        fullPath.append(keyName);
        return fullPath.toString();
    }

    public static StringBuilder constructFullPathPrefix(long initialParentId, String volumeName, String bucketName, ReconNamespaceSummaryManager reconNamespaceSummaryManager) throws IOException {
        StringBuilder fullPath = new StringBuilder();
        long parentId = initialParentId;
        boolean isDirectoryPresent = false;
        ArrayList<String> pathSegments = new ArrayList<String>();
        while (parentId != 0L) {
            NSSummary nsSummary = reconNamespaceSummaryManager.getNSSummary(parentId);
            if (nsSummary == null) {
                log.warn("NSSummary tree is currently being rebuilt or the directory could be in the progress of deletion, returning empty string for path construction.");
                fullPath.setLength(0);
                return fullPath;
            }
            if (!nsSummary.getDirName().isEmpty()) {
                pathSegments.add(nsSummary.getDirName());
            }
            parentId = nsSummary.getParentId();
            isDirectoryPresent = true;
        }
        fullPath.append(volumeName).append("/").append(bucketName).append("/");
        for (int i = pathSegments.size() - 1; i >= 0; --i) {
            fullPath.append((String)pathSegments.get(i)).append("/");
        }
        if (isDirectoryPresent && fullPath.indexOf("//") >= 0) {
            String path = fullPath.toString();
            fullPath.setLength(0);
            fullPath.append(OmUtils.normalizeKey((String)path, (boolean)true));
        }
        return fullPath;
    }

    public static String convertToObjectPathForOpenKeySearch(String prevKeyPrefix, ReconOMMetadataManager omMetadataManager, ReconNamespaceSummaryManager reconNamespaceSummaryManager, OzoneStorageContainerManager reconSCM) throws IOException {
        try {
            String[] names = EntityHandler.parseRequestPath(EntityHandler.normalizePath(prevKeyPrefix, BucketLayout.FILE_SYSTEM_OPTIMIZED));
            Table openFileTable = omMetadataManager.getOpenKeyTable(BucketLayout.FILE_SYSTEM_OPTIMIZED);
            if (names.length == 0 || names[0].isEmpty()) {
                return prevKeyPrefix;
            }
            String volumeName = names[0];
            ReconUtils.validateNames(volumeName);
            String volumeKey = omMetadataManager.getVolumeKey(volumeName);
            long volumeId = ((OmVolumeArgs)omMetadataManager.getVolumeTable().getSkipCache((Object)volumeKey)).getObjectID();
            if (names.length == 1) {
                return ReconUtils.constructObjectPathWithPrefix(volumeId);
            }
            String bucketName = names[1];
            ReconUtils.validateNames(bucketName);
            String bucketKey = omMetadataManager.getBucketKey(volumeName, bucketName);
            OmBucketInfo bucketInfo = (OmBucketInfo)omMetadataManager.getBucketTable().getSkipCache((Object)bucketKey);
            long bucketId = bucketInfo.getObjectID();
            if (names.length == 2 || bucketInfo.getBucketLayout() != BucketLayout.FILE_SYSTEM_OPTIMIZED) {
                return ReconUtils.constructObjectPathWithPrefix(volumeId, bucketId);
            }
            BucketHandler handler = BucketHandler.getBucketHandler(reconNamespaceSummaryManager, omMetadataManager, reconSCM, bucketInfo);
            if (names.length >= 3) {
                String lastEntiry = names[names.length - 1];
                OmDirectoryInfo dirInfo = handler.getDirInfo(names);
                if (dirInfo != null && dirInfo.getName().equals(lastEntiry)) {
                    return ReconUtils.constructObjectPathWithPrefix(volumeId, bucketId, dirInfo.getObjectID()) + "/";
                }
                long dirID = handler.getDirObjectId(names, names.length);
                String keyKey = ReconUtils.constructObjectPathWithPrefix(volumeId, bucketId, dirID) + "/" + lastEntiry;
                OmKeyInfo keyInfo = (OmKeyInfo)openFileTable.getSkipCache((Object)keyKey);
                if (keyInfo != null && keyInfo.getFileName().equals(lastEntiry)) {
                    return ReconUtils.constructObjectPathWithPrefix(volumeId, bucketId, keyInfo.getParentObjectID()) + "/" + lastEntiry;
                }
                return prevKeyPrefix;
            }
        }
        catch (IllegalArgumentException e) {
            log.error("IllegalArgumentException encountered while converting key prefix to object path: {}", (Object)prevKeyPrefix, (Object)e);
            throw e;
        }
        catch (RuntimeException e) {
            log.error("RuntimeException encountered while converting key prefix to object path: {}", (Object)prevKeyPrefix, (Object)e);
            return prevKeyPrefix;
        }
        return prevKeyPrefix;
    }

    public HttpURLConnection makeHttpCall(URLConnectionFactory connectionFactory, String url, boolean isSpnego) throws IOException, AuthenticationException {
        HttpURLConnection urlConnection = (HttpURLConnection)connectionFactory.openConnection(new URL(url), isSpnego);
        urlConnection.connect();
        return urlConnection;
    }

    public File getLastKnownDB(File reconDbDir, String fileNamePrefix) {
        File[] snapshotFiles;
        String lastKnownSnapshotFileName = null;
        File lastKnownSnapshotFile = null;
        long lastKnonwnSnapshotTs = Long.MIN_VALUE;
        if (reconDbDir != null && (snapshotFiles = reconDbDir.listFiles((dir, name) -> name.startsWith(fileNamePrefix))) != null) {
            for (File snapshotFile : snapshotFiles) {
                String fileName = snapshotFile.getName();
                try {
                    long snapshotTimestamp;
                    String[] fileNameSplits = fileName.split("_");
                    if (fileNameSplits.length <= 1 || lastKnonwnSnapshotTs >= (snapshotTimestamp = Long.parseLong(fileNameSplits[1]))) continue;
                    if (lastKnownSnapshotFile != null) {
                        try {
                            FileUtils.forceDelete(lastKnownSnapshotFile);
                        }
                        catch (IOException e) {
                            log.warn("Error deleting existing om db snapshot directory: {}", (Object)lastKnownSnapshotFile.getAbsolutePath());
                        }
                    }
                    lastKnonwnSnapshotTs = snapshotTimestamp;
                    lastKnownSnapshotFileName = fileName;
                    lastKnownSnapshotFile = snapshotFile;
                }
                catch (NumberFormatException nfEx) {
                    log.warn("Unknown file found in Recon DB dir : {}", (Object)fileName);
                    FileUtils.deleteQuietly((File)snapshotFile);
                }
            }
        }
        return lastKnownSnapshotFileName == null ? null : new File(reconDbDir.getPath(), lastKnownSnapshotFileName);
    }

    public static void upsertGlobalStatsTable(Configuration sqlConfiguration, GlobalStatsDao globalStatsDao, String key, Long count) {
        Timestamp now = (Timestamp)DSL.using((Configuration)sqlConfiguration).fetchValue((ResultQuery)DSL.select((SelectField)DSL.currentTimestamp()));
        GlobalStats record = globalStatsDao.fetchOneByKey(key);
        GlobalStats newRecord = new GlobalStats(key, count, now);
        if (record == null) {
            globalStatsDao.insert(newRecord);
        } else {
            globalStatsDao.update(newRecord);
        }
    }

    public static String convertNumericToSymbolic(String numericPermissions) {
        int owner = Character.getNumericValue(numericPermissions.charAt(0));
        int group = Character.getNumericValue(numericPermissions.charAt(1));
        int others = Character.getNumericValue(numericPermissions.charAt(2));
        return String.format("%s%s%s", ReconUtils.convertToSymbolicPermission(owner), ReconUtils.convertToSymbolicPermission(group), ReconUtils.convertToSymbolicPermission(others));
    }

    public static String convertToSymbolicPermission(int permission) {
        String[] symbols = new String[]{"---", "--x", "-w-", "-wx", "r--", "r-x", "rw-", "rwx"};
        return symbols[permission];
    }

    public static List<DUResponse.DiskUsage> sortDiskUsageDescendingWithLimit(List<DUResponse.DiskUsage> diskUsageList, int limit) {
        return diskUsageList.parallelStream().sorted((du1, du2) -> Long.compare(du2.getSize(), du1.getSize())).limit(limit).collect(Collectors.toList());
    }

    public static long getFileSizeUpperBound(long fileSize) {
        if (fileSize >= 0x4000000000000L) {
            return Long.MAX_VALUE;
        }
        int binIndex = ReconUtils.getFileSizeBinIndex(fileSize);
        return (long)Math.pow(2.0, 10 + binIndex);
    }

    public static long getContainerSizeUpperBound(long containerSize) {
        if (containerSize >= 0x4000000000000L) {
            return Long.MAX_VALUE;
        }
        int binIndex = ReconUtils.getContainerSizeBinIndex(containerSize);
        return (long)Math.pow(2.0, 29 + binIndex);
    }

    public static int getFileSizeBinIndex(long fileSize) {
        Preconditions.checkArgument((fileSize >= 0L ? 1 : 0) != 0, (String)"fileSize = %s < 0", (long)fileSize);
        if (fileSize >= 0x4000000000000L) {
            return ReconConstants.NUM_OF_FILE_SIZE_BINS - 1;
        }
        int index = ReconUtils.nextClosestPowerIndexOfTwo(fileSize);
        return index < 10 ? 0 : index - 10;
    }

    public static int getContainerSizeBinIndex(long containerSize) {
        Preconditions.checkArgument((containerSize >= 0L ? 1 : 0) != 0, (String)"containerSize = %s < 0", (long)containerSize);
        if (containerSize >= 0x4000000000000L) {
            return ReconConstants.NUM_OF_CONTAINER_SIZE_BINS - 1;
        }
        int index = ReconUtils.nextClosestPowerIndexOfTwo(containerSize);
        return index < 29 ? 0 : index - 29;
    }

    static int nextClosestPowerIndexOfTwo(long n) {
        return n > 0L ? 64 - Long.numberOfLeadingZeros(n - 1L) : (n == 0L ? 0 : (n == Long.MIN_VALUE ? -63 : -ReconUtils.nextClosestPowerIndexOfTwo(-n)));
    }

    public SCMNodeDetails getReconNodeDetails(OzoneConfiguration conf) {
        SCMNodeDetails.Builder builder = new SCMNodeDetails.Builder();
        builder.setSCMNodeId("Recon");
        builder.setDatanodeProtocolServerAddress(HddsServerUtil.getReconDataNodeBindAddress((ConfigurationSource)conf));
        return builder.build();
    }

    @VisibleForTesting
    public static void setLogger(Logger logger) {
        log = logger;
    }

    public static boolean isInitializationComplete(ReconOMMetadataManager omMetadataManager) {
        if (omMetadataManager == null) {
            return false;
        }
        return omMetadataManager.getVolumeTable() != null && omMetadataManager.getBucketTable() != null && omMetadataManager.getDirectoryTable() != null && omMetadataManager.getFileTable() != null && omMetadataManager.getKeyTable(BucketLayout.LEGACY) != null;
    }

    public static long convertToEpochMillis(String dateString, String dateFormat, TimeZone timeZone) {
        String localDateFormat = dateFormat;
        try {
            if (StringUtils.isEmpty((CharSequence)dateString)) {
                return Instant.now().toEpochMilli();
            }
            if (StringUtils.isEmpty((CharSequence)dateFormat)) {
                localDateFormat = "MM-dd-yyyy HH:mm:ss";
            }
            if (null == timeZone) {
                timeZone = TimeZone.getDefault();
            }
            SimpleDateFormat sdf = new SimpleDateFormat(localDateFormat);
            sdf.setTimeZone(timeZone);
            Date date = sdf.parse(dateString);
            return date.getTime();
        }
        catch (ParseException parseException) {
            log.error("Date parse exception for date: {} in format: {} -> {}", new Object[]{dateString, localDateFormat, parseException});
            return Instant.now().toEpochMilli();
        }
        catch (Exception exception) {
            log.error("Unexpected error while parsing date: {} in format: {} -> {}", new Object[]{dateString, localDateFormat, exception});
            return Instant.now().toEpochMilli();
        }
    }

    public static boolean validateStartPrefix(String startPrefix) {
        String[] pathComponents = (startPrefix = startPrefix.startsWith("/") ? startPrefix : "/" + startPrefix).split("/");
        return pathComponents.length >= 3 && !pathComponents[2].isEmpty();
    }

    public static <T> Map<String, T> extractKeysFromTable(Table<String, T> table, String startPrefix, int limit, String prevKey) throws IOException {
        LinkedHashMap<String, Object> matchedKeys = new LinkedHashMap<String, Object>();
        if (table == null) {
            log.error("Table object is null. omMetaManager might still be initializing.");
            return Collections.emptyMap();
        }
        if (limit == 0 || limit < -1) {
            return matchedKeys;
        }
        int actualLimit = limit == -1 ? Integer.MAX_VALUE : limit;
        try (Table.KeyValueIterator keyIter = table.iterator();){
            if (!prevKey.isEmpty()) {
                keyIter.seek((Object)prevKey);
                if (keyIter.hasNext()) {
                    keyIter.next();
                }
            } else if (!startPrefix.isEmpty()) {
                keyIter.seek((Object)startPrefix);
            }
            while (keyIter.hasNext() && matchedKeys.size() < actualLimit) {
                Table.KeyValue entry = (Table.KeyValue)keyIter.next();
                String dbKey = (String)entry.getKey();
                if (!startPrefix.isEmpty() && !dbKey.startsWith(startPrefix)) {
                    break;
                }
                matchedKeys.put(dbKey, entry.getValue());
            }
        }
        catch (IOException exception) {
            log.error("Error retrieving keys from table for path: {}", (Object)startPrefix, (Object)exception);
            throw exception;
        }
        return matchedKeys;
    }

    public static void gatherSubPaths(long parentId, List<String> subPaths, long volumeID, long bucketID, ReconNamespaceSummaryManager reconNamespaceSummaryManager) throws IOException {
        NSSummary parentSummary = reconNamespaceSummaryManager.getNSSummary(parentId);
        if (parentSummary == null) {
            return;
        }
        Set<Long> childDirIds = parentSummary.getChildDir();
        for (Long childId : childDirIds) {
            NSSummary childSummary = reconNamespaceSummaryManager.getNSSummary(childId);
            if (childSummary == null) continue;
            String subPath = ReconUtils.constructObjectPathWithPrefix(volumeID, bucketID, childId);
            subPaths.add(subPath);
            ReconUtils.gatherSubPaths(childId, subPaths, volumeID, bucketID, reconNamespaceSummaryManager);
        }
    }

    public static Response validateNames(String resName) throws IllegalArgumentException {
        if (resName.length() < 3 || resName.length() > 63) {
            throw new IllegalArgumentException("Bucket or Volume name length should be between 3 and 63");
        }
        if (resName.charAt(0) == '.' || resName.charAt(0) == '-' || resName.charAt(resName.length() - 1) == '.' || resName.charAt(resName.length() - 1) == '-') {
            throw new IllegalArgumentException("Bucket or Volume name cannot start or end with hyphen or period");
        }
        if (!resName.matches("^[a-z0-9._-]+$")) {
            throw new IllegalArgumentException("Bucket or Volume name can only contain lowercase letters, numbers, hyphens, underscores, and periods");
        }
        return null;
    }

    public static String constructObjectPathWithPrefix(long ... ids) {
        StringBuilder pathBuilder = new StringBuilder();
        for (long id : ids) {
            pathBuilder.append("/").append(id);
        }
        return pathBuilder.toString();
    }
}

