/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.utils.db.managed;

import org.apache.hadoop.hdds.utils.db.managed.ManagedBlockBasedTableConfig;
import org.apache.hadoop.hdds.utils.db.managed.ManagedRocksObjectUtils;
import org.apache.ratis.util.UncheckedAutoCloseable;
import org.rocksdb.BlockBasedTableConfig;
import org.rocksdb.ColumnFamilyOptions;
import org.rocksdb.TableFormatConfig;

public class ManagedColumnFamilyOptions
extends ColumnFamilyOptions {
    private boolean reused = false;
    private final UncheckedAutoCloseable leakTracker = ManagedRocksObjectUtils.track((AutoCloseable)((Object)this));

    public ManagedColumnFamilyOptions() {
    }

    public ManagedColumnFamilyOptions(ColumnFamilyOptions columnFamilyOptions) {
        super(columnFamilyOptions);
    }

    public synchronized ManagedColumnFamilyOptions setTableFormatConfig(TableFormatConfig tableFormatConfig) {
        TableFormatConfig previous = this.tableFormatConfig();
        if (previous instanceof ManagedBlockBasedTableConfig) {
            if (!((ManagedBlockBasedTableConfig)previous).isClosed()) {
                throw new IllegalStateException("Overriding an unclosed value.");
            }
        } else if (previous != null && !(previous instanceof BlockBasedTableConfig)) {
            throw new UnsupportedOperationException("Overwrite is not supported for " + previous.getClass());
        }
        super.setTableFormatConfig(tableFormatConfig);
        return this;
    }

    public synchronized ManagedColumnFamilyOptions closeAndSetTableFormatConfig(TableFormatConfig tableFormatConfig) {
        TableFormatConfig previous = this.tableFormatConfig();
        if (previous instanceof ManagedBlockBasedTableConfig) {
            ((ManagedBlockBasedTableConfig)previous).close();
        }
        this.setTableFormatConfig(tableFormatConfig);
        return this;
    }

    public void setReused(boolean reused) {
        this.reused = reused;
    }

    public boolean isReused() {
        return this.reused;
    }

    public void close() {
        try {
            super.close();
        }
        finally {
            this.leakTracker.close();
        }
    }

    public static void closeDeeply(ColumnFamilyOptions options) {
        TableFormatConfig tableFormatConfig = options.tableFormatConfig();
        if (tableFormatConfig instanceof ManagedBlockBasedTableConfig) {
            ((ManagedBlockBasedTableConfig)tableFormatConfig).close();
        }
        options.close();
    }
}

