/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.freon;

import com.codahale.metrics.Timer;
import java.io.InputStream;
import java.security.MessageDigest;
import java.util.concurrent.Callable;
import org.apache.commons.io.IOUtils;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdds.cli.HddsVersionProvider;
import org.apache.hadoop.ozone.freon.ContentGenerator;
import org.apache.hadoop.ozone.freon.HadoopBaseFreonGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import picocli.CommandLine;

@CommandLine.Command(name="dfsv", aliases={"dfs-file-validator"}, description={"Validate if the generated files have the same hash."}, versionProvider=HddsVersionProvider.class, mixinStandardHelpOptions=true, showDefaultValues=true)
public class HadoopFsValidator
extends HadoopBaseFreonGenerator
implements Callable<Void> {
    private static final Logger LOG = LoggerFactory.getLogger(HadoopFsValidator.class);
    private ContentGenerator contentGenerator;
    private Timer timer;
    private byte[] referenceDigest;

    @Override
    public Void call() throws Exception {
        super.init();
        Path file = new Path(this.getRootPath() + "/" + this.generateObjectName(0L));
        try (FSDataInputStream stream = this.getFileSystem().open(file);){
            this.referenceDigest = HadoopFsValidator.getDigest((InputStream)stream);
        }
        this.timer = this.getMetrics().timer("file-read");
        this.runTests(this::validateFile);
        return null;
    }

    private void validateFile(long counter) throws Exception {
        Path file = new Path(this.getRootPath() + "/" + this.generateObjectName(counter));
        byte[] content = (byte[])this.timer.time(() -> {
            try (FSDataInputStream input = this.getFileSystem().open(file);){
                byte[] byArray = IOUtils.toByteArray((InputStream)input);
                return byArray;
            }
        });
        if (!MessageDigest.isEqual(this.referenceDigest, HadoopFsValidator.getDigest(content))) {
            throw new IllegalStateException("Reference (=first) message digest doesn't match with digest of " + file.toString());
        }
    }
}

