---
layout: page
title: CVE-2018-8015
---

# Apache ORC denial of service vulnerability

## Date:
2018-05-17

## Severity:

Medium

## Vendor:

[The Apache Software Foundation](https://apache.org)

## Versions Affected:

* ORC 1.0.0 to 1.4.3

## Description:

A malformed ORC file can trigger an endlessly recursive function call in the
C++ or Java parser.

The impact of this bug is most likely denial-of-service against software that
uses the ORC file parser. With the C++ parser, the stack overflow might 
possibly corrupt the stack.

## Mitigation:

* 1.3.x and 1.4.x users should upgrade to 1.4.4.
* 1.0.x to 1.2.x users should apply ORC-360 (Java) and ORC-313 (C++).

## Example:

An ORC file with a struct, union, array, or map type that includes itself as
a child will cause the parser to infinitely recurse until the stack overflows.

## Credit:
This issue was discovered by Terry Chia.

## References:
[Apache ORC security](/security)