/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.pipeline.test;

import com.hazelcast.function.ConsumerEx;
import com.hazelcast.jet.core.test.JetAssert;
import com.hazelcast.jet.impl.util.ExceptionUtil;
import com.hazelcast.jet.pipeline.Sink;
import com.hazelcast.jet.pipeline.test.AssertionCompletedException;
import com.hazelcast.jet.pipeline.test.AssertionSinkBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class AssertionSinks {
    private AssertionSinks() {
    }

    @Nonnull
    public static <T> Sink<T> assertOrdered(@Nullable String message, @Nonnull Collection<? extends T> expected) {
        ArrayList exp = new ArrayList(expected);
        return AssertionSinks.assertCollected(received -> JetAssert.assertEquals(message, exp, received));
    }

    @Nonnull
    public static <T> Sink<T> assertOrdered(@Nonnull Collection<? extends T> expected) {
        return AssertionSinks.assertOrdered(null, expected);
    }

    @Nonnull
    public static <T> Sink<T> assertAnyOrder(@Nullable String message, @Nonnull Collection<? extends T> expected) {
        Map expBag = AssertionSinks.toBag(expected);
        return AssertionSinks.assertCollected(received -> {
            String msg = "Expected and received did not match. The items are printed in the format of a map as follows: {<item>=<num occurrences>}";
            JetAssert.assertEquals((String)(message == null ? msg : message + ", " + msg), expBag, AssertionSinks.toBag(received));
        });
    }

    @Nonnull
    public static <T> Sink<T> assertAnyOrder(@Nonnull Collection<? extends T> expected) {
        return AssertionSinks.assertAnyOrder(null, expected);
    }

    private static <T> Map<T, Long> toBag(Collection<T> coll) {
        return coll.stream().collect(Collectors.groupingBy(c -> c, Collectors.counting()));
    }

    @Nonnull
    public static <T> Sink<T> assertContains(@Nullable String message, @Nonnull Collection<? extends T> expected) {
        HashSet set = new HashSet(expected);
        return AssertionSinkBuilder.assertionSink("assertContains", () -> set).receiveFn(HashSet::remove).completeFn(exp -> JetAssert.assertTrue(message + ", the following items have not been observed: " + exp, exp.isEmpty())).build();
    }

    @Nonnull
    public static <T> Sink<T> assertCollected(@Nonnull ConsumerEx<? super List<T>> assertFn) {
        return AssertionSinkBuilder.assertionSink("assertCollected", ArrayList::new).receiveFn(ArrayList::add).completeFn(assertFn).build();
    }

    @Nonnull
    public static <T> Sink<T> assertCollectedEventually(int timeoutSeconds, @Nonnull ConsumerEx<? super List<T>> assertFn) {
        return AssertionSinkBuilder.assertionSink("assertCollectedEventually", () -> new CollectingSinkWithTimer(assertFn, timeoutSeconds)).receiveFn(CollectingSinkWithTimer::receive).timerFn(CollectingSinkWithTimer::timer).completeFn(CollectingSinkWithTimer::complete).build();
    }

    private static final class CollectingSinkWithTimer<T> {
        private final long start = System.nanoTime();
        private final List<T> collected = new ArrayList<T>();
        private ConsumerEx<? super List<T>> assertFn;
        private long timeoutNanos;
        private AssertionError lastError;

        CollectingSinkWithTimer(ConsumerEx<? super List<T>> assertFn, int timeoutSeconds) {
            this.assertFn = assertFn;
            this.timeoutNanos = TimeUnit.SECONDS.toNanos(timeoutSeconds);
        }

        void receive(T item) {
            this.collected.add(item);
            try {
                this.assertFn.accept(this.collected);
                throw new AssertionCompletedException("Assertion passed successfully");
            }
            catch (AssertionError e) {
                this.lastError = e;
            }
            catch (Exception e) {
                throw ExceptionUtil.rethrow(e);
            }
        }

        void timer() {
            if (System.nanoTime() - this.start > this.timeoutNanos) {
                throw new AssertionError(this.lastError);
            }
        }

        void complete() {
            this.assertFn.accept(this.collected);
        }
    }
}

