/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.http.client.reactive;

import java.net.HttpCookie;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jetty.reactive.client.ReactiveResponse;
import org.reactivestreams.Publisher;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseCookie;
import org.springframework.http.client.reactive.ClientHttpResponse;
import org.springframework.http.support.JettyHeadersAdapter;
import org.springframework.lang.Nullable;
import org.springframework.util.CollectionUtils;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import reactor.core.publisher.Flux;

class JettyClientHttpResponse
implements ClientHttpResponse {
    private static final Pattern SAME_SITE_PATTERN = Pattern.compile("(?i).*SameSite=(Strict|Lax|None).*");
    private final ReactiveResponse reactiveResponse;
    private final Flux<DataBuffer> content;
    private final HttpHeaders headers;

    public JettyClientHttpResponse(ReactiveResponse reactiveResponse, Publisher<DataBuffer> content) {
        this.reactiveResponse = reactiveResponse;
        this.content = Flux.from(content);
        JettyHeadersAdapter headers = new JettyHeadersAdapter(reactiveResponse.getHeaders());
        this.headers = HttpHeaders.readOnlyHttpHeaders(headers);
    }

    @Override
    public HttpStatusCode getStatusCode() {
        return HttpStatusCode.valueOf(this.reactiveResponse.getStatus());
    }

    @Override
    public MultiValueMap<String, ResponseCookie> getCookies() {
        LinkedMultiValueMap result = new LinkedMultiValueMap();
        Object cookieHeader = this.getHeaders().get("Set-Cookie");
        if (cookieHeader != null) {
            cookieHeader.forEach(arg_0 -> JettyClientHttpResponse.lambda$getCookies$1((MultiValueMap)result, arg_0));
        }
        return CollectionUtils.unmodifiableMultiValueMap((MultiValueMap)result);
    }

    @Nullable
    private static String parseSameSite(String headerValue) {
        Matcher matcher = SAME_SITE_PATTERN.matcher(headerValue);
        return matcher.matches() ? matcher.group(1) : null;
    }

    @Override
    public Flux<DataBuffer> getBody() {
        return this.content;
    }

    @Override
    public HttpHeaders getHeaders() {
        return this.headers;
    }

    private static /* synthetic */ void lambda$getCookies$1(MultiValueMap result, String header) {
        HttpCookie.parse(header).forEach(cookie -> result.add((Object)cookie.getName(), (Object)ResponseCookie.fromClientResponse(cookie.getName(), cookie.getValue()).domain(cookie.getDomain()).path(cookie.getPath()).maxAge(cookie.getMaxAge()).secure(cookie.getSecure()).httpOnly(cookie.isHttpOnly()).sameSite(JettyClientHttpResponse.parseSameSite(header)).build()));
    }
}

