/****************************************************************************
 * arch/arm/src/rp23xx/hardware/rp23xx_m33.h
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.  The
 * ASF licenses this file to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 *
 ****************************************************************************/

#ifndef __ARCH_ARM_SRC_RP23XX_HARDWARE_RP23XX_M33_H
#define __ARCH_ARM_SRC_RP23XX_HARDWARE_RP23XX_M33_H

/****************************************************************************
 * Included Files
 ****************************************************************************/

#include "hardware/rp23xx_memorymap.h"

/****************************************************************************
 * Pre-processor Definitions
 ****************************************************************************/

#define RP23XX_M33_ITM_STIM0_OFFSET 0x00000000
#define RP23XX_M33_ITM_STIM0_BITS   0xffffffff
#define RP23XX_M33_ITM_STIM0_RESET  0x00000000

#define RP23XX_M33_ITM_STIM0_STIMULUS_RESET  0x00000000
#define RP23XX_M33_ITM_STIM0_STIMULUS_BITS   0xffffffff
#define RP23XX_M33_ITM_STIM0_STIMULUS_MSB    31
#define RP23XX_M33_ITM_STIM0_STIMULUS_LSB    0
#define RP23XX_M33_ITM_STIM0_STIMULUS_ACCESS "RW"

#define RP23XX_M33_ITM_STIM1_OFFSET 0x00000004
#define RP23XX_M33_ITM_STIM1_BITS   0xffffffff
#define RP23XX_M33_ITM_STIM1_RESET  0x00000000

#define RP23XX_M33_ITM_STIM1_STIMULUS_RESET  0x00000000
#define RP23XX_M33_ITM_STIM1_STIMULUS_BITS   0xffffffff
#define RP23XX_M33_ITM_STIM1_STIMULUS_MSB    31
#define RP23XX_M33_ITM_STIM1_STIMULUS_LSB    0
#define RP23XX_M33_ITM_STIM1_STIMULUS_ACCESS "RW"

#define RP23XX_M33_ITM_STIM2_OFFSET 0x00000008
#define RP23XX_M33_ITM_STIM2_BITS   0xffffffff
#define RP23XX_M33_ITM_STIM2_RESET  0x00000000

#define RP23XX_M33_ITM_STIM2_STIMULUS_RESET  0x00000000
#define RP23XX_M33_ITM_STIM2_STIMULUS_BITS   0xffffffff
#define RP23XX_M33_ITM_STIM2_STIMULUS_MSB    31
#define RP23XX_M33_ITM_STIM2_STIMULUS_LSB    0
#define RP23XX_M33_ITM_STIM2_STIMULUS_ACCESS "RW"

#define RP23XX_M33_ITM_STIM3_OFFSET 0x0000000c
#define RP23XX_M33_ITM_STIM3_BITS   0xffffffff
#define RP23XX_M33_ITM_STIM3_RESET  0x00000000

#define RP23XX_M33_ITM_STIM3_STIMULUS_RESET  0x00000000
#define RP23XX_M33_ITM_STIM3_STIMULUS_BITS   0xffffffff
#define RP23XX_M33_ITM_STIM3_STIMULUS_MSB    31
#define RP23XX_M33_ITM_STIM3_STIMULUS_LSB    0
#define RP23XX_M33_ITM_STIM3_STIMULUS_ACCESS "RW"

#define RP23XX_M33_ITM_STIM4_OFFSET 0x00000010
#define RP23XX_M33_ITM_STIM4_BITS   0xffffffff
#define RP23XX_M33_ITM_STIM4_RESET  0x00000000

#define RP23XX_M33_ITM_STIM4_STIMULUS_RESET  0x00000000
#define RP23XX_M33_ITM_STIM4_STIMULUS_BITS   0xffffffff
#define RP23XX_M33_ITM_STIM4_STIMULUS_MSB    31
#define RP23XX_M33_ITM_STIM4_STIMULUS_LSB    0
#define RP23XX_M33_ITM_STIM4_STIMULUS_ACCESS "RW"

#define RP23XX_M33_ITM_STIM5_OFFSET 0x00000014
#define RP23XX_M33_ITM_STIM5_BITS   0xffffffff
#define RP23XX_M33_ITM_STIM5_RESET  0x00000000

#define RP23XX_M33_ITM_STIM5_STIMULUS_RESET  0x00000000
#define RP23XX_M33_ITM_STIM5_STIMULUS_BITS   0xffffffff
#define RP23XX_M33_ITM_STIM5_STIMULUS_MSB    31
#define RP23XX_M33_ITM_STIM5_STIMULUS_LSB    0
#define RP23XX_M33_ITM_STIM5_STIMULUS_ACCESS "RW"

#define RP23XX_M33_ITM_STIM6_OFFSET 0x00000018
#define RP23XX_M33_ITM_STIM6_BITS   0xffffffff
#define RP23XX_M33_ITM_STIM6_RESET  0x00000000

#define RP23XX_M33_ITM_STIM6_STIMULUS_RESET  0x00000000
#define RP23XX_M33_ITM_STIM6_STIMULUS_BITS   0xffffffff
#define RP23XX_M33_ITM_STIM6_STIMULUS_MSB    31
#define RP23XX_M33_ITM_STIM6_STIMULUS_LSB    0
#define RP23XX_M33_ITM_STIM6_STIMULUS_ACCESS "RW"

#define RP23XX_M33_ITM_STIM7_OFFSET 0x0000001c
#define RP23XX_M33_ITM_STIM7_BITS   0xffffffff
#define RP23XX_M33_ITM_STIM7_RESET  0x00000000

#define RP23XX_M33_ITM_STIM7_STIMULUS_RESET  0x00000000
#define RP23XX_M33_ITM_STIM7_STIMULUS_BITS   0xffffffff
#define RP23XX_M33_ITM_STIM7_STIMULUS_MSB    31
#define RP23XX_M33_ITM_STIM7_STIMULUS_LSB    0
#define RP23XX_M33_ITM_STIM7_STIMULUS_ACCESS "RW"

#define RP23XX_M33_ITM_STIM8_OFFSET 0x00000020
#define RP23XX_M33_ITM_STIM8_BITS   0xffffffff
#define RP23XX_M33_ITM_STIM8_RESET  0x00000000

#define RP23XX_M33_ITM_STIM8_STIMULUS_RESET  0x00000000
#define RP23XX_M33_ITM_STIM8_STIMULUS_BITS   0xffffffff
#define RP23XX_M33_ITM_STIM8_STIMULUS_MSB    31
#define RP23XX_M33_ITM_STIM8_STIMULUS_LSB    0
#define RP23XX_M33_ITM_STIM8_STIMULUS_ACCESS "RW"

#define RP23XX_M33_ITM_STIM9_OFFSET 0x00000024
#define RP23XX_M33_ITM_STIM9_BITS   0xffffffff
#define RP23XX_M33_ITM_STIM9_RESET  0x00000000

#define RP23XX_M33_ITM_STIM9_STIMULUS_RESET  0x00000000
#define RP23XX_M33_ITM_STIM9_STIMULUS_BITS   0xffffffff
#define RP23XX_M33_ITM_STIM9_STIMULUS_MSB    31
#define RP23XX_M33_ITM_STIM9_STIMULUS_LSB    0
#define RP23XX_M33_ITM_STIM9_STIMULUS_ACCESS "RW"

#define RP23XX_M33_ITM_STIM10_OFFSET 0x00000028
#define RP23XX_M33_ITM_STIM10_BITS   0xffffffff
#define RP23XX_M33_ITM_STIM10_RESET  0x00000000

#define RP23XX_M33_ITM_STIM10_STIMULUS_RESET  0x00000000
#define RP23XX_M33_ITM_STIM10_STIMULUS_BITS   0xffffffff
#define RP23XX_M33_ITM_STIM10_STIMULUS_MSB    31
#define RP23XX_M33_ITM_STIM10_STIMULUS_LSB    0
#define RP23XX_M33_ITM_STIM10_STIMULUS_ACCESS "RW"

#define RP23XX_M33_ITM_STIM11_OFFSET 0x0000002c
#define RP23XX_M33_ITM_STIM11_BITS   0xffffffff
#define RP23XX_M33_ITM_STIM11_RESET  0x00000000

#define RP23XX_M33_ITM_STIM11_STIMULUS_RESET  0x00000000
#define RP23XX_M33_ITM_STIM11_STIMULUS_BITS   0xffffffff
#define RP23XX_M33_ITM_STIM11_STIMULUS_MSB    31
#define RP23XX_M33_ITM_STIM11_STIMULUS_LSB    0
#define RP23XX_M33_ITM_STIM11_STIMULUS_ACCESS "RW"

#define RP23XX_M33_ITM_STIM12_OFFSET 0x00000030
#define RP23XX_M33_ITM_STIM12_BITS   0xffffffff
#define RP23XX_M33_ITM_STIM12_RESET  0x00000000

#define RP23XX_M33_ITM_STIM12_STIMULUS_RESET  0x00000000
#define RP23XX_M33_ITM_STIM12_STIMULUS_BITS   0xffffffff
#define RP23XX_M33_ITM_STIM12_STIMULUS_MSB    31
#define RP23XX_M33_ITM_STIM12_STIMULUS_LSB    0
#define RP23XX_M33_ITM_STIM12_STIMULUS_ACCESS "RW"

#define RP23XX_M33_ITM_STIM13_OFFSET 0x00000034
#define RP23XX_M33_ITM_STIM13_BITS   0xffffffff
#define RP23XX_M33_ITM_STIM13_RESET  0x00000000

#define RP23XX_M33_ITM_STIM13_STIMULUS_RESET  0x00000000
#define RP23XX_M33_ITM_STIM13_STIMULUS_BITS   0xffffffff
#define RP23XX_M33_ITM_STIM13_STIMULUS_MSB    31
#define RP23XX_M33_ITM_STIM13_STIMULUS_LSB    0
#define RP23XX_M33_ITM_STIM13_STIMULUS_ACCESS "RW"

#define RP23XX_M33_ITM_STIM14_OFFSET 0x00000038
#define RP23XX_M33_ITM_STIM14_BITS   0xffffffff
#define RP23XX_M33_ITM_STIM14_RESET  0x00000000

#define RP23XX_M33_ITM_STIM14_STIMULUS_RESET  0x00000000
#define RP23XX_M33_ITM_STIM14_STIMULUS_BITS   0xffffffff
#define RP23XX_M33_ITM_STIM14_STIMULUS_MSB    31
#define RP23XX_M33_ITM_STIM14_STIMULUS_LSB    0
#define RP23XX_M33_ITM_STIM14_STIMULUS_ACCESS "RW"

#define RP23XX_M33_ITM_STIM15_OFFSET 0x0000003c
#define RP23XX_M33_ITM_STIM15_BITS   0xffffffff
#define RP23XX_M33_ITM_STIM15_RESET  0x00000000

#define RP23XX_M33_ITM_STIM15_STIMULUS_RESET  0x00000000
#define RP23XX_M33_ITM_STIM15_STIMULUS_BITS   0xffffffff
#define RP23XX_M33_ITM_STIM15_STIMULUS_MSB    31
#define RP23XX_M33_ITM_STIM15_STIMULUS_LSB    0
#define RP23XX_M33_ITM_STIM15_STIMULUS_ACCESS "RW"

#define RP23XX_M33_ITM_STIM16_OFFSET 0x00000040
#define RP23XX_M33_ITM_STIM16_BITS   0xffffffff
#define RP23XX_M33_ITM_STIM16_RESET  0x00000000

#define RP23XX_M33_ITM_STIM16_STIMULUS_RESET  0x00000000
#define RP23XX_M33_ITM_STIM16_STIMULUS_BITS   0xffffffff
#define RP23XX_M33_ITM_STIM16_STIMULUS_MSB    31
#define RP23XX_M33_ITM_STIM16_STIMULUS_LSB    0
#define RP23XX_M33_ITM_STIM16_STIMULUS_ACCESS "RW"

#define RP23XX_M33_ITM_STIM17_OFFSET 0x00000044
#define RP23XX_M33_ITM_STIM17_BITS   0xffffffff
#define RP23XX_M33_ITM_STIM17_RESET  0x00000000

#define RP23XX_M33_ITM_STIM17_STIMULUS_RESET  0x00000000
#define RP23XX_M33_ITM_STIM17_STIMULUS_BITS   0xffffffff
#define RP23XX_M33_ITM_STIM17_STIMULUS_MSB    31
#define RP23XX_M33_ITM_STIM17_STIMULUS_LSB    0
#define RP23XX_M33_ITM_STIM17_STIMULUS_ACCESS "RW"

#define RP23XX_M33_ITM_STIM18_OFFSET 0x00000048
#define RP23XX_M33_ITM_STIM18_BITS   0xffffffff
#define RP23XX_M33_ITM_STIM18_RESET  0x00000000

#define RP23XX_M33_ITM_STIM18_STIMULUS_RESET  0x00000000
#define RP23XX_M33_ITM_STIM18_STIMULUS_BITS   0xffffffff
#define RP23XX_M33_ITM_STIM18_STIMULUS_MSB    31
#define RP23XX_M33_ITM_STIM18_STIMULUS_LSB    0
#define RP23XX_M33_ITM_STIM18_STIMULUS_ACCESS "RW"

#define RP23XX_M33_ITM_STIM19_OFFSET 0x0000004c
#define RP23XX_M33_ITM_STIM19_BITS   0xffffffff
#define RP23XX_M33_ITM_STIM19_RESET  0x00000000

#define RP23XX_M33_ITM_STIM19_STIMULUS_RESET  0x00000000
#define RP23XX_M33_ITM_STIM19_STIMULUS_BITS   0xffffffff
#define RP23XX_M33_ITM_STIM19_STIMULUS_MSB    31
#define RP23XX_M33_ITM_STIM19_STIMULUS_LSB    0
#define RP23XX_M33_ITM_STIM19_STIMULUS_ACCESS "RW"

#define RP23XX_M33_ITM_STIM20_OFFSET 0x00000050
#define RP23XX_M33_ITM_STIM20_BITS   0xffffffff
#define RP23XX_M33_ITM_STIM20_RESET  0x00000000

#define RP23XX_M33_ITM_STIM20_STIMULUS_RESET  0x00000000
#define RP23XX_M33_ITM_STIM20_STIMULUS_BITS   0xffffffff
#define RP23XX_M33_ITM_STIM20_STIMULUS_MSB    31
#define RP23XX_M33_ITM_STIM20_STIMULUS_LSB    0
#define RP23XX_M33_ITM_STIM20_STIMULUS_ACCESS "RW"

#define RP23XX_M33_ITM_STIM21_OFFSET 0x00000054
#define RP23XX_M33_ITM_STIM21_BITS   0xffffffff
#define RP23XX_M33_ITM_STIM21_RESET  0x00000000

#define RP23XX_M33_ITM_STIM21_STIMULUS_RESET  0x00000000
#define RP23XX_M33_ITM_STIM21_STIMULUS_BITS   0xffffffff
#define RP23XX_M33_ITM_STIM21_STIMULUS_MSB    31
#define RP23XX_M33_ITM_STIM21_STIMULUS_LSB    0
#define RP23XX_M33_ITM_STIM21_STIMULUS_ACCESS "RW"

#define RP23XX_M33_ITM_STIM22_OFFSET 0x00000058
#define RP23XX_M33_ITM_STIM22_BITS   0xffffffff
#define RP23XX_M33_ITM_STIM22_RESET  0x00000000

#define RP23XX_M33_ITM_STIM22_STIMULUS_RESET  0x00000000
#define RP23XX_M33_ITM_STIM22_STIMULUS_BITS   0xffffffff
#define RP23XX_M33_ITM_STIM22_STIMULUS_MSB    31
#define RP23XX_M33_ITM_STIM22_STIMULUS_LSB    0
#define RP23XX_M33_ITM_STIM22_STIMULUS_ACCESS "RW"

#define RP23XX_M33_ITM_STIM23_OFFSET 0x0000005c
#define RP23XX_M33_ITM_STIM23_BITS   0xffffffff
#define RP23XX_M33_ITM_STIM23_RESET  0x00000000

#define RP23XX_M33_ITM_STIM23_STIMULUS_RESET  0x00000000
#define RP23XX_M33_ITM_STIM23_STIMULUS_BITS   0xffffffff
#define RP23XX_M33_ITM_STIM23_STIMULUS_MSB    31
#define RP23XX_M33_ITM_STIM23_STIMULUS_LSB    0
#define RP23XX_M33_ITM_STIM23_STIMULUS_ACCESS "RW"

#define RP23XX_M33_ITM_STIM24_OFFSET 0x00000060
#define RP23XX_M33_ITM_STIM24_BITS   0xffffffff
#define RP23XX_M33_ITM_STIM24_RESET  0x00000000

#define RP23XX_M33_ITM_STIM24_STIMULUS_RESET  0x00000000
#define RP23XX_M33_ITM_STIM24_STIMULUS_BITS   0xffffffff
#define RP23XX_M33_ITM_STIM24_STIMULUS_MSB    31
#define RP23XX_M33_ITM_STIM24_STIMULUS_LSB    0
#define RP23XX_M33_ITM_STIM24_STIMULUS_ACCESS "RW"

#define RP23XX_M33_ITM_STIM25_OFFSET 0x00000064
#define RP23XX_M33_ITM_STIM25_BITS   0xffffffff
#define RP23XX_M33_ITM_STIM25_RESET  0x00000000

#define RP23XX_M33_ITM_STIM25_STIMULUS_RESET  0x00000000
#define RP23XX_M33_ITM_STIM25_STIMULUS_BITS   0xffffffff
#define RP23XX_M33_ITM_STIM25_STIMULUS_MSB    31
#define RP23XX_M33_ITM_STIM25_STIMULUS_LSB    0
#define RP23XX_M33_ITM_STIM25_STIMULUS_ACCESS "RW"

#define RP23XX_M33_ITM_STIM26_OFFSET 0x00000068
#define RP23XX_M33_ITM_STIM26_BITS   0xffffffff
#define RP23XX_M33_ITM_STIM26_RESET  0x00000000

#define RP23XX_M33_ITM_STIM26_STIMULUS_RESET  0x00000000
#define RP23XX_M33_ITM_STIM26_STIMULUS_BITS   0xffffffff
#define RP23XX_M33_ITM_STIM26_STIMULUS_MSB    31
#define RP23XX_M33_ITM_STIM26_STIMULUS_LSB    0
#define RP23XX_M33_ITM_STIM26_STIMULUS_ACCESS "RW"

#define RP23XX_M33_ITM_STIM27_OFFSET 0x0000006c
#define RP23XX_M33_ITM_STIM27_BITS   0xffffffff
#define RP23XX_M33_ITM_STIM27_RESET  0x00000000

#define RP23XX_M33_ITM_STIM27_STIMULUS_RESET  0x00000000
#define RP23XX_M33_ITM_STIM27_STIMULUS_BITS   0xffffffff
#define RP23XX_M33_ITM_STIM27_STIMULUS_MSB    31
#define RP23XX_M33_ITM_STIM27_STIMULUS_LSB    0
#define RP23XX_M33_ITM_STIM27_STIMULUS_ACCESS "RW"

#define RP23XX_M33_ITM_STIM28_OFFSET 0x00000070
#define RP23XX_M33_ITM_STIM28_BITS   0xffffffff
#define RP23XX_M33_ITM_STIM28_RESET  0x00000000

#define RP23XX_M33_ITM_STIM28_STIMULUS_RESET  0x00000000
#define RP23XX_M33_ITM_STIM28_STIMULUS_BITS   0xffffffff
#define RP23XX_M33_ITM_STIM28_STIMULUS_MSB    31
#define RP23XX_M33_ITM_STIM28_STIMULUS_LSB    0
#define RP23XX_M33_ITM_STIM28_STIMULUS_ACCESS "RW"

#define RP23XX_M33_ITM_STIM29_OFFSET 0x00000074
#define RP23XX_M33_ITM_STIM29_BITS   0xffffffff
#define RP23XX_M33_ITM_STIM29_RESET  0x00000000

#define RP23XX_M33_ITM_STIM29_STIMULUS_RESET  0x00000000
#define RP23XX_M33_ITM_STIM29_STIMULUS_BITS   0xffffffff
#define RP23XX_M33_ITM_STIM29_STIMULUS_MSB    31
#define RP23XX_M33_ITM_STIM29_STIMULUS_LSB    0
#define RP23XX_M33_ITM_STIM29_STIMULUS_ACCESS "RW"

#define RP23XX_M33_ITM_STIM30_OFFSET 0x00000078
#define RP23XX_M33_ITM_STIM30_BITS   0xffffffff
#define RP23XX_M33_ITM_STIM30_RESET  0x00000000

#define RP23XX_M33_ITM_STIM30_STIMULUS_RESET  0x00000000
#define RP23XX_M33_ITM_STIM30_STIMULUS_BITS   0xffffffff
#define RP23XX_M33_ITM_STIM30_STIMULUS_MSB    31
#define RP23XX_M33_ITM_STIM30_STIMULUS_LSB    0
#define RP23XX_M33_ITM_STIM30_STIMULUS_ACCESS "RW"

#define RP23XX_M33_ITM_STIM31_OFFSET 0x0000007c
#define RP23XX_M33_ITM_STIM31_BITS   0xffffffff
#define RP23XX_M33_ITM_STIM31_RESET  0x00000000

#define RP23XX_M33_ITM_STIM31_STIMULUS_RESET  0x00000000
#define RP23XX_M33_ITM_STIM31_STIMULUS_BITS   0xffffffff
#define RP23XX_M33_ITM_STIM31_STIMULUS_MSB    31
#define RP23XX_M33_ITM_STIM31_STIMULUS_LSB    0
#define RP23XX_M33_ITM_STIM31_STIMULUS_ACCESS "RW"

#define RP23XX_M33_ITM_TER0_OFFSET 0x00000e00
#define RP23XX_M33_ITM_TER0_BITS   0xffffffff
#define RP23XX_M33_ITM_TER0_RESET  0x00000000

#define RP23XX_M33_ITM_TER0_STIMENA_RESET  0x00000000
#define RP23XX_M33_ITM_TER0_STIMENA_BITS   0xffffffff
#define RP23XX_M33_ITM_TER0_STIMENA_MSB    31
#define RP23XX_M33_ITM_TER0_STIMENA_LSB    0
#define RP23XX_M33_ITM_TER0_STIMENA_ACCESS "RW"

#define RP23XX_M33_ITM_TPR_OFFSET 0x00000e40
#define RP23XX_M33_ITM_TPR_BITS   0x0000000f
#define RP23XX_M33_ITM_TPR_RESET  0x00000000

#define RP23XX_M33_ITM_TPR_PRIVMASK_RESET  0x0
#define RP23XX_M33_ITM_TPR_PRIVMASK_BITS   0x0000000f
#define RP23XX_M33_ITM_TPR_PRIVMASK_MSB    3
#define RP23XX_M33_ITM_TPR_PRIVMASK_LSB    0
#define RP23XX_M33_ITM_TPR_PRIVMASK_ACCESS "RW"

#define RP23XX_M33_ITM_TCR_OFFSET 0x00000e80
#define RP23XX_M33_ITM_TCR_BITS   0x00ff0f3f
#define RP23XX_M33_ITM_TCR_RESET  0x00000000

#define RP23XX_M33_ITM_TCR_BUSY_RESET  0x0
#define RP23XX_M33_ITM_TCR_BUSY_BITS   0x00800000
#define RP23XX_M33_ITM_TCR_BUSY_MSB    23
#define RP23XX_M33_ITM_TCR_BUSY_LSB    23
#define RP23XX_M33_ITM_TCR_BUSY_ACCESS "RO"

#define RP23XX_M33_ITM_TCR_TRACEBUSID_RESET  0x00
#define RP23XX_M33_ITM_TCR_TRACEBUSID_BITS   0x007f0000
#define RP23XX_M33_ITM_TCR_TRACEBUSID_MSB    22
#define RP23XX_M33_ITM_TCR_TRACEBUSID_LSB    16
#define RP23XX_M33_ITM_TCR_TRACEBUSID_ACCESS "RW"

#define RP23XX_M33_ITM_TCR_GTSFREQ_RESET  0x0
#define RP23XX_M33_ITM_TCR_GTSFREQ_BITS   0x00000c00
#define RP23XX_M33_ITM_TCR_GTSFREQ_MSB    11
#define RP23XX_M33_ITM_TCR_GTSFREQ_LSB    10
#define RP23XX_M33_ITM_TCR_GTSFREQ_ACCESS "RW"

#define RP23XX_M33_ITM_TCR_TSPRESCALE_RESET  0x0
#define RP23XX_M33_ITM_TCR_TSPRESCALE_BITS   0x00000300
#define RP23XX_M33_ITM_TCR_TSPRESCALE_MSB    9
#define RP23XX_M33_ITM_TCR_TSPRESCALE_LSB    8
#define RP23XX_M33_ITM_TCR_TSPRESCALE_ACCESS "RW"

#define RP23XX_M33_ITM_TCR_STALLENA_RESET  0x0
#define RP23XX_M33_ITM_TCR_STALLENA_BITS   0x00000020
#define RP23XX_M33_ITM_TCR_STALLENA_MSB    5
#define RP23XX_M33_ITM_TCR_STALLENA_LSB    5
#define RP23XX_M33_ITM_TCR_STALLENA_ACCESS "RW"

#define RP23XX_M33_ITM_TCR_SWOENA_RESET  0x0
#define RP23XX_M33_ITM_TCR_SWOENA_BITS   0x00000010
#define RP23XX_M33_ITM_TCR_SWOENA_MSB    4
#define RP23XX_M33_ITM_TCR_SWOENA_LSB    4
#define RP23XX_M33_ITM_TCR_SWOENA_ACCESS "RW"

#define RP23XX_M33_ITM_TCR_TXENA_RESET  0x0
#define RP23XX_M33_ITM_TCR_TXENA_BITS   0x00000008
#define RP23XX_M33_ITM_TCR_TXENA_MSB    3
#define RP23XX_M33_ITM_TCR_TXENA_LSB    3
#define RP23XX_M33_ITM_TCR_TXENA_ACCESS "RW"

#define RP23XX_M33_ITM_TCR_SYNCENA_RESET  0x0
#define RP23XX_M33_ITM_TCR_SYNCENA_BITS   0x00000004
#define RP23XX_M33_ITM_TCR_SYNCENA_MSB    2
#define RP23XX_M33_ITM_TCR_SYNCENA_LSB    2
#define RP23XX_M33_ITM_TCR_SYNCENA_ACCESS "RW"

#define RP23XX_M33_ITM_TCR_TSENA_RESET  0x0
#define RP23XX_M33_ITM_TCR_TSENA_BITS   0x00000002
#define RP23XX_M33_ITM_TCR_TSENA_MSB    1
#define RP23XX_M33_ITM_TCR_TSENA_LSB    1
#define RP23XX_M33_ITM_TCR_TSENA_ACCESS "RW"

#define RP23XX_M33_ITM_TCR_ITMENA_RESET  0x0
#define RP23XX_M33_ITM_TCR_ITMENA_BITS   0x00000001
#define RP23XX_M33_ITM_TCR_ITMENA_MSB    0
#define RP23XX_M33_ITM_TCR_ITMENA_LSB    0
#define RP23XX_M33_ITM_TCR_ITMENA_ACCESS "RW"

#define RP23XX_M33_INT_ATREADY_OFFSET 0x00000ef0
#define RP23XX_M33_INT_ATREADY_BITS   0x00000003
#define RP23XX_M33_INT_ATREADY_RESET  0x00000000

#define RP23XX_M33_INT_ATREADY_AFVALID_RESET  0x0
#define RP23XX_M33_INT_ATREADY_AFVALID_BITS   0x00000002
#define RP23XX_M33_INT_ATREADY_AFVALID_MSB    1
#define RP23XX_M33_INT_ATREADY_AFVALID_LSB    1
#define RP23XX_M33_INT_ATREADY_AFVALID_ACCESS "RO"

#define RP23XX_M33_INT_ATREADY_ATREADY_RESET  0x0
#define RP23XX_M33_INT_ATREADY_ATREADY_BITS   0x00000001
#define RP23XX_M33_INT_ATREADY_ATREADY_MSB    0
#define RP23XX_M33_INT_ATREADY_ATREADY_LSB    0
#define RP23XX_M33_INT_ATREADY_ATREADY_ACCESS "RO"

#define RP23XX_M33_INT_ATVALID_OFFSET 0x00000ef8
#define RP23XX_M33_INT_ATVALID_BITS   0x00000003
#define RP23XX_M33_INT_ATVALID_RESET  0x00000000

#define RP23XX_M33_INT_ATVALID_AFREADY_RESET  0x0
#define RP23XX_M33_INT_ATVALID_AFREADY_BITS   0x00000002
#define RP23XX_M33_INT_ATVALID_AFREADY_MSB    1
#define RP23XX_M33_INT_ATVALID_AFREADY_LSB    1
#define RP23XX_M33_INT_ATVALID_AFREADY_ACCESS "RW"

#define RP23XX_M33_INT_ATVALID_ATREADY_RESET  0x0
#define RP23XX_M33_INT_ATVALID_ATREADY_BITS   0x00000001
#define RP23XX_M33_INT_ATVALID_ATREADY_MSB    0
#define RP23XX_M33_INT_ATVALID_ATREADY_LSB    0
#define RP23XX_M33_INT_ATVALID_ATREADY_ACCESS "RW"

#define RP23XX_M33_ITM_ITCTRL_OFFSET 0x00000f00
#define RP23XX_M33_ITM_ITCTRL_BITS   0x00000001
#define RP23XX_M33_ITM_ITCTRL_RESET  0x00000000

#define RP23XX_M33_ITM_ITCTRL_IME_RESET  0x0
#define RP23XX_M33_ITM_ITCTRL_IME_BITS   0x00000001
#define RP23XX_M33_ITM_ITCTRL_IME_MSB    0
#define RP23XX_M33_ITM_ITCTRL_IME_LSB    0
#define RP23XX_M33_ITM_ITCTRL_IME_ACCESS "RW"

#define RP23XX_M33_ITM_DEVARCH_OFFSET 0x00000fbc
#define RP23XX_M33_ITM_DEVARCH_BITS   0xffffffff
#define RP23XX_M33_ITM_DEVARCH_RESET  0x47701a01

#define RP23XX_M33_ITM_DEVARCH_ARCHITECT_RESET  0x23b
#define RP23XX_M33_ITM_DEVARCH_ARCHITECT_BITS   0xffe00000
#define RP23XX_M33_ITM_DEVARCH_ARCHITECT_MSB    31
#define RP23XX_M33_ITM_DEVARCH_ARCHITECT_LSB    21
#define RP23XX_M33_ITM_DEVARCH_ARCHITECT_ACCESS "RO"

#define RP23XX_M33_ITM_DEVARCH_PRESENT_RESET  0x1
#define RP23XX_M33_ITM_DEVARCH_PRESENT_BITS   0x00100000
#define RP23XX_M33_ITM_DEVARCH_PRESENT_MSB    20
#define RP23XX_M33_ITM_DEVARCH_PRESENT_LSB    20
#define RP23XX_M33_ITM_DEVARCH_PRESENT_ACCESS "RO"

#define RP23XX_M33_ITM_DEVARCH_REVISION_RESET  0x0
#define RP23XX_M33_ITM_DEVARCH_REVISION_BITS   0x000f0000
#define RP23XX_M33_ITM_DEVARCH_REVISION_MSB    19
#define RP23XX_M33_ITM_DEVARCH_REVISION_LSB    16
#define RP23XX_M33_ITM_DEVARCH_REVISION_ACCESS "RO"

#define RP23XX_M33_ITM_DEVARCH_ARCHVER_RESET  0x1
#define RP23XX_M33_ITM_DEVARCH_ARCHVER_BITS   0x0000f000
#define RP23XX_M33_ITM_DEVARCH_ARCHVER_MSB    15
#define RP23XX_M33_ITM_DEVARCH_ARCHVER_LSB    12
#define RP23XX_M33_ITM_DEVARCH_ARCHVER_ACCESS "RO"

#define RP23XX_M33_ITM_DEVARCH_ARCHPART_RESET  0xa01
#define RP23XX_M33_ITM_DEVARCH_ARCHPART_BITS   0x00000fff
#define RP23XX_M33_ITM_DEVARCH_ARCHPART_MSB    11
#define RP23XX_M33_ITM_DEVARCH_ARCHPART_LSB    0
#define RP23XX_M33_ITM_DEVARCH_ARCHPART_ACCESS "RO"

#define RP23XX_M33_ITM_DEVTYPE_OFFSET 0x00000fcc
#define RP23XX_M33_ITM_DEVTYPE_BITS   0x000000ff
#define RP23XX_M33_ITM_DEVTYPE_RESET  0x00000043

#define RP23XX_M33_ITM_DEVTYPE_SUB_RESET  0x4
#define RP23XX_M33_ITM_DEVTYPE_SUB_BITS   0x000000f0
#define RP23XX_M33_ITM_DEVTYPE_SUB_MSB    7
#define RP23XX_M33_ITM_DEVTYPE_SUB_LSB    4
#define RP23XX_M33_ITM_DEVTYPE_SUB_ACCESS "RO"

#define RP23XX_M33_ITM_DEVTYPE_MAJOR_RESET  0x3
#define RP23XX_M33_ITM_DEVTYPE_MAJOR_BITS   0x0000000f
#define RP23XX_M33_ITM_DEVTYPE_MAJOR_MSB    3
#define RP23XX_M33_ITM_DEVTYPE_MAJOR_LSB    0
#define RP23XX_M33_ITM_DEVTYPE_MAJOR_ACCESS "RO"

#define RP23XX_M33_ITM_PIDR4_OFFSET 0x00000fd0
#define RP23XX_M33_ITM_PIDR4_BITS   0x000000ff
#define RP23XX_M33_ITM_PIDR4_RESET  0x00000004

#define RP23XX_M33_ITM_PIDR4_SIZE_RESET  0x0
#define RP23XX_M33_ITM_PIDR4_SIZE_BITS   0x000000f0
#define RP23XX_M33_ITM_PIDR4_SIZE_MSB    7
#define RP23XX_M33_ITM_PIDR4_SIZE_LSB    4
#define RP23XX_M33_ITM_PIDR4_SIZE_ACCESS "RO"

#define RP23XX_M33_ITM_PIDR4_DES_2_RESET  0x4
#define RP23XX_M33_ITM_PIDR4_DES_2_BITS   0x0000000f
#define RP23XX_M33_ITM_PIDR4_DES_2_MSB    3
#define RP23XX_M33_ITM_PIDR4_DES_2_LSB    0
#define RP23XX_M33_ITM_PIDR4_DES_2_ACCESS "RO"

#define RP23XX_M33_ITM_PIDR5_OFFSET 0x00000fd4
#define RP23XX_M33_ITM_PIDR5_BITS   0x00000000
#define RP23XX_M33_ITM_PIDR5_RESET  0x00000000
#define RP23XX_M33_ITM_PIDR5_MSB    31
#define RP23XX_M33_ITM_PIDR5_LSB    0
#define RP23XX_M33_ITM_PIDR5_ACCESS "RW"

#define RP23XX_M33_ITM_PIDR6_OFFSET 0x00000fd8
#define RP23XX_M33_ITM_PIDR6_BITS   0x00000000
#define RP23XX_M33_ITM_PIDR6_RESET  0x00000000
#define RP23XX_M33_ITM_PIDR6_MSB    31
#define RP23XX_M33_ITM_PIDR6_LSB    0
#define RP23XX_M33_ITM_PIDR6_ACCESS "RW"

#define RP23XX_M33_ITM_PIDR7_OFFSET 0x00000fdc
#define RP23XX_M33_ITM_PIDR7_BITS   0x00000000
#define RP23XX_M33_ITM_PIDR7_RESET  0x00000000
#define RP23XX_M33_ITM_PIDR7_MSB    31
#define RP23XX_M33_ITM_PIDR7_LSB    0
#define RP23XX_M33_ITM_PIDR7_ACCESS "RW"

#define RP23XX_M33_ITM_PIDR0_OFFSET 0x00000fe0
#define RP23XX_M33_ITM_PIDR0_BITS   0x000000ff
#define RP23XX_M33_ITM_PIDR0_RESET  0x00000021

#define RP23XX_M33_ITM_PIDR0_PART_0_RESET  0x21
#define RP23XX_M33_ITM_PIDR0_PART_0_BITS   0x000000ff
#define RP23XX_M33_ITM_PIDR0_PART_0_MSB    7
#define RP23XX_M33_ITM_PIDR0_PART_0_LSB    0
#define RP23XX_M33_ITM_PIDR0_PART_0_ACCESS "RO"

#define RP23XX_M33_ITM_PIDR1_OFFSET 0x00000fe4
#define RP23XX_M33_ITM_PIDR1_BITS   0x000000ff
#define RP23XX_M33_ITM_PIDR1_RESET  0x000000bd

#define RP23XX_M33_ITM_PIDR1_DES_0_RESET  0xb
#define RP23XX_M33_ITM_PIDR1_DES_0_BITS   0x000000f0
#define RP23XX_M33_ITM_PIDR1_DES_0_MSB    7
#define RP23XX_M33_ITM_PIDR1_DES_0_LSB    4
#define RP23XX_M33_ITM_PIDR1_DES_0_ACCESS "RO"

#define RP23XX_M33_ITM_PIDR1_PART_1_RESET  0xd
#define RP23XX_M33_ITM_PIDR1_PART_1_BITS   0x0000000f
#define RP23XX_M33_ITM_PIDR1_PART_1_MSB    3
#define RP23XX_M33_ITM_PIDR1_PART_1_LSB    0
#define RP23XX_M33_ITM_PIDR1_PART_1_ACCESS "RO"

#define RP23XX_M33_ITM_PIDR2_OFFSET 0x00000fe8
#define RP23XX_M33_ITM_PIDR2_BITS   0x000000ff
#define RP23XX_M33_ITM_PIDR2_RESET  0x0000000b

#define RP23XX_M33_ITM_PIDR2_REVISION_RESET  0x0
#define RP23XX_M33_ITM_PIDR2_REVISION_BITS   0x000000f0
#define RP23XX_M33_ITM_PIDR2_REVISION_MSB    7
#define RP23XX_M33_ITM_PIDR2_REVISION_LSB    4
#define RP23XX_M33_ITM_PIDR2_REVISION_ACCESS "RO"

#define RP23XX_M33_ITM_PIDR2_JEDEC_RESET  0x1
#define RP23XX_M33_ITM_PIDR2_JEDEC_BITS   0x00000008
#define RP23XX_M33_ITM_PIDR2_JEDEC_MSB    3
#define RP23XX_M33_ITM_PIDR2_JEDEC_LSB    3
#define RP23XX_M33_ITM_PIDR2_JEDEC_ACCESS "RO"

#define RP23XX_M33_ITM_PIDR2_DES_1_RESET  0x3
#define RP23XX_M33_ITM_PIDR2_DES_1_BITS   0x00000007
#define RP23XX_M33_ITM_PIDR2_DES_1_MSB    2
#define RP23XX_M33_ITM_PIDR2_DES_1_LSB    0
#define RP23XX_M33_ITM_PIDR2_DES_1_ACCESS "RO"

#define RP23XX_M33_ITM_PIDR3_OFFSET 0x00000fec
#define RP23XX_M33_ITM_PIDR3_BITS   0x000000ff
#define RP23XX_M33_ITM_PIDR3_RESET  0x00000000

#define RP23XX_M33_ITM_PIDR3_REVAND_RESET  0x0
#define RP23XX_M33_ITM_PIDR3_REVAND_BITS   0x000000f0
#define RP23XX_M33_ITM_PIDR3_REVAND_MSB    7
#define RP23XX_M33_ITM_PIDR3_REVAND_LSB    4
#define RP23XX_M33_ITM_PIDR3_REVAND_ACCESS "RO"

#define RP23XX_M33_ITM_PIDR3_CMOD_RESET  0x0
#define RP23XX_M33_ITM_PIDR3_CMOD_BITS   0x0000000f
#define RP23XX_M33_ITM_PIDR3_CMOD_MSB    3
#define RP23XX_M33_ITM_PIDR3_CMOD_LSB    0
#define RP23XX_M33_ITM_PIDR3_CMOD_ACCESS "RO"

#define RP23XX_M33_ITM_CIDR0_OFFSET 0x00000ff0
#define RP23XX_M33_ITM_CIDR0_BITS   0x000000ff
#define RP23XX_M33_ITM_CIDR0_RESET  0x0000000d

#define RP23XX_M33_ITM_CIDR0_PRMBL_0_RESET  0x0d
#define RP23XX_M33_ITM_CIDR0_PRMBL_0_BITS   0x000000ff
#define RP23XX_M33_ITM_CIDR0_PRMBL_0_MSB    7
#define RP23XX_M33_ITM_CIDR0_PRMBL_0_LSB    0
#define RP23XX_M33_ITM_CIDR0_PRMBL_0_ACCESS "RO"

#define RP23XX_M33_ITM_CIDR1_OFFSET 0x00000ff4
#define RP23XX_M33_ITM_CIDR1_BITS   0x000000ff
#define RP23XX_M33_ITM_CIDR1_RESET  0x00000090

#define RP23XX_M33_ITM_CIDR1_CLASS_RESET  0x9
#define RP23XX_M33_ITM_CIDR1_CLASS_BITS   0x000000f0
#define RP23XX_M33_ITM_CIDR1_CLASS_MSB    7
#define RP23XX_M33_ITM_CIDR1_CLASS_LSB    4
#define RP23XX_M33_ITM_CIDR1_CLASS_ACCESS "RO"

#define RP23XX_M33_ITM_CIDR1_PRMBL_1_RESET  0x0
#define RP23XX_M33_ITM_CIDR1_PRMBL_1_BITS   0x0000000f
#define RP23XX_M33_ITM_CIDR1_PRMBL_1_MSB    3
#define RP23XX_M33_ITM_CIDR1_PRMBL_1_LSB    0
#define RP23XX_M33_ITM_CIDR1_PRMBL_1_ACCESS "RO"

#define RP23XX_M33_ITM_CIDR2_OFFSET 0x00000ff8
#define RP23XX_M33_ITM_CIDR2_BITS   0x000000ff
#define RP23XX_M33_ITM_CIDR2_RESET  0x00000005

#define RP23XX_M33_ITM_CIDR2_PRMBL_2_RESET  0x05
#define RP23XX_M33_ITM_CIDR2_PRMBL_2_BITS   0x000000ff
#define RP23XX_M33_ITM_CIDR2_PRMBL_2_MSB    7
#define RP23XX_M33_ITM_CIDR2_PRMBL_2_LSB    0
#define RP23XX_M33_ITM_CIDR2_PRMBL_2_ACCESS "RO"

#define RP23XX_M33_ITM_CIDR3_OFFSET 0x00000ffc
#define RP23XX_M33_ITM_CIDR3_BITS   0x000000ff
#define RP23XX_M33_ITM_CIDR3_RESET  0x000000b1

#define RP23XX_M33_ITM_CIDR3_PRMBL_3_RESET  0xb1
#define RP23XX_M33_ITM_CIDR3_PRMBL_3_BITS   0x000000ff
#define RP23XX_M33_ITM_CIDR3_PRMBL_3_MSB    7
#define RP23XX_M33_ITM_CIDR3_PRMBL_3_LSB    0
#define RP23XX_M33_ITM_CIDR3_PRMBL_3_ACCESS "RO"

#define RP23XX_M33_DWT_CTRL_OFFSET 0x00001000
#define RP23XX_M33_DWT_CTRL_BITS   0xffff1fff
#define RP23XX_M33_DWT_CTRL_RESET  0x73741824

#define RP23XX_M33_DWT_CTRL_NUMCOMP_RESET  0x7
#define RP23XX_M33_DWT_CTRL_NUMCOMP_BITS   0xf0000000
#define RP23XX_M33_DWT_CTRL_NUMCOMP_MSB    31
#define RP23XX_M33_DWT_CTRL_NUMCOMP_LSB    28
#define RP23XX_M33_DWT_CTRL_NUMCOMP_ACCESS "RO"

#define RP23XX_M33_DWT_CTRL_NOTRCPKT_RESET  0x0
#define RP23XX_M33_DWT_CTRL_NOTRCPKT_BITS   0x08000000
#define RP23XX_M33_DWT_CTRL_NOTRCPKT_MSB    27
#define RP23XX_M33_DWT_CTRL_NOTRCPKT_LSB    27
#define RP23XX_M33_DWT_CTRL_NOTRCPKT_ACCESS "RO"

#define RP23XX_M33_DWT_CTRL_NOEXTTRIG_RESET  0x0
#define RP23XX_M33_DWT_CTRL_NOEXTTRIG_BITS   0x04000000
#define RP23XX_M33_DWT_CTRL_NOEXTTRIG_MSB    26
#define RP23XX_M33_DWT_CTRL_NOEXTTRIG_LSB    26
#define RP23XX_M33_DWT_CTRL_NOEXTTRIG_ACCESS "RO"

#define RP23XX_M33_DWT_CTRL_NOCYCCNT_RESET  0x1
#define RP23XX_M33_DWT_CTRL_NOCYCCNT_BITS   0x02000000
#define RP23XX_M33_DWT_CTRL_NOCYCCNT_MSB    25
#define RP23XX_M33_DWT_CTRL_NOCYCCNT_LSB    25
#define RP23XX_M33_DWT_CTRL_NOCYCCNT_ACCESS "RO"

#define RP23XX_M33_DWT_CTRL_NOPRFCNT_RESET  0x1
#define RP23XX_M33_DWT_CTRL_NOPRFCNT_BITS   0x01000000
#define RP23XX_M33_DWT_CTRL_NOPRFCNT_MSB    24
#define RP23XX_M33_DWT_CTRL_NOPRFCNT_LSB    24
#define RP23XX_M33_DWT_CTRL_NOPRFCNT_ACCESS "RO"

#define RP23XX_M33_DWT_CTRL_CYCDISS_RESET  0x0
#define RP23XX_M33_DWT_CTRL_CYCDISS_BITS   0x00800000
#define RP23XX_M33_DWT_CTRL_CYCDISS_MSB    23
#define RP23XX_M33_DWT_CTRL_CYCDISS_LSB    23
#define RP23XX_M33_DWT_CTRL_CYCDISS_ACCESS "RW"

#define RP23XX_M33_DWT_CTRL_CYCEVTENA_RESET  0x1
#define RP23XX_M33_DWT_CTRL_CYCEVTENA_BITS   0x00400000
#define RP23XX_M33_DWT_CTRL_CYCEVTENA_MSB    22
#define RP23XX_M33_DWT_CTRL_CYCEVTENA_LSB    22
#define RP23XX_M33_DWT_CTRL_CYCEVTENA_ACCESS "RW"

#define RP23XX_M33_DWT_CTRL_FOLDEVTENA_RESET  0x1
#define RP23XX_M33_DWT_CTRL_FOLDEVTENA_BITS   0x00200000
#define RP23XX_M33_DWT_CTRL_FOLDEVTENA_MSB    21
#define RP23XX_M33_DWT_CTRL_FOLDEVTENA_LSB    21
#define RP23XX_M33_DWT_CTRL_FOLDEVTENA_ACCESS "RW"

#define RP23XX_M33_DWT_CTRL_LSUEVTENA_RESET  0x1
#define RP23XX_M33_DWT_CTRL_LSUEVTENA_BITS   0x00100000
#define RP23XX_M33_DWT_CTRL_LSUEVTENA_MSB    20
#define RP23XX_M33_DWT_CTRL_LSUEVTENA_LSB    20
#define RP23XX_M33_DWT_CTRL_LSUEVTENA_ACCESS "RW"

#define RP23XX_M33_DWT_CTRL_SLEEPEVTENA_RESET  0x0
#define RP23XX_M33_DWT_CTRL_SLEEPEVTENA_BITS   0x00080000
#define RP23XX_M33_DWT_CTRL_SLEEPEVTENA_MSB    19
#define RP23XX_M33_DWT_CTRL_SLEEPEVTENA_LSB    19
#define RP23XX_M33_DWT_CTRL_SLEEPEVTENA_ACCESS "RW"

#define RP23XX_M33_DWT_CTRL_EXCEVTENA_RESET  0x1
#define RP23XX_M33_DWT_CTRL_EXCEVTENA_BITS   0x00040000
#define RP23XX_M33_DWT_CTRL_EXCEVTENA_MSB    18
#define RP23XX_M33_DWT_CTRL_EXCEVTENA_LSB    18
#define RP23XX_M33_DWT_CTRL_EXCEVTENA_ACCESS "RW"

#define RP23XX_M33_DWT_CTRL_CPIEVTENA_RESET  0x0
#define RP23XX_M33_DWT_CTRL_CPIEVTENA_BITS   0x00020000
#define RP23XX_M33_DWT_CTRL_CPIEVTENA_MSB    17
#define RP23XX_M33_DWT_CTRL_CPIEVTENA_LSB    17
#define RP23XX_M33_DWT_CTRL_CPIEVTENA_ACCESS "RW"

#define RP23XX_M33_DWT_CTRL_EXTTRCENA_RESET  0x0
#define RP23XX_M33_DWT_CTRL_EXTTRCENA_BITS   0x00010000
#define RP23XX_M33_DWT_CTRL_EXTTRCENA_MSB    16
#define RP23XX_M33_DWT_CTRL_EXTTRCENA_LSB    16
#define RP23XX_M33_DWT_CTRL_EXTTRCENA_ACCESS "RW"

#define RP23XX_M33_DWT_CTRL_PCSAMPLENA_RESET  0x1
#define RP23XX_M33_DWT_CTRL_PCSAMPLENA_BITS   0x00001000
#define RP23XX_M33_DWT_CTRL_PCSAMPLENA_MSB    12
#define RP23XX_M33_DWT_CTRL_PCSAMPLENA_LSB    12
#define RP23XX_M33_DWT_CTRL_PCSAMPLENA_ACCESS "RW"

#define RP23XX_M33_DWT_CTRL_SYNCTAP_RESET  0x2
#define RP23XX_M33_DWT_CTRL_SYNCTAP_BITS   0x00000c00
#define RP23XX_M33_DWT_CTRL_SYNCTAP_MSB    11
#define RP23XX_M33_DWT_CTRL_SYNCTAP_LSB    10
#define RP23XX_M33_DWT_CTRL_SYNCTAP_ACCESS "RW"

#define RP23XX_M33_DWT_CTRL_CYCTAP_RESET  0x0
#define RP23XX_M33_DWT_CTRL_CYCTAP_BITS   0x00000200
#define RP23XX_M33_DWT_CTRL_CYCTAP_MSB    9
#define RP23XX_M33_DWT_CTRL_CYCTAP_LSB    9
#define RP23XX_M33_DWT_CTRL_CYCTAP_ACCESS "RW"

#define RP23XX_M33_DWT_CTRL_POSTINIT_RESET  0x1
#define RP23XX_M33_DWT_CTRL_POSTINIT_BITS   0x000001e0
#define RP23XX_M33_DWT_CTRL_POSTINIT_MSB    8
#define RP23XX_M33_DWT_CTRL_POSTINIT_LSB    5
#define RP23XX_M33_DWT_CTRL_POSTINIT_ACCESS "RW"

#define RP23XX_M33_DWT_CTRL_POSTPRESET_RESET  0x2
#define RP23XX_M33_DWT_CTRL_POSTPRESET_BITS   0x0000001e
#define RP23XX_M33_DWT_CTRL_POSTPRESET_MSB    4
#define RP23XX_M33_DWT_CTRL_POSTPRESET_LSB    1
#define RP23XX_M33_DWT_CTRL_POSTPRESET_ACCESS "RW"

#define RP23XX_M33_DWT_CTRL_CYCCNTENA_RESET  0x0
#define RP23XX_M33_DWT_CTRL_CYCCNTENA_BITS   0x00000001
#define RP23XX_M33_DWT_CTRL_CYCCNTENA_MSB    0
#define RP23XX_M33_DWT_CTRL_CYCCNTENA_LSB    0
#define RP23XX_M33_DWT_CTRL_CYCCNTENA_ACCESS "RW"

#define RP23XX_M33_DWT_CYCCNT_OFFSET 0x00001004
#define RP23XX_M33_DWT_CYCCNT_BITS   0xffffffff
#define RP23XX_M33_DWT_CYCCNT_RESET  0x00000000

#define RP23XX_M33_DWT_CYCCNT_CYCCNT_RESET  0x00000000
#define RP23XX_M33_DWT_CYCCNT_CYCCNT_BITS   0xffffffff
#define RP23XX_M33_DWT_CYCCNT_CYCCNT_MSB    31
#define RP23XX_M33_DWT_CYCCNT_CYCCNT_LSB    0
#define RP23XX_M33_DWT_CYCCNT_CYCCNT_ACCESS "RW"

#define RP23XX_M33_DWT_EXCCNT_OFFSET 0x0000100c
#define RP23XX_M33_DWT_EXCCNT_BITS   0x000000ff
#define RP23XX_M33_DWT_EXCCNT_RESET  0x00000000

#define RP23XX_M33_DWT_EXCCNT_EXCCNT_RESET  0x00
#define RP23XX_M33_DWT_EXCCNT_EXCCNT_BITS   0x000000ff
#define RP23XX_M33_DWT_EXCCNT_EXCCNT_MSB    7
#define RP23XX_M33_DWT_EXCCNT_EXCCNT_LSB    0
#define RP23XX_M33_DWT_EXCCNT_EXCCNT_ACCESS "RW"

#define RP23XX_M33_DWT_LSUCNT_OFFSET 0x00001014
#define RP23XX_M33_DWT_LSUCNT_BITS   0x000000ff
#define RP23XX_M33_DWT_LSUCNT_RESET  0x00000000

#define RP23XX_M33_DWT_LSUCNT_LSUCNT_RESET  0x00
#define RP23XX_M33_DWT_LSUCNT_LSUCNT_BITS   0x000000ff
#define RP23XX_M33_DWT_LSUCNT_LSUCNT_MSB    7
#define RP23XX_M33_DWT_LSUCNT_LSUCNT_LSB    0
#define RP23XX_M33_DWT_LSUCNT_LSUCNT_ACCESS "RW"

#define RP23XX_M33_DWT_FOLDCNT_OFFSET 0x00001018
#define RP23XX_M33_DWT_FOLDCNT_BITS   0x000000ff
#define RP23XX_M33_DWT_FOLDCNT_RESET  0x00000000

#define RP23XX_M33_DWT_FOLDCNT_FOLDCNT_RESET  0x00
#define RP23XX_M33_DWT_FOLDCNT_FOLDCNT_BITS   0x000000ff
#define RP23XX_M33_DWT_FOLDCNT_FOLDCNT_MSB    7
#define RP23XX_M33_DWT_FOLDCNT_FOLDCNT_LSB    0
#define RP23XX_M33_DWT_FOLDCNT_FOLDCNT_ACCESS "RW"

#define RP23XX_M33_DWT_COMP0_OFFSET 0x00001020
#define RP23XX_M33_DWT_COMP0_BITS   0xffffffff
#define RP23XX_M33_DWT_COMP0_RESET  0x00000000
#define RP23XX_M33_DWT_COMP0_MSB    31
#define RP23XX_M33_DWT_COMP0_LSB    0
#define RP23XX_M33_DWT_COMP0_ACCESS "RW"

#define RP23XX_M33_DWT_FUNCTION0_OFFSET 0x00001028
#define RP23XX_M33_DWT_FUNCTION0_BITS   0xf9000c3f
#define RP23XX_M33_DWT_FUNCTION0_RESET  0x58000000

#define RP23XX_M33_DWT_FUNCTION0_ID_RESET  0x0b
#define RP23XX_M33_DWT_FUNCTION0_ID_BITS   0xf8000000
#define RP23XX_M33_DWT_FUNCTION0_ID_MSB    31
#define RP23XX_M33_DWT_FUNCTION0_ID_LSB    27
#define RP23XX_M33_DWT_FUNCTION0_ID_ACCESS "RO"

#define RP23XX_M33_DWT_FUNCTION0_MATCHED_RESET  0x0
#define RP23XX_M33_DWT_FUNCTION0_MATCHED_BITS   0x01000000
#define RP23XX_M33_DWT_FUNCTION0_MATCHED_MSB    24
#define RP23XX_M33_DWT_FUNCTION0_MATCHED_LSB    24
#define RP23XX_M33_DWT_FUNCTION0_MATCHED_ACCESS "RO"

#define RP23XX_M33_DWT_FUNCTION0_DATAVSIZE_RESET  0x0
#define RP23XX_M33_DWT_FUNCTION0_DATAVSIZE_BITS   0x00000c00
#define RP23XX_M33_DWT_FUNCTION0_DATAVSIZE_MSB    11
#define RP23XX_M33_DWT_FUNCTION0_DATAVSIZE_LSB    10
#define RP23XX_M33_DWT_FUNCTION0_DATAVSIZE_ACCESS "RW"

#define RP23XX_M33_DWT_FUNCTION0_ACTION_RESET  0x0
#define RP23XX_M33_DWT_FUNCTION0_ACTION_BITS   0x00000030
#define RP23XX_M33_DWT_FUNCTION0_ACTION_MSB    5
#define RP23XX_M33_DWT_FUNCTION0_ACTION_LSB    4
#define RP23XX_M33_DWT_FUNCTION0_ACTION_ACCESS "RW"

#define RP23XX_M33_DWT_FUNCTION0_MATCH_RESET  0x0
#define RP23XX_M33_DWT_FUNCTION0_MATCH_BITS   0x0000000f
#define RP23XX_M33_DWT_FUNCTION0_MATCH_MSB    3
#define RP23XX_M33_DWT_FUNCTION0_MATCH_LSB    0
#define RP23XX_M33_DWT_FUNCTION0_MATCH_ACCESS "RW"

#define RP23XX_M33_DWT_COMP1_OFFSET 0x00001030
#define RP23XX_M33_DWT_COMP1_BITS   0xffffffff
#define RP23XX_M33_DWT_COMP1_RESET  0x00000000
#define RP23XX_M33_DWT_COMP1_MSB    31
#define RP23XX_M33_DWT_COMP1_LSB    0
#define RP23XX_M33_DWT_COMP1_ACCESS "RW"

#define RP23XX_M33_DWT_FUNCTION1_OFFSET 0x00001038
#define RP23XX_M33_DWT_FUNCTION1_BITS   0xf9000c3f
#define RP23XX_M33_DWT_FUNCTION1_RESET  0x89000828

#define RP23XX_M33_DWT_FUNCTION1_ID_RESET  0x11
#define RP23XX_M33_DWT_FUNCTION1_ID_BITS   0xf8000000
#define RP23XX_M33_DWT_FUNCTION1_ID_MSB    31
#define RP23XX_M33_DWT_FUNCTION1_ID_LSB    27
#define RP23XX_M33_DWT_FUNCTION1_ID_ACCESS "RO"

#define RP23XX_M33_DWT_FUNCTION1_MATCHED_RESET  0x1
#define RP23XX_M33_DWT_FUNCTION1_MATCHED_BITS   0x01000000
#define RP23XX_M33_DWT_FUNCTION1_MATCHED_MSB    24
#define RP23XX_M33_DWT_FUNCTION1_MATCHED_LSB    24
#define RP23XX_M33_DWT_FUNCTION1_MATCHED_ACCESS "RO"

#define RP23XX_M33_DWT_FUNCTION1_DATAVSIZE_RESET  0x2
#define RP23XX_M33_DWT_FUNCTION1_DATAVSIZE_BITS   0x00000c00
#define RP23XX_M33_DWT_FUNCTION1_DATAVSIZE_MSB    11
#define RP23XX_M33_DWT_FUNCTION1_DATAVSIZE_LSB    10
#define RP23XX_M33_DWT_FUNCTION1_DATAVSIZE_ACCESS "RW"

#define RP23XX_M33_DWT_FUNCTION1_ACTION_RESET  0x2
#define RP23XX_M33_DWT_FUNCTION1_ACTION_BITS   0x00000030
#define RP23XX_M33_DWT_FUNCTION1_ACTION_MSB    5
#define RP23XX_M33_DWT_FUNCTION1_ACTION_LSB    4
#define RP23XX_M33_DWT_FUNCTION1_ACTION_ACCESS "RW"

#define RP23XX_M33_DWT_FUNCTION1_MATCH_RESET  0x8
#define RP23XX_M33_DWT_FUNCTION1_MATCH_BITS   0x0000000f
#define RP23XX_M33_DWT_FUNCTION1_MATCH_MSB    3
#define RP23XX_M33_DWT_FUNCTION1_MATCH_LSB    0
#define RP23XX_M33_DWT_FUNCTION1_MATCH_ACCESS "RW"

#define RP23XX_M33_DWT_COMP2_OFFSET 0x00001040
#define RP23XX_M33_DWT_COMP2_BITS   0xffffffff
#define RP23XX_M33_DWT_COMP2_RESET  0x00000000
#define RP23XX_M33_DWT_COMP2_MSB    31
#define RP23XX_M33_DWT_COMP2_LSB    0
#define RP23XX_M33_DWT_COMP2_ACCESS "RW"

#define RP23XX_M33_DWT_FUNCTION2_OFFSET 0x00001048
#define RP23XX_M33_DWT_FUNCTION2_BITS   0xf9000c3f
#define RP23XX_M33_DWT_FUNCTION2_RESET  0x50000000

#define RP23XX_M33_DWT_FUNCTION2_ID_RESET  0x0a
#define RP23XX_M33_DWT_FUNCTION2_ID_BITS   0xf8000000
#define RP23XX_M33_DWT_FUNCTION2_ID_MSB    31
#define RP23XX_M33_DWT_FUNCTION2_ID_LSB    27
#define RP23XX_M33_DWT_FUNCTION2_ID_ACCESS "RO"

#define RP23XX_M33_DWT_FUNCTION2_MATCHED_RESET  0x0
#define RP23XX_M33_DWT_FUNCTION2_MATCHED_BITS   0x01000000
#define RP23XX_M33_DWT_FUNCTION2_MATCHED_MSB    24
#define RP23XX_M33_DWT_FUNCTION2_MATCHED_LSB    24
#define RP23XX_M33_DWT_FUNCTION2_MATCHED_ACCESS "RO"

#define RP23XX_M33_DWT_FUNCTION2_DATAVSIZE_RESET  0x0
#define RP23XX_M33_DWT_FUNCTION2_DATAVSIZE_BITS   0x00000c00
#define RP23XX_M33_DWT_FUNCTION2_DATAVSIZE_MSB    11
#define RP23XX_M33_DWT_FUNCTION2_DATAVSIZE_LSB    10
#define RP23XX_M33_DWT_FUNCTION2_DATAVSIZE_ACCESS "RW"

#define RP23XX_M33_DWT_FUNCTION2_ACTION_RESET  0x0
#define RP23XX_M33_DWT_FUNCTION2_ACTION_BITS   0x00000030
#define RP23XX_M33_DWT_FUNCTION2_ACTION_MSB    5
#define RP23XX_M33_DWT_FUNCTION2_ACTION_LSB    4
#define RP23XX_M33_DWT_FUNCTION2_ACTION_ACCESS "RW"

#define RP23XX_M33_DWT_FUNCTION2_MATCH_RESET  0x0
#define RP23XX_M33_DWT_FUNCTION2_MATCH_BITS   0x0000000f
#define RP23XX_M33_DWT_FUNCTION2_MATCH_MSB    3
#define RP23XX_M33_DWT_FUNCTION2_MATCH_LSB    0
#define RP23XX_M33_DWT_FUNCTION2_MATCH_ACCESS "RW"

#define RP23XX_M33_DWT_COMP3_OFFSET 0x00001050
#define RP23XX_M33_DWT_COMP3_BITS   0xffffffff
#define RP23XX_M33_DWT_COMP3_RESET  0x00000000
#define RP23XX_M33_DWT_COMP3_MSB    31
#define RP23XX_M33_DWT_COMP3_LSB    0
#define RP23XX_M33_DWT_COMP3_ACCESS "RW"

#define RP23XX_M33_DWT_FUNCTION3_OFFSET 0x00001058
#define RP23XX_M33_DWT_FUNCTION3_BITS   0xf9000c3f
#define RP23XX_M33_DWT_FUNCTION3_RESET  0x20000800

#define RP23XX_M33_DWT_FUNCTION3_ID_RESET  0x04
#define RP23XX_M33_DWT_FUNCTION3_ID_BITS   0xf8000000
#define RP23XX_M33_DWT_FUNCTION3_ID_MSB    31
#define RP23XX_M33_DWT_FUNCTION3_ID_LSB    27
#define RP23XX_M33_DWT_FUNCTION3_ID_ACCESS "RO"

#define RP23XX_M33_DWT_FUNCTION3_MATCHED_RESET  0x0
#define RP23XX_M33_DWT_FUNCTION3_MATCHED_BITS   0x01000000
#define RP23XX_M33_DWT_FUNCTION3_MATCHED_MSB    24
#define RP23XX_M33_DWT_FUNCTION3_MATCHED_LSB    24
#define RP23XX_M33_DWT_FUNCTION3_MATCHED_ACCESS "RO"

#define RP23XX_M33_DWT_FUNCTION3_DATAVSIZE_RESET  0x2
#define RP23XX_M33_DWT_FUNCTION3_DATAVSIZE_BITS   0x00000c00
#define RP23XX_M33_DWT_FUNCTION3_DATAVSIZE_MSB    11
#define RP23XX_M33_DWT_FUNCTION3_DATAVSIZE_LSB    10
#define RP23XX_M33_DWT_FUNCTION3_DATAVSIZE_ACCESS "RW"

#define RP23XX_M33_DWT_FUNCTION3_ACTION_RESET  0x0
#define RP23XX_M33_DWT_FUNCTION3_ACTION_BITS   0x00000030
#define RP23XX_M33_DWT_FUNCTION3_ACTION_MSB    5
#define RP23XX_M33_DWT_FUNCTION3_ACTION_LSB    4
#define RP23XX_M33_DWT_FUNCTION3_ACTION_ACCESS "RW"

#define RP23XX_M33_DWT_FUNCTION3_MATCH_RESET  0x0
#define RP23XX_M33_DWT_FUNCTION3_MATCH_BITS   0x0000000f
#define RP23XX_M33_DWT_FUNCTION3_MATCH_MSB    3
#define RP23XX_M33_DWT_FUNCTION3_MATCH_LSB    0
#define RP23XX_M33_DWT_FUNCTION3_MATCH_ACCESS "RW"

#define RP23XX_M33_DWT_DEVARCH_OFFSET 0x00001fbc
#define RP23XX_M33_DWT_DEVARCH_BITS   0xffffffff
#define RP23XX_M33_DWT_DEVARCH_RESET  0x47701a02

#define RP23XX_M33_DWT_DEVARCH_ARCHITECT_RESET  0x23b
#define RP23XX_M33_DWT_DEVARCH_ARCHITECT_BITS   0xffe00000
#define RP23XX_M33_DWT_DEVARCH_ARCHITECT_MSB    31
#define RP23XX_M33_DWT_DEVARCH_ARCHITECT_LSB    21
#define RP23XX_M33_DWT_DEVARCH_ARCHITECT_ACCESS "RO"

#define RP23XX_M33_DWT_DEVARCH_PRESENT_RESET  0x1
#define RP23XX_M33_DWT_DEVARCH_PRESENT_BITS   0x00100000
#define RP23XX_M33_DWT_DEVARCH_PRESENT_MSB    20
#define RP23XX_M33_DWT_DEVARCH_PRESENT_LSB    20
#define RP23XX_M33_DWT_DEVARCH_PRESENT_ACCESS "RO"

#define RP23XX_M33_DWT_DEVARCH_REVISION_RESET  0x0
#define RP23XX_M33_DWT_DEVARCH_REVISION_BITS   0x000f0000
#define RP23XX_M33_DWT_DEVARCH_REVISION_MSB    19
#define RP23XX_M33_DWT_DEVARCH_REVISION_LSB    16
#define RP23XX_M33_DWT_DEVARCH_REVISION_ACCESS "RO"

#define RP23XX_M33_DWT_DEVARCH_ARCHVER_RESET  0x1
#define RP23XX_M33_DWT_DEVARCH_ARCHVER_BITS   0x0000f000
#define RP23XX_M33_DWT_DEVARCH_ARCHVER_MSB    15
#define RP23XX_M33_DWT_DEVARCH_ARCHVER_LSB    12
#define RP23XX_M33_DWT_DEVARCH_ARCHVER_ACCESS "RO"

#define RP23XX_M33_DWT_DEVARCH_ARCHPART_RESET  0xa02
#define RP23XX_M33_DWT_DEVARCH_ARCHPART_BITS   0x00000fff
#define RP23XX_M33_DWT_DEVARCH_ARCHPART_MSB    11
#define RP23XX_M33_DWT_DEVARCH_ARCHPART_LSB    0
#define RP23XX_M33_DWT_DEVARCH_ARCHPART_ACCESS "RO"

#define RP23XX_M33_DWT_DEVTYPE_OFFSET 0x00001fcc
#define RP23XX_M33_DWT_DEVTYPE_BITS   0x000000ff
#define RP23XX_M33_DWT_DEVTYPE_RESET  0x00000000

#define RP23XX_M33_DWT_DEVTYPE_SUB_RESET  0x0
#define RP23XX_M33_DWT_DEVTYPE_SUB_BITS   0x000000f0
#define RP23XX_M33_DWT_DEVTYPE_SUB_MSB    7
#define RP23XX_M33_DWT_DEVTYPE_SUB_LSB    4
#define RP23XX_M33_DWT_DEVTYPE_SUB_ACCESS "RO"

#define RP23XX_M33_DWT_DEVTYPE_MAJOR_RESET  0x0
#define RP23XX_M33_DWT_DEVTYPE_MAJOR_BITS   0x0000000f
#define RP23XX_M33_DWT_DEVTYPE_MAJOR_MSB    3
#define RP23XX_M33_DWT_DEVTYPE_MAJOR_LSB    0
#define RP23XX_M33_DWT_DEVTYPE_MAJOR_ACCESS "RO"

#define RP23XX_M33_DWT_PIDR4_OFFSET 0x00001fd0
#define RP23XX_M33_DWT_PIDR4_BITS   0x000000ff
#define RP23XX_M33_DWT_PIDR4_RESET  0x00000004

#define RP23XX_M33_DWT_PIDR4_SIZE_RESET  0x0
#define RP23XX_M33_DWT_PIDR4_SIZE_BITS   0x000000f0
#define RP23XX_M33_DWT_PIDR4_SIZE_MSB    7
#define RP23XX_M33_DWT_PIDR4_SIZE_LSB    4
#define RP23XX_M33_DWT_PIDR4_SIZE_ACCESS "RO"

#define RP23XX_M33_DWT_PIDR4_DES_2_RESET  0x4
#define RP23XX_M33_DWT_PIDR4_DES_2_BITS   0x0000000f
#define RP23XX_M33_DWT_PIDR4_DES_2_MSB    3
#define RP23XX_M33_DWT_PIDR4_DES_2_LSB    0
#define RP23XX_M33_DWT_PIDR4_DES_2_ACCESS "RO"

#define RP23XX_M33_DWT_PIDR5_OFFSET 0x00001fd4
#define RP23XX_M33_DWT_PIDR5_BITS   0x00000000
#define RP23XX_M33_DWT_PIDR5_RESET  0x00000000
#define RP23XX_M33_DWT_PIDR5_MSB    31
#define RP23XX_M33_DWT_PIDR5_LSB    0
#define RP23XX_M33_DWT_PIDR5_ACCESS "RW"

#define RP23XX_M33_DWT_PIDR6_OFFSET 0x00001fd8
#define RP23XX_M33_DWT_PIDR6_BITS   0x00000000
#define RP23XX_M33_DWT_PIDR6_RESET  0x00000000
#define RP23XX_M33_DWT_PIDR6_MSB    31
#define RP23XX_M33_DWT_PIDR6_LSB    0
#define RP23XX_M33_DWT_PIDR6_ACCESS "RW"

#define RP23XX_M33_DWT_PIDR7_OFFSET 0x00001fdc
#define RP23XX_M33_DWT_PIDR7_BITS   0x00000000
#define RP23XX_M33_DWT_PIDR7_RESET  0x00000000
#define RP23XX_M33_DWT_PIDR7_MSB    31
#define RP23XX_M33_DWT_PIDR7_LSB    0
#define RP23XX_M33_DWT_PIDR7_ACCESS "RW"

#define RP23XX_M33_DWT_PIDR0_OFFSET 0x00001fe0
#define RP23XX_M33_DWT_PIDR0_BITS   0x000000ff
#define RP23XX_M33_DWT_PIDR0_RESET  0x00000021

#define RP23XX_M33_DWT_PIDR0_PART_0_RESET  0x21
#define RP23XX_M33_DWT_PIDR0_PART_0_BITS   0x000000ff
#define RP23XX_M33_DWT_PIDR0_PART_0_MSB    7
#define RP23XX_M33_DWT_PIDR0_PART_0_LSB    0
#define RP23XX_M33_DWT_PIDR0_PART_0_ACCESS "RO"

#define RP23XX_M33_DWT_PIDR1_OFFSET 0x00001fe4
#define RP23XX_M33_DWT_PIDR1_BITS   0x000000ff
#define RP23XX_M33_DWT_PIDR1_RESET  0x000000bd

#define RP23XX_M33_DWT_PIDR1_DES_0_RESET  0xb
#define RP23XX_M33_DWT_PIDR1_DES_0_BITS   0x000000f0
#define RP23XX_M33_DWT_PIDR1_DES_0_MSB    7
#define RP23XX_M33_DWT_PIDR1_DES_0_LSB    4
#define RP23XX_M33_DWT_PIDR1_DES_0_ACCESS "RO"

#define RP23XX_M33_DWT_PIDR1_PART_1_RESET  0xd
#define RP23XX_M33_DWT_PIDR1_PART_1_BITS   0x0000000f
#define RP23XX_M33_DWT_PIDR1_PART_1_MSB    3
#define RP23XX_M33_DWT_PIDR1_PART_1_LSB    0
#define RP23XX_M33_DWT_PIDR1_PART_1_ACCESS "RO"

#define RP23XX_M33_DWT_PIDR2_OFFSET 0x00001fe8
#define RP23XX_M33_DWT_PIDR2_BITS   0x000000ff
#define RP23XX_M33_DWT_PIDR2_RESET  0x0000000b

#define RP23XX_M33_DWT_PIDR2_REVISION_RESET  0x0
#define RP23XX_M33_DWT_PIDR2_REVISION_BITS   0x000000f0
#define RP23XX_M33_DWT_PIDR2_REVISION_MSB    7
#define RP23XX_M33_DWT_PIDR2_REVISION_LSB    4
#define RP23XX_M33_DWT_PIDR2_REVISION_ACCESS "RO"

#define RP23XX_M33_DWT_PIDR2_JEDEC_RESET  0x1
#define RP23XX_M33_DWT_PIDR2_JEDEC_BITS   0x00000008
#define RP23XX_M33_DWT_PIDR2_JEDEC_MSB    3
#define RP23XX_M33_DWT_PIDR2_JEDEC_LSB    3
#define RP23XX_M33_DWT_PIDR2_JEDEC_ACCESS "RO"

#define RP23XX_M33_DWT_PIDR2_DES_1_RESET  0x3
#define RP23XX_M33_DWT_PIDR2_DES_1_BITS   0x00000007
#define RP23XX_M33_DWT_PIDR2_DES_1_MSB    2
#define RP23XX_M33_DWT_PIDR2_DES_1_LSB    0
#define RP23XX_M33_DWT_PIDR2_DES_1_ACCESS "RO"

#define RP23XX_M33_DWT_PIDR3_OFFSET 0x00001fec
#define RP23XX_M33_DWT_PIDR3_BITS   0x000000ff
#define RP23XX_M33_DWT_PIDR3_RESET  0x00000000

#define RP23XX_M33_DWT_PIDR3_REVAND_RESET  0x0
#define RP23XX_M33_DWT_PIDR3_REVAND_BITS   0x000000f0
#define RP23XX_M33_DWT_PIDR3_REVAND_MSB    7
#define RP23XX_M33_DWT_PIDR3_REVAND_LSB    4
#define RP23XX_M33_DWT_PIDR3_REVAND_ACCESS "RO"

#define RP23XX_M33_DWT_PIDR3_CMOD_RESET  0x0
#define RP23XX_M33_DWT_PIDR3_CMOD_BITS   0x0000000f
#define RP23XX_M33_DWT_PIDR3_CMOD_MSB    3
#define RP23XX_M33_DWT_PIDR3_CMOD_LSB    0
#define RP23XX_M33_DWT_PIDR3_CMOD_ACCESS "RO"

#define RP23XX_M33_DWT_CIDR0_OFFSET 0x00001ff0
#define RP23XX_M33_DWT_CIDR0_BITS   0x000000ff
#define RP23XX_M33_DWT_CIDR0_RESET  0x0000000d

#define RP23XX_M33_DWT_CIDR0_PRMBL_0_RESET  0x0d
#define RP23XX_M33_DWT_CIDR0_PRMBL_0_BITS   0x000000ff
#define RP23XX_M33_DWT_CIDR0_PRMBL_0_MSB    7
#define RP23XX_M33_DWT_CIDR0_PRMBL_0_LSB    0
#define RP23XX_M33_DWT_CIDR0_PRMBL_0_ACCESS "RO"

#define RP23XX_M33_DWT_CIDR1_OFFSET 0x00001ff4
#define RP23XX_M33_DWT_CIDR1_BITS   0x000000ff
#define RP23XX_M33_DWT_CIDR1_RESET  0x00000090

#define RP23XX_M33_DWT_CIDR1_CLASS_RESET  0x9
#define RP23XX_M33_DWT_CIDR1_CLASS_BITS   0x000000f0
#define RP23XX_M33_DWT_CIDR1_CLASS_MSB    7
#define RP23XX_M33_DWT_CIDR1_CLASS_LSB    4
#define RP23XX_M33_DWT_CIDR1_CLASS_ACCESS "RO"

#define RP23XX_M33_DWT_CIDR1_PRMBL_1_RESET  0x0
#define RP23XX_M33_DWT_CIDR1_PRMBL_1_BITS   0x0000000f
#define RP23XX_M33_DWT_CIDR1_PRMBL_1_MSB    3
#define RP23XX_M33_DWT_CIDR1_PRMBL_1_LSB    0
#define RP23XX_M33_DWT_CIDR1_PRMBL_1_ACCESS "RO"

#define RP23XX_M33_DWT_CIDR2_OFFSET 0x00001ff8
#define RP23XX_M33_DWT_CIDR2_BITS   0x000000ff
#define RP23XX_M33_DWT_CIDR2_RESET  0x00000005

#define RP23XX_M33_DWT_CIDR2_PRMBL_2_RESET  0x05
#define RP23XX_M33_DWT_CIDR2_PRMBL_2_BITS   0x000000ff
#define RP23XX_M33_DWT_CIDR2_PRMBL_2_MSB    7
#define RP23XX_M33_DWT_CIDR2_PRMBL_2_LSB    0
#define RP23XX_M33_DWT_CIDR2_PRMBL_2_ACCESS "RO"

#define RP23XX_M33_DWT_CIDR3_OFFSET 0x00001ffc
#define RP23XX_M33_DWT_CIDR3_BITS   0x000000ff
#define RP23XX_M33_DWT_CIDR3_RESET  0x000000b1

#define RP23XX_M33_DWT_CIDR3_PRMBL_3_RESET  0xb1
#define RP23XX_M33_DWT_CIDR3_PRMBL_3_BITS   0x000000ff
#define RP23XX_M33_DWT_CIDR3_PRMBL_3_MSB    7
#define RP23XX_M33_DWT_CIDR3_PRMBL_3_LSB    0
#define RP23XX_M33_DWT_CIDR3_PRMBL_3_ACCESS "RO"

#define RP23XX_M33_FP_CTRL_OFFSET 0x00002000
#define RP23XX_M33_FP_CTRL_BITS   0xf0007ff3
#define RP23XX_M33_FP_CTRL_RESET  0x60005580

#define RP23XX_M33_FP_CTRL_REV_RESET  0x6
#define RP23XX_M33_FP_CTRL_REV_BITS   0xf0000000
#define RP23XX_M33_FP_CTRL_REV_MSB    31
#define RP23XX_M33_FP_CTRL_REV_LSB    28
#define RP23XX_M33_FP_CTRL_REV_ACCESS "RO"

#define RP23XX_M33_FP_CTRL_NUM_CODE_14_12__RESET  0x5
#define RP23XX_M33_FP_CTRL_NUM_CODE_14_12__BITS   0x00007000
#define RP23XX_M33_FP_CTRL_NUM_CODE_14_12__MSB    14
#define RP23XX_M33_FP_CTRL_NUM_CODE_14_12__LSB    12
#define RP23XX_M33_FP_CTRL_NUM_CODE_14_12__ACCESS "RO"

#define RP23XX_M33_FP_CTRL_NUM_LIT_RESET  0x5
#define RP23XX_M33_FP_CTRL_NUM_LIT_BITS   0x00000f00
#define RP23XX_M33_FP_CTRL_NUM_LIT_MSB    11
#define RP23XX_M33_FP_CTRL_NUM_LIT_LSB    8
#define RP23XX_M33_FP_CTRL_NUM_LIT_ACCESS "RO"

#define RP23XX_M33_FP_CTRL_NUM_CODE_7_4__RESET  0x8
#define RP23XX_M33_FP_CTRL_NUM_CODE_7_4__BITS   0x000000f0
#define RP23XX_M33_FP_CTRL_NUM_CODE_7_4__MSB    7
#define RP23XX_M33_FP_CTRL_NUM_CODE_7_4__LSB    4
#define RP23XX_M33_FP_CTRL_NUM_CODE_7_4__ACCESS "RO"

#define RP23XX_M33_FP_CTRL_KEY_RESET  0x0
#define RP23XX_M33_FP_CTRL_KEY_BITS   0x00000002
#define RP23XX_M33_FP_CTRL_KEY_MSB    1
#define RP23XX_M33_FP_CTRL_KEY_LSB    1
#define RP23XX_M33_FP_CTRL_KEY_ACCESS "RW"

#define RP23XX_M33_FP_CTRL_ENABLE_RESET  0x0
#define RP23XX_M33_FP_CTRL_ENABLE_BITS   0x00000001
#define RP23XX_M33_FP_CTRL_ENABLE_MSB    0
#define RP23XX_M33_FP_CTRL_ENABLE_LSB    0
#define RP23XX_M33_FP_CTRL_ENABLE_ACCESS "RW"

#define RP23XX_M33_FP_REMAP_OFFSET 0x00002004
#define RP23XX_M33_FP_REMAP_BITS   0x3fffffe0
#define RP23XX_M33_FP_REMAP_RESET  0x00000000

#define RP23XX_M33_FP_REMAP_RMPSPT_RESET  0x0
#define RP23XX_M33_FP_REMAP_RMPSPT_BITS   0x20000000
#define RP23XX_M33_FP_REMAP_RMPSPT_MSB    29
#define RP23XX_M33_FP_REMAP_RMPSPT_LSB    29
#define RP23XX_M33_FP_REMAP_RMPSPT_ACCESS "RO"

#define RP23XX_M33_FP_REMAP_REMAP_RESET  0x000000
#define RP23XX_M33_FP_REMAP_REMAP_BITS   0x1fffffe0
#define RP23XX_M33_FP_REMAP_REMAP_MSB    28
#define RP23XX_M33_FP_REMAP_REMAP_LSB    5
#define RP23XX_M33_FP_REMAP_REMAP_ACCESS "RO"

#define RP23XX_M33_FP_COMP0_OFFSET 0x00002008
#define RP23XX_M33_FP_COMP0_BITS   0x00000001
#define RP23XX_M33_FP_COMP0_RESET  0x00000000

#define RP23XX_M33_FP_COMP0_BE_RESET  0x0
#define RP23XX_M33_FP_COMP0_BE_BITS   0x00000001
#define RP23XX_M33_FP_COMP0_BE_MSB    0
#define RP23XX_M33_FP_COMP0_BE_LSB    0
#define RP23XX_M33_FP_COMP0_BE_ACCESS "RW"

#define RP23XX_M33_FP_COMP1_OFFSET 0x0000200c
#define RP23XX_M33_FP_COMP1_BITS   0x00000001
#define RP23XX_M33_FP_COMP1_RESET  0x00000000

#define RP23XX_M33_FP_COMP1_BE_RESET  0x0
#define RP23XX_M33_FP_COMP1_BE_BITS   0x00000001
#define RP23XX_M33_FP_COMP1_BE_MSB    0
#define RP23XX_M33_FP_COMP1_BE_LSB    0
#define RP23XX_M33_FP_COMP1_BE_ACCESS "RW"

#define RP23XX_M33_FP_COMP2_OFFSET 0x00002010
#define RP23XX_M33_FP_COMP2_BITS   0x00000001
#define RP23XX_M33_FP_COMP2_RESET  0x00000000

#define RP23XX_M33_FP_COMP2_BE_RESET  0x0
#define RP23XX_M33_FP_COMP2_BE_BITS   0x00000001
#define RP23XX_M33_FP_COMP2_BE_MSB    0
#define RP23XX_M33_FP_COMP2_BE_LSB    0
#define RP23XX_M33_FP_COMP2_BE_ACCESS "RW"

#define RP23XX_M33_FP_COMP3_OFFSET 0x00002014
#define RP23XX_M33_FP_COMP3_BITS   0x00000001
#define RP23XX_M33_FP_COMP3_RESET  0x00000000

#define RP23XX_M33_FP_COMP3_BE_RESET  0x0
#define RP23XX_M33_FP_COMP3_BE_BITS   0x00000001
#define RP23XX_M33_FP_COMP3_BE_MSB    0
#define RP23XX_M33_FP_COMP3_BE_LSB    0
#define RP23XX_M33_FP_COMP3_BE_ACCESS "RW"

#define RP23XX_M33_FP_COMP4_OFFSET 0x00002018
#define RP23XX_M33_FP_COMP4_BITS   0x00000001
#define RP23XX_M33_FP_COMP4_RESET  0x00000000

#define RP23XX_M33_FP_COMP4_BE_RESET  0x0
#define RP23XX_M33_FP_COMP4_BE_BITS   0x00000001
#define RP23XX_M33_FP_COMP4_BE_MSB    0
#define RP23XX_M33_FP_COMP4_BE_LSB    0
#define RP23XX_M33_FP_COMP4_BE_ACCESS "RW"

#define RP23XX_M33_FP_COMP5_OFFSET 0x0000201c
#define RP23XX_M33_FP_COMP5_BITS   0x00000001
#define RP23XX_M33_FP_COMP5_RESET  0x00000000

#define RP23XX_M33_FP_COMP5_BE_RESET  0x0
#define RP23XX_M33_FP_COMP5_BE_BITS   0x00000001
#define RP23XX_M33_FP_COMP5_BE_MSB    0
#define RP23XX_M33_FP_COMP5_BE_LSB    0
#define RP23XX_M33_FP_COMP5_BE_ACCESS "RW"

#define RP23XX_M33_FP_COMP6_OFFSET 0x00002020
#define RP23XX_M33_FP_COMP6_BITS   0x00000001
#define RP23XX_M33_FP_COMP6_RESET  0x00000000

#define RP23XX_M33_FP_COMP6_BE_RESET  0x0
#define RP23XX_M33_FP_COMP6_BE_BITS   0x00000001
#define RP23XX_M33_FP_COMP6_BE_MSB    0
#define RP23XX_M33_FP_COMP6_BE_LSB    0
#define RP23XX_M33_FP_COMP6_BE_ACCESS "RW"

#define RP23XX_M33_FP_COMP7_OFFSET 0x00002024
#define RP23XX_M33_FP_COMP7_BITS   0x00000001
#define RP23XX_M33_FP_COMP7_RESET  0x00000000

#define RP23XX_M33_FP_COMP7_BE_RESET  0x0
#define RP23XX_M33_FP_COMP7_BE_BITS   0x00000001
#define RP23XX_M33_FP_COMP7_BE_MSB    0
#define RP23XX_M33_FP_COMP7_BE_LSB    0
#define RP23XX_M33_FP_COMP7_BE_ACCESS "RW"

#define RP23XX_M33_FP_DEVARCH_OFFSET 0x00002fbc
#define RP23XX_M33_FP_DEVARCH_BITS   0xffffffff
#define RP23XX_M33_FP_DEVARCH_RESET  0x47701a03

#define RP23XX_M33_FP_DEVARCH_ARCHITECT_RESET  0x23b
#define RP23XX_M33_FP_DEVARCH_ARCHITECT_BITS   0xffe00000
#define RP23XX_M33_FP_DEVARCH_ARCHITECT_MSB    31
#define RP23XX_M33_FP_DEVARCH_ARCHITECT_LSB    21
#define RP23XX_M33_FP_DEVARCH_ARCHITECT_ACCESS "RO"

#define RP23XX_M33_FP_DEVARCH_PRESENT_RESET  0x1
#define RP23XX_M33_FP_DEVARCH_PRESENT_BITS   0x00100000
#define RP23XX_M33_FP_DEVARCH_PRESENT_MSB    20
#define RP23XX_M33_FP_DEVARCH_PRESENT_LSB    20
#define RP23XX_M33_FP_DEVARCH_PRESENT_ACCESS "RO"

#define RP23XX_M33_FP_DEVARCH_REVISION_RESET  0x0
#define RP23XX_M33_FP_DEVARCH_REVISION_BITS   0x000f0000
#define RP23XX_M33_FP_DEVARCH_REVISION_MSB    19
#define RP23XX_M33_FP_DEVARCH_REVISION_LSB    16
#define RP23XX_M33_FP_DEVARCH_REVISION_ACCESS "RO"

#define RP23XX_M33_FP_DEVARCH_ARCHVER_RESET  0x1
#define RP23XX_M33_FP_DEVARCH_ARCHVER_BITS   0x0000f000
#define RP23XX_M33_FP_DEVARCH_ARCHVER_MSB    15
#define RP23XX_M33_FP_DEVARCH_ARCHVER_LSB    12
#define RP23XX_M33_FP_DEVARCH_ARCHVER_ACCESS "RO"

#define RP23XX_M33_FP_DEVARCH_ARCHPART_RESET  0xa03
#define RP23XX_M33_FP_DEVARCH_ARCHPART_BITS   0x00000fff
#define RP23XX_M33_FP_DEVARCH_ARCHPART_MSB    11
#define RP23XX_M33_FP_DEVARCH_ARCHPART_LSB    0
#define RP23XX_M33_FP_DEVARCH_ARCHPART_ACCESS "RO"

#define RP23XX_M33_FP_DEVTYPE_OFFSET 0x00002fcc
#define RP23XX_M33_FP_DEVTYPE_BITS   0x000000ff
#define RP23XX_M33_FP_DEVTYPE_RESET  0x00000000

#define RP23XX_M33_FP_DEVTYPE_SUB_RESET  0x0
#define RP23XX_M33_FP_DEVTYPE_SUB_BITS   0x000000f0
#define RP23XX_M33_FP_DEVTYPE_SUB_MSB    7
#define RP23XX_M33_FP_DEVTYPE_SUB_LSB    4
#define RP23XX_M33_FP_DEVTYPE_SUB_ACCESS "RO"

#define RP23XX_M33_FP_DEVTYPE_MAJOR_RESET  0x0
#define RP23XX_M33_FP_DEVTYPE_MAJOR_BITS   0x0000000f
#define RP23XX_M33_FP_DEVTYPE_MAJOR_MSB    3
#define RP23XX_M33_FP_DEVTYPE_MAJOR_LSB    0
#define RP23XX_M33_FP_DEVTYPE_MAJOR_ACCESS "RO"

#define RP23XX_M33_FP_PIDR4_OFFSET 0x00002fd0
#define RP23XX_M33_FP_PIDR4_BITS   0x000000ff
#define RP23XX_M33_FP_PIDR4_RESET  0x00000004

#define RP23XX_M33_FP_PIDR4_SIZE_RESET  0x0
#define RP23XX_M33_FP_PIDR4_SIZE_BITS   0x000000f0
#define RP23XX_M33_FP_PIDR4_SIZE_MSB    7
#define RP23XX_M33_FP_PIDR4_SIZE_LSB    4
#define RP23XX_M33_FP_PIDR4_SIZE_ACCESS "RO"

#define RP23XX_M33_FP_PIDR4_DES_2_RESET  0x4
#define RP23XX_M33_FP_PIDR4_DES_2_BITS   0x0000000f
#define RP23XX_M33_FP_PIDR4_DES_2_MSB    3
#define RP23XX_M33_FP_PIDR4_DES_2_LSB    0
#define RP23XX_M33_FP_PIDR4_DES_2_ACCESS "RO"

#define RP23XX_M33_FP_PIDR5_OFFSET 0x00002fd4
#define RP23XX_M33_FP_PIDR5_BITS   0x00000000
#define RP23XX_M33_FP_PIDR5_RESET  0x00000000
#define RP23XX_M33_FP_PIDR5_MSB    31
#define RP23XX_M33_FP_PIDR5_LSB    0
#define RP23XX_M33_FP_PIDR5_ACCESS "RW"

#define RP23XX_M33_FP_PIDR6_OFFSET 0x00002fd8
#define RP23XX_M33_FP_PIDR6_BITS   0x00000000
#define RP23XX_M33_FP_PIDR6_RESET  0x00000000
#define RP23XX_M33_FP_PIDR6_MSB    31
#define RP23XX_M33_FP_PIDR6_LSB    0
#define RP23XX_M33_FP_PIDR6_ACCESS "RW"

#define RP23XX_M33_FP_PIDR7_OFFSET 0x00002fdc
#define RP23XX_M33_FP_PIDR7_BITS   0x00000000
#define RP23XX_M33_FP_PIDR7_RESET  0x00000000
#define RP23XX_M33_FP_PIDR7_MSB    31
#define RP23XX_M33_FP_PIDR7_LSB    0
#define RP23XX_M33_FP_PIDR7_ACCESS "RW"

#define RP23XX_M33_FP_PIDR0_OFFSET 0x00002fe0
#define RP23XX_M33_FP_PIDR0_BITS   0x000000ff
#define RP23XX_M33_FP_PIDR0_RESET  0x00000021

#define RP23XX_M33_FP_PIDR0_PART_0_RESET  0x21
#define RP23XX_M33_FP_PIDR0_PART_0_BITS   0x000000ff
#define RP23XX_M33_FP_PIDR0_PART_0_MSB    7
#define RP23XX_M33_FP_PIDR0_PART_0_LSB    0
#define RP23XX_M33_FP_PIDR0_PART_0_ACCESS "RO"

#define RP23XX_M33_FP_PIDR1_OFFSET 0x00002fe4
#define RP23XX_M33_FP_PIDR1_BITS   0x000000ff
#define RP23XX_M33_FP_PIDR1_RESET  0x000000bd

#define RP23XX_M33_FP_PIDR1_DES_0_RESET  0xb
#define RP23XX_M33_FP_PIDR1_DES_0_BITS   0x000000f0
#define RP23XX_M33_FP_PIDR1_DES_0_MSB    7
#define RP23XX_M33_FP_PIDR1_DES_0_LSB    4
#define RP23XX_M33_FP_PIDR1_DES_0_ACCESS "RO"

#define RP23XX_M33_FP_PIDR1_PART_1_RESET  0xd
#define RP23XX_M33_FP_PIDR1_PART_1_BITS   0x0000000f
#define RP23XX_M33_FP_PIDR1_PART_1_MSB    3
#define RP23XX_M33_FP_PIDR1_PART_1_LSB    0
#define RP23XX_M33_FP_PIDR1_PART_1_ACCESS "RO"

#define RP23XX_M33_FP_PIDR2_OFFSET 0x00002fe8
#define RP23XX_M33_FP_PIDR2_BITS   0x000000ff
#define RP23XX_M33_FP_PIDR2_RESET  0x0000000b

#define RP23XX_M33_FP_PIDR2_REVISION_RESET  0x0
#define RP23XX_M33_FP_PIDR2_REVISION_BITS   0x000000f0
#define RP23XX_M33_FP_PIDR2_REVISION_MSB    7
#define RP23XX_M33_FP_PIDR2_REVISION_LSB    4
#define RP23XX_M33_FP_PIDR2_REVISION_ACCESS "RO"

#define RP23XX_M33_FP_PIDR2_JEDEC_RESET  0x1
#define RP23XX_M33_FP_PIDR2_JEDEC_BITS   0x00000008
#define RP23XX_M33_FP_PIDR2_JEDEC_MSB    3
#define RP23XX_M33_FP_PIDR2_JEDEC_LSB    3
#define RP23XX_M33_FP_PIDR2_JEDEC_ACCESS "RO"

#define RP23XX_M33_FP_PIDR2_DES_1_RESET  0x3
#define RP23XX_M33_FP_PIDR2_DES_1_BITS   0x00000007
#define RP23XX_M33_FP_PIDR2_DES_1_MSB    2
#define RP23XX_M33_FP_PIDR2_DES_1_LSB    0
#define RP23XX_M33_FP_PIDR2_DES_1_ACCESS "RO"

#define RP23XX_M33_FP_PIDR3_OFFSET 0x00002fec
#define RP23XX_M33_FP_PIDR3_BITS   0x000000ff
#define RP23XX_M33_FP_PIDR3_RESET  0x00000000

#define RP23XX_M33_FP_PIDR3_REVAND_RESET  0x0
#define RP23XX_M33_FP_PIDR3_REVAND_BITS   0x000000f0
#define RP23XX_M33_FP_PIDR3_REVAND_MSB    7
#define RP23XX_M33_FP_PIDR3_REVAND_LSB    4
#define RP23XX_M33_FP_PIDR3_REVAND_ACCESS "RO"

#define RP23XX_M33_FP_PIDR3_CMOD_RESET  0x0
#define RP23XX_M33_FP_PIDR3_CMOD_BITS   0x0000000f
#define RP23XX_M33_FP_PIDR3_CMOD_MSB    3
#define RP23XX_M33_FP_PIDR3_CMOD_LSB    0
#define RP23XX_M33_FP_PIDR3_CMOD_ACCESS "RO"

#define RP23XX_M33_FP_CIDR0_OFFSET 0x00002ff0
#define RP23XX_M33_FP_CIDR0_BITS   0x000000ff
#define RP23XX_M33_FP_CIDR0_RESET  0x0000000d

#define RP23XX_M33_FP_CIDR0_PRMBL_0_RESET  0x0d
#define RP23XX_M33_FP_CIDR0_PRMBL_0_BITS   0x000000ff
#define RP23XX_M33_FP_CIDR0_PRMBL_0_MSB    7
#define RP23XX_M33_FP_CIDR0_PRMBL_0_LSB    0
#define RP23XX_M33_FP_CIDR0_PRMBL_0_ACCESS "RO"

#define RP23XX_M33_FP_CIDR1_OFFSET 0x00002ff4
#define RP23XX_M33_FP_CIDR1_BITS   0x000000ff
#define RP23XX_M33_FP_CIDR1_RESET  0x00000090

#define RP23XX_M33_FP_CIDR1_CLASS_RESET  0x9
#define RP23XX_M33_FP_CIDR1_CLASS_BITS   0x000000f0
#define RP23XX_M33_FP_CIDR1_CLASS_MSB    7
#define RP23XX_M33_FP_CIDR1_CLASS_LSB    4
#define RP23XX_M33_FP_CIDR1_CLASS_ACCESS "RO"

#define RP23XX_M33_FP_CIDR1_PRMBL_1_RESET  0x0
#define RP23XX_M33_FP_CIDR1_PRMBL_1_BITS   0x0000000f
#define RP23XX_M33_FP_CIDR1_PRMBL_1_MSB    3
#define RP23XX_M33_FP_CIDR1_PRMBL_1_LSB    0
#define RP23XX_M33_FP_CIDR1_PRMBL_1_ACCESS "RO"

#define RP23XX_M33_FP_CIDR2_OFFSET 0x00002ff8
#define RP23XX_M33_FP_CIDR2_BITS   0x000000ff
#define RP23XX_M33_FP_CIDR2_RESET  0x00000005

#define RP23XX_M33_FP_CIDR2_PRMBL_2_RESET  0x05
#define RP23XX_M33_FP_CIDR2_PRMBL_2_BITS   0x000000ff
#define RP23XX_M33_FP_CIDR2_PRMBL_2_MSB    7
#define RP23XX_M33_FP_CIDR2_PRMBL_2_LSB    0
#define RP23XX_M33_FP_CIDR2_PRMBL_2_ACCESS "RO"

#define RP23XX_M33_FP_CIDR3_OFFSET 0x00002ffc
#define RP23XX_M33_FP_CIDR3_BITS   0x000000ff
#define RP23XX_M33_FP_CIDR3_RESET  0x000000b1

#define RP23XX_M33_FP_CIDR3_PRMBL_3_RESET  0xb1
#define RP23XX_M33_FP_CIDR3_PRMBL_3_BITS   0x000000ff
#define RP23XX_M33_FP_CIDR3_PRMBL_3_MSB    7
#define RP23XX_M33_FP_CIDR3_PRMBL_3_LSB    0
#define RP23XX_M33_FP_CIDR3_PRMBL_3_ACCESS "RO"

#define RP23XX_M33_ICTR_OFFSET 0x0000e004
#define RP23XX_M33_ICTR_BITS   0x0000000f
#define RP23XX_M33_ICTR_RESET  0x00000001

#define RP23XX_M33_ICTR_INTLINESNUM_RESET  0x1
#define RP23XX_M33_ICTR_INTLINESNUM_BITS   0x0000000f
#define RP23XX_M33_ICTR_INTLINESNUM_MSB    3
#define RP23XX_M33_ICTR_INTLINESNUM_LSB    0
#define RP23XX_M33_ICTR_INTLINESNUM_ACCESS "RO"

#define RP23XX_M33_ACTLR_OFFSET 0x0000e008
#define RP23XX_M33_ACTLR_BITS   0x20001605
#define RP23XX_M33_ACTLR_RESET  0x00000000

#define RP23XX_M33_ACTLR_EXTEXCLALL_RESET  0x0
#define RP23XX_M33_ACTLR_EXTEXCLALL_BITS   0x20000000
#define RP23XX_M33_ACTLR_EXTEXCLALL_MSB    29
#define RP23XX_M33_ACTLR_EXTEXCLALL_LSB    29
#define RP23XX_M33_ACTLR_EXTEXCLALL_ACCESS "RW"

#define RP23XX_M33_ACTLR_DISITMATBFLUSH_RESET  0x0
#define RP23XX_M33_ACTLR_DISITMATBFLUSH_BITS   0x00001000
#define RP23XX_M33_ACTLR_DISITMATBFLUSH_MSB    12
#define RP23XX_M33_ACTLR_DISITMATBFLUSH_LSB    12
#define RP23XX_M33_ACTLR_DISITMATBFLUSH_ACCESS "RW"

#define RP23XX_M33_ACTLR_FPEXCODIS_RESET  0x0
#define RP23XX_M33_ACTLR_FPEXCODIS_BITS   0x00000400
#define RP23XX_M33_ACTLR_FPEXCODIS_MSB    10
#define RP23XX_M33_ACTLR_FPEXCODIS_LSB    10
#define RP23XX_M33_ACTLR_FPEXCODIS_ACCESS "RW"

#define RP23XX_M33_ACTLR_DISOOFP_RESET  0x0
#define RP23XX_M33_ACTLR_DISOOFP_BITS   0x00000200
#define RP23XX_M33_ACTLR_DISOOFP_MSB    9
#define RP23XX_M33_ACTLR_DISOOFP_LSB    9
#define RP23XX_M33_ACTLR_DISOOFP_ACCESS "RW"

#define RP23XX_M33_ACTLR_DISFOLD_RESET  0x0
#define RP23XX_M33_ACTLR_DISFOLD_BITS   0x00000004
#define RP23XX_M33_ACTLR_DISFOLD_MSB    2
#define RP23XX_M33_ACTLR_DISFOLD_LSB    2
#define RP23XX_M33_ACTLR_DISFOLD_ACCESS "RW"

#define RP23XX_M33_ACTLR_DISMCYCINT_RESET  0x0
#define RP23XX_M33_ACTLR_DISMCYCINT_BITS   0x00000001
#define RP23XX_M33_ACTLR_DISMCYCINT_MSB    0
#define RP23XX_M33_ACTLR_DISMCYCINT_LSB    0
#define RP23XX_M33_ACTLR_DISMCYCINT_ACCESS "RW"

#define RP23XX_M33_SYST_CSR_OFFSET 0x0000e010
#define RP23XX_M33_SYST_CSR_BITS   0x00010007
#define RP23XX_M33_SYST_CSR_RESET  0x00000000

#define RP23XX_M33_SYST_CSR_COUNTFLAG_RESET  0x0
#define RP23XX_M33_SYST_CSR_COUNTFLAG_BITS   0x00010000
#define RP23XX_M33_SYST_CSR_COUNTFLAG_MSB    16
#define RP23XX_M33_SYST_CSR_COUNTFLAG_LSB    16
#define RP23XX_M33_SYST_CSR_COUNTFLAG_ACCESS "RO"

#define RP23XX_M33_SYST_CSR_CLKSOURCE_RESET  0x0
#define RP23XX_M33_SYST_CSR_CLKSOURCE_BITS   0x00000004
#define RP23XX_M33_SYST_CSR_CLKSOURCE_MSB    2
#define RP23XX_M33_SYST_CSR_CLKSOURCE_LSB    2
#define RP23XX_M33_SYST_CSR_CLKSOURCE_ACCESS "RW"

#define RP23XX_M33_SYST_CSR_TICKINT_RESET  0x0
#define RP23XX_M33_SYST_CSR_TICKINT_BITS   0x00000002
#define RP23XX_M33_SYST_CSR_TICKINT_MSB    1
#define RP23XX_M33_SYST_CSR_TICKINT_LSB    1
#define RP23XX_M33_SYST_CSR_TICKINT_ACCESS "RW"

#define RP23XX_M33_SYST_CSR_ENABLE_RESET  0x0
#define RP23XX_M33_SYST_CSR_ENABLE_BITS   0x00000001
#define RP23XX_M33_SYST_CSR_ENABLE_MSB    0
#define RP23XX_M33_SYST_CSR_ENABLE_LSB    0
#define RP23XX_M33_SYST_CSR_ENABLE_ACCESS "RW"

#define RP23XX_M33_SYST_RVR_OFFSET 0x0000e014
#define RP23XX_M33_SYST_RVR_BITS   0x00ffffff
#define RP23XX_M33_SYST_RVR_RESET  0x00000000

#define RP23XX_M33_SYST_RVR_RELOAD_RESET  0x000000
#define RP23XX_M33_SYST_RVR_RELOAD_BITS   0x00ffffff
#define RP23XX_M33_SYST_RVR_RELOAD_MSB    23
#define RP23XX_M33_SYST_RVR_RELOAD_LSB    0
#define RP23XX_M33_SYST_RVR_RELOAD_ACCESS "RW"

#define RP23XX_M33_SYST_CVR_OFFSET 0x0000e018
#define RP23XX_M33_SYST_CVR_BITS   0x00ffffff
#define RP23XX_M33_SYST_CVR_RESET  0x00000000

#define RP23XX_M33_SYST_CVR_CURRENT_RESET  0x000000
#define RP23XX_M33_SYST_CVR_CURRENT_BITS   0x00ffffff
#define RP23XX_M33_SYST_CVR_CURRENT_MSB    23
#define RP23XX_M33_SYST_CVR_CURRENT_LSB    0
#define RP23XX_M33_SYST_CVR_CURRENT_ACCESS "RW"

#define RP23XX_M33_SYST_CALIB_OFFSET 0x0000e01c
#define RP23XX_M33_SYST_CALIB_BITS   0xc0ffffff
#define RP23XX_M33_SYST_CALIB_RESET  0x00000000

#define RP23XX_M33_SYST_CALIB_NOREF_RESET  0x0
#define RP23XX_M33_SYST_CALIB_NOREF_BITS   0x80000000
#define RP23XX_M33_SYST_CALIB_NOREF_MSB    31
#define RP23XX_M33_SYST_CALIB_NOREF_LSB    31
#define RP23XX_M33_SYST_CALIB_NOREF_ACCESS "RO"

#define RP23XX_M33_SYST_CALIB_SKEW_RESET  0x0
#define RP23XX_M33_SYST_CALIB_SKEW_BITS   0x40000000
#define RP23XX_M33_SYST_CALIB_SKEW_MSB    30
#define RP23XX_M33_SYST_CALIB_SKEW_LSB    30
#define RP23XX_M33_SYST_CALIB_SKEW_ACCESS "RO"

#define RP23XX_M33_SYST_CALIB_TENMS_RESET  0x000000
#define RP23XX_M33_SYST_CALIB_TENMS_BITS   0x00ffffff
#define RP23XX_M33_SYST_CALIB_TENMS_MSB    23
#define RP23XX_M33_SYST_CALIB_TENMS_LSB    0
#define RP23XX_M33_SYST_CALIB_TENMS_ACCESS "RO"

#define RP23XX_M33_NVIC_ISER0_OFFSET 0x0000e100
#define RP23XX_M33_NVIC_ISER0_BITS   0xffffffff
#define RP23XX_M33_NVIC_ISER0_RESET  0x00000000

#define RP23XX_M33_NVIC_ISER0_SETENA_RESET  0x00000000
#define RP23XX_M33_NVIC_ISER0_SETENA_BITS   0xffffffff
#define RP23XX_M33_NVIC_ISER0_SETENA_MSB    31
#define RP23XX_M33_NVIC_ISER0_SETENA_LSB    0
#define RP23XX_M33_NVIC_ISER0_SETENA_ACCESS "RW"

#define RP23XX_M33_NVIC_ISER1_OFFSET 0x0000e104
#define RP23XX_M33_NVIC_ISER1_BITS   0xffffffff
#define RP23XX_M33_NVIC_ISER1_RESET  0x00000000

#define RP23XX_M33_NVIC_ISER1_SETENA_RESET  0x00000000
#define RP23XX_M33_NVIC_ISER1_SETENA_BITS   0xffffffff
#define RP23XX_M33_NVIC_ISER1_SETENA_MSB    31
#define RP23XX_M33_NVIC_ISER1_SETENA_LSB    0
#define RP23XX_M33_NVIC_ISER1_SETENA_ACCESS "RW"

#define RP23XX_M33_NVIC_ICER0_OFFSET 0x0000e180
#define RP23XX_M33_NVIC_ICER0_BITS   0xffffffff
#define RP23XX_M33_NVIC_ICER0_RESET  0x00000000

#define RP23XX_M33_NVIC_ICER0_CLRENA_RESET  0x00000000
#define RP23XX_M33_NVIC_ICER0_CLRENA_BITS   0xffffffff
#define RP23XX_M33_NVIC_ICER0_CLRENA_MSB    31
#define RP23XX_M33_NVIC_ICER0_CLRENA_LSB    0
#define RP23XX_M33_NVIC_ICER0_CLRENA_ACCESS "RW"

#define RP23XX_M33_NVIC_ICER1_OFFSET 0x0000e184
#define RP23XX_M33_NVIC_ICER1_BITS   0xffffffff
#define RP23XX_M33_NVIC_ICER1_RESET  0x00000000

#define RP23XX_M33_NVIC_ICER1_CLRENA_RESET  0x00000000
#define RP23XX_M33_NVIC_ICER1_CLRENA_BITS   0xffffffff
#define RP23XX_M33_NVIC_ICER1_CLRENA_MSB    31
#define RP23XX_M33_NVIC_ICER1_CLRENA_LSB    0
#define RP23XX_M33_NVIC_ICER1_CLRENA_ACCESS "RW"

#define RP23XX_M33_NVIC_ISPR0_OFFSET 0x0000e200
#define RP23XX_M33_NVIC_ISPR0_BITS   0xffffffff
#define RP23XX_M33_NVIC_ISPR0_RESET  0x00000000

#define RP23XX_M33_NVIC_ISPR0_SETPEND_RESET  0x00000000
#define RP23XX_M33_NVIC_ISPR0_SETPEND_BITS   0xffffffff
#define RP23XX_M33_NVIC_ISPR0_SETPEND_MSB    31
#define RP23XX_M33_NVIC_ISPR0_SETPEND_LSB    0
#define RP23XX_M33_NVIC_ISPR0_SETPEND_ACCESS "RW"

#define RP23XX_M33_NVIC_ISPR1_OFFSET 0x0000e204
#define RP23XX_M33_NVIC_ISPR1_BITS   0xffffffff
#define RP23XX_M33_NVIC_ISPR1_RESET  0x00000000

#define RP23XX_M33_NVIC_ISPR1_SETPEND_RESET  0x00000000
#define RP23XX_M33_NVIC_ISPR1_SETPEND_BITS   0xffffffff
#define RP23XX_M33_NVIC_ISPR1_SETPEND_MSB    31
#define RP23XX_M33_NVIC_ISPR1_SETPEND_LSB    0
#define RP23XX_M33_NVIC_ISPR1_SETPEND_ACCESS "RW"

#define RP23XX_M33_NVIC_ICPR0_OFFSET 0x0000e280
#define RP23XX_M33_NVIC_ICPR0_BITS   0xffffffff
#define RP23XX_M33_NVIC_ICPR0_RESET  0x00000000

#define RP23XX_M33_NVIC_ICPR0_CLRPEND_RESET  0x00000000
#define RP23XX_M33_NVIC_ICPR0_CLRPEND_BITS   0xffffffff
#define RP23XX_M33_NVIC_ICPR0_CLRPEND_MSB    31
#define RP23XX_M33_NVIC_ICPR0_CLRPEND_LSB    0
#define RP23XX_M33_NVIC_ICPR0_CLRPEND_ACCESS "RW"

#define RP23XX_M33_NVIC_ICPR1_OFFSET 0x0000e284
#define RP23XX_M33_NVIC_ICPR1_BITS   0xffffffff
#define RP23XX_M33_NVIC_ICPR1_RESET  0x00000000

#define RP23XX_M33_NVIC_ICPR1_CLRPEND_RESET  0x00000000
#define RP23XX_M33_NVIC_ICPR1_CLRPEND_BITS   0xffffffff
#define RP23XX_M33_NVIC_ICPR1_CLRPEND_MSB    31
#define RP23XX_M33_NVIC_ICPR1_CLRPEND_LSB    0
#define RP23XX_M33_NVIC_ICPR1_CLRPEND_ACCESS "RW"

#define RP23XX_M33_NVIC_IABR0_OFFSET 0x0000e300
#define RP23XX_M33_NVIC_IABR0_BITS   0xffffffff
#define RP23XX_M33_NVIC_IABR0_RESET  0x00000000

#define RP23XX_M33_NVIC_IABR0_ACTIVE_RESET  0x00000000
#define RP23XX_M33_NVIC_IABR0_ACTIVE_BITS   0xffffffff
#define RP23XX_M33_NVIC_IABR0_ACTIVE_MSB    31
#define RP23XX_M33_NVIC_IABR0_ACTIVE_LSB    0
#define RP23XX_M33_NVIC_IABR0_ACTIVE_ACCESS "RW"

#define RP23XX_M33_NVIC_IABR1_OFFSET 0x0000e304
#define RP23XX_M33_NVIC_IABR1_BITS   0xffffffff
#define RP23XX_M33_NVIC_IABR1_RESET  0x00000000

#define RP23XX_M33_NVIC_IABR1_ACTIVE_RESET  0x00000000
#define RP23XX_M33_NVIC_IABR1_ACTIVE_BITS   0xffffffff
#define RP23XX_M33_NVIC_IABR1_ACTIVE_MSB    31
#define RP23XX_M33_NVIC_IABR1_ACTIVE_LSB    0
#define RP23XX_M33_NVIC_IABR1_ACTIVE_ACCESS "RW"

#define RP23XX_M33_NVIC_ITNS0_OFFSET 0x0000e380
#define RP23XX_M33_NVIC_ITNS0_BITS   0xffffffff
#define RP23XX_M33_NVIC_ITNS0_RESET  0x00000000

#define RP23XX_M33_NVIC_ITNS0_ITNS_RESET  0x00000000
#define RP23XX_M33_NVIC_ITNS0_ITNS_BITS   0xffffffff
#define RP23XX_M33_NVIC_ITNS0_ITNS_MSB    31
#define RP23XX_M33_NVIC_ITNS0_ITNS_LSB    0
#define RP23XX_M33_NVIC_ITNS0_ITNS_ACCESS "RW"

#define RP23XX_M33_NVIC_ITNS1_OFFSET 0x0000e384
#define RP23XX_M33_NVIC_ITNS1_BITS   0xffffffff
#define RP23XX_M33_NVIC_ITNS1_RESET  0x00000000

#define RP23XX_M33_NVIC_ITNS1_ITNS_RESET  0x00000000
#define RP23XX_M33_NVIC_ITNS1_ITNS_BITS   0xffffffff
#define RP23XX_M33_NVIC_ITNS1_ITNS_MSB    31
#define RP23XX_M33_NVIC_ITNS1_ITNS_LSB    0
#define RP23XX_M33_NVIC_ITNS1_ITNS_ACCESS "RW"

#define RP23XX_M33_NVIC_IPR0_OFFSET 0x0000e400
#define RP23XX_M33_NVIC_IPR0_BITS   0xf0f0f0f0
#define RP23XX_M33_NVIC_IPR0_RESET  0x00000000

#define RP23XX_M33_NVIC_IPR0_PRI_N3_RESET  0x0
#define RP23XX_M33_NVIC_IPR0_PRI_N3_BITS   0xf0000000
#define RP23XX_M33_NVIC_IPR0_PRI_N3_MSB    31
#define RP23XX_M33_NVIC_IPR0_PRI_N3_LSB    28
#define RP23XX_M33_NVIC_IPR0_PRI_N3_ACCESS "RW"

#define RP23XX_M33_NVIC_IPR0_PRI_N2_RESET  0x0
#define RP23XX_M33_NVIC_IPR0_PRI_N2_BITS   0x00f00000
#define RP23XX_M33_NVIC_IPR0_PRI_N2_MSB    23
#define RP23XX_M33_NVIC_IPR0_PRI_N2_LSB    20
#define RP23XX_M33_NVIC_IPR0_PRI_N2_ACCESS "RW"

#define RP23XX_M33_NVIC_IPR0_PRI_N1_RESET  0x0
#define RP23XX_M33_NVIC_IPR0_PRI_N1_BITS   0x0000f000
#define RP23XX_M33_NVIC_IPR0_PRI_N1_MSB    15
#define RP23XX_M33_NVIC_IPR0_PRI_N1_LSB    12
#define RP23XX_M33_NVIC_IPR0_PRI_N1_ACCESS "RW"

#define RP23XX_M33_NVIC_IPR0_PRI_N0_RESET  0x0
#define RP23XX_M33_NVIC_IPR0_PRI_N0_BITS   0x000000f0
#define RP23XX_M33_NVIC_IPR0_PRI_N0_MSB    7
#define RP23XX_M33_NVIC_IPR0_PRI_N0_LSB    4
#define RP23XX_M33_NVIC_IPR0_PRI_N0_ACCESS "RW"

#define RP23XX_M33_NVIC_IPR1_OFFSET 0x0000e404
#define RP23XX_M33_NVIC_IPR1_BITS   0xf0f0f0f0
#define RP23XX_M33_NVIC_IPR1_RESET  0x00000000

#define RP23XX_M33_NVIC_IPR1_PRI_N3_RESET  0x0
#define RP23XX_M33_NVIC_IPR1_PRI_N3_BITS   0xf0000000
#define RP23XX_M33_NVIC_IPR1_PRI_N3_MSB    31
#define RP23XX_M33_NVIC_IPR1_PRI_N3_LSB    28
#define RP23XX_M33_NVIC_IPR1_PRI_N3_ACCESS "RW"

#define RP23XX_M33_NVIC_IPR1_PRI_N2_RESET  0x0
#define RP23XX_M33_NVIC_IPR1_PRI_N2_BITS   0x00f00000
#define RP23XX_M33_NVIC_IPR1_PRI_N2_MSB    23
#define RP23XX_M33_NVIC_IPR1_PRI_N2_LSB    20
#define RP23XX_M33_NVIC_IPR1_PRI_N2_ACCESS "RW"

#define RP23XX_M33_NVIC_IPR1_PRI_N1_RESET  0x0
#define RP23XX_M33_NVIC_IPR1_PRI_N1_BITS   0x0000f000
#define RP23XX_M33_NVIC_IPR1_PRI_N1_MSB    15
#define RP23XX_M33_NVIC_IPR1_PRI_N1_LSB    12
#define RP23XX_M33_NVIC_IPR1_PRI_N1_ACCESS "RW"

#define RP23XX_M33_NVIC_IPR1_PRI_N0_RESET  0x0
#define RP23XX_M33_NVIC_IPR1_PRI_N0_BITS   0x000000f0
#define RP23XX_M33_NVIC_IPR1_PRI_N0_MSB    7
#define RP23XX_M33_NVIC_IPR1_PRI_N0_LSB    4
#define RP23XX_M33_NVIC_IPR1_PRI_N0_ACCESS "RW"

#define RP23XX_M33_NVIC_IPR2_OFFSET 0x0000e408
#define RP23XX_M33_NVIC_IPR2_BITS   0xf0f0f0f0
#define RP23XX_M33_NVIC_IPR2_RESET  0x00000000

#define RP23XX_M33_NVIC_IPR2_PRI_N3_RESET  0x0
#define RP23XX_M33_NVIC_IPR2_PRI_N3_BITS   0xf0000000
#define RP23XX_M33_NVIC_IPR2_PRI_N3_MSB    31
#define RP23XX_M33_NVIC_IPR2_PRI_N3_LSB    28
#define RP23XX_M33_NVIC_IPR2_PRI_N3_ACCESS "RW"

#define RP23XX_M33_NVIC_IPR2_PRI_N2_RESET  0x0
#define RP23XX_M33_NVIC_IPR2_PRI_N2_BITS   0x00f00000
#define RP23XX_M33_NVIC_IPR2_PRI_N2_MSB    23
#define RP23XX_M33_NVIC_IPR2_PRI_N2_LSB    20
#define RP23XX_M33_NVIC_IPR2_PRI_N2_ACCESS "RW"

#define RP23XX_M33_NVIC_IPR2_PRI_N1_RESET  0x0
#define RP23XX_M33_NVIC_IPR2_PRI_N1_BITS   0x0000f000
#define RP23XX_M33_NVIC_IPR2_PRI_N1_MSB    15
#define RP23XX_M33_NVIC_IPR2_PRI_N1_LSB    12
#define RP23XX_M33_NVIC_IPR2_PRI_N1_ACCESS "RW"

#define RP23XX_M33_NVIC_IPR2_PRI_N0_RESET  0x0
#define RP23XX_M33_NVIC_IPR2_PRI_N0_BITS   0x000000f0
#define RP23XX_M33_NVIC_IPR2_PRI_N0_MSB    7
#define RP23XX_M33_NVIC_IPR2_PRI_N0_LSB    4
#define RP23XX_M33_NVIC_IPR2_PRI_N0_ACCESS "RW"

#define RP23XX_M33_NVIC_IPR3_OFFSET 0x0000e40c
#define RP23XX_M33_NVIC_IPR3_BITS   0xf0f0f0f0
#define RP23XX_M33_NVIC_IPR3_RESET  0x00000000

#define RP23XX_M33_NVIC_IPR3_PRI_N3_RESET  0x0
#define RP23XX_M33_NVIC_IPR3_PRI_N3_BITS   0xf0000000
#define RP23XX_M33_NVIC_IPR3_PRI_N3_MSB    31
#define RP23XX_M33_NVIC_IPR3_PRI_N3_LSB    28
#define RP23XX_M33_NVIC_IPR3_PRI_N3_ACCESS "RW"

#define RP23XX_M33_NVIC_IPR3_PRI_N2_RESET  0x0
#define RP23XX_M33_NVIC_IPR3_PRI_N2_BITS   0x00f00000
#define RP23XX_M33_NVIC_IPR3_PRI_N2_MSB    23
#define RP23XX_M33_NVIC_IPR3_PRI_N2_LSB    20
#define RP23XX_M33_NVIC_IPR3_PRI_N2_ACCESS "RW"

#define RP23XX_M33_NVIC_IPR3_PRI_N1_RESET  0x0
#define RP23XX_M33_NVIC_IPR3_PRI_N1_BITS   0x0000f000
#define RP23XX_M33_NVIC_IPR3_PRI_N1_MSB    15
#define RP23XX_M33_NVIC_IPR3_PRI_N1_LSB    12
#define RP23XX_M33_NVIC_IPR3_PRI_N1_ACCESS "RW"

#define RP23XX_M33_NVIC_IPR3_PRI_N0_RESET  0x0
#define RP23XX_M33_NVIC_IPR3_PRI_N0_BITS   0x000000f0
#define RP23XX_M33_NVIC_IPR3_PRI_N0_MSB    7
#define RP23XX_M33_NVIC_IPR3_PRI_N0_LSB    4
#define RP23XX_M33_NVIC_IPR3_PRI_N0_ACCESS "RW"

#define RP23XX_M33_NVIC_IPR4_OFFSET 0x0000e410
#define RP23XX_M33_NVIC_IPR4_BITS   0xf0f0f0f0
#define RP23XX_M33_NVIC_IPR4_RESET  0x00000000

#define RP23XX_M33_NVIC_IPR4_PRI_N3_RESET  0x0
#define RP23XX_M33_NVIC_IPR4_PRI_N3_BITS   0xf0000000
#define RP23XX_M33_NVIC_IPR4_PRI_N3_MSB    31
#define RP23XX_M33_NVIC_IPR4_PRI_N3_LSB    28
#define RP23XX_M33_NVIC_IPR4_PRI_N3_ACCESS "RW"

#define RP23XX_M33_NVIC_IPR4_PRI_N2_RESET  0x0
#define RP23XX_M33_NVIC_IPR4_PRI_N2_BITS   0x00f00000
#define RP23XX_M33_NVIC_IPR4_PRI_N2_MSB    23
#define RP23XX_M33_NVIC_IPR4_PRI_N2_LSB    20
#define RP23XX_M33_NVIC_IPR4_PRI_N2_ACCESS "RW"

#define RP23XX_M33_NVIC_IPR4_PRI_N1_RESET  0x0
#define RP23XX_M33_NVIC_IPR4_PRI_N1_BITS   0x0000f000
#define RP23XX_M33_NVIC_IPR4_PRI_N1_MSB    15
#define RP23XX_M33_NVIC_IPR4_PRI_N1_LSB    12
#define RP23XX_M33_NVIC_IPR4_PRI_N1_ACCESS "RW"

#define RP23XX_M33_NVIC_IPR4_PRI_N0_RESET  0x0
#define RP23XX_M33_NVIC_IPR4_PRI_N0_BITS   0x000000f0
#define RP23XX_M33_NVIC_IPR4_PRI_N0_MSB    7
#define RP23XX_M33_NVIC_IPR4_PRI_N0_LSB    4
#define RP23XX_M33_NVIC_IPR4_PRI_N0_ACCESS "RW"

#define RP23XX_M33_NVIC_IPR5_OFFSET 0x0000e414
#define RP23XX_M33_NVIC_IPR5_BITS   0xf0f0f0f0
#define RP23XX_M33_NVIC_IPR5_RESET  0x00000000

#define RP23XX_M33_NVIC_IPR5_PRI_N3_RESET  0x0
#define RP23XX_M33_NVIC_IPR5_PRI_N3_BITS   0xf0000000
#define RP23XX_M33_NVIC_IPR5_PRI_N3_MSB    31
#define RP23XX_M33_NVIC_IPR5_PRI_N3_LSB    28
#define RP23XX_M33_NVIC_IPR5_PRI_N3_ACCESS "RW"

#define RP23XX_M33_NVIC_IPR5_PRI_N2_RESET  0x0
#define RP23XX_M33_NVIC_IPR5_PRI_N2_BITS   0x00f00000
#define RP23XX_M33_NVIC_IPR5_PRI_N2_MSB    23
#define RP23XX_M33_NVIC_IPR5_PRI_N2_LSB    20
#define RP23XX_M33_NVIC_IPR5_PRI_N2_ACCESS "RW"

#define RP23XX_M33_NVIC_IPR5_PRI_N1_RESET  0x0
#define RP23XX_M33_NVIC_IPR5_PRI_N1_BITS   0x0000f000
#define RP23XX_M33_NVIC_IPR5_PRI_N1_MSB    15
#define RP23XX_M33_NVIC_IPR5_PRI_N1_LSB    12
#define RP23XX_M33_NVIC_IPR5_PRI_N1_ACCESS "RW"

#define RP23XX_M33_NVIC_IPR5_PRI_N0_RESET  0x0
#define RP23XX_M33_NVIC_IPR5_PRI_N0_BITS   0x000000f0
#define RP23XX_M33_NVIC_IPR5_PRI_N0_MSB    7
#define RP23XX_M33_NVIC_IPR5_PRI_N0_LSB    4
#define RP23XX_M33_NVIC_IPR5_PRI_N0_ACCESS "RW"

#define RP23XX_M33_NVIC_IPR6_OFFSET 0x0000e418
#define RP23XX_M33_NVIC_IPR6_BITS   0xf0f0f0f0
#define RP23XX_M33_NVIC_IPR6_RESET  0x00000000

#define RP23XX_M33_NVIC_IPR6_PRI_N3_RESET  0x0
#define RP23XX_M33_NVIC_IPR6_PRI_N3_BITS   0xf0000000
#define RP23XX_M33_NVIC_IPR6_PRI_N3_MSB    31
#define RP23XX_M33_NVIC_IPR6_PRI_N3_LSB    28
#define RP23XX_M33_NVIC_IPR6_PRI_N3_ACCESS "RW"

#define RP23XX_M33_NVIC_IPR6_PRI_N2_RESET  0x0
#define RP23XX_M33_NVIC_IPR6_PRI_N2_BITS   0x00f00000
#define RP23XX_M33_NVIC_IPR6_PRI_N2_MSB    23
#define RP23XX_M33_NVIC_IPR6_PRI_N2_LSB    20
#define RP23XX_M33_NVIC_IPR6_PRI_N2_ACCESS "RW"

#define RP23XX_M33_NVIC_IPR6_PRI_N1_RESET  0x0
#define RP23XX_M33_NVIC_IPR6_PRI_N1_BITS   0x0000f000
#define RP23XX_M33_NVIC_IPR6_PRI_N1_MSB    15
#define RP23XX_M33_NVIC_IPR6_PRI_N1_LSB    12
#define RP23XX_M33_NVIC_IPR6_PRI_N1_ACCESS "RW"

#define RP23XX_M33_NVIC_IPR6_PRI_N0_RESET  0x0
#define RP23XX_M33_NVIC_IPR6_PRI_N0_BITS   0x000000f0
#define RP23XX_M33_NVIC_IPR6_PRI_N0_MSB    7
#define RP23XX_M33_NVIC_IPR6_PRI_N0_LSB    4
#define RP23XX_M33_NVIC_IPR6_PRI_N0_ACCESS "RW"

#define RP23XX_M33_NVIC_IPR7_OFFSET 0x0000e41c
#define RP23XX_M33_NVIC_IPR7_BITS   0xf0f0f0f0
#define RP23XX_M33_NVIC_IPR7_RESET  0x00000000

#define RP23XX_M33_NVIC_IPR7_PRI_N3_RESET  0x0
#define RP23XX_M33_NVIC_IPR7_PRI_N3_BITS   0xf0000000
#define RP23XX_M33_NVIC_IPR7_PRI_N3_MSB    31
#define RP23XX_M33_NVIC_IPR7_PRI_N3_LSB    28
#define RP23XX_M33_NVIC_IPR7_PRI_N3_ACCESS "RW"

#define RP23XX_M33_NVIC_IPR7_PRI_N2_RESET  0x0
#define RP23XX_M33_NVIC_IPR7_PRI_N2_BITS   0x00f00000
#define RP23XX_M33_NVIC_IPR7_PRI_N2_MSB    23
#define RP23XX_M33_NVIC_IPR7_PRI_N2_LSB    20
#define RP23XX_M33_NVIC_IPR7_PRI_N2_ACCESS "RW"

#define RP23XX_M33_NVIC_IPR7_PRI_N1_RESET  0x0
#define RP23XX_M33_NVIC_IPR7_PRI_N1_BITS   0x0000f000
#define RP23XX_M33_NVIC_IPR7_PRI_N1_MSB    15
#define RP23XX_M33_NVIC_IPR7_PRI_N1_LSB    12
#define RP23XX_M33_NVIC_IPR7_PRI_N1_ACCESS "RW"

#define RP23XX_M33_NVIC_IPR7_PRI_N0_RESET  0x0
#define RP23XX_M33_NVIC_IPR7_PRI_N0_BITS   0x000000f0
#define RP23XX_M33_NVIC_IPR7_PRI_N0_MSB    7
#define RP23XX_M33_NVIC_IPR7_PRI_N0_LSB    4
#define RP23XX_M33_NVIC_IPR7_PRI_N0_ACCESS "RW"

#define RP23XX_M33_NVIC_IPR8_OFFSET 0x0000e420
#define RP23XX_M33_NVIC_IPR8_BITS   0xf0f0f0f0
#define RP23XX_M33_NVIC_IPR8_RESET  0x00000000

#define RP23XX_M33_NVIC_IPR8_PRI_N3_RESET  0x0
#define RP23XX_M33_NVIC_IPR8_PRI_N3_BITS   0xf0000000
#define RP23XX_M33_NVIC_IPR8_PRI_N3_MSB    31
#define RP23XX_M33_NVIC_IPR8_PRI_N3_LSB    28
#define RP23XX_M33_NVIC_IPR8_PRI_N3_ACCESS "RW"

#define RP23XX_M33_NVIC_IPR8_PRI_N2_RESET  0x0
#define RP23XX_M33_NVIC_IPR8_PRI_N2_BITS   0x00f00000
#define RP23XX_M33_NVIC_IPR8_PRI_N2_MSB    23
#define RP23XX_M33_NVIC_IPR8_PRI_N2_LSB    20
#define RP23XX_M33_NVIC_IPR8_PRI_N2_ACCESS "RW"

#define RP23XX_M33_NVIC_IPR8_PRI_N1_RESET  0x0
#define RP23XX_M33_NVIC_IPR8_PRI_N1_BITS   0x0000f000
#define RP23XX_M33_NVIC_IPR8_PRI_N1_MSB    15
#define RP23XX_M33_NVIC_IPR8_PRI_N1_LSB    12
#define RP23XX_M33_NVIC_IPR8_PRI_N1_ACCESS "RW"

#define RP23XX_M33_NVIC_IPR8_PRI_N0_RESET  0x0
#define RP23XX_M33_NVIC_IPR8_PRI_N0_BITS   0x000000f0
#define RP23XX_M33_NVIC_IPR8_PRI_N0_MSB    7
#define RP23XX_M33_NVIC_IPR8_PRI_N0_LSB    4
#define RP23XX_M33_NVIC_IPR8_PRI_N0_ACCESS "RW"

#define RP23XX_M33_NVIC_IPR9_OFFSET 0x0000e424
#define RP23XX_M33_NVIC_IPR9_BITS   0xf0f0f0f0
#define RP23XX_M33_NVIC_IPR9_RESET  0x00000000

#define RP23XX_M33_NVIC_IPR9_PRI_N3_RESET  0x0
#define RP23XX_M33_NVIC_IPR9_PRI_N3_BITS   0xf0000000
#define RP23XX_M33_NVIC_IPR9_PRI_N3_MSB    31
#define RP23XX_M33_NVIC_IPR9_PRI_N3_LSB    28
#define RP23XX_M33_NVIC_IPR9_PRI_N3_ACCESS "RW"

#define RP23XX_M33_NVIC_IPR9_PRI_N2_RESET  0x0
#define RP23XX_M33_NVIC_IPR9_PRI_N2_BITS   0x00f00000
#define RP23XX_M33_NVIC_IPR9_PRI_N2_MSB    23
#define RP23XX_M33_NVIC_IPR9_PRI_N2_LSB    20
#define RP23XX_M33_NVIC_IPR9_PRI_N2_ACCESS "RW"

#define RP23XX_M33_NVIC_IPR9_PRI_N1_RESET  0x0
#define RP23XX_M33_NVIC_IPR9_PRI_N1_BITS   0x0000f000
#define RP23XX_M33_NVIC_IPR9_PRI_N1_MSB    15
#define RP23XX_M33_NVIC_IPR9_PRI_N1_LSB    12
#define RP23XX_M33_NVIC_IPR9_PRI_N1_ACCESS "RW"

#define RP23XX_M33_NVIC_IPR9_PRI_N0_RESET  0x0
#define RP23XX_M33_NVIC_IPR9_PRI_N0_BITS   0x000000f0
#define RP23XX_M33_NVIC_IPR9_PRI_N0_MSB    7
#define RP23XX_M33_NVIC_IPR9_PRI_N0_LSB    4
#define RP23XX_M33_NVIC_IPR9_PRI_N0_ACCESS "RW"

#define RP23XX_M33_NVIC_IPR10_OFFSET 0x0000e428
#define RP23XX_M33_NVIC_IPR10_BITS   0xf0f0f0f0
#define RP23XX_M33_NVIC_IPR10_RESET  0x00000000

#define RP23XX_M33_NVIC_IPR10_PRI_N3_RESET  0x0
#define RP23XX_M33_NVIC_IPR10_PRI_N3_BITS   0xf0000000
#define RP23XX_M33_NVIC_IPR10_PRI_N3_MSB    31
#define RP23XX_M33_NVIC_IPR10_PRI_N3_LSB    28
#define RP23XX_M33_NVIC_IPR10_PRI_N3_ACCESS "RW"

#define RP23XX_M33_NVIC_IPR10_PRI_N2_RESET  0x0
#define RP23XX_M33_NVIC_IPR10_PRI_N2_BITS   0x00f00000
#define RP23XX_M33_NVIC_IPR10_PRI_N2_MSB    23
#define RP23XX_M33_NVIC_IPR10_PRI_N2_LSB    20
#define RP23XX_M33_NVIC_IPR10_PRI_N2_ACCESS "RW"

#define RP23XX_M33_NVIC_IPR10_PRI_N1_RESET  0x0
#define RP23XX_M33_NVIC_IPR10_PRI_N1_BITS   0x0000f000
#define RP23XX_M33_NVIC_IPR10_PRI_N1_MSB    15
#define RP23XX_M33_NVIC_IPR10_PRI_N1_LSB    12
#define RP23XX_M33_NVIC_IPR10_PRI_N1_ACCESS "RW"

#define RP23XX_M33_NVIC_IPR10_PRI_N0_RESET  0x0
#define RP23XX_M33_NVIC_IPR10_PRI_N0_BITS   0x000000f0
#define RP23XX_M33_NVIC_IPR10_PRI_N0_MSB    7
#define RP23XX_M33_NVIC_IPR10_PRI_N0_LSB    4
#define RP23XX_M33_NVIC_IPR10_PRI_N0_ACCESS "RW"

#define RP23XX_M33_NVIC_IPR11_OFFSET 0x0000e42c
#define RP23XX_M33_NVIC_IPR11_BITS   0xf0f0f0f0
#define RP23XX_M33_NVIC_IPR11_RESET  0x00000000

#define RP23XX_M33_NVIC_IPR11_PRI_N3_RESET  0x0
#define RP23XX_M33_NVIC_IPR11_PRI_N3_BITS   0xf0000000
#define RP23XX_M33_NVIC_IPR11_PRI_N3_MSB    31
#define RP23XX_M33_NVIC_IPR11_PRI_N3_LSB    28
#define RP23XX_M33_NVIC_IPR11_PRI_N3_ACCESS "RW"

#define RP23XX_M33_NVIC_IPR11_PRI_N2_RESET  0x0
#define RP23XX_M33_NVIC_IPR11_PRI_N2_BITS   0x00f00000
#define RP23XX_M33_NVIC_IPR11_PRI_N2_MSB    23
#define RP23XX_M33_NVIC_IPR11_PRI_N2_LSB    20
#define RP23XX_M33_NVIC_IPR11_PRI_N2_ACCESS "RW"

#define RP23XX_M33_NVIC_IPR11_PRI_N1_RESET  0x0
#define RP23XX_M33_NVIC_IPR11_PRI_N1_BITS   0x0000f000
#define RP23XX_M33_NVIC_IPR11_PRI_N1_MSB    15
#define RP23XX_M33_NVIC_IPR11_PRI_N1_LSB    12
#define RP23XX_M33_NVIC_IPR11_PRI_N1_ACCESS "RW"

#define RP23XX_M33_NVIC_IPR11_PRI_N0_RESET  0x0
#define RP23XX_M33_NVIC_IPR11_PRI_N0_BITS   0x000000f0
#define RP23XX_M33_NVIC_IPR11_PRI_N0_MSB    7
#define RP23XX_M33_NVIC_IPR11_PRI_N0_LSB    4
#define RP23XX_M33_NVIC_IPR11_PRI_N0_ACCESS "RW"

#define RP23XX_M33_NVIC_IPR12_OFFSET 0x0000e430
#define RP23XX_M33_NVIC_IPR12_BITS   0xf0f0f0f0
#define RP23XX_M33_NVIC_IPR12_RESET  0x00000000

#define RP23XX_M33_NVIC_IPR12_PRI_N3_RESET  0x0
#define RP23XX_M33_NVIC_IPR12_PRI_N3_BITS   0xf0000000
#define RP23XX_M33_NVIC_IPR12_PRI_N3_MSB    31
#define RP23XX_M33_NVIC_IPR12_PRI_N3_LSB    28
#define RP23XX_M33_NVIC_IPR12_PRI_N3_ACCESS "RW"

#define RP23XX_M33_NVIC_IPR12_PRI_N2_RESET  0x0
#define RP23XX_M33_NVIC_IPR12_PRI_N2_BITS   0x00f00000
#define RP23XX_M33_NVIC_IPR12_PRI_N2_MSB    23
#define RP23XX_M33_NVIC_IPR12_PRI_N2_LSB    20
#define RP23XX_M33_NVIC_IPR12_PRI_N2_ACCESS "RW"

#define RP23XX_M33_NVIC_IPR12_PRI_N1_RESET  0x0
#define RP23XX_M33_NVIC_IPR12_PRI_N1_BITS   0x0000f000
#define RP23XX_M33_NVIC_IPR12_PRI_N1_MSB    15
#define RP23XX_M33_NVIC_IPR12_PRI_N1_LSB    12
#define RP23XX_M33_NVIC_IPR12_PRI_N1_ACCESS "RW"

#define RP23XX_M33_NVIC_IPR12_PRI_N0_RESET  0x0
#define RP23XX_M33_NVIC_IPR12_PRI_N0_BITS   0x000000f0
#define RP23XX_M33_NVIC_IPR12_PRI_N0_MSB    7
#define RP23XX_M33_NVIC_IPR12_PRI_N0_LSB    4
#define RP23XX_M33_NVIC_IPR12_PRI_N0_ACCESS "RW"

#define RP23XX_M33_NVIC_IPR13_OFFSET 0x0000e434
#define RP23XX_M33_NVIC_IPR13_BITS   0xf0f0f0f0
#define RP23XX_M33_NVIC_IPR13_RESET  0x00000000

#define RP23XX_M33_NVIC_IPR13_PRI_N3_RESET  0x0
#define RP23XX_M33_NVIC_IPR13_PRI_N3_BITS   0xf0000000
#define RP23XX_M33_NVIC_IPR13_PRI_N3_MSB    31
#define RP23XX_M33_NVIC_IPR13_PRI_N3_LSB    28
#define RP23XX_M33_NVIC_IPR13_PRI_N3_ACCESS "RW"

#define RP23XX_M33_NVIC_IPR13_PRI_N2_RESET  0x0
#define RP23XX_M33_NVIC_IPR13_PRI_N2_BITS   0x00f00000
#define RP23XX_M33_NVIC_IPR13_PRI_N2_MSB    23
#define RP23XX_M33_NVIC_IPR13_PRI_N2_LSB    20
#define RP23XX_M33_NVIC_IPR13_PRI_N2_ACCESS "RW"

#define RP23XX_M33_NVIC_IPR13_PRI_N1_RESET  0x0
#define RP23XX_M33_NVIC_IPR13_PRI_N1_BITS   0x0000f000
#define RP23XX_M33_NVIC_IPR13_PRI_N1_MSB    15
#define RP23XX_M33_NVIC_IPR13_PRI_N1_LSB    12
#define RP23XX_M33_NVIC_IPR13_PRI_N1_ACCESS "RW"

#define RP23XX_M33_NVIC_IPR13_PRI_N0_RESET  0x0
#define RP23XX_M33_NVIC_IPR13_PRI_N0_BITS   0x000000f0
#define RP23XX_M33_NVIC_IPR13_PRI_N0_MSB    7
#define RP23XX_M33_NVIC_IPR13_PRI_N0_LSB    4
#define RP23XX_M33_NVIC_IPR13_PRI_N0_ACCESS "RW"

#define RP23XX_M33_NVIC_IPR14_OFFSET 0x0000e438
#define RP23XX_M33_NVIC_IPR14_BITS   0xf0f0f0f0
#define RP23XX_M33_NVIC_IPR14_RESET  0x00000000

#define RP23XX_M33_NVIC_IPR14_PRI_N3_RESET  0x0
#define RP23XX_M33_NVIC_IPR14_PRI_N3_BITS   0xf0000000
#define RP23XX_M33_NVIC_IPR14_PRI_N3_MSB    31
#define RP23XX_M33_NVIC_IPR14_PRI_N3_LSB    28
#define RP23XX_M33_NVIC_IPR14_PRI_N3_ACCESS "RW"

#define RP23XX_M33_NVIC_IPR14_PRI_N2_RESET  0x0
#define RP23XX_M33_NVIC_IPR14_PRI_N2_BITS   0x00f00000
#define RP23XX_M33_NVIC_IPR14_PRI_N2_MSB    23
#define RP23XX_M33_NVIC_IPR14_PRI_N2_LSB    20
#define RP23XX_M33_NVIC_IPR14_PRI_N2_ACCESS "RW"

#define RP23XX_M33_NVIC_IPR14_PRI_N1_RESET  0x0
#define RP23XX_M33_NVIC_IPR14_PRI_N1_BITS   0x0000f000
#define RP23XX_M33_NVIC_IPR14_PRI_N1_MSB    15
#define RP23XX_M33_NVIC_IPR14_PRI_N1_LSB    12
#define RP23XX_M33_NVIC_IPR14_PRI_N1_ACCESS "RW"

#define RP23XX_M33_NVIC_IPR14_PRI_N0_RESET  0x0
#define RP23XX_M33_NVIC_IPR14_PRI_N0_BITS   0x000000f0
#define RP23XX_M33_NVIC_IPR14_PRI_N0_MSB    7
#define RP23XX_M33_NVIC_IPR14_PRI_N0_LSB    4
#define RP23XX_M33_NVIC_IPR14_PRI_N0_ACCESS "RW"

#define RP23XX_M33_NVIC_IPR15_OFFSET 0x0000e43c
#define RP23XX_M33_NVIC_IPR15_BITS   0xf0f0f0f0
#define RP23XX_M33_NVIC_IPR15_RESET  0x00000000

#define RP23XX_M33_NVIC_IPR15_PRI_N3_RESET  0x0
#define RP23XX_M33_NVIC_IPR15_PRI_N3_BITS   0xf0000000
#define RP23XX_M33_NVIC_IPR15_PRI_N3_MSB    31
#define RP23XX_M33_NVIC_IPR15_PRI_N3_LSB    28
#define RP23XX_M33_NVIC_IPR15_PRI_N3_ACCESS "RW"

#define RP23XX_M33_NVIC_IPR15_PRI_N2_RESET  0x0
#define RP23XX_M33_NVIC_IPR15_PRI_N2_BITS   0x00f00000
#define RP23XX_M33_NVIC_IPR15_PRI_N2_MSB    23
#define RP23XX_M33_NVIC_IPR15_PRI_N2_LSB    20
#define RP23XX_M33_NVIC_IPR15_PRI_N2_ACCESS "RW"

#define RP23XX_M33_NVIC_IPR15_PRI_N1_RESET  0x0
#define RP23XX_M33_NVIC_IPR15_PRI_N1_BITS   0x0000f000
#define RP23XX_M33_NVIC_IPR15_PRI_N1_MSB    15
#define RP23XX_M33_NVIC_IPR15_PRI_N1_LSB    12
#define RP23XX_M33_NVIC_IPR15_PRI_N1_ACCESS "RW"

#define RP23XX_M33_NVIC_IPR15_PRI_N0_RESET  0x0
#define RP23XX_M33_NVIC_IPR15_PRI_N0_BITS   0x000000f0
#define RP23XX_M33_NVIC_IPR15_PRI_N0_MSB    7
#define RP23XX_M33_NVIC_IPR15_PRI_N0_LSB    4
#define RP23XX_M33_NVIC_IPR15_PRI_N0_ACCESS "RW"

#define RP23XX_M33_CPUID_OFFSET 0x0000ed00
#define RP23XX_M33_CPUID_BITS   0xffffffff
#define RP23XX_M33_CPUID_RESET  0x411fd210

#define RP23XX_M33_CPUID_IMPLEMENTER_RESET  0x41
#define RP23XX_M33_CPUID_IMPLEMENTER_BITS   0xff000000
#define RP23XX_M33_CPUID_IMPLEMENTER_MSB    31
#define RP23XX_M33_CPUID_IMPLEMENTER_LSB    24
#define RP23XX_M33_CPUID_IMPLEMENTER_ACCESS "RO"

#define RP23XX_M33_CPUID_VARIANT_RESET  0x1
#define RP23XX_M33_CPUID_VARIANT_BITS   0x00f00000
#define RP23XX_M33_CPUID_VARIANT_MSB    23
#define RP23XX_M33_CPUID_VARIANT_LSB    20
#define RP23XX_M33_CPUID_VARIANT_ACCESS "RO"

#define RP23XX_M33_CPUID_ARCHITECTURE_RESET  0xf
#define RP23XX_M33_CPUID_ARCHITECTURE_BITS   0x000f0000
#define RP23XX_M33_CPUID_ARCHITECTURE_MSB    19
#define RP23XX_M33_CPUID_ARCHITECTURE_LSB    16
#define RP23XX_M33_CPUID_ARCHITECTURE_ACCESS "RO"

#define RP23XX_M33_CPUID_PARTNO_RESET  0xd21
#define RP23XX_M33_CPUID_PARTNO_BITS   0x0000fff0
#define RP23XX_M33_CPUID_PARTNO_MSB    15
#define RP23XX_M33_CPUID_PARTNO_LSB    4
#define RP23XX_M33_CPUID_PARTNO_ACCESS "RO"

#define RP23XX_M33_CPUID_REVISION_RESET  0x0
#define RP23XX_M33_CPUID_REVISION_BITS   0x0000000f
#define RP23XX_M33_CPUID_REVISION_MSB    3
#define RP23XX_M33_CPUID_REVISION_LSB    0
#define RP23XX_M33_CPUID_REVISION_ACCESS "RO"

#define RP23XX_M33_ICSR_OFFSET 0x0000ed04
#define RP23XX_M33_ICSR_BITS   0xdfdff9ff
#define RP23XX_M33_ICSR_RESET  0x00000000

#define RP23XX_M33_ICSR_PENDNMISET_RESET  0x0
#define RP23XX_M33_ICSR_PENDNMISET_BITS   0x80000000
#define RP23XX_M33_ICSR_PENDNMISET_MSB    31
#define RP23XX_M33_ICSR_PENDNMISET_LSB    31
#define RP23XX_M33_ICSR_PENDNMISET_ACCESS "RO"

#define RP23XX_M33_ICSR_PENDNMICLR_RESET  0x0
#define RP23XX_M33_ICSR_PENDNMICLR_BITS   0x40000000
#define RP23XX_M33_ICSR_PENDNMICLR_MSB    30
#define RP23XX_M33_ICSR_PENDNMICLR_LSB    30
#define RP23XX_M33_ICSR_PENDNMICLR_ACCESS "RW"

#define RP23XX_M33_ICSR_PENDSVSET_RESET  0x0
#define RP23XX_M33_ICSR_PENDSVSET_BITS   0x10000000
#define RP23XX_M33_ICSR_PENDSVSET_MSB    28
#define RP23XX_M33_ICSR_PENDSVSET_LSB    28
#define RP23XX_M33_ICSR_PENDSVSET_ACCESS "RO"

#define RP23XX_M33_ICSR_PENDSVCLR_RESET  0x0
#define RP23XX_M33_ICSR_PENDSVCLR_BITS   0x08000000
#define RP23XX_M33_ICSR_PENDSVCLR_MSB    27
#define RP23XX_M33_ICSR_PENDSVCLR_LSB    27
#define RP23XX_M33_ICSR_PENDSVCLR_ACCESS "RW"

#define RP23XX_M33_ICSR_PENDSTSET_RESET  0x0
#define RP23XX_M33_ICSR_PENDSTSET_BITS   0x04000000
#define RP23XX_M33_ICSR_PENDSTSET_MSB    26
#define RP23XX_M33_ICSR_PENDSTSET_LSB    26
#define RP23XX_M33_ICSR_PENDSTSET_ACCESS "RO"

#define RP23XX_M33_ICSR_PENDSTCLR_RESET  0x0
#define RP23XX_M33_ICSR_PENDSTCLR_BITS   0x02000000
#define RP23XX_M33_ICSR_PENDSTCLR_MSB    25
#define RP23XX_M33_ICSR_PENDSTCLR_LSB    25
#define RP23XX_M33_ICSR_PENDSTCLR_ACCESS "RW"

#define RP23XX_M33_ICSR_STTNS_RESET  0x0
#define RP23XX_M33_ICSR_STTNS_BITS   0x01000000
#define RP23XX_M33_ICSR_STTNS_MSB    24
#define RP23XX_M33_ICSR_STTNS_LSB    24
#define RP23XX_M33_ICSR_STTNS_ACCESS "RW"

#define RP23XX_M33_ICSR_ISRPREEMPT_RESET  0x0
#define RP23XX_M33_ICSR_ISRPREEMPT_BITS   0x00800000
#define RP23XX_M33_ICSR_ISRPREEMPT_MSB    23
#define RP23XX_M33_ICSR_ISRPREEMPT_LSB    23
#define RP23XX_M33_ICSR_ISRPREEMPT_ACCESS "RO"

#define RP23XX_M33_ICSR_ISRPENDING_RESET  0x0
#define RP23XX_M33_ICSR_ISRPENDING_BITS   0x00400000
#define RP23XX_M33_ICSR_ISRPENDING_MSB    22
#define RP23XX_M33_ICSR_ISRPENDING_LSB    22
#define RP23XX_M33_ICSR_ISRPENDING_ACCESS "RO"

#define RP23XX_M33_ICSR_VECTPENDING_RESET  0x000
#define RP23XX_M33_ICSR_VECTPENDING_BITS   0x001ff000
#define RP23XX_M33_ICSR_VECTPENDING_MSB    20
#define RP23XX_M33_ICSR_VECTPENDING_LSB    12
#define RP23XX_M33_ICSR_VECTPENDING_ACCESS "RO"

#define RP23XX_M33_ICSR_RETTOBASE_RESET  0x0
#define RP23XX_M33_ICSR_RETTOBASE_BITS   0x00000800
#define RP23XX_M33_ICSR_RETTOBASE_MSB    11
#define RP23XX_M33_ICSR_RETTOBASE_LSB    11
#define RP23XX_M33_ICSR_RETTOBASE_ACCESS "RO"

#define RP23XX_M33_ICSR_VECTACTIVE_RESET  0x000
#define RP23XX_M33_ICSR_VECTACTIVE_BITS   0x000001ff
#define RP23XX_M33_ICSR_VECTACTIVE_MSB    8
#define RP23XX_M33_ICSR_VECTACTIVE_LSB    0
#define RP23XX_M33_ICSR_VECTACTIVE_ACCESS "RO"

#define RP23XX_M33_VTOR_OFFSET 0x0000ed08
#define RP23XX_M33_VTOR_BITS   0xffffff80
#define RP23XX_M33_VTOR_RESET  0x00000000

#define RP23XX_M33_VTOR_TBLOFF_RESET  0x0000000
#define RP23XX_M33_VTOR_TBLOFF_BITS   0xffffff80
#define RP23XX_M33_VTOR_TBLOFF_MSB    31
#define RP23XX_M33_VTOR_TBLOFF_LSB    7
#define RP23XX_M33_VTOR_TBLOFF_ACCESS "RW"

#define RP23XX_M33_AIRCR_OFFSET 0x0000ed0c
#define RP23XX_M33_AIRCR_BITS   0xffffe70e
#define RP23XX_M33_AIRCR_RESET  0x00000000

#define RP23XX_M33_AIRCR_VECTKEY_RESET  0x0000
#define RP23XX_M33_AIRCR_VECTKEY_BITS   0xffff0000
#define RP23XX_M33_AIRCR_VECTKEY_MSB    31
#define RP23XX_M33_AIRCR_VECTKEY_LSB    16
#define RP23XX_M33_AIRCR_VECTKEY_ACCESS "RW"

#define RP23XX_M33_AIRCR_ENDIANESS_RESET  0x0
#define RP23XX_M33_AIRCR_ENDIANESS_BITS   0x00008000
#define RP23XX_M33_AIRCR_ENDIANESS_MSB    15
#define RP23XX_M33_AIRCR_ENDIANESS_LSB    15
#define RP23XX_M33_AIRCR_ENDIANESS_ACCESS "RO"

#define RP23XX_M33_AIRCR_PRIS_RESET  0x0
#define RP23XX_M33_AIRCR_PRIS_BITS   0x00004000
#define RP23XX_M33_AIRCR_PRIS_MSB    14
#define RP23XX_M33_AIRCR_PRIS_LSB    14
#define RP23XX_M33_AIRCR_PRIS_ACCESS "RW"

#define RP23XX_M33_AIRCR_BFHFNMINS_RESET  0x0
#define RP23XX_M33_AIRCR_BFHFNMINS_BITS   0x00002000
#define RP23XX_M33_AIRCR_BFHFNMINS_MSB    13
#define RP23XX_M33_AIRCR_BFHFNMINS_LSB    13
#define RP23XX_M33_AIRCR_BFHFNMINS_ACCESS "RW"

#define RP23XX_M33_AIRCR_PRIGROUP_RESET  0x0
#define RP23XX_M33_AIRCR_PRIGROUP_BITS   0x00000700
#define RP23XX_M33_AIRCR_PRIGROUP_MSB    10
#define RP23XX_M33_AIRCR_PRIGROUP_LSB    8
#define RP23XX_M33_AIRCR_PRIGROUP_ACCESS "RW"

#define RP23XX_M33_AIRCR_SYSRESETREQS_RESET  0x0
#define RP23XX_M33_AIRCR_SYSRESETREQS_BITS   0x00000008
#define RP23XX_M33_AIRCR_SYSRESETREQS_MSB    3
#define RP23XX_M33_AIRCR_SYSRESETREQS_LSB    3
#define RP23XX_M33_AIRCR_SYSRESETREQS_ACCESS "RW"

#define RP23XX_M33_AIRCR_SYSRESETREQ_RESET  0x0
#define RP23XX_M33_AIRCR_SYSRESETREQ_BITS   0x00000004
#define RP23XX_M33_AIRCR_SYSRESETREQ_MSB    2
#define RP23XX_M33_AIRCR_SYSRESETREQ_LSB    2
#define RP23XX_M33_AIRCR_SYSRESETREQ_ACCESS "RW"

#define RP23XX_M33_AIRCR_VECTCLRACTIVE_RESET  0x0
#define RP23XX_M33_AIRCR_VECTCLRACTIVE_BITS   0x00000002
#define RP23XX_M33_AIRCR_VECTCLRACTIVE_MSB    1
#define RP23XX_M33_AIRCR_VECTCLRACTIVE_LSB    1
#define RP23XX_M33_AIRCR_VECTCLRACTIVE_ACCESS "RW"

#define RP23XX_M33_SCR_OFFSET 0x0000ed10
#define RP23XX_M33_SCR_BITS   0x0000001e
#define RP23XX_M33_SCR_RESET  0x00000000

#define RP23XX_M33_SCR_SEVONPEND_RESET  0x0
#define RP23XX_M33_SCR_SEVONPEND_BITS   0x00000010
#define RP23XX_M33_SCR_SEVONPEND_MSB    4
#define RP23XX_M33_SCR_SEVONPEND_LSB    4
#define RP23XX_M33_SCR_SEVONPEND_ACCESS "RW"

#define RP23XX_M33_SCR_SLEEPDEEPS_RESET  0x0
#define RP23XX_M33_SCR_SLEEPDEEPS_BITS   0x00000008
#define RP23XX_M33_SCR_SLEEPDEEPS_MSB    3
#define RP23XX_M33_SCR_SLEEPDEEPS_LSB    3
#define RP23XX_M33_SCR_SLEEPDEEPS_ACCESS "RW"

#define RP23XX_M33_SCR_SLEEPDEEP_RESET  0x0
#define RP23XX_M33_SCR_SLEEPDEEP_BITS   0x00000004
#define RP23XX_M33_SCR_SLEEPDEEP_MSB    2
#define RP23XX_M33_SCR_SLEEPDEEP_LSB    2
#define RP23XX_M33_SCR_SLEEPDEEP_ACCESS "RW"

#define RP23XX_M33_SCR_SLEEPONEXIT_RESET  0x0
#define RP23XX_M33_SCR_SLEEPONEXIT_BITS   0x00000002
#define RP23XX_M33_SCR_SLEEPONEXIT_MSB    1
#define RP23XX_M33_SCR_SLEEPONEXIT_LSB    1
#define RP23XX_M33_SCR_SLEEPONEXIT_ACCESS "RW"

#define RP23XX_M33_CCR_OFFSET 0x0000ed14
#define RP23XX_M33_CCR_BITS   0x0007071b
#define RP23XX_M33_CCR_RESET  0x00000201

#define RP23XX_M33_CCR_BP_RESET  0x0
#define RP23XX_M33_CCR_BP_BITS   0x00040000
#define RP23XX_M33_CCR_BP_MSB    18
#define RP23XX_M33_CCR_BP_LSB    18
#define RP23XX_M33_CCR_BP_ACCESS "RO"

#define RP23XX_M33_CCR_IC_RESET  0x0
#define RP23XX_M33_CCR_IC_BITS   0x00020000
#define RP23XX_M33_CCR_IC_MSB    17
#define RP23XX_M33_CCR_IC_LSB    17
#define RP23XX_M33_CCR_IC_ACCESS "RO"

#define RP23XX_M33_CCR_DC_RESET  0x0
#define RP23XX_M33_CCR_DC_BITS   0x00010000
#define RP23XX_M33_CCR_DC_MSB    16
#define RP23XX_M33_CCR_DC_LSB    16
#define RP23XX_M33_CCR_DC_ACCESS "RO"

#define RP23XX_M33_CCR_STKOFHFNMIGN_RESET  0x0
#define RP23XX_M33_CCR_STKOFHFNMIGN_BITS   0x00000400
#define RP23XX_M33_CCR_STKOFHFNMIGN_MSB    10
#define RP23XX_M33_CCR_STKOFHFNMIGN_LSB    10
#define RP23XX_M33_CCR_STKOFHFNMIGN_ACCESS "RW"

#define RP23XX_M33_CCR_RES1_RESET  0x1
#define RP23XX_M33_CCR_RES1_BITS   0x00000200
#define RP23XX_M33_CCR_RES1_MSB    9
#define RP23XX_M33_CCR_RES1_LSB    9
#define RP23XX_M33_CCR_RES1_ACCESS "RO"

#define RP23XX_M33_CCR_BFHFNMIGN_RESET  0x0
#define RP23XX_M33_CCR_BFHFNMIGN_BITS   0x00000100
#define RP23XX_M33_CCR_BFHFNMIGN_MSB    8
#define RP23XX_M33_CCR_BFHFNMIGN_LSB    8
#define RP23XX_M33_CCR_BFHFNMIGN_ACCESS "RW"

#define RP23XX_M33_CCR_DIV_0_TRP_RESET  0x0
#define RP23XX_M33_CCR_DIV_0_TRP_BITS   0x00000010
#define RP23XX_M33_CCR_DIV_0_TRP_MSB    4
#define RP23XX_M33_CCR_DIV_0_TRP_LSB    4
#define RP23XX_M33_CCR_DIV_0_TRP_ACCESS "RW"

#define RP23XX_M33_CCR_UNALIGN_TRP_RESET  0x0
#define RP23XX_M33_CCR_UNALIGN_TRP_BITS   0x00000008
#define RP23XX_M33_CCR_UNALIGN_TRP_MSB    3
#define RP23XX_M33_CCR_UNALIGN_TRP_LSB    3
#define RP23XX_M33_CCR_UNALIGN_TRP_ACCESS "RW"

#define RP23XX_M33_CCR_USERSETMPEND_RESET  0x0
#define RP23XX_M33_CCR_USERSETMPEND_BITS   0x00000002
#define RP23XX_M33_CCR_USERSETMPEND_MSB    1
#define RP23XX_M33_CCR_USERSETMPEND_LSB    1
#define RP23XX_M33_CCR_USERSETMPEND_ACCESS "RW"

#define RP23XX_M33_CCR_RES1_1_RESET  0x1
#define RP23XX_M33_CCR_RES1_1_BITS   0x00000001
#define RP23XX_M33_CCR_RES1_1_MSB    0
#define RP23XX_M33_CCR_RES1_1_LSB    0
#define RP23XX_M33_CCR_RES1_1_ACCESS "RO"

#define RP23XX_M33_SHPR1_OFFSET 0x0000ed18
#define RP23XX_M33_SHPR1_BITS   0xe0e0e0e0
#define RP23XX_M33_SHPR1_RESET  0x00000000

#define RP23XX_M33_SHPR1_PRI_7_3_RESET  0x0
#define RP23XX_M33_SHPR1_PRI_7_3_BITS   0xe0000000
#define RP23XX_M33_SHPR1_PRI_7_3_MSB    31
#define RP23XX_M33_SHPR1_PRI_7_3_LSB    29
#define RP23XX_M33_SHPR1_PRI_7_3_ACCESS "RW"

#define RP23XX_M33_SHPR1_PRI_6_3_RESET  0x0
#define RP23XX_M33_SHPR1_PRI_6_3_BITS   0x00e00000
#define RP23XX_M33_SHPR1_PRI_6_3_MSB    23
#define RP23XX_M33_SHPR1_PRI_6_3_LSB    21
#define RP23XX_M33_SHPR1_PRI_6_3_ACCESS "RW"

#define RP23XX_M33_SHPR1_PRI_5_3_RESET  0x0
#define RP23XX_M33_SHPR1_PRI_5_3_BITS   0x0000e000
#define RP23XX_M33_SHPR1_PRI_5_3_MSB    15
#define RP23XX_M33_SHPR1_PRI_5_3_LSB    13
#define RP23XX_M33_SHPR1_PRI_5_3_ACCESS "RW"

#define RP23XX_M33_SHPR1_PRI_4_3_RESET  0x0
#define RP23XX_M33_SHPR1_PRI_4_3_BITS   0x000000e0
#define RP23XX_M33_SHPR1_PRI_4_3_MSB    7
#define RP23XX_M33_SHPR1_PRI_4_3_LSB    5
#define RP23XX_M33_SHPR1_PRI_4_3_ACCESS "RW"

#define RP23XX_M33_SHPR2_OFFSET 0x0000ed1c
#define RP23XX_M33_SHPR2_BITS   0xe0ffffff
#define RP23XX_M33_SHPR2_RESET  0x00000000

#define RP23XX_M33_SHPR2_PRI_11_3_RESET  0x0
#define RP23XX_M33_SHPR2_PRI_11_3_BITS   0xe0000000
#define RP23XX_M33_SHPR2_PRI_11_3_MSB    31
#define RP23XX_M33_SHPR2_PRI_11_3_LSB    29
#define RP23XX_M33_SHPR2_PRI_11_3_ACCESS "RW"

#define RP23XX_M33_SHPR2_PRI_10_RESET  0x00
#define RP23XX_M33_SHPR2_PRI_10_BITS   0x00ff0000
#define RP23XX_M33_SHPR2_PRI_10_MSB    23
#define RP23XX_M33_SHPR2_PRI_10_LSB    16
#define RP23XX_M33_SHPR2_PRI_10_ACCESS "RO"

#define RP23XX_M33_SHPR2_PRI_9_RESET  0x00
#define RP23XX_M33_SHPR2_PRI_9_BITS   0x0000ff00
#define RP23XX_M33_SHPR2_PRI_9_MSB    15
#define RP23XX_M33_SHPR2_PRI_9_LSB    8
#define RP23XX_M33_SHPR2_PRI_9_ACCESS "RO"

#define RP23XX_M33_SHPR2_PRI_8_RESET  0x00
#define RP23XX_M33_SHPR2_PRI_8_BITS   0x000000ff
#define RP23XX_M33_SHPR2_PRI_8_MSB    7
#define RP23XX_M33_SHPR2_PRI_8_LSB    0
#define RP23XX_M33_SHPR2_PRI_8_ACCESS "RO"

#define RP23XX_M33_SHPR3_OFFSET 0x0000ed20
#define RP23XX_M33_SHPR3_BITS   0xe0e0ffe0
#define RP23XX_M33_SHPR3_RESET  0x00000000

#define RP23XX_M33_SHPR3_PRI_15_3_RESET  0x0
#define RP23XX_M33_SHPR3_PRI_15_3_BITS   0xe0000000
#define RP23XX_M33_SHPR3_PRI_15_3_MSB    31
#define RP23XX_M33_SHPR3_PRI_15_3_LSB    29
#define RP23XX_M33_SHPR3_PRI_15_3_ACCESS "RW"

#define RP23XX_M33_SHPR3_PRI_14_3_RESET  0x0
#define RP23XX_M33_SHPR3_PRI_14_3_BITS   0x00e00000
#define RP23XX_M33_SHPR3_PRI_14_3_MSB    23
#define RP23XX_M33_SHPR3_PRI_14_3_LSB    21
#define RP23XX_M33_SHPR3_PRI_14_3_ACCESS "RW"

#define RP23XX_M33_SHPR3_PRI_13_RESET  0x00
#define RP23XX_M33_SHPR3_PRI_13_BITS   0x0000ff00
#define RP23XX_M33_SHPR3_PRI_13_MSB    15
#define RP23XX_M33_SHPR3_PRI_13_LSB    8
#define RP23XX_M33_SHPR3_PRI_13_ACCESS "RO"

#define RP23XX_M33_SHPR3_PRI_12_3_RESET  0x0
#define RP23XX_M33_SHPR3_PRI_12_3_BITS   0x000000e0
#define RP23XX_M33_SHPR3_PRI_12_3_MSB    7
#define RP23XX_M33_SHPR3_PRI_12_3_LSB    5
#define RP23XX_M33_SHPR3_PRI_12_3_ACCESS "RW"

#define RP23XX_M33_SHCSR_OFFSET 0x0000ed24
#define RP23XX_M33_SHCSR_BITS   0x003ffdbf
#define RP23XX_M33_SHCSR_RESET  0x00000000

#define RP23XX_M33_SHCSR_HARDFAULTPENDED_RESET  0x0
#define RP23XX_M33_SHCSR_HARDFAULTPENDED_BITS   0x00200000
#define RP23XX_M33_SHCSR_HARDFAULTPENDED_MSB    21
#define RP23XX_M33_SHCSR_HARDFAULTPENDED_LSB    21
#define RP23XX_M33_SHCSR_HARDFAULTPENDED_ACCESS "RW"

#define RP23XX_M33_SHCSR_SECUREFAULTPENDED_RESET  0x0
#define RP23XX_M33_SHCSR_SECUREFAULTPENDED_BITS   0x00100000
#define RP23XX_M33_SHCSR_SECUREFAULTPENDED_MSB    20
#define RP23XX_M33_SHCSR_SECUREFAULTPENDED_LSB    20
#define RP23XX_M33_SHCSR_SECUREFAULTPENDED_ACCESS "RW"

#define RP23XX_M33_SHCSR_SECUREFAULTENA_RESET  0x0
#define RP23XX_M33_SHCSR_SECUREFAULTENA_BITS   0x00080000
#define RP23XX_M33_SHCSR_SECUREFAULTENA_MSB    19
#define RP23XX_M33_SHCSR_SECUREFAULTENA_LSB    19
#define RP23XX_M33_SHCSR_SECUREFAULTENA_ACCESS "RW"

#define RP23XX_M33_SHCSR_USGFAULTENA_RESET  0x0
#define RP23XX_M33_SHCSR_USGFAULTENA_BITS   0x00040000
#define RP23XX_M33_SHCSR_USGFAULTENA_MSB    18
#define RP23XX_M33_SHCSR_USGFAULTENA_LSB    18
#define RP23XX_M33_SHCSR_USGFAULTENA_ACCESS "RW"

#define RP23XX_M33_SHCSR_BUSFAULTENA_RESET  0x0
#define RP23XX_M33_SHCSR_BUSFAULTENA_BITS   0x00020000
#define RP23XX_M33_SHCSR_BUSFAULTENA_MSB    17
#define RP23XX_M33_SHCSR_BUSFAULTENA_LSB    17
#define RP23XX_M33_SHCSR_BUSFAULTENA_ACCESS "RW"

#define RP23XX_M33_SHCSR_MEMFAULTENA_RESET  0x0
#define RP23XX_M33_SHCSR_MEMFAULTENA_BITS   0x00010000
#define RP23XX_M33_SHCSR_MEMFAULTENA_MSB    16
#define RP23XX_M33_SHCSR_MEMFAULTENA_LSB    16
#define RP23XX_M33_SHCSR_MEMFAULTENA_ACCESS "RW"

#define RP23XX_M33_SHCSR_SVCALLPENDED_RESET  0x0
#define RP23XX_M33_SHCSR_SVCALLPENDED_BITS   0x00008000
#define RP23XX_M33_SHCSR_SVCALLPENDED_MSB    15
#define RP23XX_M33_SHCSR_SVCALLPENDED_LSB    15
#define RP23XX_M33_SHCSR_SVCALLPENDED_ACCESS "RW"

#define RP23XX_M33_SHCSR_BUSFAULTPENDED_RESET  0x0
#define RP23XX_M33_SHCSR_BUSFAULTPENDED_BITS   0x00004000
#define RP23XX_M33_SHCSR_BUSFAULTPENDED_MSB    14
#define RP23XX_M33_SHCSR_BUSFAULTPENDED_LSB    14
#define RP23XX_M33_SHCSR_BUSFAULTPENDED_ACCESS "RW"

#define RP23XX_M33_SHCSR_MEMFAULTPENDED_RESET  0x0
#define RP23XX_M33_SHCSR_MEMFAULTPENDED_BITS   0x00002000
#define RP23XX_M33_SHCSR_MEMFAULTPENDED_MSB    13
#define RP23XX_M33_SHCSR_MEMFAULTPENDED_LSB    13
#define RP23XX_M33_SHCSR_MEMFAULTPENDED_ACCESS "RW"

#define RP23XX_M33_SHCSR_USGFAULTPENDED_RESET  0x0
#define RP23XX_M33_SHCSR_USGFAULTPENDED_BITS   0x00001000
#define RP23XX_M33_SHCSR_USGFAULTPENDED_MSB    12
#define RP23XX_M33_SHCSR_USGFAULTPENDED_LSB    12
#define RP23XX_M33_SHCSR_USGFAULTPENDED_ACCESS "RW"

#define RP23XX_M33_SHCSR_SYSTICKACT_RESET  0x0
#define RP23XX_M33_SHCSR_SYSTICKACT_BITS   0x00000800
#define RP23XX_M33_SHCSR_SYSTICKACT_MSB    11
#define RP23XX_M33_SHCSR_SYSTICKACT_LSB    11
#define RP23XX_M33_SHCSR_SYSTICKACT_ACCESS "RW"

#define RP23XX_M33_SHCSR_PENDSVACT_RESET  0x0
#define RP23XX_M33_SHCSR_PENDSVACT_BITS   0x00000400
#define RP23XX_M33_SHCSR_PENDSVACT_MSB    10
#define RP23XX_M33_SHCSR_PENDSVACT_LSB    10
#define RP23XX_M33_SHCSR_PENDSVACT_ACCESS "RW"

#define RP23XX_M33_SHCSR_MONITORACT_RESET  0x0
#define RP23XX_M33_SHCSR_MONITORACT_BITS   0x00000100
#define RP23XX_M33_SHCSR_MONITORACT_MSB    8
#define RP23XX_M33_SHCSR_MONITORACT_LSB    8
#define RP23XX_M33_SHCSR_MONITORACT_ACCESS "RW"

#define RP23XX_M33_SHCSR_SVCALLACT_RESET  0x0
#define RP23XX_M33_SHCSR_SVCALLACT_BITS   0x00000080
#define RP23XX_M33_SHCSR_SVCALLACT_MSB    7
#define RP23XX_M33_SHCSR_SVCALLACT_LSB    7
#define RP23XX_M33_SHCSR_SVCALLACT_ACCESS "RW"

#define RP23XX_M33_SHCSR_NMIACT_RESET  0x0
#define RP23XX_M33_SHCSR_NMIACT_BITS   0x00000020
#define RP23XX_M33_SHCSR_NMIACT_MSB    5
#define RP23XX_M33_SHCSR_NMIACT_LSB    5
#define RP23XX_M33_SHCSR_NMIACT_ACCESS "RW"

#define RP23XX_M33_SHCSR_SECUREFAULTACT_RESET  0x0
#define RP23XX_M33_SHCSR_SECUREFAULTACT_BITS   0x00000010
#define RP23XX_M33_SHCSR_SECUREFAULTACT_MSB    4
#define RP23XX_M33_SHCSR_SECUREFAULTACT_LSB    4
#define RP23XX_M33_SHCSR_SECUREFAULTACT_ACCESS "RW"

#define RP23XX_M33_SHCSR_USGFAULTACT_RESET  0x0
#define RP23XX_M33_SHCSR_USGFAULTACT_BITS   0x00000008
#define RP23XX_M33_SHCSR_USGFAULTACT_MSB    3
#define RP23XX_M33_SHCSR_USGFAULTACT_LSB    3
#define RP23XX_M33_SHCSR_USGFAULTACT_ACCESS "RW"

#define RP23XX_M33_SHCSR_HARDFAULTACT_RESET  0x0
#define RP23XX_M33_SHCSR_HARDFAULTACT_BITS   0x00000004
#define RP23XX_M33_SHCSR_HARDFAULTACT_MSB    2
#define RP23XX_M33_SHCSR_HARDFAULTACT_LSB    2
#define RP23XX_M33_SHCSR_HARDFAULTACT_ACCESS "RW"

#define RP23XX_M33_SHCSR_BUSFAULTACT_RESET  0x0
#define RP23XX_M33_SHCSR_BUSFAULTACT_BITS   0x00000002
#define RP23XX_M33_SHCSR_BUSFAULTACT_MSB    1
#define RP23XX_M33_SHCSR_BUSFAULTACT_LSB    1
#define RP23XX_M33_SHCSR_BUSFAULTACT_ACCESS "RW"

#define RP23XX_M33_SHCSR_MEMFAULTACT_RESET  0x0
#define RP23XX_M33_SHCSR_MEMFAULTACT_BITS   0x00000001
#define RP23XX_M33_SHCSR_MEMFAULTACT_MSB    0
#define RP23XX_M33_SHCSR_MEMFAULTACT_LSB    0
#define RP23XX_M33_SHCSR_MEMFAULTACT_ACCESS "RW"

#define RP23XX_M33_CFSR_OFFSET 0x0000ed28
#define RP23XX_M33_CFSR_BITS   0x031fbfff
#define RP23XX_M33_CFSR_RESET  0x00000000

#define RP23XX_M33_CFSR_UFSR_DIVBYZERO_RESET  0x0
#define RP23XX_M33_CFSR_UFSR_DIVBYZERO_BITS   0x02000000
#define RP23XX_M33_CFSR_UFSR_DIVBYZERO_MSB    25
#define RP23XX_M33_CFSR_UFSR_DIVBYZERO_LSB    25
#define RP23XX_M33_CFSR_UFSR_DIVBYZERO_ACCESS "RW"

#define RP23XX_M33_CFSR_UFSR_UNALIGNED_RESET  0x0
#define RP23XX_M33_CFSR_UFSR_UNALIGNED_BITS   0x01000000
#define RP23XX_M33_CFSR_UFSR_UNALIGNED_MSB    24
#define RP23XX_M33_CFSR_UFSR_UNALIGNED_LSB    24
#define RP23XX_M33_CFSR_UFSR_UNALIGNED_ACCESS "RW"

#define RP23XX_M33_CFSR_UFSR_STKOF_RESET  0x0
#define RP23XX_M33_CFSR_UFSR_STKOF_BITS   0x00100000
#define RP23XX_M33_CFSR_UFSR_STKOF_MSB    20
#define RP23XX_M33_CFSR_UFSR_STKOF_LSB    20
#define RP23XX_M33_CFSR_UFSR_STKOF_ACCESS "RW"

#define RP23XX_M33_CFSR_UFSR_NOCP_RESET  0x0
#define RP23XX_M33_CFSR_UFSR_NOCP_BITS   0x00080000
#define RP23XX_M33_CFSR_UFSR_NOCP_MSB    19
#define RP23XX_M33_CFSR_UFSR_NOCP_LSB    19
#define RP23XX_M33_CFSR_UFSR_NOCP_ACCESS "RW"

#define RP23XX_M33_CFSR_UFSR_INVPC_RESET  0x0
#define RP23XX_M33_CFSR_UFSR_INVPC_BITS   0x00040000
#define RP23XX_M33_CFSR_UFSR_INVPC_MSB    18
#define RP23XX_M33_CFSR_UFSR_INVPC_LSB    18
#define RP23XX_M33_CFSR_UFSR_INVPC_ACCESS "RW"

#define RP23XX_M33_CFSR_UFSR_INVSTATE_RESET  0x0
#define RP23XX_M33_CFSR_UFSR_INVSTATE_BITS   0x00020000
#define RP23XX_M33_CFSR_UFSR_INVSTATE_MSB    17
#define RP23XX_M33_CFSR_UFSR_INVSTATE_LSB    17
#define RP23XX_M33_CFSR_UFSR_INVSTATE_ACCESS "RW"

#define RP23XX_M33_CFSR_UFSR_UNDEFINSTR_RESET  0x0
#define RP23XX_M33_CFSR_UFSR_UNDEFINSTR_BITS   0x00010000
#define RP23XX_M33_CFSR_UFSR_UNDEFINSTR_MSB    16
#define RP23XX_M33_CFSR_UFSR_UNDEFINSTR_LSB    16
#define RP23XX_M33_CFSR_UFSR_UNDEFINSTR_ACCESS "RW"

#define RP23XX_M33_CFSR_BFSR_BFARVALID_RESET  0x0
#define RP23XX_M33_CFSR_BFSR_BFARVALID_BITS   0x00008000
#define RP23XX_M33_CFSR_BFSR_BFARVALID_MSB    15
#define RP23XX_M33_CFSR_BFSR_BFARVALID_LSB    15
#define RP23XX_M33_CFSR_BFSR_BFARVALID_ACCESS "RW"

#define RP23XX_M33_CFSR_BFSR_LSPERR_RESET  0x0
#define RP23XX_M33_CFSR_BFSR_LSPERR_BITS   0x00002000
#define RP23XX_M33_CFSR_BFSR_LSPERR_MSB    13
#define RP23XX_M33_CFSR_BFSR_LSPERR_LSB    13
#define RP23XX_M33_CFSR_BFSR_LSPERR_ACCESS "RW"

#define RP23XX_M33_CFSR_BFSR_STKERR_RESET  0x0
#define RP23XX_M33_CFSR_BFSR_STKERR_BITS   0x00001000
#define RP23XX_M33_CFSR_BFSR_STKERR_MSB    12
#define RP23XX_M33_CFSR_BFSR_STKERR_LSB    12
#define RP23XX_M33_CFSR_BFSR_STKERR_ACCESS "RW"

#define RP23XX_M33_CFSR_BFSR_UNSTKERR_RESET  0x0
#define RP23XX_M33_CFSR_BFSR_UNSTKERR_BITS   0x00000800
#define RP23XX_M33_CFSR_BFSR_UNSTKERR_MSB    11
#define RP23XX_M33_CFSR_BFSR_UNSTKERR_LSB    11
#define RP23XX_M33_CFSR_BFSR_UNSTKERR_ACCESS "RW"

#define RP23XX_M33_CFSR_BFSR_IMPRECISERR_RESET  0x0
#define RP23XX_M33_CFSR_BFSR_IMPRECISERR_BITS   0x00000400
#define RP23XX_M33_CFSR_BFSR_IMPRECISERR_MSB    10
#define RP23XX_M33_CFSR_BFSR_IMPRECISERR_LSB    10
#define RP23XX_M33_CFSR_BFSR_IMPRECISERR_ACCESS "RW"

#define RP23XX_M33_CFSR_BFSR_PRECISERR_RESET  0x0
#define RP23XX_M33_CFSR_BFSR_PRECISERR_BITS   0x00000200
#define RP23XX_M33_CFSR_BFSR_PRECISERR_MSB    9
#define RP23XX_M33_CFSR_BFSR_PRECISERR_LSB    9
#define RP23XX_M33_CFSR_BFSR_PRECISERR_ACCESS "RW"

#define RP23XX_M33_CFSR_BFSR_IBUSERR_RESET  0x0
#define RP23XX_M33_CFSR_BFSR_IBUSERR_BITS   0x00000100
#define RP23XX_M33_CFSR_BFSR_IBUSERR_MSB    8
#define RP23XX_M33_CFSR_BFSR_IBUSERR_LSB    8
#define RP23XX_M33_CFSR_BFSR_IBUSERR_ACCESS "RW"

#define RP23XX_M33_CFSR_MMFSR_RESET  0x00
#define RP23XX_M33_CFSR_MMFSR_BITS   0x000000ff
#define RP23XX_M33_CFSR_MMFSR_MSB    7
#define RP23XX_M33_CFSR_MMFSR_LSB    0
#define RP23XX_M33_CFSR_MMFSR_ACCESS "RW"

#define RP23XX_M33_HFSR_OFFSET 0x0000ed2c
#define RP23XX_M33_HFSR_BITS   0xc0000002
#define RP23XX_M33_HFSR_RESET  0x00000000

#define RP23XX_M33_HFSR_DEBUGEVT_RESET  0x0
#define RP23XX_M33_HFSR_DEBUGEVT_BITS   0x80000000
#define RP23XX_M33_HFSR_DEBUGEVT_MSB    31
#define RP23XX_M33_HFSR_DEBUGEVT_LSB    31
#define RP23XX_M33_HFSR_DEBUGEVT_ACCESS "RW"

#define RP23XX_M33_HFSR_FORCED_RESET  0x0
#define RP23XX_M33_HFSR_FORCED_BITS   0x40000000
#define RP23XX_M33_HFSR_FORCED_MSB    30
#define RP23XX_M33_HFSR_FORCED_LSB    30
#define RP23XX_M33_HFSR_FORCED_ACCESS "RW"

#define RP23XX_M33_HFSR_VECTTBL_RESET  0x0
#define RP23XX_M33_HFSR_VECTTBL_BITS   0x00000002
#define RP23XX_M33_HFSR_VECTTBL_MSB    1
#define RP23XX_M33_HFSR_VECTTBL_LSB    1
#define RP23XX_M33_HFSR_VECTTBL_ACCESS "RW"

#define RP23XX_M33_DFSR_OFFSET 0x0000ed30
#define RP23XX_M33_DFSR_BITS   0x0000001f
#define RP23XX_M33_DFSR_RESET  0x00000000

#define RP23XX_M33_DFSR_EXTERNAL_RESET  0x0
#define RP23XX_M33_DFSR_EXTERNAL_BITS   0x00000010
#define RP23XX_M33_DFSR_EXTERNAL_MSB    4
#define RP23XX_M33_DFSR_EXTERNAL_LSB    4
#define RP23XX_M33_DFSR_EXTERNAL_ACCESS "RW"

#define RP23XX_M33_DFSR_VCATCH_RESET  0x0
#define RP23XX_M33_DFSR_VCATCH_BITS   0x00000008
#define RP23XX_M33_DFSR_VCATCH_MSB    3
#define RP23XX_M33_DFSR_VCATCH_LSB    3
#define RP23XX_M33_DFSR_VCATCH_ACCESS "RW"

#define RP23XX_M33_DFSR_DWTTRAP_RESET  0x0
#define RP23XX_M33_DFSR_DWTTRAP_BITS   0x00000004
#define RP23XX_M33_DFSR_DWTTRAP_MSB    2
#define RP23XX_M33_DFSR_DWTTRAP_LSB    2
#define RP23XX_M33_DFSR_DWTTRAP_ACCESS "RW"

#define RP23XX_M33_DFSR_BKPT_RESET  0x0
#define RP23XX_M33_DFSR_BKPT_BITS   0x00000002
#define RP23XX_M33_DFSR_BKPT_MSB    1
#define RP23XX_M33_DFSR_BKPT_LSB    1
#define RP23XX_M33_DFSR_BKPT_ACCESS "RW"

#define RP23XX_M33_DFSR_HALTED_RESET  0x0
#define RP23XX_M33_DFSR_HALTED_BITS   0x00000001
#define RP23XX_M33_DFSR_HALTED_MSB    0
#define RP23XX_M33_DFSR_HALTED_LSB    0
#define RP23XX_M33_DFSR_HALTED_ACCESS "RW"

#define RP23XX_M33_MMFAR_OFFSET 0x0000ed34
#define RP23XX_M33_MMFAR_BITS   0xffffffff
#define RP23XX_M33_MMFAR_RESET  0x00000000

#define RP23XX_M33_MMFAR_ADDRESS_RESET  0x00000000
#define RP23XX_M33_MMFAR_ADDRESS_BITS   0xffffffff
#define RP23XX_M33_MMFAR_ADDRESS_MSB    31
#define RP23XX_M33_MMFAR_ADDRESS_LSB    0
#define RP23XX_M33_MMFAR_ADDRESS_ACCESS "RW"

#define RP23XX_M33_BFAR_OFFSET 0x0000ed38
#define RP23XX_M33_BFAR_BITS   0xffffffff
#define RP23XX_M33_BFAR_RESET  0x00000000

#define RP23XX_M33_BFAR_ADDRESS_RESET  0x00000000
#define RP23XX_M33_BFAR_ADDRESS_BITS   0xffffffff
#define RP23XX_M33_BFAR_ADDRESS_MSB    31
#define RP23XX_M33_BFAR_ADDRESS_LSB    0
#define RP23XX_M33_BFAR_ADDRESS_ACCESS "RW"

#define RP23XX_M33_ID_PFR0_OFFSET 0x0000ed40
#define RP23XX_M33_ID_PFR0_BITS   0x000000ff
#define RP23XX_M33_ID_PFR0_RESET  0x00000030

#define RP23XX_M33_ID_PFR0_STATE1_RESET  0x3
#define RP23XX_M33_ID_PFR0_STATE1_BITS   0x000000f0
#define RP23XX_M33_ID_PFR0_STATE1_MSB    7
#define RP23XX_M33_ID_PFR0_STATE1_LSB    4
#define RP23XX_M33_ID_PFR0_STATE1_ACCESS "RO"

#define RP23XX_M33_ID_PFR0_STATE0_RESET  0x0
#define RP23XX_M33_ID_PFR0_STATE0_BITS   0x0000000f
#define RP23XX_M33_ID_PFR0_STATE0_MSB    3
#define RP23XX_M33_ID_PFR0_STATE0_LSB    0
#define RP23XX_M33_ID_PFR0_STATE0_ACCESS "RO"

#define RP23XX_M33_ID_PFR1_OFFSET 0x0000ed44
#define RP23XX_M33_ID_PFR1_BITS   0x00000ff0
#define RP23XX_M33_ID_PFR1_RESET  0x00000520

#define RP23XX_M33_ID_PFR1_MPROGMOD_RESET  0x5
#define RP23XX_M33_ID_PFR1_MPROGMOD_BITS   0x00000f00
#define RP23XX_M33_ID_PFR1_MPROGMOD_MSB    11
#define RP23XX_M33_ID_PFR1_MPROGMOD_LSB    8
#define RP23XX_M33_ID_PFR1_MPROGMOD_ACCESS "RO"

#define RP23XX_M33_ID_PFR1_SECURITY_RESET  0x2
#define RP23XX_M33_ID_PFR1_SECURITY_BITS   0x000000f0
#define RP23XX_M33_ID_PFR1_SECURITY_MSB    7
#define RP23XX_M33_ID_PFR1_SECURITY_LSB    4
#define RP23XX_M33_ID_PFR1_SECURITY_ACCESS "RO"

#define RP23XX_M33_ID_DFR0_OFFSET 0x0000ed48
#define RP23XX_M33_ID_DFR0_BITS   0x00f00000
#define RP23XX_M33_ID_DFR0_RESET  0x00200000

#define RP23XX_M33_ID_DFR0_MPROFDBG_RESET  0x2
#define RP23XX_M33_ID_DFR0_MPROFDBG_BITS   0x00f00000
#define RP23XX_M33_ID_DFR0_MPROFDBG_MSB    23
#define RP23XX_M33_ID_DFR0_MPROFDBG_LSB    20
#define RP23XX_M33_ID_DFR0_MPROFDBG_ACCESS "RO"

#define RP23XX_M33_ID_AFR0_OFFSET 0x0000ed4c
#define RP23XX_M33_ID_AFR0_BITS   0x0000ffff
#define RP23XX_M33_ID_AFR0_RESET  0x00000000

#define RP23XX_M33_ID_AFR0_IMPDEF3_RESET  0x0
#define RP23XX_M33_ID_AFR0_IMPDEF3_BITS   0x0000f000
#define RP23XX_M33_ID_AFR0_IMPDEF3_MSB    15
#define RP23XX_M33_ID_AFR0_IMPDEF3_LSB    12
#define RP23XX_M33_ID_AFR0_IMPDEF3_ACCESS "RO"

#define RP23XX_M33_ID_AFR0_IMPDEF2_RESET  0x0
#define RP23XX_M33_ID_AFR0_IMPDEF2_BITS   0x00000f00
#define RP23XX_M33_ID_AFR0_IMPDEF2_MSB    11
#define RP23XX_M33_ID_AFR0_IMPDEF2_LSB    8
#define RP23XX_M33_ID_AFR0_IMPDEF2_ACCESS "RO"

#define RP23XX_M33_ID_AFR0_IMPDEF1_RESET  0x0
#define RP23XX_M33_ID_AFR0_IMPDEF1_BITS   0x000000f0
#define RP23XX_M33_ID_AFR0_IMPDEF1_MSB    7
#define RP23XX_M33_ID_AFR0_IMPDEF1_LSB    4
#define RP23XX_M33_ID_AFR0_IMPDEF1_ACCESS "RO"

#define RP23XX_M33_ID_AFR0_IMPDEF0_RESET  0x0
#define RP23XX_M33_ID_AFR0_IMPDEF0_BITS   0x0000000f
#define RP23XX_M33_ID_AFR0_IMPDEF0_MSB    3
#define RP23XX_M33_ID_AFR0_IMPDEF0_LSB    0
#define RP23XX_M33_ID_AFR0_IMPDEF0_ACCESS "RO"

#define RP23XX_M33_ID_MMFR0_OFFSET 0x0000ed50
#define RP23XX_M33_ID_MMFR0_BITS   0x00fffff0
#define RP23XX_M33_ID_MMFR0_RESET  0x00101f40

#define RP23XX_M33_ID_MMFR0_AUXREG_RESET  0x1
#define RP23XX_M33_ID_MMFR0_AUXREG_BITS   0x00f00000
#define RP23XX_M33_ID_MMFR0_AUXREG_MSB    23
#define RP23XX_M33_ID_MMFR0_AUXREG_LSB    20
#define RP23XX_M33_ID_MMFR0_AUXREG_ACCESS "RO"

#define RP23XX_M33_ID_MMFR0_TCM_RESET  0x0
#define RP23XX_M33_ID_MMFR0_TCM_BITS   0x000f0000
#define RP23XX_M33_ID_MMFR0_TCM_MSB    19
#define RP23XX_M33_ID_MMFR0_TCM_LSB    16
#define RP23XX_M33_ID_MMFR0_TCM_ACCESS "RO"

#define RP23XX_M33_ID_MMFR0_SHARELVL_RESET  0x1
#define RP23XX_M33_ID_MMFR0_SHARELVL_BITS   0x0000f000
#define RP23XX_M33_ID_MMFR0_SHARELVL_MSB    15
#define RP23XX_M33_ID_MMFR0_SHARELVL_LSB    12
#define RP23XX_M33_ID_MMFR0_SHARELVL_ACCESS "RO"

#define RP23XX_M33_ID_MMFR0_OUTERSHR_RESET  0xf
#define RP23XX_M33_ID_MMFR0_OUTERSHR_BITS   0x00000f00
#define RP23XX_M33_ID_MMFR0_OUTERSHR_MSB    11
#define RP23XX_M33_ID_MMFR0_OUTERSHR_LSB    8
#define RP23XX_M33_ID_MMFR0_OUTERSHR_ACCESS "RO"

#define RP23XX_M33_ID_MMFR0_PMSA_RESET  0x4
#define RP23XX_M33_ID_MMFR0_PMSA_BITS   0x000000f0
#define RP23XX_M33_ID_MMFR0_PMSA_MSB    7
#define RP23XX_M33_ID_MMFR0_PMSA_LSB    4
#define RP23XX_M33_ID_MMFR0_PMSA_ACCESS "RO"

#define RP23XX_M33_ID_MMFR1_OFFSET 0x0000ed54
#define RP23XX_M33_ID_MMFR1_BITS   0x00000000
#define RP23XX_M33_ID_MMFR1_RESET  0x00000000
#define RP23XX_M33_ID_MMFR1_MSB    31
#define RP23XX_M33_ID_MMFR1_LSB    0
#define RP23XX_M33_ID_MMFR1_ACCESS "RW"

#define RP23XX_M33_ID_MMFR2_OFFSET 0x0000ed58
#define RP23XX_M33_ID_MMFR2_BITS   0x0f000000
#define RP23XX_M33_ID_MMFR2_RESET  0x01000000

#define RP23XX_M33_ID_MMFR2_WFISTALL_RESET  0x1
#define RP23XX_M33_ID_MMFR2_WFISTALL_BITS   0x0f000000
#define RP23XX_M33_ID_MMFR2_WFISTALL_MSB    27
#define RP23XX_M33_ID_MMFR2_WFISTALL_LSB    24
#define RP23XX_M33_ID_MMFR2_WFISTALL_ACCESS "RO"

#define RP23XX_M33_ID_MMFR3_OFFSET 0x0000ed5c
#define RP23XX_M33_ID_MMFR3_BITS   0x00000fff
#define RP23XX_M33_ID_MMFR3_RESET  0x00000000

#define RP23XX_M33_ID_MMFR3_BPMAINT_RESET  0x0
#define RP23XX_M33_ID_MMFR3_BPMAINT_BITS   0x00000f00
#define RP23XX_M33_ID_MMFR3_BPMAINT_MSB    11
#define RP23XX_M33_ID_MMFR3_BPMAINT_LSB    8
#define RP23XX_M33_ID_MMFR3_BPMAINT_ACCESS "RO"

#define RP23XX_M33_ID_MMFR3_CMAINTSW_RESET  0x0
#define RP23XX_M33_ID_MMFR3_CMAINTSW_BITS   0x000000f0
#define RP23XX_M33_ID_MMFR3_CMAINTSW_MSB    7
#define RP23XX_M33_ID_MMFR3_CMAINTSW_LSB    4
#define RP23XX_M33_ID_MMFR3_CMAINTSW_ACCESS "RO"

#define RP23XX_M33_ID_MMFR3_CMAINTVA_RESET  0x0
#define RP23XX_M33_ID_MMFR3_CMAINTVA_BITS   0x0000000f
#define RP23XX_M33_ID_MMFR3_CMAINTVA_MSB    3
#define RP23XX_M33_ID_MMFR3_CMAINTVA_LSB    0
#define RP23XX_M33_ID_MMFR3_CMAINTVA_ACCESS "RO"

#define RP23XX_M33_ID_ISAR0_OFFSET 0x0000ed60
#define RP23XX_M33_ID_ISAR0_BITS   0x0ffffff0
#define RP23XX_M33_ID_ISAR0_RESET  0x08092300

#define RP23XX_M33_ID_ISAR0_DIVIDE_RESET  0x8
#define RP23XX_M33_ID_ISAR0_DIVIDE_BITS   0x0f000000
#define RP23XX_M33_ID_ISAR0_DIVIDE_MSB    27
#define RP23XX_M33_ID_ISAR0_DIVIDE_LSB    24
#define RP23XX_M33_ID_ISAR0_DIVIDE_ACCESS "RO"

#define RP23XX_M33_ID_ISAR0_DEBUG_RESET  0x0
#define RP23XX_M33_ID_ISAR0_DEBUG_BITS   0x00f00000
#define RP23XX_M33_ID_ISAR0_DEBUG_MSB    23
#define RP23XX_M33_ID_ISAR0_DEBUG_LSB    20
#define RP23XX_M33_ID_ISAR0_DEBUG_ACCESS "RO"

#define RP23XX_M33_ID_ISAR0_COPROC_RESET  0x9
#define RP23XX_M33_ID_ISAR0_COPROC_BITS   0x000f0000
#define RP23XX_M33_ID_ISAR0_COPROC_MSB    19
#define RP23XX_M33_ID_ISAR0_COPROC_LSB    16
#define RP23XX_M33_ID_ISAR0_COPROC_ACCESS "RO"

#define RP23XX_M33_ID_ISAR0_CMPBRANCH_RESET  0x2
#define RP23XX_M33_ID_ISAR0_CMPBRANCH_BITS   0x0000f000
#define RP23XX_M33_ID_ISAR0_CMPBRANCH_MSB    15
#define RP23XX_M33_ID_ISAR0_CMPBRANCH_LSB    12
#define RP23XX_M33_ID_ISAR0_CMPBRANCH_ACCESS "RO"

#define RP23XX_M33_ID_ISAR0_BITFIELD_RESET  0x3
#define RP23XX_M33_ID_ISAR0_BITFIELD_BITS   0x00000f00
#define RP23XX_M33_ID_ISAR0_BITFIELD_MSB    11
#define RP23XX_M33_ID_ISAR0_BITFIELD_LSB    8
#define RP23XX_M33_ID_ISAR0_BITFIELD_ACCESS "RO"

#define RP23XX_M33_ID_ISAR0_BITCOUNT_RESET  0x0
#define RP23XX_M33_ID_ISAR0_BITCOUNT_BITS   0x000000f0
#define RP23XX_M33_ID_ISAR0_BITCOUNT_MSB    7
#define RP23XX_M33_ID_ISAR0_BITCOUNT_LSB    4
#define RP23XX_M33_ID_ISAR0_BITCOUNT_ACCESS "RO"

#define RP23XX_M33_ID_ISAR1_OFFSET 0x0000ed64
#define RP23XX_M33_ID_ISAR1_BITS   0x0ffff000
#define RP23XX_M33_ID_ISAR1_RESET  0x05725000

#define RP23XX_M33_ID_ISAR1_INTERWORK_RESET  0x5
#define RP23XX_M33_ID_ISAR1_INTERWORK_BITS   0x0f000000
#define RP23XX_M33_ID_ISAR1_INTERWORK_MSB    27
#define RP23XX_M33_ID_ISAR1_INTERWORK_LSB    24
#define RP23XX_M33_ID_ISAR1_INTERWORK_ACCESS "RO"

#define RP23XX_M33_ID_ISAR1_IMMEDIATE_RESET  0x7
#define RP23XX_M33_ID_ISAR1_IMMEDIATE_BITS   0x00f00000
#define RP23XX_M33_ID_ISAR1_IMMEDIATE_MSB    23
#define RP23XX_M33_ID_ISAR1_IMMEDIATE_LSB    20
#define RP23XX_M33_ID_ISAR1_IMMEDIATE_ACCESS "RO"

#define RP23XX_M33_ID_ISAR1_IFTHEN_RESET  0x2
#define RP23XX_M33_ID_ISAR1_IFTHEN_BITS   0x000f0000
#define RP23XX_M33_ID_ISAR1_IFTHEN_MSB    19
#define RP23XX_M33_ID_ISAR1_IFTHEN_LSB    16
#define RP23XX_M33_ID_ISAR1_IFTHEN_ACCESS "RO"

#define RP23XX_M33_ID_ISAR1_EXTEND_RESET  0x5
#define RP23XX_M33_ID_ISAR1_EXTEND_BITS   0x0000f000
#define RP23XX_M33_ID_ISAR1_EXTEND_MSB    15
#define RP23XX_M33_ID_ISAR1_EXTEND_LSB    12
#define RP23XX_M33_ID_ISAR1_EXTEND_ACCESS "RO"

#define RP23XX_M33_ID_ISAR2_OFFSET 0x0000ed68
#define RP23XX_M33_ID_ISAR2_BITS   0xf0ffffff
#define RP23XX_M33_ID_ISAR2_RESET  0x30173426

#define RP23XX_M33_ID_ISAR2_REVERSAL_RESET  0x3
#define RP23XX_M33_ID_ISAR2_REVERSAL_BITS   0xf0000000
#define RP23XX_M33_ID_ISAR2_REVERSAL_MSB    31
#define RP23XX_M33_ID_ISAR2_REVERSAL_LSB    28
#define RP23XX_M33_ID_ISAR2_REVERSAL_ACCESS "RO"

#define RP23XX_M33_ID_ISAR2_MULTU_RESET  0x1
#define RP23XX_M33_ID_ISAR2_MULTU_BITS   0x00f00000
#define RP23XX_M33_ID_ISAR2_MULTU_MSB    23
#define RP23XX_M33_ID_ISAR2_MULTU_LSB    20
#define RP23XX_M33_ID_ISAR2_MULTU_ACCESS "RO"

#define RP23XX_M33_ID_ISAR2_MULTS_RESET  0x7
#define RP23XX_M33_ID_ISAR2_MULTS_BITS   0x000f0000
#define RP23XX_M33_ID_ISAR2_MULTS_MSB    19
#define RP23XX_M33_ID_ISAR2_MULTS_LSB    16
#define RP23XX_M33_ID_ISAR2_MULTS_ACCESS "RO"

#define RP23XX_M33_ID_ISAR2_MULT_RESET  0x3
#define RP23XX_M33_ID_ISAR2_MULT_BITS   0x0000f000
#define RP23XX_M33_ID_ISAR2_MULT_MSB    15
#define RP23XX_M33_ID_ISAR2_MULT_LSB    12
#define RP23XX_M33_ID_ISAR2_MULT_ACCESS "RO"

#define RP23XX_M33_ID_ISAR2_MULTIACCESSINT_RESET  0x4
#define RP23XX_M33_ID_ISAR2_MULTIACCESSINT_BITS   0x00000f00
#define RP23XX_M33_ID_ISAR2_MULTIACCESSINT_MSB    11
#define RP23XX_M33_ID_ISAR2_MULTIACCESSINT_LSB    8
#define RP23XX_M33_ID_ISAR2_MULTIACCESSINT_ACCESS "RO"

#define RP23XX_M33_ID_ISAR2_MEMHINT_RESET  0x2
#define RP23XX_M33_ID_ISAR2_MEMHINT_BITS   0x000000f0
#define RP23XX_M33_ID_ISAR2_MEMHINT_MSB    7
#define RP23XX_M33_ID_ISAR2_MEMHINT_LSB    4
#define RP23XX_M33_ID_ISAR2_MEMHINT_ACCESS "RO"

#define RP23XX_M33_ID_ISAR2_LOADSTORE_RESET  0x6
#define RP23XX_M33_ID_ISAR2_LOADSTORE_BITS   0x0000000f
#define RP23XX_M33_ID_ISAR2_LOADSTORE_MSB    3
#define RP23XX_M33_ID_ISAR2_LOADSTORE_LSB    0
#define RP23XX_M33_ID_ISAR2_LOADSTORE_ACCESS "RO"

#define RP23XX_M33_ID_ISAR3_OFFSET 0x0000ed6c
#define RP23XX_M33_ID_ISAR3_BITS   0x0fffffff
#define RP23XX_M33_ID_ISAR3_RESET  0x07895729

#define RP23XX_M33_ID_ISAR3_TRUENOP_RESET  0x7
#define RP23XX_M33_ID_ISAR3_TRUENOP_BITS   0x0f000000
#define RP23XX_M33_ID_ISAR3_TRUENOP_MSB    27
#define RP23XX_M33_ID_ISAR3_TRUENOP_LSB    24
#define RP23XX_M33_ID_ISAR3_TRUENOP_ACCESS "RO"

#define RP23XX_M33_ID_ISAR3_T32COPY_RESET  0x8
#define RP23XX_M33_ID_ISAR3_T32COPY_BITS   0x00f00000
#define RP23XX_M33_ID_ISAR3_T32COPY_MSB    23
#define RP23XX_M33_ID_ISAR3_T32COPY_LSB    20
#define RP23XX_M33_ID_ISAR3_T32COPY_ACCESS "RO"

#define RP23XX_M33_ID_ISAR3_TABBRANCH_RESET  0x9
#define RP23XX_M33_ID_ISAR3_TABBRANCH_BITS   0x000f0000
#define RP23XX_M33_ID_ISAR3_TABBRANCH_MSB    19
#define RP23XX_M33_ID_ISAR3_TABBRANCH_LSB    16
#define RP23XX_M33_ID_ISAR3_TABBRANCH_ACCESS "RO"

#define RP23XX_M33_ID_ISAR3_SYNCHPRIM_RESET  0x5
#define RP23XX_M33_ID_ISAR3_SYNCHPRIM_BITS   0x0000f000
#define RP23XX_M33_ID_ISAR3_SYNCHPRIM_MSB    15
#define RP23XX_M33_ID_ISAR3_SYNCHPRIM_LSB    12
#define RP23XX_M33_ID_ISAR3_SYNCHPRIM_ACCESS "RO"

#define RP23XX_M33_ID_ISAR3_SVC_RESET  0x7
#define RP23XX_M33_ID_ISAR3_SVC_BITS   0x00000f00
#define RP23XX_M33_ID_ISAR3_SVC_MSB    11
#define RP23XX_M33_ID_ISAR3_SVC_LSB    8
#define RP23XX_M33_ID_ISAR3_SVC_ACCESS "RO"

#define RP23XX_M33_ID_ISAR3_SIMD_RESET  0x2
#define RP23XX_M33_ID_ISAR3_SIMD_BITS   0x000000f0
#define RP23XX_M33_ID_ISAR3_SIMD_MSB    7
#define RP23XX_M33_ID_ISAR3_SIMD_LSB    4
#define RP23XX_M33_ID_ISAR3_SIMD_ACCESS "RO"

#define RP23XX_M33_ID_ISAR3_SATURATE_RESET  0x9
#define RP23XX_M33_ID_ISAR3_SATURATE_BITS   0x0000000f
#define RP23XX_M33_ID_ISAR3_SATURATE_MSB    3
#define RP23XX_M33_ID_ISAR3_SATURATE_LSB    0
#define RP23XX_M33_ID_ISAR3_SATURATE_ACCESS "RO"

#define RP23XX_M33_ID_ISAR4_OFFSET 0x0000ed70
#define RP23XX_M33_ID_ISAR4_BITS   0x0fff0fff
#define RP23XX_M33_ID_ISAR4_RESET  0x01310132

#define RP23XX_M33_ID_ISAR4_PSR_M_RESET  0x1
#define RP23XX_M33_ID_ISAR4_PSR_M_BITS   0x0f000000
#define RP23XX_M33_ID_ISAR4_PSR_M_MSB    27
#define RP23XX_M33_ID_ISAR4_PSR_M_LSB    24
#define RP23XX_M33_ID_ISAR4_PSR_M_ACCESS "RO"

#define RP23XX_M33_ID_ISAR4_SYNCPRIM_FRAC_RESET  0x3
#define RP23XX_M33_ID_ISAR4_SYNCPRIM_FRAC_BITS   0x00f00000
#define RP23XX_M33_ID_ISAR4_SYNCPRIM_FRAC_MSB    23
#define RP23XX_M33_ID_ISAR4_SYNCPRIM_FRAC_LSB    20
#define RP23XX_M33_ID_ISAR4_SYNCPRIM_FRAC_ACCESS "RO"

#define RP23XX_M33_ID_ISAR4_BARRIER_RESET  0x1
#define RP23XX_M33_ID_ISAR4_BARRIER_BITS   0x000f0000
#define RP23XX_M33_ID_ISAR4_BARRIER_MSB    19
#define RP23XX_M33_ID_ISAR4_BARRIER_LSB    16
#define RP23XX_M33_ID_ISAR4_BARRIER_ACCESS "RO"

#define RP23XX_M33_ID_ISAR4_WRITEBACK_RESET  0x1
#define RP23XX_M33_ID_ISAR4_WRITEBACK_BITS   0x00000f00
#define RP23XX_M33_ID_ISAR4_WRITEBACK_MSB    11
#define RP23XX_M33_ID_ISAR4_WRITEBACK_LSB    8
#define RP23XX_M33_ID_ISAR4_WRITEBACK_ACCESS "RO"

#define RP23XX_M33_ID_ISAR4_WITHSHIFTS_RESET  0x3
#define RP23XX_M33_ID_ISAR4_WITHSHIFTS_BITS   0x000000f0
#define RP23XX_M33_ID_ISAR4_WITHSHIFTS_MSB    7
#define RP23XX_M33_ID_ISAR4_WITHSHIFTS_LSB    4
#define RP23XX_M33_ID_ISAR4_WITHSHIFTS_ACCESS "RO"

#define RP23XX_M33_ID_ISAR4_UNPRIV_RESET  0x2
#define RP23XX_M33_ID_ISAR4_UNPRIV_BITS   0x0000000f
#define RP23XX_M33_ID_ISAR4_UNPRIV_MSB    3
#define RP23XX_M33_ID_ISAR4_UNPRIV_LSB    0
#define RP23XX_M33_ID_ISAR4_UNPRIV_ACCESS "RO"

#define RP23XX_M33_ID_ISAR5_OFFSET 0x0000ed74
#define RP23XX_M33_ID_ISAR5_BITS   0x00000000
#define RP23XX_M33_ID_ISAR5_RESET  0x00000000
#define RP23XX_M33_ID_ISAR5_MSB    31
#define RP23XX_M33_ID_ISAR5_LSB    0
#define RP23XX_M33_ID_ISAR5_ACCESS "RW"

#define RP23XX_M33_CTR_OFFSET 0x0000ed7c
#define RP23XX_M33_CTR_BITS   0x8fffc00f
#define RP23XX_M33_CTR_RESET  0x8000c000

#define RP23XX_M33_CTR_RES1_RESET  0x1
#define RP23XX_M33_CTR_RES1_BITS   0x80000000
#define RP23XX_M33_CTR_RES1_MSB    31
#define RP23XX_M33_CTR_RES1_LSB    31
#define RP23XX_M33_CTR_RES1_ACCESS "RO"

#define RP23XX_M33_CTR_CWG_RESET  0x0
#define RP23XX_M33_CTR_CWG_BITS   0x0f000000
#define RP23XX_M33_CTR_CWG_MSB    27
#define RP23XX_M33_CTR_CWG_LSB    24
#define RP23XX_M33_CTR_CWG_ACCESS "RO"

#define RP23XX_M33_CTR_ERG_RESET  0x0
#define RP23XX_M33_CTR_ERG_BITS   0x00f00000
#define RP23XX_M33_CTR_ERG_MSB    23
#define RP23XX_M33_CTR_ERG_LSB    20
#define RP23XX_M33_CTR_ERG_ACCESS "RO"

#define RP23XX_M33_CTR_DMINLINE_RESET  0x0
#define RP23XX_M33_CTR_DMINLINE_BITS   0x000f0000
#define RP23XX_M33_CTR_DMINLINE_MSB    19
#define RP23XX_M33_CTR_DMINLINE_LSB    16
#define RP23XX_M33_CTR_DMINLINE_ACCESS "RO"

#define RP23XX_M33_CTR_RES1_1_RESET  0x3
#define RP23XX_M33_CTR_RES1_1_BITS   0x0000c000
#define RP23XX_M33_CTR_RES1_1_MSB    15
#define RP23XX_M33_CTR_RES1_1_LSB    14
#define RP23XX_M33_CTR_RES1_1_ACCESS "RO"

#define RP23XX_M33_CTR_IMINLINE_RESET  0x0
#define RP23XX_M33_CTR_IMINLINE_BITS   0x0000000f
#define RP23XX_M33_CTR_IMINLINE_MSB    3
#define RP23XX_M33_CTR_IMINLINE_LSB    0
#define RP23XX_M33_CTR_IMINLINE_ACCESS "RO"

#define RP23XX_M33_CPACR_OFFSET 0x0000ed88
#define RP23XX_M33_CPACR_BITS   0x00f0ffff
#define RP23XX_M33_CPACR_RESET  0x00000000

#define RP23XX_M33_CPACR_CP11_RESET  0x0
#define RP23XX_M33_CPACR_CP11_BITS   0x00c00000
#define RP23XX_M33_CPACR_CP11_MSB    23
#define RP23XX_M33_CPACR_CP11_LSB    22
#define RP23XX_M33_CPACR_CP11_ACCESS "RW"

#define RP23XX_M33_CPACR_CP10_RESET  0x0
#define RP23XX_M33_CPACR_CP10_BITS   0x00300000
#define RP23XX_M33_CPACR_CP10_MSB    21
#define RP23XX_M33_CPACR_CP10_LSB    20
#define RP23XX_M33_CPACR_CP10_ACCESS "RW"

#define RP23XX_M33_CPACR_CP7_RESET  0x0
#define RP23XX_M33_CPACR_CP7_BITS   0x0000c000
#define RP23XX_M33_CPACR_CP7_MSB    15
#define RP23XX_M33_CPACR_CP7_LSB    14
#define RP23XX_M33_CPACR_CP7_ACCESS "RW"

#define RP23XX_M33_CPACR_CP6_RESET  0x0
#define RP23XX_M33_CPACR_CP6_BITS   0x00003000
#define RP23XX_M33_CPACR_CP6_MSB    13
#define RP23XX_M33_CPACR_CP6_LSB    12
#define RP23XX_M33_CPACR_CP6_ACCESS "RW"

#define RP23XX_M33_CPACR_CP5_RESET  0x0
#define RP23XX_M33_CPACR_CP5_BITS   0x00000c00
#define RP23XX_M33_CPACR_CP5_MSB    11
#define RP23XX_M33_CPACR_CP5_LSB    10
#define RP23XX_M33_CPACR_CP5_ACCESS "RW"

#define RP23XX_M33_CPACR_CP4_RESET  0x0
#define RP23XX_M33_CPACR_CP4_BITS   0x00000300
#define RP23XX_M33_CPACR_CP4_MSB    9
#define RP23XX_M33_CPACR_CP4_LSB    8
#define RP23XX_M33_CPACR_CP4_ACCESS "RW"

#define RP23XX_M33_CPACR_CP3_RESET  0x0
#define RP23XX_M33_CPACR_CP3_BITS   0x000000c0
#define RP23XX_M33_CPACR_CP3_MSB    7
#define RP23XX_M33_CPACR_CP3_LSB    6
#define RP23XX_M33_CPACR_CP3_ACCESS "RW"

#define RP23XX_M33_CPACR_CP2_RESET  0x0
#define RP23XX_M33_CPACR_CP2_BITS   0x00000030
#define RP23XX_M33_CPACR_CP2_MSB    5
#define RP23XX_M33_CPACR_CP2_LSB    4
#define RP23XX_M33_CPACR_CP2_ACCESS "RW"

#define RP23XX_M33_CPACR_CP1_RESET  0x0
#define RP23XX_M33_CPACR_CP1_BITS   0x0000000c
#define RP23XX_M33_CPACR_CP1_MSB    3
#define RP23XX_M33_CPACR_CP1_LSB    2
#define RP23XX_M33_CPACR_CP1_ACCESS "RW"

#define RP23XX_M33_CPACR_CP0_RESET  0x0
#define RP23XX_M33_CPACR_CP0_BITS   0x00000003
#define RP23XX_M33_CPACR_CP0_MSB    1
#define RP23XX_M33_CPACR_CP0_LSB    0
#define RP23XX_M33_CPACR_CP0_ACCESS "RW"

#define RP23XX_M33_NSACR_OFFSET 0x0000ed8c
#define RP23XX_M33_NSACR_BITS   0x00000cff
#define RP23XX_M33_NSACR_RESET  0x00000000

#define RP23XX_M33_NSACR_CP11_RESET  0x0
#define RP23XX_M33_NSACR_CP11_BITS   0x00000800
#define RP23XX_M33_NSACR_CP11_MSB    11
#define RP23XX_M33_NSACR_CP11_LSB    11
#define RP23XX_M33_NSACR_CP11_ACCESS "RW"

#define RP23XX_M33_NSACR_CP10_RESET  0x0
#define RP23XX_M33_NSACR_CP10_BITS   0x00000400
#define RP23XX_M33_NSACR_CP10_MSB    10
#define RP23XX_M33_NSACR_CP10_LSB    10
#define RP23XX_M33_NSACR_CP10_ACCESS "RW"

#define RP23XX_M33_NSACR_CP7_RESET  0x0
#define RP23XX_M33_NSACR_CP7_BITS   0x00000080
#define RP23XX_M33_NSACR_CP7_MSB    7
#define RP23XX_M33_NSACR_CP7_LSB    7
#define RP23XX_M33_NSACR_CP7_ACCESS "RW"

#define RP23XX_M33_NSACR_CP6_RESET  0x0
#define RP23XX_M33_NSACR_CP6_BITS   0x00000040
#define RP23XX_M33_NSACR_CP6_MSB    6
#define RP23XX_M33_NSACR_CP6_LSB    6
#define RP23XX_M33_NSACR_CP6_ACCESS "RW"

#define RP23XX_M33_NSACR_CP5_RESET  0x0
#define RP23XX_M33_NSACR_CP5_BITS   0x00000020
#define RP23XX_M33_NSACR_CP5_MSB    5
#define RP23XX_M33_NSACR_CP5_LSB    5
#define RP23XX_M33_NSACR_CP5_ACCESS "RW"

#define RP23XX_M33_NSACR_CP4_RESET  0x0
#define RP23XX_M33_NSACR_CP4_BITS   0x00000010
#define RP23XX_M33_NSACR_CP4_MSB    4
#define RP23XX_M33_NSACR_CP4_LSB    4
#define RP23XX_M33_NSACR_CP4_ACCESS "RW"

#define RP23XX_M33_NSACR_CP3_RESET  0x0
#define RP23XX_M33_NSACR_CP3_BITS   0x00000008
#define RP23XX_M33_NSACR_CP3_MSB    3
#define RP23XX_M33_NSACR_CP3_LSB    3
#define RP23XX_M33_NSACR_CP3_ACCESS "RW"

#define RP23XX_M33_NSACR_CP2_RESET  0x0
#define RP23XX_M33_NSACR_CP2_BITS   0x00000004
#define RP23XX_M33_NSACR_CP2_MSB    2
#define RP23XX_M33_NSACR_CP2_LSB    2
#define RP23XX_M33_NSACR_CP2_ACCESS "RW"

#define RP23XX_M33_NSACR_CP1_RESET  0x0
#define RP23XX_M33_NSACR_CP1_BITS   0x00000002
#define RP23XX_M33_NSACR_CP1_MSB    1
#define RP23XX_M33_NSACR_CP1_LSB    1
#define RP23XX_M33_NSACR_CP1_ACCESS "RW"

#define RP23XX_M33_NSACR_CP0_RESET  0x0
#define RP23XX_M33_NSACR_CP0_BITS   0x00000001
#define RP23XX_M33_NSACR_CP0_MSB    0
#define RP23XX_M33_NSACR_CP0_LSB    0
#define RP23XX_M33_NSACR_CP0_ACCESS "RW"

#define RP23XX_M33_MPU_TYPE_OFFSET 0x0000ed90
#define RP23XX_M33_MPU_TYPE_BITS   0x0000ff01
#define RP23XX_M33_MPU_TYPE_RESET  0x00000800

#define RP23XX_M33_MPU_TYPE_DREGION_RESET  0x08
#define RP23XX_M33_MPU_TYPE_DREGION_BITS   0x0000ff00
#define RP23XX_M33_MPU_TYPE_DREGION_MSB    15
#define RP23XX_M33_MPU_TYPE_DREGION_LSB    8
#define RP23XX_M33_MPU_TYPE_DREGION_ACCESS "RO"

#define RP23XX_M33_MPU_TYPE_SEPARATE_RESET  0x0
#define RP23XX_M33_MPU_TYPE_SEPARATE_BITS   0x00000001
#define RP23XX_M33_MPU_TYPE_SEPARATE_MSB    0
#define RP23XX_M33_MPU_TYPE_SEPARATE_LSB    0
#define RP23XX_M33_MPU_TYPE_SEPARATE_ACCESS "RO"

#define RP23XX_M33_MPU_CTRL_OFFSET 0x0000ed94
#define RP23XX_M33_MPU_CTRL_BITS   0x00000007
#define RP23XX_M33_MPU_CTRL_RESET  0x00000000

#define RP23XX_M33_MPU_CTRL_PRIVDEFENA_RESET  0x0
#define RP23XX_M33_MPU_CTRL_PRIVDEFENA_BITS   0x00000004
#define RP23XX_M33_MPU_CTRL_PRIVDEFENA_MSB    2
#define RP23XX_M33_MPU_CTRL_PRIVDEFENA_LSB    2
#define RP23XX_M33_MPU_CTRL_PRIVDEFENA_ACCESS "RW"

#define RP23XX_M33_MPU_CTRL_HFNMIENA_RESET  0x0
#define RP23XX_M33_MPU_CTRL_HFNMIENA_BITS   0x00000002
#define RP23XX_M33_MPU_CTRL_HFNMIENA_MSB    1
#define RP23XX_M33_MPU_CTRL_HFNMIENA_LSB    1
#define RP23XX_M33_MPU_CTRL_HFNMIENA_ACCESS "RW"

#define RP23XX_M33_MPU_CTRL_ENABLE_RESET  0x0
#define RP23XX_M33_MPU_CTRL_ENABLE_BITS   0x00000001
#define RP23XX_M33_MPU_CTRL_ENABLE_MSB    0
#define RP23XX_M33_MPU_CTRL_ENABLE_LSB    0
#define RP23XX_M33_MPU_CTRL_ENABLE_ACCESS "RW"

#define RP23XX_M33_MPU_RNR_OFFSET 0x0000ed98
#define RP23XX_M33_MPU_RNR_BITS   0x00000007
#define RP23XX_M33_MPU_RNR_RESET  0x00000000

#define RP23XX_M33_MPU_RNR_REGION_RESET  0x0
#define RP23XX_M33_MPU_RNR_REGION_BITS   0x00000007
#define RP23XX_M33_MPU_RNR_REGION_MSB    2
#define RP23XX_M33_MPU_RNR_REGION_LSB    0
#define RP23XX_M33_MPU_RNR_REGION_ACCESS "RW"

#define RP23XX_M33_MPU_RBAR_OFFSET 0x0000ed9c
#define RP23XX_M33_MPU_RBAR_BITS   0xffffffff
#define RP23XX_M33_MPU_RBAR_RESET  0x00000000

#define RP23XX_M33_MPU_RBAR_BASE_RESET  0x0000000
#define RP23XX_M33_MPU_RBAR_BASE_BITS   0xffffffe0
#define RP23XX_M33_MPU_RBAR_BASE_MSB    31
#define RP23XX_M33_MPU_RBAR_BASE_LSB    5
#define RP23XX_M33_MPU_RBAR_BASE_ACCESS "RW"

#define RP23XX_M33_MPU_RBAR_SH_RESET  0x0
#define RP23XX_M33_MPU_RBAR_SH_BITS   0x00000018
#define RP23XX_M33_MPU_RBAR_SH_MSB    4
#define RP23XX_M33_MPU_RBAR_SH_LSB    3
#define RP23XX_M33_MPU_RBAR_SH_ACCESS "RW"

#define RP23XX_M33_MPU_RBAR_AP_RESET  0x0
#define RP23XX_M33_MPU_RBAR_AP_BITS   0x00000006
#define RP23XX_M33_MPU_RBAR_AP_MSB    2
#define RP23XX_M33_MPU_RBAR_AP_LSB    1
#define RP23XX_M33_MPU_RBAR_AP_ACCESS "RW"

#define RP23XX_M33_MPU_RBAR_XN_RESET  0x0
#define RP23XX_M33_MPU_RBAR_XN_BITS   0x00000001
#define RP23XX_M33_MPU_RBAR_XN_MSB    0
#define RP23XX_M33_MPU_RBAR_XN_LSB    0
#define RP23XX_M33_MPU_RBAR_XN_ACCESS "RW"

#define RP23XX_M33_MPU_RLAR_OFFSET 0x0000eda0
#define RP23XX_M33_MPU_RLAR_BITS   0xffffffef
#define RP23XX_M33_MPU_RLAR_RESET  0x00000000

#define RP23XX_M33_MPU_RLAR_LIMIT_RESET  0x0000000
#define RP23XX_M33_MPU_RLAR_LIMIT_BITS   0xffffffe0
#define RP23XX_M33_MPU_RLAR_LIMIT_MSB    31
#define RP23XX_M33_MPU_RLAR_LIMIT_LSB    5
#define RP23XX_M33_MPU_RLAR_LIMIT_ACCESS "RW"

#define RP23XX_M33_MPU_RLAR_ATTRINDX_RESET  0x0
#define RP23XX_M33_MPU_RLAR_ATTRINDX_BITS   0x0000000e
#define RP23XX_M33_MPU_RLAR_ATTRINDX_MSB    3
#define RP23XX_M33_MPU_RLAR_ATTRINDX_LSB    1
#define RP23XX_M33_MPU_RLAR_ATTRINDX_ACCESS "RW"

#define RP23XX_M33_MPU_RLAR_EN_RESET  0x0
#define RP23XX_M33_MPU_RLAR_EN_BITS   0x00000001
#define RP23XX_M33_MPU_RLAR_EN_MSB    0
#define RP23XX_M33_MPU_RLAR_EN_LSB    0
#define RP23XX_M33_MPU_RLAR_EN_ACCESS "RW"

#define RP23XX_M33_MPU_RBAR_A1_OFFSET 0x0000eda4
#define RP23XX_M33_MPU_RBAR_A1_BITS   0xffffffff
#define RP23XX_M33_MPU_RBAR_A1_RESET  0x00000000

#define RP23XX_M33_MPU_RBAR_A1_BASE_RESET  0x0000000
#define RP23XX_M33_MPU_RBAR_A1_BASE_BITS   0xffffffe0
#define RP23XX_M33_MPU_RBAR_A1_BASE_MSB    31
#define RP23XX_M33_MPU_RBAR_A1_BASE_LSB    5
#define RP23XX_M33_MPU_RBAR_A1_BASE_ACCESS "RW"

#define RP23XX_M33_MPU_RBAR_A1_SH_RESET  0x0
#define RP23XX_M33_MPU_RBAR_A1_SH_BITS   0x00000018
#define RP23XX_M33_MPU_RBAR_A1_SH_MSB    4
#define RP23XX_M33_MPU_RBAR_A1_SH_LSB    3
#define RP23XX_M33_MPU_RBAR_A1_SH_ACCESS "RW"

#define RP23XX_M33_MPU_RBAR_A1_AP_RESET  0x0
#define RP23XX_M33_MPU_RBAR_A1_AP_BITS   0x00000006
#define RP23XX_M33_MPU_RBAR_A1_AP_MSB    2
#define RP23XX_M33_MPU_RBAR_A1_AP_LSB    1
#define RP23XX_M33_MPU_RBAR_A1_AP_ACCESS "RW"

#define RP23XX_M33_MPU_RBAR_A1_XN_RESET  0x0
#define RP23XX_M33_MPU_RBAR_A1_XN_BITS   0x00000001
#define RP23XX_M33_MPU_RBAR_A1_XN_MSB    0
#define RP23XX_M33_MPU_RBAR_A1_XN_LSB    0
#define RP23XX_M33_MPU_RBAR_A1_XN_ACCESS "RW"

#define RP23XX_M33_MPU_RLAR_A1_OFFSET 0x0000eda8
#define RP23XX_M33_MPU_RLAR_A1_BITS   0xffffffef
#define RP23XX_M33_MPU_RLAR_A1_RESET  0x00000000

#define RP23XX_M33_MPU_RLAR_A1_LIMIT_RESET  0x0000000
#define RP23XX_M33_MPU_RLAR_A1_LIMIT_BITS   0xffffffe0
#define RP23XX_M33_MPU_RLAR_A1_LIMIT_MSB    31
#define RP23XX_M33_MPU_RLAR_A1_LIMIT_LSB    5
#define RP23XX_M33_MPU_RLAR_A1_LIMIT_ACCESS "RW"

#define RP23XX_M33_MPU_RLAR_A1_ATTRINDX_RESET  0x0
#define RP23XX_M33_MPU_RLAR_A1_ATTRINDX_BITS   0x0000000e
#define RP23XX_M33_MPU_RLAR_A1_ATTRINDX_MSB    3
#define RP23XX_M33_MPU_RLAR_A1_ATTRINDX_LSB    1
#define RP23XX_M33_MPU_RLAR_A1_ATTRINDX_ACCESS "RW"

#define RP23XX_M33_MPU_RLAR_A1_EN_RESET  0x0
#define RP23XX_M33_MPU_RLAR_A1_EN_BITS   0x00000001
#define RP23XX_M33_MPU_RLAR_A1_EN_MSB    0
#define RP23XX_M33_MPU_RLAR_A1_EN_LSB    0
#define RP23XX_M33_MPU_RLAR_A1_EN_ACCESS "RW"

#define RP23XX_M33_MPU_RBAR_A2_OFFSET 0x0000edac
#define RP23XX_M33_MPU_RBAR_A2_BITS   0xffffffff
#define RP23XX_M33_MPU_RBAR_A2_RESET  0x00000000

#define RP23XX_M33_MPU_RBAR_A2_BASE_RESET  0x0000000
#define RP23XX_M33_MPU_RBAR_A2_BASE_BITS   0xffffffe0
#define RP23XX_M33_MPU_RBAR_A2_BASE_MSB    31
#define RP23XX_M33_MPU_RBAR_A2_BASE_LSB    5
#define RP23XX_M33_MPU_RBAR_A2_BASE_ACCESS "RW"

#define RP23XX_M33_MPU_RBAR_A2_SH_RESET  0x0
#define RP23XX_M33_MPU_RBAR_A2_SH_BITS   0x00000018
#define RP23XX_M33_MPU_RBAR_A2_SH_MSB    4
#define RP23XX_M33_MPU_RBAR_A2_SH_LSB    3
#define RP23XX_M33_MPU_RBAR_A2_SH_ACCESS "RW"

#define RP23XX_M33_MPU_RBAR_A2_AP_RESET  0x0
#define RP23XX_M33_MPU_RBAR_A2_AP_BITS   0x00000006
#define RP23XX_M33_MPU_RBAR_A2_AP_MSB    2
#define RP23XX_M33_MPU_RBAR_A2_AP_LSB    1
#define RP23XX_M33_MPU_RBAR_A2_AP_ACCESS "RW"

#define RP23XX_M33_MPU_RBAR_A2_XN_RESET  0x0
#define RP23XX_M33_MPU_RBAR_A2_XN_BITS   0x00000001
#define RP23XX_M33_MPU_RBAR_A2_XN_MSB    0
#define RP23XX_M33_MPU_RBAR_A2_XN_LSB    0
#define RP23XX_M33_MPU_RBAR_A2_XN_ACCESS "RW"

#define RP23XX_M33_MPU_RLAR_A2_OFFSET 0x0000edb0
#define RP23XX_M33_MPU_RLAR_A2_BITS   0xffffffef
#define RP23XX_M33_MPU_RLAR_A2_RESET  0x00000000

#define RP23XX_M33_MPU_RLAR_A2_LIMIT_RESET  0x0000000
#define RP23XX_M33_MPU_RLAR_A2_LIMIT_BITS   0xffffffe0
#define RP23XX_M33_MPU_RLAR_A2_LIMIT_MSB    31
#define RP23XX_M33_MPU_RLAR_A2_LIMIT_LSB    5
#define RP23XX_M33_MPU_RLAR_A2_LIMIT_ACCESS "RW"

#define RP23XX_M33_MPU_RLAR_A2_ATTRINDX_RESET  0x0
#define RP23XX_M33_MPU_RLAR_A2_ATTRINDX_BITS   0x0000000e
#define RP23XX_M33_MPU_RLAR_A2_ATTRINDX_MSB    3
#define RP23XX_M33_MPU_RLAR_A2_ATTRINDX_LSB    1
#define RP23XX_M33_MPU_RLAR_A2_ATTRINDX_ACCESS "RW"

#define RP23XX_M33_MPU_RLAR_A2_EN_RESET  0x0
#define RP23XX_M33_MPU_RLAR_A2_EN_BITS   0x00000001
#define RP23XX_M33_MPU_RLAR_A2_EN_MSB    0
#define RP23XX_M33_MPU_RLAR_A2_EN_LSB    0
#define RP23XX_M33_MPU_RLAR_A2_EN_ACCESS "RW"

#define RP23XX_M33_MPU_RBAR_A3_OFFSET 0x0000edb4
#define RP23XX_M33_MPU_RBAR_A3_BITS   0xffffffff
#define RP23XX_M33_MPU_RBAR_A3_RESET  0x00000000

#define RP23XX_M33_MPU_RBAR_A3_BASE_RESET  0x0000000
#define RP23XX_M33_MPU_RBAR_A3_BASE_BITS   0xffffffe0
#define RP23XX_M33_MPU_RBAR_A3_BASE_MSB    31
#define RP23XX_M33_MPU_RBAR_A3_BASE_LSB    5
#define RP23XX_M33_MPU_RBAR_A3_BASE_ACCESS "RW"

#define RP23XX_M33_MPU_RBAR_A3_SH_RESET  0x0
#define RP23XX_M33_MPU_RBAR_A3_SH_BITS   0x00000018
#define RP23XX_M33_MPU_RBAR_A3_SH_MSB    4
#define RP23XX_M33_MPU_RBAR_A3_SH_LSB    3
#define RP23XX_M33_MPU_RBAR_A3_SH_ACCESS "RW"

#define RP23XX_M33_MPU_RBAR_A3_AP_RESET  0x0
#define RP23XX_M33_MPU_RBAR_A3_AP_BITS   0x00000006
#define RP23XX_M33_MPU_RBAR_A3_AP_MSB    2
#define RP23XX_M33_MPU_RBAR_A3_AP_LSB    1
#define RP23XX_M33_MPU_RBAR_A3_AP_ACCESS "RW"

#define RP23XX_M33_MPU_RBAR_A3_XN_RESET  0x0
#define RP23XX_M33_MPU_RBAR_A3_XN_BITS   0x00000001
#define RP23XX_M33_MPU_RBAR_A3_XN_MSB    0
#define RP23XX_M33_MPU_RBAR_A3_XN_LSB    0
#define RP23XX_M33_MPU_RBAR_A3_XN_ACCESS "RW"

#define RP23XX_M33_MPU_RLAR_A3_OFFSET 0x0000edb8
#define RP23XX_M33_MPU_RLAR_A3_BITS   0xffffffef
#define RP23XX_M33_MPU_RLAR_A3_RESET  0x00000000

#define RP23XX_M33_MPU_RLAR_A3_LIMIT_RESET  0x0000000
#define RP23XX_M33_MPU_RLAR_A3_LIMIT_BITS   0xffffffe0
#define RP23XX_M33_MPU_RLAR_A3_LIMIT_MSB    31
#define RP23XX_M33_MPU_RLAR_A3_LIMIT_LSB    5
#define RP23XX_M33_MPU_RLAR_A3_LIMIT_ACCESS "RW"

#define RP23XX_M33_MPU_RLAR_A3_ATTRINDX_RESET  0x0
#define RP23XX_M33_MPU_RLAR_A3_ATTRINDX_BITS   0x0000000e
#define RP23XX_M33_MPU_RLAR_A3_ATTRINDX_MSB    3
#define RP23XX_M33_MPU_RLAR_A3_ATTRINDX_LSB    1
#define RP23XX_M33_MPU_RLAR_A3_ATTRINDX_ACCESS "RW"

#define RP23XX_M33_MPU_RLAR_A3_EN_RESET  0x0
#define RP23XX_M33_MPU_RLAR_A3_EN_BITS   0x00000001
#define RP23XX_M33_MPU_RLAR_A3_EN_MSB    0
#define RP23XX_M33_MPU_RLAR_A3_EN_LSB    0
#define RP23XX_M33_MPU_RLAR_A3_EN_ACCESS "RW"

#define RP23XX_M33_MPU_MAIR0_OFFSET 0x0000edc0
#define RP23XX_M33_MPU_MAIR0_BITS   0xffffffff
#define RP23XX_M33_MPU_MAIR0_RESET  0x00000000

#define RP23XX_M33_MPU_MAIR0_ATTR3_RESET  0x00
#define RP23XX_M33_MPU_MAIR0_ATTR3_BITS   0xff000000
#define RP23XX_M33_MPU_MAIR0_ATTR3_MSB    31
#define RP23XX_M33_MPU_MAIR0_ATTR3_LSB    24
#define RP23XX_M33_MPU_MAIR0_ATTR3_ACCESS "RW"

#define RP23XX_M33_MPU_MAIR0_ATTR2_RESET  0x00
#define RP23XX_M33_MPU_MAIR0_ATTR2_BITS   0x00ff0000
#define RP23XX_M33_MPU_MAIR0_ATTR2_MSB    23
#define RP23XX_M33_MPU_MAIR0_ATTR2_LSB    16
#define RP23XX_M33_MPU_MAIR0_ATTR2_ACCESS "RW"

#define RP23XX_M33_MPU_MAIR0_ATTR1_RESET  0x00
#define RP23XX_M33_MPU_MAIR0_ATTR1_BITS   0x0000ff00
#define RP23XX_M33_MPU_MAIR0_ATTR1_MSB    15
#define RP23XX_M33_MPU_MAIR0_ATTR1_LSB    8
#define RP23XX_M33_MPU_MAIR0_ATTR1_ACCESS "RW"

#define RP23XX_M33_MPU_MAIR0_ATTR0_RESET  0x00
#define RP23XX_M33_MPU_MAIR0_ATTR0_BITS   0x000000ff
#define RP23XX_M33_MPU_MAIR0_ATTR0_MSB    7
#define RP23XX_M33_MPU_MAIR0_ATTR0_LSB    0
#define RP23XX_M33_MPU_MAIR0_ATTR0_ACCESS "RW"

#define RP23XX_M33_MPU_MAIR1_OFFSET 0x0000edc4
#define RP23XX_M33_MPU_MAIR1_BITS   0xffffffff
#define RP23XX_M33_MPU_MAIR1_RESET  0x00000000

#define RP23XX_M33_MPU_MAIR1_ATTR7_RESET  0x00
#define RP23XX_M33_MPU_MAIR1_ATTR7_BITS   0xff000000
#define RP23XX_M33_MPU_MAIR1_ATTR7_MSB    31
#define RP23XX_M33_MPU_MAIR1_ATTR7_LSB    24
#define RP23XX_M33_MPU_MAIR1_ATTR7_ACCESS "RW"

#define RP23XX_M33_MPU_MAIR1_ATTR6_RESET  0x00
#define RP23XX_M33_MPU_MAIR1_ATTR6_BITS   0x00ff0000
#define RP23XX_M33_MPU_MAIR1_ATTR6_MSB    23
#define RP23XX_M33_MPU_MAIR1_ATTR6_LSB    16
#define RP23XX_M33_MPU_MAIR1_ATTR6_ACCESS "RW"

#define RP23XX_M33_MPU_MAIR1_ATTR5_RESET  0x00
#define RP23XX_M33_MPU_MAIR1_ATTR5_BITS   0x0000ff00
#define RP23XX_M33_MPU_MAIR1_ATTR5_MSB    15
#define RP23XX_M33_MPU_MAIR1_ATTR5_LSB    8
#define RP23XX_M33_MPU_MAIR1_ATTR5_ACCESS "RW"

#define RP23XX_M33_MPU_MAIR1_ATTR4_RESET  0x00
#define RP23XX_M33_MPU_MAIR1_ATTR4_BITS   0x000000ff
#define RP23XX_M33_MPU_MAIR1_ATTR4_MSB    7
#define RP23XX_M33_MPU_MAIR1_ATTR4_LSB    0
#define RP23XX_M33_MPU_MAIR1_ATTR4_ACCESS "RW"

#define RP23XX_M33_SAU_CTRL_OFFSET 0x0000edd0
#define RP23XX_M33_SAU_CTRL_BITS   0x00000003
#define RP23XX_M33_SAU_CTRL_RESET  0x00000000

#define RP23XX_M33_SAU_CTRL_ALLNS_RESET  0x0
#define RP23XX_M33_SAU_CTRL_ALLNS_BITS   0x00000002
#define RP23XX_M33_SAU_CTRL_ALLNS_MSB    1
#define RP23XX_M33_SAU_CTRL_ALLNS_LSB    1
#define RP23XX_M33_SAU_CTRL_ALLNS_ACCESS "RW"

#define RP23XX_M33_SAU_CTRL_ENABLE_RESET  0x0
#define RP23XX_M33_SAU_CTRL_ENABLE_BITS   0x00000001
#define RP23XX_M33_SAU_CTRL_ENABLE_MSB    0
#define RP23XX_M33_SAU_CTRL_ENABLE_LSB    0
#define RP23XX_M33_SAU_CTRL_ENABLE_ACCESS "RW"

#define RP23XX_M33_SAU_TYPE_OFFSET 0x0000edd4
#define RP23XX_M33_SAU_TYPE_BITS   0x000000ff
#define RP23XX_M33_SAU_TYPE_RESET  0x00000008

#define RP23XX_M33_SAU_TYPE_SREGION_RESET  0x08
#define RP23XX_M33_SAU_TYPE_SREGION_BITS   0x000000ff
#define RP23XX_M33_SAU_TYPE_SREGION_MSB    7
#define RP23XX_M33_SAU_TYPE_SREGION_LSB    0
#define RP23XX_M33_SAU_TYPE_SREGION_ACCESS "RO"

#define RP23XX_M33_SAU_RNR_OFFSET 0x0000edd8
#define RP23XX_M33_SAU_RNR_BITS   0x000000ff
#define RP23XX_M33_SAU_RNR_RESET  0x00000000

#define RP23XX_M33_SAU_RNR_REGION_RESET  0x00
#define RP23XX_M33_SAU_RNR_REGION_BITS   0x000000ff
#define RP23XX_M33_SAU_RNR_REGION_MSB    7
#define RP23XX_M33_SAU_RNR_REGION_LSB    0
#define RP23XX_M33_SAU_RNR_REGION_ACCESS "RW"

#define RP23XX_M33_SAU_RBAR_OFFSET 0x0000eddc
#define RP23XX_M33_SAU_RBAR_BITS   0xffffffe0
#define RP23XX_M33_SAU_RBAR_RESET  0x00000000

#define RP23XX_M33_SAU_RBAR_BADDR_RESET  0x0000000
#define RP23XX_M33_SAU_RBAR_BADDR_BITS   0xffffffe0
#define RP23XX_M33_SAU_RBAR_BADDR_MSB    31
#define RP23XX_M33_SAU_RBAR_BADDR_LSB    5
#define RP23XX_M33_SAU_RBAR_BADDR_ACCESS "RW"

#define RP23XX_M33_SAU_RLAR_OFFSET 0x0000ede0
#define RP23XX_M33_SAU_RLAR_BITS   0xffffffe3
#define RP23XX_M33_SAU_RLAR_RESET  0x00000000

#define RP23XX_M33_SAU_RLAR_LADDR_RESET  0x0000000
#define RP23XX_M33_SAU_RLAR_LADDR_BITS   0xffffffe0
#define RP23XX_M33_SAU_RLAR_LADDR_MSB    31
#define RP23XX_M33_SAU_RLAR_LADDR_LSB    5
#define RP23XX_M33_SAU_RLAR_LADDR_ACCESS "RW"

#define RP23XX_M33_SAU_RLAR_NSC_RESET  0x0
#define RP23XX_M33_SAU_RLAR_NSC_BITS   0x00000002
#define RP23XX_M33_SAU_RLAR_NSC_MSB    1
#define RP23XX_M33_SAU_RLAR_NSC_LSB    1
#define RP23XX_M33_SAU_RLAR_NSC_ACCESS "RW"

#define RP23XX_M33_SAU_RLAR_ENABLE_RESET  0x0
#define RP23XX_M33_SAU_RLAR_ENABLE_BITS   0x00000001
#define RP23XX_M33_SAU_RLAR_ENABLE_MSB    0
#define RP23XX_M33_SAU_RLAR_ENABLE_LSB    0
#define RP23XX_M33_SAU_RLAR_ENABLE_ACCESS "RW"

#define RP23XX_M33_SFSR_OFFSET 0x0000ede4
#define RP23XX_M33_SFSR_BITS   0x000000ff
#define RP23XX_M33_SFSR_RESET  0x00000000

#define RP23XX_M33_SFSR_LSERR_RESET  0x0
#define RP23XX_M33_SFSR_LSERR_BITS   0x00000080
#define RP23XX_M33_SFSR_LSERR_MSB    7
#define RP23XX_M33_SFSR_LSERR_LSB    7
#define RP23XX_M33_SFSR_LSERR_ACCESS "RW"

#define RP23XX_M33_SFSR_SFARVALID_RESET  0x0
#define RP23XX_M33_SFSR_SFARVALID_BITS   0x00000040
#define RP23XX_M33_SFSR_SFARVALID_MSB    6
#define RP23XX_M33_SFSR_SFARVALID_LSB    6
#define RP23XX_M33_SFSR_SFARVALID_ACCESS "RW"

#define RP23XX_M33_SFSR_LSPERR_RESET  0x0
#define RP23XX_M33_SFSR_LSPERR_BITS   0x00000020
#define RP23XX_M33_SFSR_LSPERR_MSB    5
#define RP23XX_M33_SFSR_LSPERR_LSB    5
#define RP23XX_M33_SFSR_LSPERR_ACCESS "RW"

#define RP23XX_M33_SFSR_INVTRAN_RESET  0x0
#define RP23XX_M33_SFSR_INVTRAN_BITS   0x00000010
#define RP23XX_M33_SFSR_INVTRAN_MSB    4
#define RP23XX_M33_SFSR_INVTRAN_LSB    4
#define RP23XX_M33_SFSR_INVTRAN_ACCESS "RW"

#define RP23XX_M33_SFSR_AUVIOL_RESET  0x0
#define RP23XX_M33_SFSR_AUVIOL_BITS   0x00000008
#define RP23XX_M33_SFSR_AUVIOL_MSB    3
#define RP23XX_M33_SFSR_AUVIOL_LSB    3
#define RP23XX_M33_SFSR_AUVIOL_ACCESS "RW"

#define RP23XX_M33_SFSR_INVER_RESET  0x0
#define RP23XX_M33_SFSR_INVER_BITS   0x00000004
#define RP23XX_M33_SFSR_INVER_MSB    2
#define RP23XX_M33_SFSR_INVER_LSB    2
#define RP23XX_M33_SFSR_INVER_ACCESS "RW"

#define RP23XX_M33_SFSR_INVIS_RESET  0x0
#define RP23XX_M33_SFSR_INVIS_BITS   0x00000002
#define RP23XX_M33_SFSR_INVIS_MSB    1
#define RP23XX_M33_SFSR_INVIS_LSB    1
#define RP23XX_M33_SFSR_INVIS_ACCESS "RW"

#define RP23XX_M33_SFSR_INVEP_RESET  0x0
#define RP23XX_M33_SFSR_INVEP_BITS   0x00000001
#define RP23XX_M33_SFSR_INVEP_MSB    0
#define RP23XX_M33_SFSR_INVEP_LSB    0
#define RP23XX_M33_SFSR_INVEP_ACCESS "RW"

#define RP23XX_M33_SFAR_OFFSET 0x0000ede8
#define RP23XX_M33_SFAR_BITS   0xffffffff
#define RP23XX_M33_SFAR_RESET  0x00000000

#define RP23XX_M33_SFAR_ADDRESS_RESET  0x00000000
#define RP23XX_M33_SFAR_ADDRESS_BITS   0xffffffff
#define RP23XX_M33_SFAR_ADDRESS_MSB    31
#define RP23XX_M33_SFAR_ADDRESS_LSB    0
#define RP23XX_M33_SFAR_ADDRESS_ACCESS "RW"

#define RP23XX_M33_DHCSR_OFFSET 0x0000edf0
#define RP23XX_M33_DHCSR_BITS   0x071f002f
#define RP23XX_M33_DHCSR_RESET  0x00000000

#define RP23XX_M33_DHCSR_S_RESTART_ST_RESET  0x0
#define RP23XX_M33_DHCSR_S_RESTART_ST_BITS   0x04000000
#define RP23XX_M33_DHCSR_S_RESTART_ST_MSB    26
#define RP23XX_M33_DHCSR_S_RESTART_ST_LSB    26
#define RP23XX_M33_DHCSR_S_RESTART_ST_ACCESS "RO"

#define RP23XX_M33_DHCSR_S_RESET_ST_RESET  0x0
#define RP23XX_M33_DHCSR_S_RESET_ST_BITS   0x02000000
#define RP23XX_M33_DHCSR_S_RESET_ST_MSB    25
#define RP23XX_M33_DHCSR_S_RESET_ST_LSB    25
#define RP23XX_M33_DHCSR_S_RESET_ST_ACCESS "RO"

#define RP23XX_M33_DHCSR_S_RETIRE_ST_RESET  0x0
#define RP23XX_M33_DHCSR_S_RETIRE_ST_BITS   0x01000000
#define RP23XX_M33_DHCSR_S_RETIRE_ST_MSB    24
#define RP23XX_M33_DHCSR_S_RETIRE_ST_LSB    24
#define RP23XX_M33_DHCSR_S_RETIRE_ST_ACCESS "RO"

#define RP23XX_M33_DHCSR_S_SDE_RESET  0x0
#define RP23XX_M33_DHCSR_S_SDE_BITS   0x00100000
#define RP23XX_M33_DHCSR_S_SDE_MSB    20
#define RP23XX_M33_DHCSR_S_SDE_LSB    20
#define RP23XX_M33_DHCSR_S_SDE_ACCESS "RO"

#define RP23XX_M33_DHCSR_S_LOCKUP_RESET  0x0
#define RP23XX_M33_DHCSR_S_LOCKUP_BITS   0x00080000
#define RP23XX_M33_DHCSR_S_LOCKUP_MSB    19
#define RP23XX_M33_DHCSR_S_LOCKUP_LSB    19
#define RP23XX_M33_DHCSR_S_LOCKUP_ACCESS "RO"

#define RP23XX_M33_DHCSR_S_SLEEP_RESET  0x0
#define RP23XX_M33_DHCSR_S_SLEEP_BITS   0x00040000
#define RP23XX_M33_DHCSR_S_SLEEP_MSB    18
#define RP23XX_M33_DHCSR_S_SLEEP_LSB    18
#define RP23XX_M33_DHCSR_S_SLEEP_ACCESS "RO"

#define RP23XX_M33_DHCSR_S_HALT_RESET  0x0
#define RP23XX_M33_DHCSR_S_HALT_BITS   0x00020000
#define RP23XX_M33_DHCSR_S_HALT_MSB    17
#define RP23XX_M33_DHCSR_S_HALT_LSB    17
#define RP23XX_M33_DHCSR_S_HALT_ACCESS "RO"

#define RP23XX_M33_DHCSR_S_REGRDY_RESET  0x0
#define RP23XX_M33_DHCSR_S_REGRDY_BITS   0x00010000
#define RP23XX_M33_DHCSR_S_REGRDY_MSB    16
#define RP23XX_M33_DHCSR_S_REGRDY_LSB    16
#define RP23XX_M33_DHCSR_S_REGRDY_ACCESS "RO"

#define RP23XX_M33_DHCSR_C_SNAPSTALL_RESET  0x0
#define RP23XX_M33_DHCSR_C_SNAPSTALL_BITS   0x00000020
#define RP23XX_M33_DHCSR_C_SNAPSTALL_MSB    5
#define RP23XX_M33_DHCSR_C_SNAPSTALL_LSB    5
#define RP23XX_M33_DHCSR_C_SNAPSTALL_ACCESS "RW"

#define RP23XX_M33_DHCSR_C_MASKINTS_RESET  0x0
#define RP23XX_M33_DHCSR_C_MASKINTS_BITS   0x00000008
#define RP23XX_M33_DHCSR_C_MASKINTS_MSB    3
#define RP23XX_M33_DHCSR_C_MASKINTS_LSB    3
#define RP23XX_M33_DHCSR_C_MASKINTS_ACCESS "RW"

#define RP23XX_M33_DHCSR_C_STEP_RESET  0x0
#define RP23XX_M33_DHCSR_C_STEP_BITS   0x00000004
#define RP23XX_M33_DHCSR_C_STEP_MSB    2
#define RP23XX_M33_DHCSR_C_STEP_LSB    2
#define RP23XX_M33_DHCSR_C_STEP_ACCESS "RW"

#define RP23XX_M33_DHCSR_C_HALT_RESET  0x0
#define RP23XX_M33_DHCSR_C_HALT_BITS   0x00000002
#define RP23XX_M33_DHCSR_C_HALT_MSB    1
#define RP23XX_M33_DHCSR_C_HALT_LSB    1
#define RP23XX_M33_DHCSR_C_HALT_ACCESS "RW"

#define RP23XX_M33_DHCSR_C_DEBUGEN_RESET  0x0
#define RP23XX_M33_DHCSR_C_DEBUGEN_BITS   0x00000001
#define RP23XX_M33_DHCSR_C_DEBUGEN_MSB    0
#define RP23XX_M33_DHCSR_C_DEBUGEN_LSB    0
#define RP23XX_M33_DHCSR_C_DEBUGEN_ACCESS "RW"

#define RP23XX_M33_DCRSR_OFFSET 0x0000edf4
#define RP23XX_M33_DCRSR_BITS   0x0001007f
#define RP23XX_M33_DCRSR_RESET  0x00000000

#define RP23XX_M33_DCRSR_REGWNR_RESET  0x0
#define RP23XX_M33_DCRSR_REGWNR_BITS   0x00010000
#define RP23XX_M33_DCRSR_REGWNR_MSB    16
#define RP23XX_M33_DCRSR_REGWNR_LSB    16
#define RP23XX_M33_DCRSR_REGWNR_ACCESS "RW"

#define RP23XX_M33_DCRSR_REGSEL_RESET  0x00
#define RP23XX_M33_DCRSR_REGSEL_BITS   0x0000007f
#define RP23XX_M33_DCRSR_REGSEL_MSB    6
#define RP23XX_M33_DCRSR_REGSEL_LSB    0
#define RP23XX_M33_DCRSR_REGSEL_ACCESS "RW"

#define RP23XX_M33_DCRDR_OFFSET 0x0000edf8
#define RP23XX_M33_DCRDR_BITS   0xffffffff
#define RP23XX_M33_DCRDR_RESET  0x00000000

#define RP23XX_M33_DCRDR_DBGTMP_RESET  0x00000000
#define RP23XX_M33_DCRDR_DBGTMP_BITS   0xffffffff
#define RP23XX_M33_DCRDR_DBGTMP_MSB    31
#define RP23XX_M33_DCRDR_DBGTMP_LSB    0
#define RP23XX_M33_DCRDR_DBGTMP_ACCESS "RW"

#define RP23XX_M33_DEMCR_OFFSET 0x0000edfc
#define RP23XX_M33_DEMCR_BITS   0x011f0ff1
#define RP23XX_M33_DEMCR_RESET  0x00000000

#define RP23XX_M33_DEMCR_TRCENA_RESET  0x0
#define RP23XX_M33_DEMCR_TRCENA_BITS   0x01000000
#define RP23XX_M33_DEMCR_TRCENA_MSB    24
#define RP23XX_M33_DEMCR_TRCENA_LSB    24
#define RP23XX_M33_DEMCR_TRCENA_ACCESS "RW"

#define RP23XX_M33_DEMCR_SDME_RESET  0x0
#define RP23XX_M33_DEMCR_SDME_BITS   0x00100000
#define RP23XX_M33_DEMCR_SDME_MSB    20
#define RP23XX_M33_DEMCR_SDME_LSB    20
#define RP23XX_M33_DEMCR_SDME_ACCESS "RO"

#define RP23XX_M33_DEMCR_MON_REQ_RESET  0x0
#define RP23XX_M33_DEMCR_MON_REQ_BITS   0x00080000
#define RP23XX_M33_DEMCR_MON_REQ_MSB    19
#define RP23XX_M33_DEMCR_MON_REQ_LSB    19
#define RP23XX_M33_DEMCR_MON_REQ_ACCESS "RW"

#define RP23XX_M33_DEMCR_MON_STEP_RESET  0x0
#define RP23XX_M33_DEMCR_MON_STEP_BITS   0x00040000
#define RP23XX_M33_DEMCR_MON_STEP_MSB    18
#define RP23XX_M33_DEMCR_MON_STEP_LSB    18
#define RP23XX_M33_DEMCR_MON_STEP_ACCESS "RW"

#define RP23XX_M33_DEMCR_MON_PEND_RESET  0x0
#define RP23XX_M33_DEMCR_MON_PEND_BITS   0x00020000
#define RP23XX_M33_DEMCR_MON_PEND_MSB    17
#define RP23XX_M33_DEMCR_MON_PEND_LSB    17
#define RP23XX_M33_DEMCR_MON_PEND_ACCESS "RW"

#define RP23XX_M33_DEMCR_MON_EN_RESET  0x0
#define RP23XX_M33_DEMCR_MON_EN_BITS   0x00010000
#define RP23XX_M33_DEMCR_MON_EN_MSB    16
#define RP23XX_M33_DEMCR_MON_EN_LSB    16
#define RP23XX_M33_DEMCR_MON_EN_ACCESS "RW"

#define RP23XX_M33_DEMCR_VC_SFERR_RESET  0x0
#define RP23XX_M33_DEMCR_VC_SFERR_BITS   0x00000800
#define RP23XX_M33_DEMCR_VC_SFERR_MSB    11
#define RP23XX_M33_DEMCR_VC_SFERR_LSB    11
#define RP23XX_M33_DEMCR_VC_SFERR_ACCESS "RW"

#define RP23XX_M33_DEMCR_VC_HARDERR_RESET  0x0
#define RP23XX_M33_DEMCR_VC_HARDERR_BITS   0x00000400
#define RP23XX_M33_DEMCR_VC_HARDERR_MSB    10
#define RP23XX_M33_DEMCR_VC_HARDERR_LSB    10
#define RP23XX_M33_DEMCR_VC_HARDERR_ACCESS "RW"

#define RP23XX_M33_DEMCR_VC_INTERR_RESET  0x0
#define RP23XX_M33_DEMCR_VC_INTERR_BITS   0x00000200
#define RP23XX_M33_DEMCR_VC_INTERR_MSB    9
#define RP23XX_M33_DEMCR_VC_INTERR_LSB    9
#define RP23XX_M33_DEMCR_VC_INTERR_ACCESS "RW"

#define RP23XX_M33_DEMCR_VC_BUSERR_RESET  0x0
#define RP23XX_M33_DEMCR_VC_BUSERR_BITS   0x00000100
#define RP23XX_M33_DEMCR_VC_BUSERR_MSB    8
#define RP23XX_M33_DEMCR_VC_BUSERR_LSB    8
#define RP23XX_M33_DEMCR_VC_BUSERR_ACCESS "RW"

#define RP23XX_M33_DEMCR_VC_STATERR_RESET  0x0
#define RP23XX_M33_DEMCR_VC_STATERR_BITS   0x00000080
#define RP23XX_M33_DEMCR_VC_STATERR_MSB    7
#define RP23XX_M33_DEMCR_VC_STATERR_LSB    7
#define RP23XX_M33_DEMCR_VC_STATERR_ACCESS "RW"

#define RP23XX_M33_DEMCR_VC_CHKERR_RESET  0x0
#define RP23XX_M33_DEMCR_VC_CHKERR_BITS   0x00000040
#define RP23XX_M33_DEMCR_VC_CHKERR_MSB    6
#define RP23XX_M33_DEMCR_VC_CHKERR_LSB    6
#define RP23XX_M33_DEMCR_VC_CHKERR_ACCESS "RW"

#define RP23XX_M33_DEMCR_VC_NOCPERR_RESET  0x0
#define RP23XX_M33_DEMCR_VC_NOCPERR_BITS   0x00000020
#define RP23XX_M33_DEMCR_VC_NOCPERR_MSB    5
#define RP23XX_M33_DEMCR_VC_NOCPERR_LSB    5
#define RP23XX_M33_DEMCR_VC_NOCPERR_ACCESS "RW"

#define RP23XX_M33_DEMCR_VC_MMERR_RESET  0x0
#define RP23XX_M33_DEMCR_VC_MMERR_BITS   0x00000010
#define RP23XX_M33_DEMCR_VC_MMERR_MSB    4
#define RP23XX_M33_DEMCR_VC_MMERR_LSB    4
#define RP23XX_M33_DEMCR_VC_MMERR_ACCESS "RW"

#define RP23XX_M33_DEMCR_VC_CORERESET_RESET  0x0
#define RP23XX_M33_DEMCR_VC_CORERESET_BITS   0x00000001
#define RP23XX_M33_DEMCR_VC_CORERESET_MSB    0
#define RP23XX_M33_DEMCR_VC_CORERESET_LSB    0
#define RP23XX_M33_DEMCR_VC_CORERESET_ACCESS "RW"

#define RP23XX_M33_DSCSR_OFFSET 0x0000ee08
#define RP23XX_M33_DSCSR_BITS   0x00030003
#define RP23XX_M33_DSCSR_RESET  0x00000000

#define RP23XX_M33_DSCSR_CDSKEY_RESET  0x0
#define RP23XX_M33_DSCSR_CDSKEY_BITS   0x00020000
#define RP23XX_M33_DSCSR_CDSKEY_MSB    17
#define RP23XX_M33_DSCSR_CDSKEY_LSB    17
#define RP23XX_M33_DSCSR_CDSKEY_ACCESS "RW"

#define RP23XX_M33_DSCSR_CDS_RESET  0x0
#define RP23XX_M33_DSCSR_CDS_BITS   0x00010000
#define RP23XX_M33_DSCSR_CDS_MSB    16
#define RP23XX_M33_DSCSR_CDS_LSB    16
#define RP23XX_M33_DSCSR_CDS_ACCESS "RW"

#define RP23XX_M33_DSCSR_SBRSEL_RESET  0x0
#define RP23XX_M33_DSCSR_SBRSEL_BITS   0x00000002
#define RP23XX_M33_DSCSR_SBRSEL_MSB    1
#define RP23XX_M33_DSCSR_SBRSEL_LSB    1
#define RP23XX_M33_DSCSR_SBRSEL_ACCESS "RW"

#define RP23XX_M33_DSCSR_SBRSELEN_RESET  0x0
#define RP23XX_M33_DSCSR_SBRSELEN_BITS   0x00000001
#define RP23XX_M33_DSCSR_SBRSELEN_MSB    0
#define RP23XX_M33_DSCSR_SBRSELEN_LSB    0
#define RP23XX_M33_DSCSR_SBRSELEN_ACCESS "RW"

#define RP23XX_M33_STIR_OFFSET 0x0000ef00
#define RP23XX_M33_STIR_BITS   0x000001ff
#define RP23XX_M33_STIR_RESET  0x00000000

#define RP23XX_M33_STIR_INTID_RESET  0x000
#define RP23XX_M33_STIR_INTID_BITS   0x000001ff
#define RP23XX_M33_STIR_INTID_MSB    8
#define RP23XX_M33_STIR_INTID_LSB    0
#define RP23XX_M33_STIR_INTID_ACCESS "RW"

#define RP23XX_M33_FPCCR_OFFSET 0x0000ef34
#define RP23XX_M33_FPCCR_BITS   0xfc0007ff
#define RP23XX_M33_FPCCR_RESET  0x20000472

#define RP23XX_M33_FPCCR_ASPEN_RESET  0x0
#define RP23XX_M33_FPCCR_ASPEN_BITS   0x80000000
#define RP23XX_M33_FPCCR_ASPEN_MSB    31
#define RP23XX_M33_FPCCR_ASPEN_LSB    31
#define RP23XX_M33_FPCCR_ASPEN_ACCESS "RW"

#define RP23XX_M33_FPCCR_LSPEN_RESET  0x0
#define RP23XX_M33_FPCCR_LSPEN_BITS   0x40000000
#define RP23XX_M33_FPCCR_LSPEN_MSB    30
#define RP23XX_M33_FPCCR_LSPEN_LSB    30
#define RP23XX_M33_FPCCR_LSPEN_ACCESS "RW"

#define RP23XX_M33_FPCCR_LSPENS_RESET  0x1
#define RP23XX_M33_FPCCR_LSPENS_BITS   0x20000000
#define RP23XX_M33_FPCCR_LSPENS_MSB    29
#define RP23XX_M33_FPCCR_LSPENS_LSB    29
#define RP23XX_M33_FPCCR_LSPENS_ACCESS "RW"

#define RP23XX_M33_FPCCR_CLRONRET_RESET  0x0
#define RP23XX_M33_FPCCR_CLRONRET_BITS   0x10000000
#define RP23XX_M33_FPCCR_CLRONRET_MSB    28
#define RP23XX_M33_FPCCR_CLRONRET_LSB    28
#define RP23XX_M33_FPCCR_CLRONRET_ACCESS "RW"

#define RP23XX_M33_FPCCR_CLRONRETS_RESET  0x0
#define RP23XX_M33_FPCCR_CLRONRETS_BITS   0x08000000
#define RP23XX_M33_FPCCR_CLRONRETS_MSB    27
#define RP23XX_M33_FPCCR_CLRONRETS_LSB    27
#define RP23XX_M33_FPCCR_CLRONRETS_ACCESS "RW"

#define RP23XX_M33_FPCCR_TS_RESET  0x0
#define RP23XX_M33_FPCCR_TS_BITS   0x04000000
#define RP23XX_M33_FPCCR_TS_MSB    26
#define RP23XX_M33_FPCCR_TS_LSB    26
#define RP23XX_M33_FPCCR_TS_ACCESS "RW"

#define RP23XX_M33_FPCCR_UFRDY_RESET  0x1
#define RP23XX_M33_FPCCR_UFRDY_BITS   0x00000400
#define RP23XX_M33_FPCCR_UFRDY_MSB    10
#define RP23XX_M33_FPCCR_UFRDY_LSB    10
#define RP23XX_M33_FPCCR_UFRDY_ACCESS "RW"

#define RP23XX_M33_FPCCR_SPLIMVIOL_RESET  0x0
#define RP23XX_M33_FPCCR_SPLIMVIOL_BITS   0x00000200
#define RP23XX_M33_FPCCR_SPLIMVIOL_MSB    9
#define RP23XX_M33_FPCCR_SPLIMVIOL_LSB    9
#define RP23XX_M33_FPCCR_SPLIMVIOL_ACCESS "RW"

#define RP23XX_M33_FPCCR_MONRDY_RESET  0x0
#define RP23XX_M33_FPCCR_MONRDY_BITS   0x00000100
#define RP23XX_M33_FPCCR_MONRDY_MSB    8
#define RP23XX_M33_FPCCR_MONRDY_LSB    8
#define RP23XX_M33_FPCCR_MONRDY_ACCESS "RW"

#define RP23XX_M33_FPCCR_SFRDY_RESET  0x0
#define RP23XX_M33_FPCCR_SFRDY_BITS   0x00000080
#define RP23XX_M33_FPCCR_SFRDY_MSB    7
#define RP23XX_M33_FPCCR_SFRDY_LSB    7
#define RP23XX_M33_FPCCR_SFRDY_ACCESS "RW"

#define RP23XX_M33_FPCCR_BFRDY_RESET  0x1
#define RP23XX_M33_FPCCR_BFRDY_BITS   0x00000040
#define RP23XX_M33_FPCCR_BFRDY_MSB    6
#define RP23XX_M33_FPCCR_BFRDY_LSB    6
#define RP23XX_M33_FPCCR_BFRDY_ACCESS "RW"

#define RP23XX_M33_FPCCR_MMRDY_RESET  0x1
#define RP23XX_M33_FPCCR_MMRDY_BITS   0x00000020
#define RP23XX_M33_FPCCR_MMRDY_MSB    5
#define RP23XX_M33_FPCCR_MMRDY_LSB    5
#define RP23XX_M33_FPCCR_MMRDY_ACCESS "RW"

#define RP23XX_M33_FPCCR_HFRDY_RESET  0x1
#define RP23XX_M33_FPCCR_HFRDY_BITS   0x00000010
#define RP23XX_M33_FPCCR_HFRDY_MSB    4
#define RP23XX_M33_FPCCR_HFRDY_LSB    4
#define RP23XX_M33_FPCCR_HFRDY_ACCESS "RW"

#define RP23XX_M33_FPCCR_THREAD_RESET  0x0
#define RP23XX_M33_FPCCR_THREAD_BITS   0x00000008
#define RP23XX_M33_FPCCR_THREAD_MSB    3
#define RP23XX_M33_FPCCR_THREAD_LSB    3
#define RP23XX_M33_FPCCR_THREAD_ACCESS "RW"

#define RP23XX_M33_FPCCR_S_RESET  0x0
#define RP23XX_M33_FPCCR_S_BITS   0x00000004
#define RP23XX_M33_FPCCR_S_MSB    2
#define RP23XX_M33_FPCCR_S_LSB    2
#define RP23XX_M33_FPCCR_S_ACCESS "RW"

#define RP23XX_M33_FPCCR_USER_RESET  0x1
#define RP23XX_M33_FPCCR_USER_BITS   0x00000002
#define RP23XX_M33_FPCCR_USER_MSB    1
#define RP23XX_M33_FPCCR_USER_LSB    1
#define RP23XX_M33_FPCCR_USER_ACCESS "RW"

#define RP23XX_M33_FPCCR_LSPACT_RESET  0x0
#define RP23XX_M33_FPCCR_LSPACT_BITS   0x00000001
#define RP23XX_M33_FPCCR_LSPACT_MSB    0
#define RP23XX_M33_FPCCR_LSPACT_LSB    0
#define RP23XX_M33_FPCCR_LSPACT_ACCESS "RW"

#define RP23XX_M33_FPCAR_OFFSET 0x0000ef38
#define RP23XX_M33_FPCAR_BITS   0xfffffff8
#define RP23XX_M33_FPCAR_RESET  0x00000000

#define RP23XX_M33_FPCAR_ADDRESS_RESET  0x00000000
#define RP23XX_M33_FPCAR_ADDRESS_BITS   0xfffffff8
#define RP23XX_M33_FPCAR_ADDRESS_MSB    31
#define RP23XX_M33_FPCAR_ADDRESS_LSB    3
#define RP23XX_M33_FPCAR_ADDRESS_ACCESS "RW"

#define RP23XX_M33_FPDSCR_OFFSET 0x0000ef3c
#define RP23XX_M33_FPDSCR_BITS   0x07c00000
#define RP23XX_M33_FPDSCR_RESET  0x00000000

#define RP23XX_M33_FPDSCR_AHP_RESET  0x0
#define RP23XX_M33_FPDSCR_AHP_BITS   0x04000000
#define RP23XX_M33_FPDSCR_AHP_MSB    26
#define RP23XX_M33_FPDSCR_AHP_LSB    26
#define RP23XX_M33_FPDSCR_AHP_ACCESS "RW"

#define RP23XX_M33_FPDSCR_DN_RESET  0x0
#define RP23XX_M33_FPDSCR_DN_BITS   0x02000000
#define RP23XX_M33_FPDSCR_DN_MSB    25
#define RP23XX_M33_FPDSCR_DN_LSB    25
#define RP23XX_M33_FPDSCR_DN_ACCESS "RW"

#define RP23XX_M33_FPDSCR_FZ_RESET  0x0
#define RP23XX_M33_FPDSCR_FZ_BITS   0x01000000
#define RP23XX_M33_FPDSCR_FZ_MSB    24
#define RP23XX_M33_FPDSCR_FZ_LSB    24
#define RP23XX_M33_FPDSCR_FZ_ACCESS "RW"

#define RP23XX_M33_FPDSCR_RMODE_RESET  0x0
#define RP23XX_M33_FPDSCR_RMODE_BITS   0x00c00000
#define RP23XX_M33_FPDSCR_RMODE_MSB    23
#define RP23XX_M33_FPDSCR_RMODE_LSB    22
#define RP23XX_M33_FPDSCR_RMODE_ACCESS "RW"

#define RP23XX_M33_MVFR0_OFFSET 0x0000ef40
#define RP23XX_M33_MVFR0_BITS   0xf0ff0fff
#define RP23XX_M33_MVFR0_RESET  0x60540601

#define RP23XX_M33_MVFR0_FPROUND_RESET  0x6
#define RP23XX_M33_MVFR0_FPROUND_BITS   0xf0000000
#define RP23XX_M33_MVFR0_FPROUND_MSB    31
#define RP23XX_M33_MVFR0_FPROUND_LSB    28
#define RP23XX_M33_MVFR0_FPROUND_ACCESS "RO"

#define RP23XX_M33_MVFR0_FPSQRT_RESET  0x5
#define RP23XX_M33_MVFR0_FPSQRT_BITS   0x00f00000
#define RP23XX_M33_MVFR0_FPSQRT_MSB    23
#define RP23XX_M33_MVFR0_FPSQRT_LSB    20
#define RP23XX_M33_MVFR0_FPSQRT_ACCESS "RO"

#define RP23XX_M33_MVFR0_FPDIVIDE_RESET  0x4
#define RP23XX_M33_MVFR0_FPDIVIDE_BITS   0x000f0000
#define RP23XX_M33_MVFR0_FPDIVIDE_MSB    19
#define RP23XX_M33_MVFR0_FPDIVIDE_LSB    16
#define RP23XX_M33_MVFR0_FPDIVIDE_ACCESS "RO"

#define RP23XX_M33_MVFR0_FPDP_RESET  0x6
#define RP23XX_M33_MVFR0_FPDP_BITS   0x00000f00
#define RP23XX_M33_MVFR0_FPDP_MSB    11
#define RP23XX_M33_MVFR0_FPDP_LSB    8
#define RP23XX_M33_MVFR0_FPDP_ACCESS "RO"

#define RP23XX_M33_MVFR0_FPSP_RESET  0x0
#define RP23XX_M33_MVFR0_FPSP_BITS   0x000000f0
#define RP23XX_M33_MVFR0_FPSP_MSB    7
#define RP23XX_M33_MVFR0_FPSP_LSB    4
#define RP23XX_M33_MVFR0_FPSP_ACCESS "RO"

#define RP23XX_M33_MVFR0_SIMDREG_RESET  0x1
#define RP23XX_M33_MVFR0_SIMDREG_BITS   0x0000000f
#define RP23XX_M33_MVFR0_SIMDREG_MSB    3
#define RP23XX_M33_MVFR0_SIMDREG_LSB    0
#define RP23XX_M33_MVFR0_SIMDREG_ACCESS "RO"

#define RP23XX_M33_MVFR1_OFFSET 0x0000ef44
#define RP23XX_M33_MVFR1_BITS   0xff0000ff
#define RP23XX_M33_MVFR1_RESET  0x85000089

#define RP23XX_M33_MVFR1_FMAC_RESET  0x8
#define RP23XX_M33_MVFR1_FMAC_BITS   0xf0000000
#define RP23XX_M33_MVFR1_FMAC_MSB    31
#define RP23XX_M33_MVFR1_FMAC_LSB    28
#define RP23XX_M33_MVFR1_FMAC_ACCESS "RO"

#define RP23XX_M33_MVFR1_FPHP_RESET  0x5
#define RP23XX_M33_MVFR1_FPHP_BITS   0x0f000000
#define RP23XX_M33_MVFR1_FPHP_MSB    27
#define RP23XX_M33_MVFR1_FPHP_LSB    24
#define RP23XX_M33_MVFR1_FPHP_ACCESS "RO"

#define RP23XX_M33_MVFR1_FPDNAN_RESET  0x8
#define RP23XX_M33_MVFR1_FPDNAN_BITS   0x000000f0
#define RP23XX_M33_MVFR1_FPDNAN_MSB    7
#define RP23XX_M33_MVFR1_FPDNAN_LSB    4
#define RP23XX_M33_MVFR1_FPDNAN_ACCESS "RO"

#define RP23XX_M33_MVFR1_FPFTZ_RESET  0x9
#define RP23XX_M33_MVFR1_FPFTZ_BITS   0x0000000f
#define RP23XX_M33_MVFR1_FPFTZ_MSB    3
#define RP23XX_M33_MVFR1_FPFTZ_LSB    0
#define RP23XX_M33_MVFR1_FPFTZ_ACCESS "RO"

#define RP23XX_M33_MVFR2_OFFSET 0x0000ef48
#define RP23XX_M33_MVFR2_BITS   0x000000f0
#define RP23XX_M33_MVFR2_RESET  0x00000060

#define RP23XX_M33_MVFR2_FPMISC_RESET  0x6
#define RP23XX_M33_MVFR2_FPMISC_BITS   0x000000f0
#define RP23XX_M33_MVFR2_FPMISC_MSB    7
#define RP23XX_M33_MVFR2_FPMISC_LSB    4
#define RP23XX_M33_MVFR2_FPMISC_ACCESS "RO"

#define RP23XX_M33_DDEVARCH_OFFSET 0x0000efbc
#define RP23XX_M33_DDEVARCH_BITS   0xffffffff
#define RP23XX_M33_DDEVARCH_RESET  0x47702a04

#define RP23XX_M33_DDEVARCH_ARCHITECT_RESET  0x23b
#define RP23XX_M33_DDEVARCH_ARCHITECT_BITS   0xffe00000
#define RP23XX_M33_DDEVARCH_ARCHITECT_MSB    31
#define RP23XX_M33_DDEVARCH_ARCHITECT_LSB    21
#define RP23XX_M33_DDEVARCH_ARCHITECT_ACCESS "RO"

#define RP23XX_M33_DDEVARCH_PRESENT_RESET  0x1
#define RP23XX_M33_DDEVARCH_PRESENT_BITS   0x00100000
#define RP23XX_M33_DDEVARCH_PRESENT_MSB    20
#define RP23XX_M33_DDEVARCH_PRESENT_LSB    20
#define RP23XX_M33_DDEVARCH_PRESENT_ACCESS "RO"

#define RP23XX_M33_DDEVARCH_REVISION_RESET  0x0
#define RP23XX_M33_DDEVARCH_REVISION_BITS   0x000f0000
#define RP23XX_M33_DDEVARCH_REVISION_MSB    19
#define RP23XX_M33_DDEVARCH_REVISION_LSB    16
#define RP23XX_M33_DDEVARCH_REVISION_ACCESS "RO"

#define RP23XX_M33_DDEVARCH_ARCHVER_RESET  0x2
#define RP23XX_M33_DDEVARCH_ARCHVER_BITS   0x0000f000
#define RP23XX_M33_DDEVARCH_ARCHVER_MSB    15
#define RP23XX_M33_DDEVARCH_ARCHVER_LSB    12
#define RP23XX_M33_DDEVARCH_ARCHVER_ACCESS "RO"

#define RP23XX_M33_DDEVARCH_ARCHPART_RESET  0xa04
#define RP23XX_M33_DDEVARCH_ARCHPART_BITS   0x00000fff
#define RP23XX_M33_DDEVARCH_ARCHPART_MSB    11
#define RP23XX_M33_DDEVARCH_ARCHPART_LSB    0
#define RP23XX_M33_DDEVARCH_ARCHPART_ACCESS "RO"

#define RP23XX_M33_DDEVTYPE_OFFSET 0x0000efcc
#define RP23XX_M33_DDEVTYPE_BITS   0x000000ff
#define RP23XX_M33_DDEVTYPE_RESET  0x00000000

#define RP23XX_M33_DDEVTYPE_SUB_RESET  0x0
#define RP23XX_M33_DDEVTYPE_SUB_BITS   0x000000f0
#define RP23XX_M33_DDEVTYPE_SUB_MSB    7
#define RP23XX_M33_DDEVTYPE_SUB_LSB    4
#define RP23XX_M33_DDEVTYPE_SUB_ACCESS "RO"

#define RP23XX_M33_DDEVTYPE_MAJOR_RESET  0x0
#define RP23XX_M33_DDEVTYPE_MAJOR_BITS   0x0000000f
#define RP23XX_M33_DDEVTYPE_MAJOR_MSB    3
#define RP23XX_M33_DDEVTYPE_MAJOR_LSB    0
#define RP23XX_M33_DDEVTYPE_MAJOR_ACCESS "RO"

#define RP23XX_M33_DPIDR4_OFFSET 0x0000efd0
#define RP23XX_M33_DPIDR4_BITS   0x000000ff
#define RP23XX_M33_DPIDR4_RESET  0x00000004

#define RP23XX_M33_DPIDR4_SIZE_RESET  0x0
#define RP23XX_M33_DPIDR4_SIZE_BITS   0x000000f0
#define RP23XX_M33_DPIDR4_SIZE_MSB    7
#define RP23XX_M33_DPIDR4_SIZE_LSB    4
#define RP23XX_M33_DPIDR4_SIZE_ACCESS "RO"

#define RP23XX_M33_DPIDR4_DES_2_RESET  0x4
#define RP23XX_M33_DPIDR4_DES_2_BITS   0x0000000f
#define RP23XX_M33_DPIDR4_DES_2_MSB    3
#define RP23XX_M33_DPIDR4_DES_2_LSB    0
#define RP23XX_M33_DPIDR4_DES_2_ACCESS "RO"

#define RP23XX_M33_DPIDR5_OFFSET 0x0000efd4
#define RP23XX_M33_DPIDR5_BITS   0x00000000
#define RP23XX_M33_DPIDR5_RESET  0x00000000
#define RP23XX_M33_DPIDR5_MSB    31
#define RP23XX_M33_DPIDR5_LSB    0
#define RP23XX_M33_DPIDR5_ACCESS "RW"

#define RP23XX_M33_DPIDR6_OFFSET 0x0000efd8
#define RP23XX_M33_DPIDR6_BITS   0x00000000
#define RP23XX_M33_DPIDR6_RESET  0x00000000
#define RP23XX_M33_DPIDR6_MSB    31
#define RP23XX_M33_DPIDR6_LSB    0
#define RP23XX_M33_DPIDR6_ACCESS "RW"

#define RP23XX_M33_DPIDR7_OFFSET 0x0000efdc
#define RP23XX_M33_DPIDR7_BITS   0x00000000
#define RP23XX_M33_DPIDR7_RESET  0x00000000
#define RP23XX_M33_DPIDR7_MSB    31
#define RP23XX_M33_DPIDR7_LSB    0
#define RP23XX_M33_DPIDR7_ACCESS "RW"

#define RP23XX_M33_DPIDR0_OFFSET 0x0000efe0
#define RP23XX_M33_DPIDR0_BITS   0x000000ff
#define RP23XX_M33_DPIDR0_RESET  0x00000021

#define RP23XX_M33_DPIDR0_PART_0_RESET  0x21
#define RP23XX_M33_DPIDR0_PART_0_BITS   0x000000ff
#define RP23XX_M33_DPIDR0_PART_0_MSB    7
#define RP23XX_M33_DPIDR0_PART_0_LSB    0
#define RP23XX_M33_DPIDR0_PART_0_ACCESS "RO"

#define RP23XX_M33_DPIDR1_OFFSET 0x0000efe4
#define RP23XX_M33_DPIDR1_BITS   0x000000ff
#define RP23XX_M33_DPIDR1_RESET  0x000000bd

#define RP23XX_M33_DPIDR1_DES_0_RESET  0xb
#define RP23XX_M33_DPIDR1_DES_0_BITS   0x000000f0
#define RP23XX_M33_DPIDR1_DES_0_MSB    7
#define RP23XX_M33_DPIDR1_DES_0_LSB    4
#define RP23XX_M33_DPIDR1_DES_0_ACCESS "RO"

#define RP23XX_M33_DPIDR1_PART_1_RESET  0xd
#define RP23XX_M33_DPIDR1_PART_1_BITS   0x0000000f
#define RP23XX_M33_DPIDR1_PART_1_MSB    3
#define RP23XX_M33_DPIDR1_PART_1_LSB    0
#define RP23XX_M33_DPIDR1_PART_1_ACCESS "RO"

#define RP23XX_M33_DPIDR2_OFFSET 0x0000efe8
#define RP23XX_M33_DPIDR2_BITS   0x000000ff
#define RP23XX_M33_DPIDR2_RESET  0x0000000b

#define RP23XX_M33_DPIDR2_REVISION_RESET  0x0
#define RP23XX_M33_DPIDR2_REVISION_BITS   0x000000f0
#define RP23XX_M33_DPIDR2_REVISION_MSB    7
#define RP23XX_M33_DPIDR2_REVISION_LSB    4
#define RP23XX_M33_DPIDR2_REVISION_ACCESS "RO"

#define RP23XX_M33_DPIDR2_JEDEC_RESET  0x1
#define RP23XX_M33_DPIDR2_JEDEC_BITS   0x00000008
#define RP23XX_M33_DPIDR2_JEDEC_MSB    3
#define RP23XX_M33_DPIDR2_JEDEC_LSB    3
#define RP23XX_M33_DPIDR2_JEDEC_ACCESS "RO"

#define RP23XX_M33_DPIDR2_DES_1_RESET  0x3
#define RP23XX_M33_DPIDR2_DES_1_BITS   0x00000007
#define RP23XX_M33_DPIDR2_DES_1_MSB    2
#define RP23XX_M33_DPIDR2_DES_1_LSB    0
#define RP23XX_M33_DPIDR2_DES_1_ACCESS "RO"

#define RP23XX_M33_DPIDR3_OFFSET 0x0000efec
#define RP23XX_M33_DPIDR3_BITS   0x000000ff
#define RP23XX_M33_DPIDR3_RESET  0x00000000

#define RP23XX_M33_DPIDR3_REVAND_RESET  0x0
#define RP23XX_M33_DPIDR3_REVAND_BITS   0x000000f0
#define RP23XX_M33_DPIDR3_REVAND_MSB    7
#define RP23XX_M33_DPIDR3_REVAND_LSB    4
#define RP23XX_M33_DPIDR3_REVAND_ACCESS "RO"

#define RP23XX_M33_DPIDR3_CMOD_RESET  0x0
#define RP23XX_M33_DPIDR3_CMOD_BITS   0x0000000f
#define RP23XX_M33_DPIDR3_CMOD_MSB    3
#define RP23XX_M33_DPIDR3_CMOD_LSB    0
#define RP23XX_M33_DPIDR3_CMOD_ACCESS "RO"

#define RP23XX_M33_DCIDR0_OFFSET 0x0000eff0
#define RP23XX_M33_DCIDR0_BITS   0x000000ff
#define RP23XX_M33_DCIDR0_RESET  0x0000000d

#define RP23XX_M33_DCIDR0_PRMBL_0_RESET  0x0d
#define RP23XX_M33_DCIDR0_PRMBL_0_BITS   0x000000ff
#define RP23XX_M33_DCIDR0_PRMBL_0_MSB    7
#define RP23XX_M33_DCIDR0_PRMBL_0_LSB    0
#define RP23XX_M33_DCIDR0_PRMBL_0_ACCESS "RO"

#define RP23XX_M33_DCIDR1_OFFSET 0x0000eff4
#define RP23XX_M33_DCIDR1_BITS   0x000000ff
#define RP23XX_M33_DCIDR1_RESET  0x00000090

#define RP23XX_M33_DCIDR1_CLASS_RESET  0x9
#define RP23XX_M33_DCIDR1_CLASS_BITS   0x000000f0
#define RP23XX_M33_DCIDR1_CLASS_MSB    7
#define RP23XX_M33_DCIDR1_CLASS_LSB    4
#define RP23XX_M33_DCIDR1_CLASS_ACCESS "RO"

#define RP23XX_M33_DCIDR1_PRMBL_1_RESET  0x0
#define RP23XX_M33_DCIDR1_PRMBL_1_BITS   0x0000000f
#define RP23XX_M33_DCIDR1_PRMBL_1_MSB    3
#define RP23XX_M33_DCIDR1_PRMBL_1_LSB    0
#define RP23XX_M33_DCIDR1_PRMBL_1_ACCESS "RO"

#define RP23XX_M33_DCIDR2_OFFSET 0x0000eff8
#define RP23XX_M33_DCIDR2_BITS   0x000000ff
#define RP23XX_M33_DCIDR2_RESET  0x00000005

#define RP23XX_M33_DCIDR2_PRMBL_2_RESET  0x05
#define RP23XX_M33_DCIDR2_PRMBL_2_BITS   0x000000ff
#define RP23XX_M33_DCIDR2_PRMBL_2_MSB    7
#define RP23XX_M33_DCIDR2_PRMBL_2_LSB    0
#define RP23XX_M33_DCIDR2_PRMBL_2_ACCESS "RO"

#define RP23XX_M33_DCIDR3_OFFSET 0x0000effc
#define RP23XX_M33_DCIDR3_BITS   0x000000ff
#define RP23XX_M33_DCIDR3_RESET  0x000000b1

#define RP23XX_M33_DCIDR3_PRMBL_3_RESET  0xb1
#define RP23XX_M33_DCIDR3_PRMBL_3_BITS   0x000000ff
#define RP23XX_M33_DCIDR3_PRMBL_3_MSB    7
#define RP23XX_M33_DCIDR3_PRMBL_3_LSB    0
#define RP23XX_M33_DCIDR3_PRMBL_3_ACCESS "RO"

#define RP23XX_M33_TRCPRGCTLR_OFFSET 0x00041004
#define RP23XX_M33_TRCPRGCTLR_BITS   0x00000001
#define RP23XX_M33_TRCPRGCTLR_RESET  0x00000000

#define RP23XX_M33_TRCPRGCTLR_EN_RESET  0x0
#define RP23XX_M33_TRCPRGCTLR_EN_BITS   0x00000001
#define RP23XX_M33_TRCPRGCTLR_EN_MSB    0
#define RP23XX_M33_TRCPRGCTLR_EN_LSB    0
#define RP23XX_M33_TRCPRGCTLR_EN_ACCESS "RW"

#define RP23XX_M33_TRCSTATR_OFFSET 0x0004100c
#define RP23XX_M33_TRCSTATR_BITS   0x00000003
#define RP23XX_M33_TRCSTATR_RESET  0x00000000

#define RP23XX_M33_TRCSTATR_PMSTABLE_RESET  0x0
#define RP23XX_M33_TRCSTATR_PMSTABLE_BITS   0x00000002
#define RP23XX_M33_TRCSTATR_PMSTABLE_MSB    1
#define RP23XX_M33_TRCSTATR_PMSTABLE_LSB    1
#define RP23XX_M33_TRCSTATR_PMSTABLE_ACCESS "RO"

#define RP23XX_M33_TRCSTATR_IDLE_RESET  0x0
#define RP23XX_M33_TRCSTATR_IDLE_BITS   0x00000001
#define RP23XX_M33_TRCSTATR_IDLE_MSB    0
#define RP23XX_M33_TRCSTATR_IDLE_LSB    0
#define RP23XX_M33_TRCSTATR_IDLE_ACCESS "RO"

#define RP23XX_M33_TRCCONFIGR_OFFSET 0x00041010
#define RP23XX_M33_TRCCONFIGR_BITS   0x00001ff8
#define RP23XX_M33_TRCCONFIGR_RESET  0x00000000

#define RP23XX_M33_TRCCONFIGR_RS_RESET  0x0
#define RP23XX_M33_TRCCONFIGR_RS_BITS   0x00001000
#define RP23XX_M33_TRCCONFIGR_RS_MSB    12
#define RP23XX_M33_TRCCONFIGR_RS_LSB    12
#define RP23XX_M33_TRCCONFIGR_RS_ACCESS "RW"

#define RP23XX_M33_TRCCONFIGR_TS_RESET  0x0
#define RP23XX_M33_TRCCONFIGR_TS_BITS   0x00000800
#define RP23XX_M33_TRCCONFIGR_TS_MSB    11
#define RP23XX_M33_TRCCONFIGR_TS_LSB    11
#define RP23XX_M33_TRCCONFIGR_TS_ACCESS "RW"

#define RP23XX_M33_TRCCONFIGR_COND_RESET  0x00
#define RP23XX_M33_TRCCONFIGR_COND_BITS   0x000007e0
#define RP23XX_M33_TRCCONFIGR_COND_MSB    10
#define RP23XX_M33_TRCCONFIGR_COND_LSB    5
#define RP23XX_M33_TRCCONFIGR_COND_ACCESS "RW"

#define RP23XX_M33_TRCCONFIGR_CCI_RESET  0x0
#define RP23XX_M33_TRCCONFIGR_CCI_BITS   0x00000010
#define RP23XX_M33_TRCCONFIGR_CCI_MSB    4
#define RP23XX_M33_TRCCONFIGR_CCI_LSB    4
#define RP23XX_M33_TRCCONFIGR_CCI_ACCESS "RW"

#define RP23XX_M33_TRCCONFIGR_BB_RESET  0x0
#define RP23XX_M33_TRCCONFIGR_BB_BITS   0x00000008
#define RP23XX_M33_TRCCONFIGR_BB_MSB    3
#define RP23XX_M33_TRCCONFIGR_BB_LSB    3
#define RP23XX_M33_TRCCONFIGR_BB_ACCESS "RW"

#define RP23XX_M33_TRCEVENTCTL0R_OFFSET 0x00041020
#define RP23XX_M33_TRCEVENTCTL0R_BITS   0x00008787
#define RP23XX_M33_TRCEVENTCTL0R_RESET  0x00000000

#define RP23XX_M33_TRCEVENTCTL0R_TYPE1_RESET  0x0
#define RP23XX_M33_TRCEVENTCTL0R_TYPE1_BITS   0x00008000
#define RP23XX_M33_TRCEVENTCTL0R_TYPE1_MSB    15
#define RP23XX_M33_TRCEVENTCTL0R_TYPE1_LSB    15
#define RP23XX_M33_TRCEVENTCTL0R_TYPE1_ACCESS "RW"

#define RP23XX_M33_TRCEVENTCTL0R_SEL1_RESET  0x0
#define RP23XX_M33_TRCEVENTCTL0R_SEL1_BITS   0x00000700
#define RP23XX_M33_TRCEVENTCTL0R_SEL1_MSB    10
#define RP23XX_M33_TRCEVENTCTL0R_SEL1_LSB    8
#define RP23XX_M33_TRCEVENTCTL0R_SEL1_ACCESS "RW"

#define RP23XX_M33_TRCEVENTCTL0R_TYPE0_RESET  0x0
#define RP23XX_M33_TRCEVENTCTL0R_TYPE0_BITS   0x00000080
#define RP23XX_M33_TRCEVENTCTL0R_TYPE0_MSB    7
#define RP23XX_M33_TRCEVENTCTL0R_TYPE0_LSB    7
#define RP23XX_M33_TRCEVENTCTL0R_TYPE0_ACCESS "RW"

#define RP23XX_M33_TRCEVENTCTL0R_SEL0_RESET  0x0
#define RP23XX_M33_TRCEVENTCTL0R_SEL0_BITS   0x00000007
#define RP23XX_M33_TRCEVENTCTL0R_SEL0_MSB    2
#define RP23XX_M33_TRCEVENTCTL0R_SEL0_LSB    0
#define RP23XX_M33_TRCEVENTCTL0R_SEL0_ACCESS "RW"

#define RP23XX_M33_TRCEVENTCTL1R_OFFSET 0x00041024
#define RP23XX_M33_TRCEVENTCTL1R_BITS   0x00001803
#define RP23XX_M33_TRCEVENTCTL1R_RESET  0x00000000

#define RP23XX_M33_TRCEVENTCTL1R_LPOVERRIDE_RESET  0x0
#define RP23XX_M33_TRCEVENTCTL1R_LPOVERRIDE_BITS   0x00001000
#define RP23XX_M33_TRCEVENTCTL1R_LPOVERRIDE_MSB    12
#define RP23XX_M33_TRCEVENTCTL1R_LPOVERRIDE_LSB    12
#define RP23XX_M33_TRCEVENTCTL1R_LPOVERRIDE_ACCESS "RW"

#define RP23XX_M33_TRCEVENTCTL1R_ATB_RESET  0x0
#define RP23XX_M33_TRCEVENTCTL1R_ATB_BITS   0x00000800
#define RP23XX_M33_TRCEVENTCTL1R_ATB_MSB    11
#define RP23XX_M33_TRCEVENTCTL1R_ATB_LSB    11
#define RP23XX_M33_TRCEVENTCTL1R_ATB_ACCESS "RW"

#define RP23XX_M33_TRCEVENTCTL1R_INSTEN1_RESET  0x0
#define RP23XX_M33_TRCEVENTCTL1R_INSTEN1_BITS   0x00000002
#define RP23XX_M33_TRCEVENTCTL1R_INSTEN1_MSB    1
#define RP23XX_M33_TRCEVENTCTL1R_INSTEN1_LSB    1
#define RP23XX_M33_TRCEVENTCTL1R_INSTEN1_ACCESS "RW"

#define RP23XX_M33_TRCEVENTCTL1R_INSTEN0_RESET  0x0
#define RP23XX_M33_TRCEVENTCTL1R_INSTEN0_BITS   0x00000001
#define RP23XX_M33_TRCEVENTCTL1R_INSTEN0_MSB    0
#define RP23XX_M33_TRCEVENTCTL1R_INSTEN0_LSB    0
#define RP23XX_M33_TRCEVENTCTL1R_INSTEN0_ACCESS "RW"

#define RP23XX_M33_TRCSTALLCTLR_OFFSET 0x0004102c
#define RP23XX_M33_TRCSTALLCTLR_BITS   0x0000050c
#define RP23XX_M33_TRCSTALLCTLR_RESET  0x00000000

#define RP23XX_M33_TRCSTALLCTLR_INSTPRIORITY_RESET  0x0
#define RP23XX_M33_TRCSTALLCTLR_INSTPRIORITY_BITS   0x00000400
#define RP23XX_M33_TRCSTALLCTLR_INSTPRIORITY_MSB    10
#define RP23XX_M33_TRCSTALLCTLR_INSTPRIORITY_LSB    10
#define RP23XX_M33_TRCSTALLCTLR_INSTPRIORITY_ACCESS "RO"

#define RP23XX_M33_TRCSTALLCTLR_ISTALL_RESET  0x0
#define RP23XX_M33_TRCSTALLCTLR_ISTALL_BITS   0x00000100
#define RP23XX_M33_TRCSTALLCTLR_ISTALL_MSB    8
#define RP23XX_M33_TRCSTALLCTLR_ISTALL_LSB    8
#define RP23XX_M33_TRCSTALLCTLR_ISTALL_ACCESS "RW"

#define RP23XX_M33_TRCSTALLCTLR_LEVEL_RESET  0x0
#define RP23XX_M33_TRCSTALLCTLR_LEVEL_BITS   0x0000000c
#define RP23XX_M33_TRCSTALLCTLR_LEVEL_MSB    3
#define RP23XX_M33_TRCSTALLCTLR_LEVEL_LSB    2
#define RP23XX_M33_TRCSTALLCTLR_LEVEL_ACCESS "RW"

#define RP23XX_M33_TRCTSCTLR_OFFSET 0x00041030
#define RP23XX_M33_TRCTSCTLR_BITS   0x00000083
#define RP23XX_M33_TRCTSCTLR_RESET  0x00000000

#define RP23XX_M33_TRCTSCTLR_TYPE0_RESET  0x0
#define RP23XX_M33_TRCTSCTLR_TYPE0_BITS   0x00000080
#define RP23XX_M33_TRCTSCTLR_TYPE0_MSB    7
#define RP23XX_M33_TRCTSCTLR_TYPE0_LSB    7
#define RP23XX_M33_TRCTSCTLR_TYPE0_ACCESS "RW"

#define RP23XX_M33_TRCTSCTLR_SEL0_RESET  0x0
#define RP23XX_M33_TRCTSCTLR_SEL0_BITS   0x00000003
#define RP23XX_M33_TRCTSCTLR_SEL0_MSB    1
#define RP23XX_M33_TRCTSCTLR_SEL0_LSB    0
#define RP23XX_M33_TRCTSCTLR_SEL0_ACCESS "RW"

#define RP23XX_M33_TRCSYNCPR_OFFSET 0x00041034
#define RP23XX_M33_TRCSYNCPR_BITS   0x0000001f
#define RP23XX_M33_TRCSYNCPR_RESET  0x0000000a

#define RP23XX_M33_TRCSYNCPR_PERIOD_RESET  0x0a
#define RP23XX_M33_TRCSYNCPR_PERIOD_BITS   0x0000001f
#define RP23XX_M33_TRCSYNCPR_PERIOD_MSB    4
#define RP23XX_M33_TRCSYNCPR_PERIOD_LSB    0
#define RP23XX_M33_TRCSYNCPR_PERIOD_ACCESS "RO"

#define RP23XX_M33_TRCCCCTLR_OFFSET 0x00041038
#define RP23XX_M33_TRCCCCTLR_BITS   0x00000fff
#define RP23XX_M33_TRCCCCTLR_RESET  0x00000000

#define RP23XX_M33_TRCCCCTLR_THRESHOLD_RESET  0x000
#define RP23XX_M33_TRCCCCTLR_THRESHOLD_BITS   0x00000fff
#define RP23XX_M33_TRCCCCTLR_THRESHOLD_MSB    11
#define RP23XX_M33_TRCCCCTLR_THRESHOLD_LSB    0
#define RP23XX_M33_TRCCCCTLR_THRESHOLD_ACCESS "RW"

#define RP23XX_M33_TRCVICTLR_OFFSET 0x00041080
#define RP23XX_M33_TRCVICTLR_BITS   0x00090e83
#define RP23XX_M33_TRCVICTLR_RESET  0x00000000

#define RP23XX_M33_TRCVICTLR_EXLEVEL_S3_RESET  0x0
#define RP23XX_M33_TRCVICTLR_EXLEVEL_S3_BITS   0x00080000
#define RP23XX_M33_TRCVICTLR_EXLEVEL_S3_MSB    19
#define RP23XX_M33_TRCVICTLR_EXLEVEL_S3_LSB    19
#define RP23XX_M33_TRCVICTLR_EXLEVEL_S3_ACCESS "RW"

#define RP23XX_M33_TRCVICTLR_EXLEVEL_S0_RESET  0x0
#define RP23XX_M33_TRCVICTLR_EXLEVEL_S0_BITS   0x00010000
#define RP23XX_M33_TRCVICTLR_EXLEVEL_S0_MSB    16
#define RP23XX_M33_TRCVICTLR_EXLEVEL_S0_LSB    16
#define RP23XX_M33_TRCVICTLR_EXLEVEL_S0_ACCESS "RW"

#define RP23XX_M33_TRCVICTLR_TRCERR_RESET  0x0
#define RP23XX_M33_TRCVICTLR_TRCERR_BITS   0x00000800
#define RP23XX_M33_TRCVICTLR_TRCERR_MSB    11
#define RP23XX_M33_TRCVICTLR_TRCERR_LSB    11
#define RP23XX_M33_TRCVICTLR_TRCERR_ACCESS "RW"

#define RP23XX_M33_TRCVICTLR_TRCRESET_RESET  0x0
#define RP23XX_M33_TRCVICTLR_TRCRESET_BITS   0x00000400
#define RP23XX_M33_TRCVICTLR_TRCRESET_MSB    10
#define RP23XX_M33_TRCVICTLR_TRCRESET_LSB    10
#define RP23XX_M33_TRCVICTLR_TRCRESET_ACCESS "RW"

#define RP23XX_M33_TRCVICTLR_SSSTATUS_RESET  0x0
#define RP23XX_M33_TRCVICTLR_SSSTATUS_BITS   0x00000200
#define RP23XX_M33_TRCVICTLR_SSSTATUS_MSB    9
#define RP23XX_M33_TRCVICTLR_SSSTATUS_LSB    9
#define RP23XX_M33_TRCVICTLR_SSSTATUS_ACCESS "RW"

#define RP23XX_M33_TRCVICTLR_TYPE0_RESET  0x0
#define RP23XX_M33_TRCVICTLR_TYPE0_BITS   0x00000080
#define RP23XX_M33_TRCVICTLR_TYPE0_MSB    7
#define RP23XX_M33_TRCVICTLR_TYPE0_LSB    7
#define RP23XX_M33_TRCVICTLR_TYPE0_ACCESS "RW"

#define RP23XX_M33_TRCVICTLR_SEL0_RESET  0x0
#define RP23XX_M33_TRCVICTLR_SEL0_BITS   0x00000003
#define RP23XX_M33_TRCVICTLR_SEL0_MSB    1
#define RP23XX_M33_TRCVICTLR_SEL0_LSB    0
#define RP23XX_M33_TRCVICTLR_SEL0_ACCESS "RW"

#define RP23XX_M33_TRCCNTRLDVR0_OFFSET 0x00041140
#define RP23XX_M33_TRCCNTRLDVR0_BITS   0x0000ffff
#define RP23XX_M33_TRCCNTRLDVR0_RESET  0x00000000

#define RP23XX_M33_TRCCNTRLDVR0_VALUE_RESET  0x0000
#define RP23XX_M33_TRCCNTRLDVR0_VALUE_BITS   0x0000ffff
#define RP23XX_M33_TRCCNTRLDVR0_VALUE_MSB    15
#define RP23XX_M33_TRCCNTRLDVR0_VALUE_LSB    0
#define RP23XX_M33_TRCCNTRLDVR0_VALUE_ACCESS "RW"

#define RP23XX_M33_TRCIDR8_OFFSET 0x00041180
#define RP23XX_M33_TRCIDR8_BITS   0xffffffff
#define RP23XX_M33_TRCIDR8_RESET  0x00000000

#define RP23XX_M33_TRCIDR8_MAXSPEC_RESET  0x00000000
#define RP23XX_M33_TRCIDR8_MAXSPEC_BITS   0xffffffff
#define RP23XX_M33_TRCIDR8_MAXSPEC_MSB    31
#define RP23XX_M33_TRCIDR8_MAXSPEC_LSB    0
#define RP23XX_M33_TRCIDR8_MAXSPEC_ACCESS "RO"

#define RP23XX_M33_TRCIDR9_OFFSET 0x00041184
#define RP23XX_M33_TRCIDR9_BITS   0xffffffff
#define RP23XX_M33_TRCIDR9_RESET  0x00000000

#define RP23XX_M33_TRCIDR9_NUMP0KEY_RESET  0x00000000
#define RP23XX_M33_TRCIDR9_NUMP0KEY_BITS   0xffffffff
#define RP23XX_M33_TRCIDR9_NUMP0KEY_MSB    31
#define RP23XX_M33_TRCIDR9_NUMP0KEY_LSB    0
#define RP23XX_M33_TRCIDR9_NUMP0KEY_ACCESS "RO"

#define RP23XX_M33_TRCIDR10_OFFSET 0x00041188
#define RP23XX_M33_TRCIDR10_BITS   0xffffffff
#define RP23XX_M33_TRCIDR10_RESET  0x00000000

#define RP23XX_M33_TRCIDR10_NUMP1KEY_RESET  0x00000000
#define RP23XX_M33_TRCIDR10_NUMP1KEY_BITS   0xffffffff
#define RP23XX_M33_TRCIDR10_NUMP1KEY_MSB    31
#define RP23XX_M33_TRCIDR10_NUMP1KEY_LSB    0
#define RP23XX_M33_TRCIDR10_NUMP1KEY_ACCESS "RO"

#define RP23XX_M33_TRCIDR11_OFFSET 0x0004118c
#define RP23XX_M33_TRCIDR11_BITS   0xffffffff
#define RP23XX_M33_TRCIDR11_RESET  0x00000000

#define RP23XX_M33_TRCIDR11_NUMP1SPC_RESET  0x00000000
#define RP23XX_M33_TRCIDR11_NUMP1SPC_BITS   0xffffffff
#define RP23XX_M33_TRCIDR11_NUMP1SPC_MSB    31
#define RP23XX_M33_TRCIDR11_NUMP1SPC_LSB    0
#define RP23XX_M33_TRCIDR11_NUMP1SPC_ACCESS "RO"

#define RP23XX_M33_TRCIDR12_OFFSET 0x00041190
#define RP23XX_M33_TRCIDR12_BITS   0xffffffff
#define RP23XX_M33_TRCIDR12_RESET  0x00000001

#define RP23XX_M33_TRCIDR12_NUMCONDKEY_RESET  0x00000001
#define RP23XX_M33_TRCIDR12_NUMCONDKEY_BITS   0xffffffff
#define RP23XX_M33_TRCIDR12_NUMCONDKEY_MSB    31
#define RP23XX_M33_TRCIDR12_NUMCONDKEY_LSB    0
#define RP23XX_M33_TRCIDR12_NUMCONDKEY_ACCESS "RO"

#define RP23XX_M33_TRCIDR13_OFFSET 0x00041194
#define RP23XX_M33_TRCIDR13_BITS   0xffffffff
#define RP23XX_M33_TRCIDR13_RESET  0x00000000

#define RP23XX_M33_TRCIDR13_NUMCONDSPC_RESET  0x00000000
#define RP23XX_M33_TRCIDR13_NUMCONDSPC_BITS   0xffffffff
#define RP23XX_M33_TRCIDR13_NUMCONDSPC_MSB    31
#define RP23XX_M33_TRCIDR13_NUMCONDSPC_LSB    0
#define RP23XX_M33_TRCIDR13_NUMCONDSPC_ACCESS "RO"

#define RP23XX_M33_TRCIMSPEC_OFFSET 0x000411c0
#define RP23XX_M33_TRCIMSPEC_BITS   0x0000000f
#define RP23XX_M33_TRCIMSPEC_RESET  0x00000000

#define RP23XX_M33_TRCIMSPEC_SUPPORT_RESET  0x0
#define RP23XX_M33_TRCIMSPEC_SUPPORT_BITS   0x0000000f
#define RP23XX_M33_TRCIMSPEC_SUPPORT_MSB    3
#define RP23XX_M33_TRCIMSPEC_SUPPORT_LSB    0
#define RP23XX_M33_TRCIMSPEC_SUPPORT_ACCESS "RO"

#define RP23XX_M33_TRCIDR0_OFFSET 0x000411e0
#define RP23XX_M33_TRCIDR0_BITS   0x3f03feff
#define RP23XX_M33_TRCIDR0_RESET  0x280006e1

#define RP23XX_M33_TRCIDR0_COMMOPT_RESET  0x1
#define RP23XX_M33_TRCIDR0_COMMOPT_BITS   0x20000000
#define RP23XX_M33_TRCIDR0_COMMOPT_MSB    29
#define RP23XX_M33_TRCIDR0_COMMOPT_LSB    29
#define RP23XX_M33_TRCIDR0_COMMOPT_ACCESS "RO"

#define RP23XX_M33_TRCIDR0_TSSIZE_RESET  0x08
#define RP23XX_M33_TRCIDR0_TSSIZE_BITS   0x1f000000
#define RP23XX_M33_TRCIDR0_TSSIZE_MSB    28
#define RP23XX_M33_TRCIDR0_TSSIZE_LSB    24
#define RP23XX_M33_TRCIDR0_TSSIZE_ACCESS "RO"

#define RP23XX_M33_TRCIDR0_TRCEXDATA_RESET  0x0
#define RP23XX_M33_TRCIDR0_TRCEXDATA_BITS   0x00020000
#define RP23XX_M33_TRCIDR0_TRCEXDATA_MSB    17
#define RP23XX_M33_TRCIDR0_TRCEXDATA_LSB    17
#define RP23XX_M33_TRCIDR0_TRCEXDATA_ACCESS "RO"

#define RP23XX_M33_TRCIDR0_QSUPP_RESET  0x0
#define RP23XX_M33_TRCIDR0_QSUPP_BITS   0x00018000
#define RP23XX_M33_TRCIDR0_QSUPP_MSB    16
#define RP23XX_M33_TRCIDR0_QSUPP_LSB    15
#define RP23XX_M33_TRCIDR0_QSUPP_ACCESS "RO"

#define RP23XX_M33_TRCIDR0_QFILT_RESET  0x0
#define RP23XX_M33_TRCIDR0_QFILT_BITS   0x00004000
#define RP23XX_M33_TRCIDR0_QFILT_MSB    14
#define RP23XX_M33_TRCIDR0_QFILT_LSB    14
#define RP23XX_M33_TRCIDR0_QFILT_ACCESS "RO"

#define RP23XX_M33_TRCIDR0_CONDTYPE_RESET  0x0
#define RP23XX_M33_TRCIDR0_CONDTYPE_BITS   0x00003000
#define RP23XX_M33_TRCIDR0_CONDTYPE_MSB    13
#define RP23XX_M33_TRCIDR0_CONDTYPE_LSB    12
#define RP23XX_M33_TRCIDR0_CONDTYPE_ACCESS "RO"

#define RP23XX_M33_TRCIDR0_NUMEVENT_RESET  0x1
#define RP23XX_M33_TRCIDR0_NUMEVENT_BITS   0x00000c00
#define RP23XX_M33_TRCIDR0_NUMEVENT_MSB    11
#define RP23XX_M33_TRCIDR0_NUMEVENT_LSB    10
#define RP23XX_M33_TRCIDR0_NUMEVENT_ACCESS "RO"

#define RP23XX_M33_TRCIDR0_RETSTACK_RESET  0x1
#define RP23XX_M33_TRCIDR0_RETSTACK_BITS   0x00000200
#define RP23XX_M33_TRCIDR0_RETSTACK_MSB    9
#define RP23XX_M33_TRCIDR0_RETSTACK_LSB    9
#define RP23XX_M33_TRCIDR0_RETSTACK_ACCESS "RO"

#define RP23XX_M33_TRCIDR0_TRCCCI_RESET  0x1
#define RP23XX_M33_TRCIDR0_TRCCCI_BITS   0x00000080
#define RP23XX_M33_TRCIDR0_TRCCCI_MSB    7
#define RP23XX_M33_TRCIDR0_TRCCCI_LSB    7
#define RP23XX_M33_TRCIDR0_TRCCCI_ACCESS "RO"

#define RP23XX_M33_TRCIDR0_TRCCOND_RESET  0x1
#define RP23XX_M33_TRCIDR0_TRCCOND_BITS   0x00000040
#define RP23XX_M33_TRCIDR0_TRCCOND_MSB    6
#define RP23XX_M33_TRCIDR0_TRCCOND_LSB    6
#define RP23XX_M33_TRCIDR0_TRCCOND_ACCESS "RO"

#define RP23XX_M33_TRCIDR0_TRCBB_RESET  0x1
#define RP23XX_M33_TRCIDR0_TRCBB_BITS   0x00000020
#define RP23XX_M33_TRCIDR0_TRCBB_MSB    5
#define RP23XX_M33_TRCIDR0_TRCBB_LSB    5
#define RP23XX_M33_TRCIDR0_TRCBB_ACCESS "RO"

#define RP23XX_M33_TRCIDR0_TRCDATA_RESET  0x0
#define RP23XX_M33_TRCIDR0_TRCDATA_BITS   0x00000018
#define RP23XX_M33_TRCIDR0_TRCDATA_MSB    4
#define RP23XX_M33_TRCIDR0_TRCDATA_LSB    3
#define RP23XX_M33_TRCIDR0_TRCDATA_ACCESS "RO"

#define RP23XX_M33_TRCIDR0_INSTP0_RESET  0x0
#define RP23XX_M33_TRCIDR0_INSTP0_BITS   0x00000006
#define RP23XX_M33_TRCIDR0_INSTP0_MSB    2
#define RP23XX_M33_TRCIDR0_INSTP0_LSB    1
#define RP23XX_M33_TRCIDR0_INSTP0_ACCESS "RO"

#define RP23XX_M33_TRCIDR0_RES1_RESET  0x1
#define RP23XX_M33_TRCIDR0_RES1_BITS   0x00000001
#define RP23XX_M33_TRCIDR0_RES1_MSB    0
#define RP23XX_M33_TRCIDR0_RES1_LSB    0
#define RP23XX_M33_TRCIDR0_RES1_ACCESS "RO"

#define RP23XX_M33_TRCIDR1_OFFSET 0x000411e4
#define RP23XX_M33_TRCIDR1_BITS   0xff00ffff
#define RP23XX_M33_TRCIDR1_RESET  0x4100f421

#define RP23XX_M33_TRCIDR1_DESIGNER_RESET  0x41
#define RP23XX_M33_TRCIDR1_DESIGNER_BITS   0xff000000
#define RP23XX_M33_TRCIDR1_DESIGNER_MSB    31
#define RP23XX_M33_TRCIDR1_DESIGNER_LSB    24
#define RP23XX_M33_TRCIDR1_DESIGNER_ACCESS "RO"

#define RP23XX_M33_TRCIDR1_RES1_RESET  0xf
#define RP23XX_M33_TRCIDR1_RES1_BITS   0x0000f000
#define RP23XX_M33_TRCIDR1_RES1_MSB    15
#define RP23XX_M33_TRCIDR1_RES1_LSB    12
#define RP23XX_M33_TRCIDR1_RES1_ACCESS "RO"

#define RP23XX_M33_TRCIDR1_TRCARCHMAJ_RESET  0x4
#define RP23XX_M33_TRCIDR1_TRCARCHMAJ_BITS   0x00000f00
#define RP23XX_M33_TRCIDR1_TRCARCHMAJ_MSB    11
#define RP23XX_M33_TRCIDR1_TRCARCHMAJ_LSB    8
#define RP23XX_M33_TRCIDR1_TRCARCHMAJ_ACCESS "RO"

#define RP23XX_M33_TRCIDR1_TRCARCHMIN_RESET  0x2
#define RP23XX_M33_TRCIDR1_TRCARCHMIN_BITS   0x000000f0
#define RP23XX_M33_TRCIDR1_TRCARCHMIN_MSB    7
#define RP23XX_M33_TRCIDR1_TRCARCHMIN_LSB    4
#define RP23XX_M33_TRCIDR1_TRCARCHMIN_ACCESS "RO"

#define RP23XX_M33_TRCIDR1_REVISION_RESET  0x1
#define RP23XX_M33_TRCIDR1_REVISION_BITS   0x0000000f
#define RP23XX_M33_TRCIDR1_REVISION_MSB    3
#define RP23XX_M33_TRCIDR1_REVISION_LSB    0
#define RP23XX_M33_TRCIDR1_REVISION_ACCESS "RO"

#define RP23XX_M33_TRCIDR2_OFFSET 0x000411e8
#define RP23XX_M33_TRCIDR2_BITS   0x1fffffff
#define RP23XX_M33_TRCIDR2_RESET  0x00000004

#define RP23XX_M33_TRCIDR2_CCSIZE_RESET  0x0
#define RP23XX_M33_TRCIDR2_CCSIZE_BITS   0x1e000000
#define RP23XX_M33_TRCIDR2_CCSIZE_MSB    28
#define RP23XX_M33_TRCIDR2_CCSIZE_LSB    25
#define RP23XX_M33_TRCIDR2_CCSIZE_ACCESS "RO"

#define RP23XX_M33_TRCIDR2_DVSIZE_RESET  0x00
#define RP23XX_M33_TRCIDR2_DVSIZE_BITS   0x01f00000
#define RP23XX_M33_TRCIDR2_DVSIZE_MSB    24
#define RP23XX_M33_TRCIDR2_DVSIZE_LSB    20
#define RP23XX_M33_TRCIDR2_DVSIZE_ACCESS "RO"

#define RP23XX_M33_TRCIDR2_DASIZE_RESET  0x00
#define RP23XX_M33_TRCIDR2_DASIZE_BITS   0x000f8000
#define RP23XX_M33_TRCIDR2_DASIZE_MSB    19
#define RP23XX_M33_TRCIDR2_DASIZE_LSB    15
#define RP23XX_M33_TRCIDR2_DASIZE_ACCESS "RO"

#define RP23XX_M33_TRCIDR2_VMIDSIZE_RESET  0x00
#define RP23XX_M33_TRCIDR2_VMIDSIZE_BITS   0x00007c00
#define RP23XX_M33_TRCIDR2_VMIDSIZE_MSB    14
#define RP23XX_M33_TRCIDR2_VMIDSIZE_LSB    10
#define RP23XX_M33_TRCIDR2_VMIDSIZE_ACCESS "RO"

#define RP23XX_M33_TRCIDR2_CIDSIZE_RESET  0x00
#define RP23XX_M33_TRCIDR2_CIDSIZE_BITS   0x000003e0
#define RP23XX_M33_TRCIDR2_CIDSIZE_MSB    9
#define RP23XX_M33_TRCIDR2_CIDSIZE_LSB    5
#define RP23XX_M33_TRCIDR2_CIDSIZE_ACCESS "RO"

#define RP23XX_M33_TRCIDR2_IASIZE_RESET  0x04
#define RP23XX_M33_TRCIDR2_IASIZE_BITS   0x0000001f
#define RP23XX_M33_TRCIDR2_IASIZE_MSB    4
#define RP23XX_M33_TRCIDR2_IASIZE_LSB    0
#define RP23XX_M33_TRCIDR2_IASIZE_ACCESS "RO"

#define RP23XX_M33_TRCIDR3_OFFSET 0x000411ec
#define RP23XX_M33_TRCIDR3_BITS   0xffff0fff
#define RP23XX_M33_TRCIDR3_RESET  0x0f090004

#define RP23XX_M33_TRCIDR3_NOOVERFLOW_RESET  0x0
#define RP23XX_M33_TRCIDR3_NOOVERFLOW_BITS   0x80000000
#define RP23XX_M33_TRCIDR3_NOOVERFLOW_MSB    31
#define RP23XX_M33_TRCIDR3_NOOVERFLOW_LSB    31
#define RP23XX_M33_TRCIDR3_NOOVERFLOW_ACCESS "RO"

#define RP23XX_M33_TRCIDR3_NUMPROC_RESET  0x0
#define RP23XX_M33_TRCIDR3_NUMPROC_BITS   0x70000000
#define RP23XX_M33_TRCIDR3_NUMPROC_MSB    30
#define RP23XX_M33_TRCIDR3_NUMPROC_LSB    28
#define RP23XX_M33_TRCIDR3_NUMPROC_ACCESS "RO"

#define RP23XX_M33_TRCIDR3_SYSSTALL_RESET  0x1
#define RP23XX_M33_TRCIDR3_SYSSTALL_BITS   0x08000000
#define RP23XX_M33_TRCIDR3_SYSSTALL_MSB    27
#define RP23XX_M33_TRCIDR3_SYSSTALL_LSB    27
#define RP23XX_M33_TRCIDR3_SYSSTALL_ACCESS "RO"

#define RP23XX_M33_TRCIDR3_STALLCTL_RESET  0x1
#define RP23XX_M33_TRCIDR3_STALLCTL_BITS   0x04000000
#define RP23XX_M33_TRCIDR3_STALLCTL_MSB    26
#define RP23XX_M33_TRCIDR3_STALLCTL_LSB    26
#define RP23XX_M33_TRCIDR3_STALLCTL_ACCESS "RO"

#define RP23XX_M33_TRCIDR3_SYNCPR_RESET  0x1
#define RP23XX_M33_TRCIDR3_SYNCPR_BITS   0x02000000
#define RP23XX_M33_TRCIDR3_SYNCPR_MSB    25
#define RP23XX_M33_TRCIDR3_SYNCPR_LSB    25
#define RP23XX_M33_TRCIDR3_SYNCPR_ACCESS "RO"

#define RP23XX_M33_TRCIDR3_TRCERR_RESET  0x1
#define RP23XX_M33_TRCIDR3_TRCERR_BITS   0x01000000
#define RP23XX_M33_TRCIDR3_TRCERR_MSB    24
#define RP23XX_M33_TRCIDR3_TRCERR_LSB    24
#define RP23XX_M33_TRCIDR3_TRCERR_ACCESS "RO"

#define RP23XX_M33_TRCIDR3_EXLEVEL_NS_RESET  0x0
#define RP23XX_M33_TRCIDR3_EXLEVEL_NS_BITS   0x00f00000
#define RP23XX_M33_TRCIDR3_EXLEVEL_NS_MSB    23
#define RP23XX_M33_TRCIDR3_EXLEVEL_NS_LSB    20
#define RP23XX_M33_TRCIDR3_EXLEVEL_NS_ACCESS "RO"

#define RP23XX_M33_TRCIDR3_EXLEVEL_S_RESET  0x9
#define RP23XX_M33_TRCIDR3_EXLEVEL_S_BITS   0x000f0000
#define RP23XX_M33_TRCIDR3_EXLEVEL_S_MSB    19
#define RP23XX_M33_TRCIDR3_EXLEVEL_S_LSB    16
#define RP23XX_M33_TRCIDR3_EXLEVEL_S_ACCESS "RO"

#define RP23XX_M33_TRCIDR3_CCITMIN_RESET  0x004
#define RP23XX_M33_TRCIDR3_CCITMIN_BITS   0x00000fff
#define RP23XX_M33_TRCIDR3_CCITMIN_MSB    11
#define RP23XX_M33_TRCIDR3_CCITMIN_LSB    0
#define RP23XX_M33_TRCIDR3_CCITMIN_ACCESS "RO"

#define RP23XX_M33_TRCIDR4_OFFSET 0x000411f0
#define RP23XX_M33_TRCIDR4_BITS   0xfffff1ff
#define RP23XX_M33_TRCIDR4_RESET  0x00114000

#define RP23XX_M33_TRCIDR4_NUMVMIDC_RESET  0x0
#define RP23XX_M33_TRCIDR4_NUMVMIDC_BITS   0xf0000000
#define RP23XX_M33_TRCIDR4_NUMVMIDC_MSB    31
#define RP23XX_M33_TRCIDR4_NUMVMIDC_LSB    28
#define RP23XX_M33_TRCIDR4_NUMVMIDC_ACCESS "RO"

#define RP23XX_M33_TRCIDR4_NUMCIDC_RESET  0x0
#define RP23XX_M33_TRCIDR4_NUMCIDC_BITS   0x0f000000
#define RP23XX_M33_TRCIDR4_NUMCIDC_MSB    27
#define RP23XX_M33_TRCIDR4_NUMCIDC_LSB    24
#define RP23XX_M33_TRCIDR4_NUMCIDC_ACCESS "RO"

#define RP23XX_M33_TRCIDR4_NUMSSCC_RESET  0x1
#define RP23XX_M33_TRCIDR4_NUMSSCC_BITS   0x00f00000
#define RP23XX_M33_TRCIDR4_NUMSSCC_MSB    23
#define RP23XX_M33_TRCIDR4_NUMSSCC_LSB    20
#define RP23XX_M33_TRCIDR4_NUMSSCC_ACCESS "RO"

#define RP23XX_M33_TRCIDR4_NUMRSPAIR_RESET  0x1
#define RP23XX_M33_TRCIDR4_NUMRSPAIR_BITS   0x000f0000
#define RP23XX_M33_TRCIDR4_NUMRSPAIR_MSB    19
#define RP23XX_M33_TRCIDR4_NUMRSPAIR_LSB    16
#define RP23XX_M33_TRCIDR4_NUMRSPAIR_ACCESS "RO"

#define RP23XX_M33_TRCIDR4_NUMPC_RESET  0x4
#define RP23XX_M33_TRCIDR4_NUMPC_BITS   0x0000f000
#define RP23XX_M33_TRCIDR4_NUMPC_MSB    15
#define RP23XX_M33_TRCIDR4_NUMPC_LSB    12
#define RP23XX_M33_TRCIDR4_NUMPC_ACCESS "RO"

#define RP23XX_M33_TRCIDR4_SUPPDAC_RESET  0x0
#define RP23XX_M33_TRCIDR4_SUPPDAC_BITS   0x00000100
#define RP23XX_M33_TRCIDR4_SUPPDAC_MSB    8
#define RP23XX_M33_TRCIDR4_SUPPDAC_LSB    8
#define RP23XX_M33_TRCIDR4_SUPPDAC_ACCESS "RO"

#define RP23XX_M33_TRCIDR4_NUMDVC_RESET  0x0
#define RP23XX_M33_TRCIDR4_NUMDVC_BITS   0x000000f0
#define RP23XX_M33_TRCIDR4_NUMDVC_MSB    7
#define RP23XX_M33_TRCIDR4_NUMDVC_LSB    4
#define RP23XX_M33_TRCIDR4_NUMDVC_ACCESS "RO"

#define RP23XX_M33_TRCIDR4_NUMACPAIRS_RESET  0x0
#define RP23XX_M33_TRCIDR4_NUMACPAIRS_BITS   0x0000000f
#define RP23XX_M33_TRCIDR4_NUMACPAIRS_MSB    3
#define RP23XX_M33_TRCIDR4_NUMACPAIRS_LSB    0
#define RP23XX_M33_TRCIDR4_NUMACPAIRS_ACCESS "RO"

#define RP23XX_M33_TRCIDR5_OFFSET 0x000411f4
#define RP23XX_M33_TRCIDR5_BITS   0xfeff0fff
#define RP23XX_M33_TRCIDR5_RESET  0x90c70004

#define RP23XX_M33_TRCIDR5_REDFUNCNTR_RESET  0x1
#define RP23XX_M33_TRCIDR5_REDFUNCNTR_BITS   0x80000000
#define RP23XX_M33_TRCIDR5_REDFUNCNTR_MSB    31
#define RP23XX_M33_TRCIDR5_REDFUNCNTR_LSB    31
#define RP23XX_M33_TRCIDR5_REDFUNCNTR_ACCESS "RO"

#define RP23XX_M33_TRCIDR5_NUMCNTR_RESET  0x1
#define RP23XX_M33_TRCIDR5_NUMCNTR_BITS   0x70000000
#define RP23XX_M33_TRCIDR5_NUMCNTR_MSB    30
#define RP23XX_M33_TRCIDR5_NUMCNTR_LSB    28
#define RP23XX_M33_TRCIDR5_NUMCNTR_ACCESS "RO"

#define RP23XX_M33_TRCIDR5_NUMSEQSTATE_RESET  0x0
#define RP23XX_M33_TRCIDR5_NUMSEQSTATE_BITS   0x0e000000
#define RP23XX_M33_TRCIDR5_NUMSEQSTATE_MSB    27
#define RP23XX_M33_TRCIDR5_NUMSEQSTATE_LSB    25
#define RP23XX_M33_TRCIDR5_NUMSEQSTATE_ACCESS "RO"

#define RP23XX_M33_TRCIDR5_LPOVERRIDE_RESET  0x1
#define RP23XX_M33_TRCIDR5_LPOVERRIDE_BITS   0x00800000
#define RP23XX_M33_TRCIDR5_LPOVERRIDE_MSB    23
#define RP23XX_M33_TRCIDR5_LPOVERRIDE_LSB    23
#define RP23XX_M33_TRCIDR5_LPOVERRIDE_ACCESS "RO"

#define RP23XX_M33_TRCIDR5_ATBTRIG_RESET  0x1
#define RP23XX_M33_TRCIDR5_ATBTRIG_BITS   0x00400000
#define RP23XX_M33_TRCIDR5_ATBTRIG_MSB    22
#define RP23XX_M33_TRCIDR5_ATBTRIG_LSB    22
#define RP23XX_M33_TRCIDR5_ATBTRIG_ACCESS "RO"

#define RP23XX_M33_TRCIDR5_TRACEIDSIZE_RESET  0x07
#define RP23XX_M33_TRCIDR5_TRACEIDSIZE_BITS   0x003f0000
#define RP23XX_M33_TRCIDR5_TRACEIDSIZE_MSB    21
#define RP23XX_M33_TRCIDR5_TRACEIDSIZE_LSB    16
#define RP23XX_M33_TRCIDR5_TRACEIDSIZE_ACCESS "RO"

#define RP23XX_M33_TRCIDR5_NUMEXTINSEL_RESET  0x0
#define RP23XX_M33_TRCIDR5_NUMEXTINSEL_BITS   0x00000e00
#define RP23XX_M33_TRCIDR5_NUMEXTINSEL_MSB    11
#define RP23XX_M33_TRCIDR5_NUMEXTINSEL_LSB    9
#define RP23XX_M33_TRCIDR5_NUMEXTINSEL_ACCESS "RO"

#define RP23XX_M33_TRCIDR5_NUMEXTIN_RESET  0x004
#define RP23XX_M33_TRCIDR5_NUMEXTIN_BITS   0x000001ff
#define RP23XX_M33_TRCIDR5_NUMEXTIN_MSB    8
#define RP23XX_M33_TRCIDR5_NUMEXTIN_LSB    0
#define RP23XX_M33_TRCIDR5_NUMEXTIN_ACCESS "RO"

#define RP23XX_M33_TRCIDR6_OFFSET 0x000411f8
#define RP23XX_M33_TRCIDR6_BITS   0x00000000
#define RP23XX_M33_TRCIDR6_RESET  0x00000000
#define RP23XX_M33_TRCIDR6_MSB    31
#define RP23XX_M33_TRCIDR6_LSB    0
#define RP23XX_M33_TRCIDR6_ACCESS "RW"

#define RP23XX_M33_TRCIDR7_OFFSET 0x000411fc
#define RP23XX_M33_TRCIDR7_BITS   0x00000000
#define RP23XX_M33_TRCIDR7_RESET  0x00000000
#define RP23XX_M33_TRCIDR7_MSB    31
#define RP23XX_M33_TRCIDR7_LSB    0
#define RP23XX_M33_TRCIDR7_ACCESS "RW"

#define RP23XX_M33_TRCRSCTLR2_OFFSET 0x00041208
#define RP23XX_M33_TRCRSCTLR2_BITS   0x003700ff
#define RP23XX_M33_TRCRSCTLR2_RESET  0x00000000

#define RP23XX_M33_TRCRSCTLR2_PAIRINV_RESET  0x0
#define RP23XX_M33_TRCRSCTLR2_PAIRINV_BITS   0x00200000
#define RP23XX_M33_TRCRSCTLR2_PAIRINV_MSB    21
#define RP23XX_M33_TRCRSCTLR2_PAIRINV_LSB    21
#define RP23XX_M33_TRCRSCTLR2_PAIRINV_ACCESS "RW"

#define RP23XX_M33_TRCRSCTLR2_INV_RESET  0x0
#define RP23XX_M33_TRCRSCTLR2_INV_BITS   0x00100000
#define RP23XX_M33_TRCRSCTLR2_INV_MSB    20
#define RP23XX_M33_TRCRSCTLR2_INV_LSB    20
#define RP23XX_M33_TRCRSCTLR2_INV_ACCESS "RW"

#define RP23XX_M33_TRCRSCTLR2_GROUP_RESET  0x0
#define RP23XX_M33_TRCRSCTLR2_GROUP_BITS   0x00070000
#define RP23XX_M33_TRCRSCTLR2_GROUP_MSB    18
#define RP23XX_M33_TRCRSCTLR2_GROUP_LSB    16
#define RP23XX_M33_TRCRSCTLR2_GROUP_ACCESS "RW"

#define RP23XX_M33_TRCRSCTLR2_SELECT_RESET  0x00
#define RP23XX_M33_TRCRSCTLR2_SELECT_BITS   0x000000ff
#define RP23XX_M33_TRCRSCTLR2_SELECT_MSB    7
#define RP23XX_M33_TRCRSCTLR2_SELECT_LSB    0
#define RP23XX_M33_TRCRSCTLR2_SELECT_ACCESS "RW"

#define RP23XX_M33_TRCRSCTLR3_OFFSET 0x0004120c
#define RP23XX_M33_TRCRSCTLR3_BITS   0x003700ff
#define RP23XX_M33_TRCRSCTLR3_RESET  0x00000000

#define RP23XX_M33_TRCRSCTLR3_PAIRINV_RESET  0x0
#define RP23XX_M33_TRCRSCTLR3_PAIRINV_BITS   0x00200000
#define RP23XX_M33_TRCRSCTLR3_PAIRINV_MSB    21
#define RP23XX_M33_TRCRSCTLR3_PAIRINV_LSB    21
#define RP23XX_M33_TRCRSCTLR3_PAIRINV_ACCESS "RW"

#define RP23XX_M33_TRCRSCTLR3_INV_RESET  0x0
#define RP23XX_M33_TRCRSCTLR3_INV_BITS   0x00100000
#define RP23XX_M33_TRCRSCTLR3_INV_MSB    20
#define RP23XX_M33_TRCRSCTLR3_INV_LSB    20
#define RP23XX_M33_TRCRSCTLR3_INV_ACCESS "RW"

#define RP23XX_M33_TRCRSCTLR3_GROUP_RESET  0x0
#define RP23XX_M33_TRCRSCTLR3_GROUP_BITS   0x00070000
#define RP23XX_M33_TRCRSCTLR3_GROUP_MSB    18
#define RP23XX_M33_TRCRSCTLR3_GROUP_LSB    16
#define RP23XX_M33_TRCRSCTLR3_GROUP_ACCESS "RW"

#define RP23XX_M33_TRCRSCTLR3_SELECT_RESET  0x00
#define RP23XX_M33_TRCRSCTLR3_SELECT_BITS   0x000000ff
#define RP23XX_M33_TRCRSCTLR3_SELECT_MSB    7
#define RP23XX_M33_TRCRSCTLR3_SELECT_LSB    0
#define RP23XX_M33_TRCRSCTLR3_SELECT_ACCESS "RW"

#define RP23XX_M33_TRCSSCSR_OFFSET 0x000412a0
#define RP23XX_M33_TRCSSCSR_BITS   0x8000000f
#define RP23XX_M33_TRCSSCSR_RESET  0x00000000

#define RP23XX_M33_TRCSSCSR_STATUS_RESET  0x0
#define RP23XX_M33_TRCSSCSR_STATUS_BITS   0x80000000
#define RP23XX_M33_TRCSSCSR_STATUS_MSB    31
#define RP23XX_M33_TRCSSCSR_STATUS_LSB    31
#define RP23XX_M33_TRCSSCSR_STATUS_ACCESS "RW"

#define RP23XX_M33_TRCSSCSR_PC_RESET  0x0
#define RP23XX_M33_TRCSSCSR_PC_BITS   0x00000008
#define RP23XX_M33_TRCSSCSR_PC_MSB    3
#define RP23XX_M33_TRCSSCSR_PC_LSB    3
#define RP23XX_M33_TRCSSCSR_PC_ACCESS "RO"

#define RP23XX_M33_TRCSSCSR_DV_RESET  0x0
#define RP23XX_M33_TRCSSCSR_DV_BITS   0x00000004
#define RP23XX_M33_TRCSSCSR_DV_MSB    2
#define RP23XX_M33_TRCSSCSR_DV_LSB    2
#define RP23XX_M33_TRCSSCSR_DV_ACCESS "RO"

#define RP23XX_M33_TRCSSCSR_DA_RESET  0x0
#define RP23XX_M33_TRCSSCSR_DA_BITS   0x00000002
#define RP23XX_M33_TRCSSCSR_DA_MSB    1
#define RP23XX_M33_TRCSSCSR_DA_LSB    1
#define RP23XX_M33_TRCSSCSR_DA_ACCESS "RO"

#define RP23XX_M33_TRCSSCSR_INST_RESET  0x0
#define RP23XX_M33_TRCSSCSR_INST_BITS   0x00000001
#define RP23XX_M33_TRCSSCSR_INST_MSB    0
#define RP23XX_M33_TRCSSCSR_INST_LSB    0
#define RP23XX_M33_TRCSSCSR_INST_ACCESS "RO"

#define RP23XX_M33_TRCSSPCICR_OFFSET 0x000412c0
#define RP23XX_M33_TRCSSPCICR_BITS   0x0000000f
#define RP23XX_M33_TRCSSPCICR_RESET  0x00000000

#define RP23XX_M33_TRCSSPCICR_PC_RESET  0x0
#define RP23XX_M33_TRCSSPCICR_PC_BITS   0x0000000f
#define RP23XX_M33_TRCSSPCICR_PC_MSB    3
#define RP23XX_M33_TRCSSPCICR_PC_LSB    0
#define RP23XX_M33_TRCSSPCICR_PC_ACCESS "RW"

#define RP23XX_M33_TRCPDCR_OFFSET 0x00041310
#define RP23XX_M33_TRCPDCR_BITS   0x00000008
#define RP23XX_M33_TRCPDCR_RESET  0x00000000

#define RP23XX_M33_TRCPDCR_PU_RESET  0x0
#define RP23XX_M33_TRCPDCR_PU_BITS   0x00000008
#define RP23XX_M33_TRCPDCR_PU_MSB    3
#define RP23XX_M33_TRCPDCR_PU_LSB    3
#define RP23XX_M33_TRCPDCR_PU_ACCESS "RW"

#define RP23XX_M33_TRCPDSR_OFFSET 0x00041314
#define RP23XX_M33_TRCPDSR_BITS   0x00000023
#define RP23XX_M33_TRCPDSR_RESET  0x00000003

#define RP23XX_M33_TRCPDSR_OSLK_RESET  0x0
#define RP23XX_M33_TRCPDSR_OSLK_BITS   0x00000020
#define RP23XX_M33_TRCPDSR_OSLK_MSB    5
#define RP23XX_M33_TRCPDSR_OSLK_LSB    5
#define RP23XX_M33_TRCPDSR_OSLK_ACCESS "RO"

#define RP23XX_M33_TRCPDSR_STICKYPD_RESET  0x1
#define RP23XX_M33_TRCPDSR_STICKYPD_BITS   0x00000002
#define RP23XX_M33_TRCPDSR_STICKYPD_MSB    1
#define RP23XX_M33_TRCPDSR_STICKYPD_LSB    1
#define RP23XX_M33_TRCPDSR_STICKYPD_ACCESS "RO"

#define RP23XX_M33_TRCPDSR_POWER_RESET  0x1
#define RP23XX_M33_TRCPDSR_POWER_BITS   0x00000001
#define RP23XX_M33_TRCPDSR_POWER_MSB    0
#define RP23XX_M33_TRCPDSR_POWER_LSB    0
#define RP23XX_M33_TRCPDSR_POWER_ACCESS "RO"

#define RP23XX_M33_TRCITATBIDR_OFFSET 0x00041ee4
#define RP23XX_M33_TRCITATBIDR_BITS   0x0000007f
#define RP23XX_M33_TRCITATBIDR_RESET  0x00000000

#define RP23XX_M33_TRCITATBIDR_ID_RESET  0x00
#define RP23XX_M33_TRCITATBIDR_ID_BITS   0x0000007f
#define RP23XX_M33_TRCITATBIDR_ID_MSB    6
#define RP23XX_M33_TRCITATBIDR_ID_LSB    0
#define RP23XX_M33_TRCITATBIDR_ID_ACCESS "RW"

#define RP23XX_M33_TRCITIATBINR_OFFSET 0x00041ef4
#define RP23XX_M33_TRCITIATBINR_BITS   0x00000003
#define RP23XX_M33_TRCITIATBINR_RESET  0x00000000

#define RP23XX_M33_TRCITIATBINR_AFVALIDM_RESET  0x0
#define RP23XX_M33_TRCITIATBINR_AFVALIDM_BITS   0x00000002
#define RP23XX_M33_TRCITIATBINR_AFVALIDM_MSB    1
#define RP23XX_M33_TRCITIATBINR_AFVALIDM_LSB    1
#define RP23XX_M33_TRCITIATBINR_AFVALIDM_ACCESS "RW"

#define RP23XX_M33_TRCITIATBINR_ATREADYM_RESET  0x0
#define RP23XX_M33_TRCITIATBINR_ATREADYM_BITS   0x00000001
#define RP23XX_M33_TRCITIATBINR_ATREADYM_MSB    0
#define RP23XX_M33_TRCITIATBINR_ATREADYM_LSB    0
#define RP23XX_M33_TRCITIATBINR_ATREADYM_ACCESS "RW"

#define RP23XX_M33_TRCITIATBOUTR_OFFSET 0x00041efc
#define RP23XX_M33_TRCITIATBOUTR_BITS   0x00000003
#define RP23XX_M33_TRCITIATBOUTR_RESET  0x00000000

#define RP23XX_M33_TRCITIATBOUTR_AFREADY_RESET  0x0
#define RP23XX_M33_TRCITIATBOUTR_AFREADY_BITS   0x00000002
#define RP23XX_M33_TRCITIATBOUTR_AFREADY_MSB    1
#define RP23XX_M33_TRCITIATBOUTR_AFREADY_LSB    1
#define RP23XX_M33_TRCITIATBOUTR_AFREADY_ACCESS "RW"

#define RP23XX_M33_TRCITIATBOUTR_ATVALID_RESET  0x0
#define RP23XX_M33_TRCITIATBOUTR_ATVALID_BITS   0x00000001
#define RP23XX_M33_TRCITIATBOUTR_ATVALID_MSB    0
#define RP23XX_M33_TRCITIATBOUTR_ATVALID_LSB    0
#define RP23XX_M33_TRCITIATBOUTR_ATVALID_ACCESS "RW"

#define RP23XX_M33_TRCCLAIMSET_OFFSET 0x00041fa0
#define RP23XX_M33_TRCCLAIMSET_BITS   0x0000000f
#define RP23XX_M33_TRCCLAIMSET_RESET  0x0000000f

#define RP23XX_M33_TRCCLAIMSET_SET3_RESET  0x1
#define RP23XX_M33_TRCCLAIMSET_SET3_BITS   0x00000008
#define RP23XX_M33_TRCCLAIMSET_SET3_MSB    3
#define RP23XX_M33_TRCCLAIMSET_SET3_LSB    3
#define RP23XX_M33_TRCCLAIMSET_SET3_ACCESS "RW"

#define RP23XX_M33_TRCCLAIMSET_SET2_RESET  0x1
#define RP23XX_M33_TRCCLAIMSET_SET2_BITS   0x00000004
#define RP23XX_M33_TRCCLAIMSET_SET2_MSB    2
#define RP23XX_M33_TRCCLAIMSET_SET2_LSB    2
#define RP23XX_M33_TRCCLAIMSET_SET2_ACCESS "RW"

#define RP23XX_M33_TRCCLAIMSET_SET1_RESET  0x1
#define RP23XX_M33_TRCCLAIMSET_SET1_BITS   0x00000002
#define RP23XX_M33_TRCCLAIMSET_SET1_MSB    1
#define RP23XX_M33_TRCCLAIMSET_SET1_LSB    1
#define RP23XX_M33_TRCCLAIMSET_SET1_ACCESS "RW"

#define RP23XX_M33_TRCCLAIMSET_SET0_RESET  0x1
#define RP23XX_M33_TRCCLAIMSET_SET0_BITS   0x00000001
#define RP23XX_M33_TRCCLAIMSET_SET0_MSB    0
#define RP23XX_M33_TRCCLAIMSET_SET0_LSB    0
#define RP23XX_M33_TRCCLAIMSET_SET0_ACCESS "RW"

#define RP23XX_M33_TRCCLAIMCLR_OFFSET 0x00041fa4
#define RP23XX_M33_TRCCLAIMCLR_BITS   0x0000000f
#define RP23XX_M33_TRCCLAIMCLR_RESET  0x00000000

#define RP23XX_M33_TRCCLAIMCLR_CLR3_RESET  0x0
#define RP23XX_M33_TRCCLAIMCLR_CLR3_BITS   0x00000008
#define RP23XX_M33_TRCCLAIMCLR_CLR3_MSB    3
#define RP23XX_M33_TRCCLAIMCLR_CLR3_LSB    3
#define RP23XX_M33_TRCCLAIMCLR_CLR3_ACCESS "RW"

#define RP23XX_M33_TRCCLAIMCLR_CLR2_RESET  0x0
#define RP23XX_M33_TRCCLAIMCLR_CLR2_BITS   0x00000004
#define RP23XX_M33_TRCCLAIMCLR_CLR2_MSB    2
#define RP23XX_M33_TRCCLAIMCLR_CLR2_LSB    2
#define RP23XX_M33_TRCCLAIMCLR_CLR2_ACCESS "RW"

#define RP23XX_M33_TRCCLAIMCLR_CLR1_RESET  0x0
#define RP23XX_M33_TRCCLAIMCLR_CLR1_BITS   0x00000002
#define RP23XX_M33_TRCCLAIMCLR_CLR1_MSB    1
#define RP23XX_M33_TRCCLAIMCLR_CLR1_LSB    1
#define RP23XX_M33_TRCCLAIMCLR_CLR1_ACCESS "RW"

#define RP23XX_M33_TRCCLAIMCLR_CLR0_RESET  0x0
#define RP23XX_M33_TRCCLAIMCLR_CLR0_BITS   0x00000001
#define RP23XX_M33_TRCCLAIMCLR_CLR0_MSB    0
#define RP23XX_M33_TRCCLAIMCLR_CLR0_LSB    0
#define RP23XX_M33_TRCCLAIMCLR_CLR0_ACCESS "RW"

#define RP23XX_M33_TRCAUTHSTATUS_OFFSET 0x00041fb8
#define RP23XX_M33_TRCAUTHSTATUS_BITS   0x000000ff
#define RP23XX_M33_TRCAUTHSTATUS_RESET  0x00000000

#define RP23XX_M33_TRCAUTHSTATUS_SNID_RESET  0x0
#define RP23XX_M33_TRCAUTHSTATUS_SNID_BITS   0x000000c0
#define RP23XX_M33_TRCAUTHSTATUS_SNID_MSB    7
#define RP23XX_M33_TRCAUTHSTATUS_SNID_LSB    6
#define RP23XX_M33_TRCAUTHSTATUS_SNID_ACCESS "RO"

#define RP23XX_M33_TRCAUTHSTATUS_SID_RESET  0x0
#define RP23XX_M33_TRCAUTHSTATUS_SID_BITS   0x00000030
#define RP23XX_M33_TRCAUTHSTATUS_SID_MSB    5
#define RP23XX_M33_TRCAUTHSTATUS_SID_LSB    4
#define RP23XX_M33_TRCAUTHSTATUS_SID_ACCESS "RO"

#define RP23XX_M33_TRCAUTHSTATUS_NSNID_RESET  0x0
#define RP23XX_M33_TRCAUTHSTATUS_NSNID_BITS   0x0000000c
#define RP23XX_M33_TRCAUTHSTATUS_NSNID_MSB    3
#define RP23XX_M33_TRCAUTHSTATUS_NSNID_LSB    2
#define RP23XX_M33_TRCAUTHSTATUS_NSNID_ACCESS "RO"

#define RP23XX_M33_TRCAUTHSTATUS_NSID_RESET  0x0
#define RP23XX_M33_TRCAUTHSTATUS_NSID_BITS   0x00000003
#define RP23XX_M33_TRCAUTHSTATUS_NSID_MSB    1
#define RP23XX_M33_TRCAUTHSTATUS_NSID_LSB    0
#define RP23XX_M33_TRCAUTHSTATUS_NSID_ACCESS "RO"

#define RP23XX_M33_TRCDEVARCH_OFFSET 0x00041fbc
#define RP23XX_M33_TRCDEVARCH_BITS   0xffffffff
#define RP23XX_M33_TRCDEVARCH_RESET  0x47724a13

#define RP23XX_M33_TRCDEVARCH_ARCHITECT_RESET  0x23b
#define RP23XX_M33_TRCDEVARCH_ARCHITECT_BITS   0xffe00000
#define RP23XX_M33_TRCDEVARCH_ARCHITECT_MSB    31
#define RP23XX_M33_TRCDEVARCH_ARCHITECT_LSB    21
#define RP23XX_M33_TRCDEVARCH_ARCHITECT_ACCESS "RO"

#define RP23XX_M33_TRCDEVARCH_PRESENT_RESET  0x1
#define RP23XX_M33_TRCDEVARCH_PRESENT_BITS   0x00100000
#define RP23XX_M33_TRCDEVARCH_PRESENT_MSB    20
#define RP23XX_M33_TRCDEVARCH_PRESENT_LSB    20
#define RP23XX_M33_TRCDEVARCH_PRESENT_ACCESS "RO"

#define RP23XX_M33_TRCDEVARCH_REVISION_RESET  0x2
#define RP23XX_M33_TRCDEVARCH_REVISION_BITS   0x000f0000
#define RP23XX_M33_TRCDEVARCH_REVISION_MSB    19
#define RP23XX_M33_TRCDEVARCH_REVISION_LSB    16
#define RP23XX_M33_TRCDEVARCH_REVISION_ACCESS "RO"

#define RP23XX_M33_TRCDEVARCH_ARCHID_RESET  0x4a13
#define RP23XX_M33_TRCDEVARCH_ARCHID_BITS   0x0000ffff
#define RP23XX_M33_TRCDEVARCH_ARCHID_MSB    15
#define RP23XX_M33_TRCDEVARCH_ARCHID_LSB    0
#define RP23XX_M33_TRCDEVARCH_ARCHID_ACCESS "RO"

#define RP23XX_M33_TRCDEVID_OFFSET 0x00041fc8
#define RP23XX_M33_TRCDEVID_BITS   0x00000000
#define RP23XX_M33_TRCDEVID_RESET  0x00000000
#define RP23XX_M33_TRCDEVID_MSB    31
#define RP23XX_M33_TRCDEVID_LSB    0
#define RP23XX_M33_TRCDEVID_ACCESS "RW"

#define RP23XX_M33_TRCDEVTYPE_OFFSET 0x00041fcc
#define RP23XX_M33_TRCDEVTYPE_BITS   0x000000ff
#define RP23XX_M33_TRCDEVTYPE_RESET  0x00000013

#define RP23XX_M33_TRCDEVTYPE_SUB_RESET  0x1
#define RP23XX_M33_TRCDEVTYPE_SUB_BITS   0x000000f0
#define RP23XX_M33_TRCDEVTYPE_SUB_MSB    7
#define RP23XX_M33_TRCDEVTYPE_SUB_LSB    4
#define RP23XX_M33_TRCDEVTYPE_SUB_ACCESS "RO"

#define RP23XX_M33_TRCDEVTYPE_MAJOR_RESET  0x3
#define RP23XX_M33_TRCDEVTYPE_MAJOR_BITS   0x0000000f
#define RP23XX_M33_TRCDEVTYPE_MAJOR_MSB    3
#define RP23XX_M33_TRCDEVTYPE_MAJOR_LSB    0
#define RP23XX_M33_TRCDEVTYPE_MAJOR_ACCESS "RO"

#define RP23XX_M33_TRCPIDR4_OFFSET 0x00041fd0
#define RP23XX_M33_TRCPIDR4_BITS   0x000000ff
#define RP23XX_M33_TRCPIDR4_RESET  0x00000004

#define RP23XX_M33_TRCPIDR4_SIZE_RESET  0x0
#define RP23XX_M33_TRCPIDR4_SIZE_BITS   0x000000f0
#define RP23XX_M33_TRCPIDR4_SIZE_MSB    7
#define RP23XX_M33_TRCPIDR4_SIZE_LSB    4
#define RP23XX_M33_TRCPIDR4_SIZE_ACCESS "RO"

#define RP23XX_M33_TRCPIDR4_DES_2_RESET  0x4
#define RP23XX_M33_TRCPIDR4_DES_2_BITS   0x0000000f
#define RP23XX_M33_TRCPIDR4_DES_2_MSB    3
#define RP23XX_M33_TRCPIDR4_DES_2_LSB    0
#define RP23XX_M33_TRCPIDR4_DES_2_ACCESS "RO"

#define RP23XX_M33_TRCPIDR5_OFFSET 0x00041fd4
#define RP23XX_M33_TRCPIDR5_BITS   0x00000000
#define RP23XX_M33_TRCPIDR5_RESET  0x00000000
#define RP23XX_M33_TRCPIDR5_MSB    31
#define RP23XX_M33_TRCPIDR5_LSB    0
#define RP23XX_M33_TRCPIDR5_ACCESS "RW"

#define RP23XX_M33_TRCPIDR6_OFFSET 0x00041fd8
#define RP23XX_M33_TRCPIDR6_BITS   0x00000000
#define RP23XX_M33_TRCPIDR6_RESET  0x00000000
#define RP23XX_M33_TRCPIDR6_MSB    31
#define RP23XX_M33_TRCPIDR6_LSB    0
#define RP23XX_M33_TRCPIDR6_ACCESS "RW"

#define RP23XX_M33_TRCPIDR7_OFFSET 0x00041fdc
#define RP23XX_M33_TRCPIDR7_BITS   0x00000000
#define RP23XX_M33_TRCPIDR7_RESET  0x00000000
#define RP23XX_M33_TRCPIDR7_MSB    31
#define RP23XX_M33_TRCPIDR7_LSB    0
#define RP23XX_M33_TRCPIDR7_ACCESS "RW"

#define RP23XX_M33_TRCPIDR0_OFFSET 0x00041fe0
#define RP23XX_M33_TRCPIDR0_BITS   0x000000ff
#define RP23XX_M33_TRCPIDR0_RESET  0x00000021

#define RP23XX_M33_TRCPIDR0_PART_0_RESET  0x21
#define RP23XX_M33_TRCPIDR0_PART_0_BITS   0x000000ff
#define RP23XX_M33_TRCPIDR0_PART_0_MSB    7
#define RP23XX_M33_TRCPIDR0_PART_0_LSB    0
#define RP23XX_M33_TRCPIDR0_PART_0_ACCESS "RO"

#define RP23XX_M33_TRCPIDR1_OFFSET 0x00041fe4
#define RP23XX_M33_TRCPIDR1_BITS   0x000000ff
#define RP23XX_M33_TRCPIDR1_RESET  0x000000bd

#define RP23XX_M33_TRCPIDR1_DES_0_RESET  0xb
#define RP23XX_M33_TRCPIDR1_DES_0_BITS   0x000000f0
#define RP23XX_M33_TRCPIDR1_DES_0_MSB    7
#define RP23XX_M33_TRCPIDR1_DES_0_LSB    4
#define RP23XX_M33_TRCPIDR1_DES_0_ACCESS "RO"

#define RP23XX_M33_TRCPIDR1_PART_0_RESET  0xd
#define RP23XX_M33_TRCPIDR1_PART_0_BITS   0x0000000f
#define RP23XX_M33_TRCPIDR1_PART_0_MSB    3
#define RP23XX_M33_TRCPIDR1_PART_0_LSB    0
#define RP23XX_M33_TRCPIDR1_PART_0_ACCESS "RO"

#define RP23XX_M33_TRCPIDR2_OFFSET 0x00041fe8
#define RP23XX_M33_TRCPIDR2_BITS   0x000000ff
#define RP23XX_M33_TRCPIDR2_RESET  0x0000002b

#define RP23XX_M33_TRCPIDR2_REVISION_RESET  0x2
#define RP23XX_M33_TRCPIDR2_REVISION_BITS   0x000000f0
#define RP23XX_M33_TRCPIDR2_REVISION_MSB    7
#define RP23XX_M33_TRCPIDR2_REVISION_LSB    4
#define RP23XX_M33_TRCPIDR2_REVISION_ACCESS "RO"

#define RP23XX_M33_TRCPIDR2_JEDEC_RESET  0x1
#define RP23XX_M33_TRCPIDR2_JEDEC_BITS   0x00000008
#define RP23XX_M33_TRCPIDR2_JEDEC_MSB    3
#define RP23XX_M33_TRCPIDR2_JEDEC_LSB    3
#define RP23XX_M33_TRCPIDR2_JEDEC_ACCESS "RO"

#define RP23XX_M33_TRCPIDR2_DES_0_RESET  0x3
#define RP23XX_M33_TRCPIDR2_DES_0_BITS   0x00000007
#define RP23XX_M33_TRCPIDR2_DES_0_MSB    2
#define RP23XX_M33_TRCPIDR2_DES_0_LSB    0
#define RP23XX_M33_TRCPIDR2_DES_0_ACCESS "RO"

#define RP23XX_M33_TRCPIDR3_OFFSET 0x00041fec
#define RP23XX_M33_TRCPIDR3_BITS   0x000000ff
#define RP23XX_M33_TRCPIDR3_RESET  0x00000000

#define RP23XX_M33_TRCPIDR3_REVAND_RESET  0x0
#define RP23XX_M33_TRCPIDR3_REVAND_BITS   0x000000f0
#define RP23XX_M33_TRCPIDR3_REVAND_MSB    7
#define RP23XX_M33_TRCPIDR3_REVAND_LSB    4
#define RP23XX_M33_TRCPIDR3_REVAND_ACCESS "RO"

#define RP23XX_M33_TRCPIDR3_CMOD_RESET  0x0
#define RP23XX_M33_TRCPIDR3_CMOD_BITS   0x0000000f
#define RP23XX_M33_TRCPIDR3_CMOD_MSB    3
#define RP23XX_M33_TRCPIDR3_CMOD_LSB    0
#define RP23XX_M33_TRCPIDR3_CMOD_ACCESS "RO"

#define RP23XX_M33_TRCCIDR0_OFFSET 0x00041ff0
#define RP23XX_M33_TRCCIDR0_BITS   0x000000ff
#define RP23XX_M33_TRCCIDR0_RESET  0x0000000d

#define RP23XX_M33_TRCCIDR0_PRMBL_0_RESET  0x0d
#define RP23XX_M33_TRCCIDR0_PRMBL_0_BITS   0x000000ff
#define RP23XX_M33_TRCCIDR0_PRMBL_0_MSB    7
#define RP23XX_M33_TRCCIDR0_PRMBL_0_LSB    0
#define RP23XX_M33_TRCCIDR0_PRMBL_0_ACCESS "RO"

#define RP23XX_M33_TRCCIDR1_OFFSET 0x00041ff4
#define RP23XX_M33_TRCCIDR1_BITS   0x000000ff
#define RP23XX_M33_TRCCIDR1_RESET  0x00000090

#define RP23XX_M33_TRCCIDR1_CLASS_RESET  0x9
#define RP23XX_M33_TRCCIDR1_CLASS_BITS   0x000000f0
#define RP23XX_M33_TRCCIDR1_CLASS_MSB    7
#define RP23XX_M33_TRCCIDR1_CLASS_LSB    4
#define RP23XX_M33_TRCCIDR1_CLASS_ACCESS "RO"

#define RP23XX_M33_TRCCIDR1_PRMBL_1_RESET  0x0
#define RP23XX_M33_TRCCIDR1_PRMBL_1_BITS   0x0000000f
#define RP23XX_M33_TRCCIDR1_PRMBL_1_MSB    3
#define RP23XX_M33_TRCCIDR1_PRMBL_1_LSB    0
#define RP23XX_M33_TRCCIDR1_PRMBL_1_ACCESS "RO"

#define RP23XX_M33_TRCCIDR2_OFFSET 0x00041ff8
#define RP23XX_M33_TRCCIDR2_BITS   0x000000ff
#define RP23XX_M33_TRCCIDR2_RESET  0x00000005

#define RP23XX_M33_TRCCIDR2_PRMBL_2_RESET  0x05
#define RP23XX_M33_TRCCIDR2_PRMBL_2_BITS   0x000000ff
#define RP23XX_M33_TRCCIDR2_PRMBL_2_MSB    7
#define RP23XX_M33_TRCCIDR2_PRMBL_2_LSB    0
#define RP23XX_M33_TRCCIDR2_PRMBL_2_ACCESS "RO"

#define RP23XX_M33_TRCCIDR3_OFFSET 0x00041ffc
#define RP23XX_M33_TRCCIDR3_BITS   0x000000ff
#define RP23XX_M33_TRCCIDR3_RESET  0x000000b1

#define RP23XX_M33_TRCCIDR3_PRMBL_3_RESET  0xb1
#define RP23XX_M33_TRCCIDR3_PRMBL_3_BITS   0x000000ff
#define RP23XX_M33_TRCCIDR3_PRMBL_3_MSB    7
#define RP23XX_M33_TRCCIDR3_PRMBL_3_LSB    0
#define RP23XX_M33_TRCCIDR3_PRMBL_3_ACCESS "RO"

#define RP23XX_M33_CTICONTROL_OFFSET 0x00042000
#define RP23XX_M33_CTICONTROL_BITS   0x00000001
#define RP23XX_M33_CTICONTROL_RESET  0x00000000

#define RP23XX_M33_CTICONTROL_GLBEN_RESET  0x0
#define RP23XX_M33_CTICONTROL_GLBEN_BITS   0x00000001
#define RP23XX_M33_CTICONTROL_GLBEN_MSB    0
#define RP23XX_M33_CTICONTROL_GLBEN_LSB    0
#define RP23XX_M33_CTICONTROL_GLBEN_ACCESS "RW"

#define RP23XX_M33_CTIINTACK_OFFSET 0x00042010
#define RP23XX_M33_CTIINTACK_BITS   0x000000ff
#define RP23XX_M33_CTIINTACK_RESET  0x00000000

#define RP23XX_M33_CTIINTACK_INTACK_RESET  0x00
#define RP23XX_M33_CTIINTACK_INTACK_BITS   0x000000ff
#define RP23XX_M33_CTIINTACK_INTACK_MSB    7
#define RP23XX_M33_CTIINTACK_INTACK_LSB    0
#define RP23XX_M33_CTIINTACK_INTACK_ACCESS "RW"

#define RP23XX_M33_CTIAPPSET_OFFSET 0x00042014
#define RP23XX_M33_CTIAPPSET_BITS   0x0000000f
#define RP23XX_M33_CTIAPPSET_RESET  0x00000000

#define RP23XX_M33_CTIAPPSET_APPSET_RESET  0x0
#define RP23XX_M33_CTIAPPSET_APPSET_BITS   0x0000000f
#define RP23XX_M33_CTIAPPSET_APPSET_MSB    3
#define RP23XX_M33_CTIAPPSET_APPSET_LSB    0
#define RP23XX_M33_CTIAPPSET_APPSET_ACCESS "RW"

#define RP23XX_M33_CTIAPPCLEAR_OFFSET 0x00042018
#define RP23XX_M33_CTIAPPCLEAR_BITS   0x0000000f
#define RP23XX_M33_CTIAPPCLEAR_RESET  0x00000000

#define RP23XX_M33_CTIAPPCLEAR_APPCLEAR_RESET  0x0
#define RP23XX_M33_CTIAPPCLEAR_APPCLEAR_BITS   0x0000000f
#define RP23XX_M33_CTIAPPCLEAR_APPCLEAR_MSB    3
#define RP23XX_M33_CTIAPPCLEAR_APPCLEAR_LSB    0
#define RP23XX_M33_CTIAPPCLEAR_APPCLEAR_ACCESS "RW"

#define RP23XX_M33_CTIAPPPULSE_OFFSET 0x0004201c
#define RP23XX_M33_CTIAPPPULSE_BITS   0x0000000f
#define RP23XX_M33_CTIAPPPULSE_RESET  0x00000000

#define RP23XX_M33_CTIAPPPULSE_APPULSE_RESET  0x0
#define RP23XX_M33_CTIAPPPULSE_APPULSE_BITS   0x0000000f
#define RP23XX_M33_CTIAPPPULSE_APPULSE_MSB    3
#define RP23XX_M33_CTIAPPPULSE_APPULSE_LSB    0
#define RP23XX_M33_CTIAPPPULSE_APPULSE_ACCESS "RW"

#define RP23XX_M33_CTIINEN0_OFFSET 0x00042020
#define RP23XX_M33_CTIINEN0_BITS   0x0000000f
#define RP23XX_M33_CTIINEN0_RESET  0x00000000

#define RP23XX_M33_CTIINEN0_TRIGINEN_RESET  0x0
#define RP23XX_M33_CTIINEN0_TRIGINEN_BITS   0x0000000f
#define RP23XX_M33_CTIINEN0_TRIGINEN_MSB    3
#define RP23XX_M33_CTIINEN0_TRIGINEN_LSB    0
#define RP23XX_M33_CTIINEN0_TRIGINEN_ACCESS "RW"

#define RP23XX_M33_CTIINEN1_OFFSET 0x00042024
#define RP23XX_M33_CTIINEN1_BITS   0x0000000f
#define RP23XX_M33_CTIINEN1_RESET  0x00000000

#define RP23XX_M33_CTIINEN1_TRIGINEN_RESET  0x0
#define RP23XX_M33_CTIINEN1_TRIGINEN_BITS   0x0000000f
#define RP23XX_M33_CTIINEN1_TRIGINEN_MSB    3
#define RP23XX_M33_CTIINEN1_TRIGINEN_LSB    0
#define RP23XX_M33_CTIINEN1_TRIGINEN_ACCESS "RW"

#define RP23XX_M33_CTIINEN2_OFFSET 0x00042028
#define RP23XX_M33_CTIINEN2_BITS   0x0000000f
#define RP23XX_M33_CTIINEN2_RESET  0x00000000

#define RP23XX_M33_CTIINEN2_TRIGINEN_RESET  0x0
#define RP23XX_M33_CTIINEN2_TRIGINEN_BITS   0x0000000f
#define RP23XX_M33_CTIINEN2_TRIGINEN_MSB    3
#define RP23XX_M33_CTIINEN2_TRIGINEN_LSB    0
#define RP23XX_M33_CTIINEN2_TRIGINEN_ACCESS "RW"

#define RP23XX_M33_CTIINEN3_OFFSET 0x0004202c
#define RP23XX_M33_CTIINEN3_BITS   0x0000000f
#define RP23XX_M33_CTIINEN3_RESET  0x00000000

#define RP23XX_M33_CTIINEN3_TRIGINEN_RESET  0x0
#define RP23XX_M33_CTIINEN3_TRIGINEN_BITS   0x0000000f
#define RP23XX_M33_CTIINEN3_TRIGINEN_MSB    3
#define RP23XX_M33_CTIINEN3_TRIGINEN_LSB    0
#define RP23XX_M33_CTIINEN3_TRIGINEN_ACCESS "RW"

#define RP23XX_M33_CTIINEN4_OFFSET 0x00042030
#define RP23XX_M33_CTIINEN4_BITS   0x0000000f
#define RP23XX_M33_CTIINEN4_RESET  0x00000000

#define RP23XX_M33_CTIINEN4_TRIGINEN_RESET  0x0
#define RP23XX_M33_CTIINEN4_TRIGINEN_BITS   0x0000000f
#define RP23XX_M33_CTIINEN4_TRIGINEN_MSB    3
#define RP23XX_M33_CTIINEN4_TRIGINEN_LSB    0
#define RP23XX_M33_CTIINEN4_TRIGINEN_ACCESS "RW"

#define RP23XX_M33_CTIINEN5_OFFSET 0x00042034
#define RP23XX_M33_CTIINEN5_BITS   0x0000000f
#define RP23XX_M33_CTIINEN5_RESET  0x00000000

#define RP23XX_M33_CTIINEN5_TRIGINEN_RESET  0x0
#define RP23XX_M33_CTIINEN5_TRIGINEN_BITS   0x0000000f
#define RP23XX_M33_CTIINEN5_TRIGINEN_MSB    3
#define RP23XX_M33_CTIINEN5_TRIGINEN_LSB    0
#define RP23XX_M33_CTIINEN5_TRIGINEN_ACCESS "RW"

#define RP23XX_M33_CTIINEN6_OFFSET 0x00042038
#define RP23XX_M33_CTIINEN6_BITS   0x0000000f
#define RP23XX_M33_CTIINEN6_RESET  0x00000000

#define RP23XX_M33_CTIINEN6_TRIGINEN_RESET  0x0
#define RP23XX_M33_CTIINEN6_TRIGINEN_BITS   0x0000000f
#define RP23XX_M33_CTIINEN6_TRIGINEN_MSB    3
#define RP23XX_M33_CTIINEN6_TRIGINEN_LSB    0
#define RP23XX_M33_CTIINEN6_TRIGINEN_ACCESS "RW"

#define RP23XX_M33_CTIINEN7_OFFSET 0x0004203c
#define RP23XX_M33_CTIINEN7_BITS   0x0000000f
#define RP23XX_M33_CTIINEN7_RESET  0x00000000

#define RP23XX_M33_CTIINEN7_TRIGINEN_RESET  0x0
#define RP23XX_M33_CTIINEN7_TRIGINEN_BITS   0x0000000f
#define RP23XX_M33_CTIINEN7_TRIGINEN_MSB    3
#define RP23XX_M33_CTIINEN7_TRIGINEN_LSB    0
#define RP23XX_M33_CTIINEN7_TRIGINEN_ACCESS "RW"

#define RP23XX_M33_CTIOUTEN0_OFFSET 0x000420a0
#define RP23XX_M33_CTIOUTEN0_BITS   0x0000000f
#define RP23XX_M33_CTIOUTEN0_RESET  0x00000000

#define RP23XX_M33_CTIOUTEN0_TRIGOUTEN_RESET  0x0
#define RP23XX_M33_CTIOUTEN0_TRIGOUTEN_BITS   0x0000000f
#define RP23XX_M33_CTIOUTEN0_TRIGOUTEN_MSB    3
#define RP23XX_M33_CTIOUTEN0_TRIGOUTEN_LSB    0
#define RP23XX_M33_CTIOUTEN0_TRIGOUTEN_ACCESS "RW"

#define RP23XX_M33_CTIOUTEN1_OFFSET 0x000420a4
#define RP23XX_M33_CTIOUTEN1_BITS   0x0000000f
#define RP23XX_M33_CTIOUTEN1_RESET  0x00000000

#define RP23XX_M33_CTIOUTEN1_TRIGOUTEN_RESET  0x0
#define RP23XX_M33_CTIOUTEN1_TRIGOUTEN_BITS   0x0000000f
#define RP23XX_M33_CTIOUTEN1_TRIGOUTEN_MSB    3
#define RP23XX_M33_CTIOUTEN1_TRIGOUTEN_LSB    0
#define RP23XX_M33_CTIOUTEN1_TRIGOUTEN_ACCESS "RW"

#define RP23XX_M33_CTIOUTEN2_OFFSET 0x000420a8
#define RP23XX_M33_CTIOUTEN2_BITS   0x0000000f
#define RP23XX_M33_CTIOUTEN2_RESET  0x00000000

#define RP23XX_M33_CTIOUTEN2_TRIGOUTEN_RESET  0x0
#define RP23XX_M33_CTIOUTEN2_TRIGOUTEN_BITS   0x0000000f
#define RP23XX_M33_CTIOUTEN2_TRIGOUTEN_MSB    3
#define RP23XX_M33_CTIOUTEN2_TRIGOUTEN_LSB    0
#define RP23XX_M33_CTIOUTEN2_TRIGOUTEN_ACCESS "RW"

#define RP23XX_M33_CTIOUTEN3_OFFSET 0x000420ac
#define RP23XX_M33_CTIOUTEN3_BITS   0x0000000f
#define RP23XX_M33_CTIOUTEN3_RESET  0x00000000

#define RP23XX_M33_CTIOUTEN3_TRIGOUTEN_RESET  0x0
#define RP23XX_M33_CTIOUTEN3_TRIGOUTEN_BITS   0x0000000f
#define RP23XX_M33_CTIOUTEN3_TRIGOUTEN_MSB    3
#define RP23XX_M33_CTIOUTEN3_TRIGOUTEN_LSB    0
#define RP23XX_M33_CTIOUTEN3_TRIGOUTEN_ACCESS "RW"

#define RP23XX_M33_CTIOUTEN4_OFFSET 0x000420b0
#define RP23XX_M33_CTIOUTEN4_BITS   0x0000000f
#define RP23XX_M33_CTIOUTEN4_RESET  0x00000000

#define RP23XX_M33_CTIOUTEN4_TRIGOUTEN_RESET  0x0
#define RP23XX_M33_CTIOUTEN4_TRIGOUTEN_BITS   0x0000000f
#define RP23XX_M33_CTIOUTEN4_TRIGOUTEN_MSB    3
#define RP23XX_M33_CTIOUTEN4_TRIGOUTEN_LSB    0
#define RP23XX_M33_CTIOUTEN4_TRIGOUTEN_ACCESS "RW"

#define RP23XX_M33_CTIOUTEN5_OFFSET 0x000420b4
#define RP23XX_M33_CTIOUTEN5_BITS   0x0000000f
#define RP23XX_M33_CTIOUTEN5_RESET  0x00000000

#define RP23XX_M33_CTIOUTEN5_TRIGOUTEN_RESET  0x0
#define RP23XX_M33_CTIOUTEN5_TRIGOUTEN_BITS   0x0000000f
#define RP23XX_M33_CTIOUTEN5_TRIGOUTEN_MSB    3
#define RP23XX_M33_CTIOUTEN5_TRIGOUTEN_LSB    0
#define RP23XX_M33_CTIOUTEN5_TRIGOUTEN_ACCESS "RW"

#define RP23XX_M33_CTIOUTEN6_OFFSET 0x000420b8
#define RP23XX_M33_CTIOUTEN6_BITS   0x0000000f
#define RP23XX_M33_CTIOUTEN6_RESET  0x00000000

#define RP23XX_M33_CTIOUTEN6_TRIGOUTEN_RESET  0x0
#define RP23XX_M33_CTIOUTEN6_TRIGOUTEN_BITS   0x0000000f
#define RP23XX_M33_CTIOUTEN6_TRIGOUTEN_MSB    3
#define RP23XX_M33_CTIOUTEN6_TRIGOUTEN_LSB    0
#define RP23XX_M33_CTIOUTEN6_TRIGOUTEN_ACCESS "RW"

#define RP23XX_M33_CTIOUTEN7_OFFSET 0x000420bc
#define RP23XX_M33_CTIOUTEN7_BITS   0x0000000f
#define RP23XX_M33_CTIOUTEN7_RESET  0x00000000

#define RP23XX_M33_CTIOUTEN7_TRIGOUTEN_RESET  0x0
#define RP23XX_M33_CTIOUTEN7_TRIGOUTEN_BITS   0x0000000f
#define RP23XX_M33_CTIOUTEN7_TRIGOUTEN_MSB    3
#define RP23XX_M33_CTIOUTEN7_TRIGOUTEN_LSB    0
#define RP23XX_M33_CTIOUTEN7_TRIGOUTEN_ACCESS "RW"

#define RP23XX_M33_CTITRIGINSTATUS_OFFSET 0x00042130
#define RP23XX_M33_CTITRIGINSTATUS_BITS   0x000000ff
#define RP23XX_M33_CTITRIGINSTATUS_RESET  0x00000000

#define RP23XX_M33_CTITRIGINSTATUS_TRIGINSTATUS_RESET  0x00
#define RP23XX_M33_CTITRIGINSTATUS_TRIGINSTATUS_BITS   0x000000ff
#define RP23XX_M33_CTITRIGINSTATUS_TRIGINSTATUS_MSB    7
#define RP23XX_M33_CTITRIGINSTATUS_TRIGINSTATUS_LSB    0
#define RP23XX_M33_CTITRIGINSTATUS_TRIGINSTATUS_ACCESS "RO"

#define RP23XX_M33_CTITRIGOUTSTATUS_OFFSET 0x00042134
#define RP23XX_M33_CTITRIGOUTSTATUS_BITS   0x000000ff
#define RP23XX_M33_CTITRIGOUTSTATUS_RESET  0x00000000

#define RP23XX_M33_CTITRIGOUTSTATUS_TRIGOUTSTATUS_RESET  0x00
#define RP23XX_M33_CTITRIGOUTSTATUS_TRIGOUTSTATUS_BITS   0x000000ff
#define RP23XX_M33_CTITRIGOUTSTATUS_TRIGOUTSTATUS_MSB    7
#define RP23XX_M33_CTITRIGOUTSTATUS_TRIGOUTSTATUS_LSB    0
#define RP23XX_M33_CTITRIGOUTSTATUS_TRIGOUTSTATUS_ACCESS "RO"

#define RP23XX_M33_CTICHINSTATUS_OFFSET 0x00042138
#define RP23XX_M33_CTICHINSTATUS_BITS   0x0000000f
#define RP23XX_M33_CTICHINSTATUS_RESET  0x00000000

#define RP23XX_M33_CTICHINSTATUS_CTICHOUTSTATUS_RESET  0x0
#define RP23XX_M33_CTICHINSTATUS_CTICHOUTSTATUS_BITS   0x0000000f
#define RP23XX_M33_CTICHINSTATUS_CTICHOUTSTATUS_MSB    3
#define RP23XX_M33_CTICHINSTATUS_CTICHOUTSTATUS_LSB    0
#define RP23XX_M33_CTICHINSTATUS_CTICHOUTSTATUS_ACCESS "RO"

#define RP23XX_M33_CTIGATE_OFFSET 0x00042140
#define RP23XX_M33_CTIGATE_BITS   0x0000000f
#define RP23XX_M33_CTIGATE_RESET  0x0000000f

#define RP23XX_M33_CTIGATE_CTIGATEEN3_RESET  0x1
#define RP23XX_M33_CTIGATE_CTIGATEEN3_BITS   0x00000008
#define RP23XX_M33_CTIGATE_CTIGATEEN3_MSB    3
#define RP23XX_M33_CTIGATE_CTIGATEEN3_LSB    3
#define RP23XX_M33_CTIGATE_CTIGATEEN3_ACCESS "RW"

#define RP23XX_M33_CTIGATE_CTIGATEEN2_RESET  0x1
#define RP23XX_M33_CTIGATE_CTIGATEEN2_BITS   0x00000004
#define RP23XX_M33_CTIGATE_CTIGATEEN2_MSB    2
#define RP23XX_M33_CTIGATE_CTIGATEEN2_LSB    2
#define RP23XX_M33_CTIGATE_CTIGATEEN2_ACCESS "RW"

#define RP23XX_M33_CTIGATE_CTIGATEEN1_RESET  0x1
#define RP23XX_M33_CTIGATE_CTIGATEEN1_BITS   0x00000002
#define RP23XX_M33_CTIGATE_CTIGATEEN1_MSB    1
#define RP23XX_M33_CTIGATE_CTIGATEEN1_LSB    1
#define RP23XX_M33_CTIGATE_CTIGATEEN1_ACCESS "RW"

#define RP23XX_M33_CTIGATE_CTIGATEEN0_RESET  0x1
#define RP23XX_M33_CTIGATE_CTIGATEEN0_BITS   0x00000001
#define RP23XX_M33_CTIGATE_CTIGATEEN0_MSB    0
#define RP23XX_M33_CTIGATE_CTIGATEEN0_LSB    0
#define RP23XX_M33_CTIGATE_CTIGATEEN0_ACCESS "RW"

#define RP23XX_M33_ASICCTL_OFFSET 0x00042144
#define RP23XX_M33_ASICCTL_BITS   0x00000000
#define RP23XX_M33_ASICCTL_RESET  0x00000000
#define RP23XX_M33_ASICCTL_MSB    31
#define RP23XX_M33_ASICCTL_LSB    0
#define RP23XX_M33_ASICCTL_ACCESS "RW"

#define RP23XX_M33_ITCHOUT_OFFSET 0x00042ee4
#define RP23XX_M33_ITCHOUT_BITS   0x0000000f
#define RP23XX_M33_ITCHOUT_RESET  0x00000000

#define RP23XX_M33_ITCHOUT_CTCHOUT_RESET  0x0
#define RP23XX_M33_ITCHOUT_CTCHOUT_BITS   0x0000000f
#define RP23XX_M33_ITCHOUT_CTCHOUT_MSB    3
#define RP23XX_M33_ITCHOUT_CTCHOUT_LSB    0
#define RP23XX_M33_ITCHOUT_CTCHOUT_ACCESS "RW"

#define RP23XX_M33_ITTRIGOUT_OFFSET 0x00042ee8
#define RP23XX_M33_ITTRIGOUT_BITS   0x000000ff
#define RP23XX_M33_ITTRIGOUT_RESET  0x00000000

#define RP23XX_M33_ITTRIGOUT_CTTRIGOUT_RESET  0x00
#define RP23XX_M33_ITTRIGOUT_CTTRIGOUT_BITS   0x000000ff
#define RP23XX_M33_ITTRIGOUT_CTTRIGOUT_MSB    7
#define RP23XX_M33_ITTRIGOUT_CTTRIGOUT_LSB    0
#define RP23XX_M33_ITTRIGOUT_CTTRIGOUT_ACCESS "RW"

#define RP23XX_M33_ITCHIN_OFFSET 0x00042ef4
#define RP23XX_M33_ITCHIN_BITS   0x0000000f
#define RP23XX_M33_ITCHIN_RESET  0x00000000

#define RP23XX_M33_ITCHIN_CTCHIN_RESET  0x0
#define RP23XX_M33_ITCHIN_CTCHIN_BITS   0x0000000f
#define RP23XX_M33_ITCHIN_CTCHIN_MSB    3
#define RP23XX_M33_ITCHIN_CTCHIN_LSB    0
#define RP23XX_M33_ITCHIN_CTCHIN_ACCESS "RO"

#define RP23XX_M33_ITCTRL_OFFSET 0x00042f00
#define RP23XX_M33_ITCTRL_BITS   0x00000001
#define RP23XX_M33_ITCTRL_RESET  0x00000000

#define RP23XX_M33_ITCTRL_IME_RESET  0x0
#define RP23XX_M33_ITCTRL_IME_BITS   0x00000001
#define RP23XX_M33_ITCTRL_IME_MSB    0
#define RP23XX_M33_ITCTRL_IME_LSB    0
#define RP23XX_M33_ITCTRL_IME_ACCESS "RW"

#define RP23XX_M33_DEVARCH_OFFSET 0x00042fbc
#define RP23XX_M33_DEVARCH_BITS   0xffffffff
#define RP23XX_M33_DEVARCH_RESET  0x47701a14

#define RP23XX_M33_DEVARCH_ARCHITECT_RESET  0x23b
#define RP23XX_M33_DEVARCH_ARCHITECT_BITS   0xffe00000
#define RP23XX_M33_DEVARCH_ARCHITECT_MSB    31
#define RP23XX_M33_DEVARCH_ARCHITECT_LSB    21
#define RP23XX_M33_DEVARCH_ARCHITECT_ACCESS "RO"

#define RP23XX_M33_DEVARCH_PRESENT_RESET  0x1
#define RP23XX_M33_DEVARCH_PRESENT_BITS   0x00100000
#define RP23XX_M33_DEVARCH_PRESENT_MSB    20
#define RP23XX_M33_DEVARCH_PRESENT_LSB    20
#define RP23XX_M33_DEVARCH_PRESENT_ACCESS "RO"

#define RP23XX_M33_DEVARCH_REVISION_RESET  0x0
#define RP23XX_M33_DEVARCH_REVISION_BITS   0x000f0000
#define RP23XX_M33_DEVARCH_REVISION_MSB    19
#define RP23XX_M33_DEVARCH_REVISION_LSB    16
#define RP23XX_M33_DEVARCH_REVISION_ACCESS "RO"

#define RP23XX_M33_DEVARCH_ARCHID_RESET  0x1a14
#define RP23XX_M33_DEVARCH_ARCHID_BITS   0x0000ffff
#define RP23XX_M33_DEVARCH_ARCHID_MSB    15
#define RP23XX_M33_DEVARCH_ARCHID_LSB    0
#define RP23XX_M33_DEVARCH_ARCHID_ACCESS "RO"

#define RP23XX_M33_DEVID_OFFSET 0x00042fc8
#define RP23XX_M33_DEVID_BITS   0x000fff1f
#define RP23XX_M33_DEVID_RESET  0x00040800

#define RP23XX_M33_DEVID_NUMCH_RESET  0x4
#define RP23XX_M33_DEVID_NUMCH_BITS   0x000f0000
#define RP23XX_M33_DEVID_NUMCH_MSB    19
#define RP23XX_M33_DEVID_NUMCH_LSB    16
#define RP23XX_M33_DEVID_NUMCH_ACCESS "RO"

#define RP23XX_M33_DEVID_NUMTRIG_RESET  0x08
#define RP23XX_M33_DEVID_NUMTRIG_BITS   0x0000ff00
#define RP23XX_M33_DEVID_NUMTRIG_MSB    15
#define RP23XX_M33_DEVID_NUMTRIG_LSB    8
#define RP23XX_M33_DEVID_NUMTRIG_ACCESS "RO"

#define RP23XX_M33_DEVID_EXTMUXNUM_RESET  0x00
#define RP23XX_M33_DEVID_EXTMUXNUM_BITS   0x0000001f
#define RP23XX_M33_DEVID_EXTMUXNUM_MSB    4
#define RP23XX_M33_DEVID_EXTMUXNUM_LSB    0
#define RP23XX_M33_DEVID_EXTMUXNUM_ACCESS "RO"

#define RP23XX_M33_DEVTYPE_OFFSET 0x00042fcc
#define RP23XX_M33_DEVTYPE_BITS   0x000000ff
#define RP23XX_M33_DEVTYPE_RESET  0x00000014

#define RP23XX_M33_DEVTYPE_SUB_RESET  0x1
#define RP23XX_M33_DEVTYPE_SUB_BITS   0x000000f0
#define RP23XX_M33_DEVTYPE_SUB_MSB    7
#define RP23XX_M33_DEVTYPE_SUB_LSB    4
#define RP23XX_M33_DEVTYPE_SUB_ACCESS "RO"

#define RP23XX_M33_DEVTYPE_MAJOR_RESET  0x4
#define RP23XX_M33_DEVTYPE_MAJOR_BITS   0x0000000f
#define RP23XX_M33_DEVTYPE_MAJOR_MSB    3
#define RP23XX_M33_DEVTYPE_MAJOR_LSB    0
#define RP23XX_M33_DEVTYPE_MAJOR_ACCESS "RO"

#define RP23XX_M33_PIDR4_OFFSET 0x00042fd0
#define RP23XX_M33_PIDR4_BITS   0x000000ff
#define RP23XX_M33_PIDR4_RESET  0x00000004

#define RP23XX_M33_PIDR4_SIZE_RESET  0x0
#define RP23XX_M33_PIDR4_SIZE_BITS   0x000000f0
#define RP23XX_M33_PIDR4_SIZE_MSB    7
#define RP23XX_M33_PIDR4_SIZE_LSB    4
#define RP23XX_M33_PIDR4_SIZE_ACCESS "RO"

#define RP23XX_M33_PIDR4_DES_2_RESET  0x4
#define RP23XX_M33_PIDR4_DES_2_BITS   0x0000000f
#define RP23XX_M33_PIDR4_DES_2_MSB    3
#define RP23XX_M33_PIDR4_DES_2_LSB    0
#define RP23XX_M33_PIDR4_DES_2_ACCESS "RO"

#define RP23XX_M33_PIDR5_OFFSET 0x00042fd4
#define RP23XX_M33_PIDR5_BITS   0x00000000
#define RP23XX_M33_PIDR5_RESET  0x00000000
#define RP23XX_M33_PIDR5_MSB    31
#define RP23XX_M33_PIDR5_LSB    0
#define RP23XX_M33_PIDR5_ACCESS "RW"

#define RP23XX_M33_PIDR6_OFFSET 0x00042fd8
#define RP23XX_M33_PIDR6_BITS   0x00000000
#define RP23XX_M33_PIDR6_RESET  0x00000000
#define RP23XX_M33_PIDR6_MSB    31
#define RP23XX_M33_PIDR6_LSB    0
#define RP23XX_M33_PIDR6_ACCESS "RW"

#define RP23XX_M33_PIDR7_OFFSET 0x00042fdc
#define RP23XX_M33_PIDR7_BITS   0x00000000
#define RP23XX_M33_PIDR7_RESET  0x00000000
#define RP23XX_M33_PIDR7_MSB    31
#define RP23XX_M33_PIDR7_LSB    0
#define RP23XX_M33_PIDR7_ACCESS "RW"

#define RP23XX_M33_PIDR0_OFFSET 0x00042fe0
#define RP23XX_M33_PIDR0_BITS   0x000000ff
#define RP23XX_M33_PIDR0_RESET  0x00000021

#define RP23XX_M33_PIDR0_PART_0_RESET  0x21
#define RP23XX_M33_PIDR0_PART_0_BITS   0x000000ff
#define RP23XX_M33_PIDR0_PART_0_MSB    7
#define RP23XX_M33_PIDR0_PART_0_LSB    0
#define RP23XX_M33_PIDR0_PART_0_ACCESS "RO"

#define RP23XX_M33_PIDR1_OFFSET 0x00042fe4
#define RP23XX_M33_PIDR1_BITS   0x000000ff
#define RP23XX_M33_PIDR1_RESET  0x000000bd

#define RP23XX_M33_PIDR1_DES_0_RESET  0xb
#define RP23XX_M33_PIDR1_DES_0_BITS   0x000000f0
#define RP23XX_M33_PIDR1_DES_0_MSB    7
#define RP23XX_M33_PIDR1_DES_0_LSB    4
#define RP23XX_M33_PIDR1_DES_0_ACCESS "RO"

#define RP23XX_M33_PIDR1_PART_1_RESET  0xd
#define RP23XX_M33_PIDR1_PART_1_BITS   0x0000000f
#define RP23XX_M33_PIDR1_PART_1_MSB    3
#define RP23XX_M33_PIDR1_PART_1_LSB    0
#define RP23XX_M33_PIDR1_PART_1_ACCESS "RO"

#define RP23XX_M33_PIDR2_OFFSET 0x00042fe8
#define RP23XX_M33_PIDR2_BITS   0x000000ff
#define RP23XX_M33_PIDR2_RESET  0x0000000b

#define RP23XX_M33_PIDR2_REVISION_RESET  0x0
#define RP23XX_M33_PIDR2_REVISION_BITS   0x000000f0
#define RP23XX_M33_PIDR2_REVISION_MSB    7
#define RP23XX_M33_PIDR2_REVISION_LSB    4
#define RP23XX_M33_PIDR2_REVISION_ACCESS "RO"

#define RP23XX_M33_PIDR2_JEDEC_RESET  0x1
#define RP23XX_M33_PIDR2_JEDEC_BITS   0x00000008
#define RP23XX_M33_PIDR2_JEDEC_MSB    3
#define RP23XX_M33_PIDR2_JEDEC_LSB    3
#define RP23XX_M33_PIDR2_JEDEC_ACCESS "RO"

#define RP23XX_M33_PIDR2_DES_1_RESET  0x3
#define RP23XX_M33_PIDR2_DES_1_BITS   0x00000007
#define RP23XX_M33_PIDR2_DES_1_MSB    2
#define RP23XX_M33_PIDR2_DES_1_LSB    0
#define RP23XX_M33_PIDR2_DES_1_ACCESS "RO"

#define RP23XX_M33_PIDR3_OFFSET 0x00042fec
#define RP23XX_M33_PIDR3_BITS   0x000000ff
#define RP23XX_M33_PIDR3_RESET  0x00000000

#define RP23XX_M33_PIDR3_REVAND_RESET  0x0
#define RP23XX_M33_PIDR3_REVAND_BITS   0x000000f0
#define RP23XX_M33_PIDR3_REVAND_MSB    7
#define RP23XX_M33_PIDR3_REVAND_LSB    4
#define RP23XX_M33_PIDR3_REVAND_ACCESS "RO"

#define RP23XX_M33_PIDR3_CMOD_RESET  0x0
#define RP23XX_M33_PIDR3_CMOD_BITS   0x0000000f
#define RP23XX_M33_PIDR3_CMOD_MSB    3
#define RP23XX_M33_PIDR3_CMOD_LSB    0
#define RP23XX_M33_PIDR3_CMOD_ACCESS "RO"

#define RP23XX_M33_CIDR0_OFFSET 0x00042ff0
#define RP23XX_M33_CIDR0_BITS   0x000000ff
#define RP23XX_M33_CIDR0_RESET  0x0000000d

#define RP23XX_M33_CIDR0_PRMBL_0_RESET  0x0d
#define RP23XX_M33_CIDR0_PRMBL_0_BITS   0x000000ff
#define RP23XX_M33_CIDR0_PRMBL_0_MSB    7
#define RP23XX_M33_CIDR0_PRMBL_0_LSB    0
#define RP23XX_M33_CIDR0_PRMBL_0_ACCESS "RO"

#define RP23XX_M33_CIDR1_OFFSET 0x00042ff4
#define RP23XX_M33_CIDR1_BITS   0x000000ff
#define RP23XX_M33_CIDR1_RESET  0x00000090

#define RP23XX_M33_CIDR1_CLASS_RESET  0x9
#define RP23XX_M33_CIDR1_CLASS_BITS   0x000000f0
#define RP23XX_M33_CIDR1_CLASS_MSB    7
#define RP23XX_M33_CIDR1_CLASS_LSB    4
#define RP23XX_M33_CIDR1_CLASS_ACCESS "RO"

#define RP23XX_M33_CIDR1_PRMBL_1_RESET  0x0
#define RP23XX_M33_CIDR1_PRMBL_1_BITS   0x0000000f
#define RP23XX_M33_CIDR1_PRMBL_1_MSB    3
#define RP23XX_M33_CIDR1_PRMBL_1_LSB    0
#define RP23XX_M33_CIDR1_PRMBL_1_ACCESS "RO"

#define RP23XX_M33_CIDR2_OFFSET 0x00042ff8
#define RP23XX_M33_CIDR2_BITS   0x000000ff
#define RP23XX_M33_CIDR2_RESET  0x00000005

#define RP23XX_M33_CIDR2_PRMBL_2_RESET  0x05
#define RP23XX_M33_CIDR2_PRMBL_2_BITS   0x000000ff
#define RP23XX_M33_CIDR2_PRMBL_2_MSB    7
#define RP23XX_M33_CIDR2_PRMBL_2_LSB    0
#define RP23XX_M33_CIDR2_PRMBL_2_ACCESS "RO"

#define RP23XX_M33_CIDR3_OFFSET 0x00042ffc
#define RP23XX_M33_CIDR3_BITS   0x000000ff
#define RP23XX_M33_CIDR3_RESET  0x000000b1

#define RP23XX_M33_CIDR3_PRMBL_3_RESET  0xb1
#define RP23XX_M33_CIDR3_PRMBL_3_BITS   0x000000ff
#define RP23XX_M33_CIDR3_PRMBL_3_MSB    7
#define RP23XX_M33_CIDR3_PRMBL_3_LSB    0
#define RP23XX_M33_CIDR3_PRMBL_3_ACCESS "RO"

#endif /* __ARCH_ARM_SRC_RP23XX_HARDWARE_RP23XX_M33_H */
