/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config.annotation.web.socket;

import io.micrometer.observation.ObservationRegistry;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Role;
import org.springframework.messaging.Message;
import org.springframework.security.authorization.AuthorizationManager;
import org.springframework.security.authorization.ObservationAuthorizationManager;
import org.springframework.security.config.ObjectPostProcessor;
import org.springframework.security.config.observation.SecurityObservationSettings;

@Configuration(proxyBeanMethods=false)
@Role(value=2)
class WebSocketObservationConfiguration {
    private static final SecurityObservationSettings all = SecurityObservationSettings.withDefaults().shouldObserveRequests(true).shouldObserveAuthentications(true).shouldObserveAuthorizations(true).build();

    WebSocketObservationConfiguration() {
    }

    @Bean
    @Role(value=2)
    static ObjectPostProcessor<AuthorizationManager<Message<?>>> webSocketAuthorizationManagerPostProcessor(final ObjectProvider<ObservationRegistry> registry, final ObjectProvider<SecurityObservationSettings> predicate) {
        return new ObjectPostProcessor<AuthorizationManager<Message<?>>>(){

            @Override
            public AuthorizationManager postProcess(AuthorizationManager object) {
                ObservationRegistry r = (ObservationRegistry)registry.getIfUnique(() -> ObservationRegistry.NOOP);
                boolean active = !r.isNoop() && ((SecurityObservationSettings)predicate.getIfUnique(() -> all)).shouldObserveAuthorizations();
                return active ? new ObservationAuthorizationManager(r, object) : object;
            }
        };
    }
}

