/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.minifi.toolkit.schema;

import java.util.Map;
import org.apache.nifi.minifi.toolkit.schema.SwapSchema;
import org.apache.nifi.minifi.toolkit.schema.common.BaseSchema;
import org.apache.nifi.minifi.toolkit.schema.common.WritableSchema;

public class FlowFileRepositorySchema
extends BaseSchema
implements WritableSchema {
    public static final String FLOWFILE_REPOSITORY_IMPLEMENTATION = "implementation";
    public static final String PARTITIONS_KEY = "partitions";
    public static final String CHECKPOINT_INTERVAL_KEY = "checkpoint interval";
    public static final String DEFAULT_FLOWFILE_REPOSITORY_IMPLEMENTATION = "org.apache.nifi.controller.repository.WriteAheadFlowFileRepository";
    public static final int DEFAULT_PARTITIONS = 256;
    public static final String DEFAULT_CHECKPOINT_INTERVAL = "2 mins";
    public static final boolean DEFAULT_ALWAYS_SYNC = false;
    private Number partitions = 256;
    private String flowFileRepository = "org.apache.nifi.controller.repository.WriteAheadFlowFileRepository";
    private String checkpointInterval = "2 mins";
    private Boolean alwaysSync = false;
    private SwapSchema swapProperties;

    public FlowFileRepositorySchema() {
        this.swapProperties = new SwapSchema();
    }

    public FlowFileRepositorySchema(Map map) {
        this.flowFileRepository = this.getOptionalKeyAsType(map, FLOWFILE_REPOSITORY_IMPLEMENTATION, String.class, "FlowFile Repository", DEFAULT_FLOWFILE_REPOSITORY_IMPLEMENTATION);
        this.partitions = this.getOptionalKeyAsType(map, PARTITIONS_KEY, Number.class, "FlowFile Repository", 256);
        this.checkpointInterval = this.getOptionalKeyAsType(map, CHECKPOINT_INTERVAL_KEY, String.class, "FlowFile Repository", DEFAULT_CHECKPOINT_INTERVAL);
        this.alwaysSync = this.getOptionalKeyAsType(map, "always sync", Boolean.class, "FlowFile Repository", false);
        this.swapProperties = this.getMapAsType(map, "Swap", SwapSchema.class, "FlowFile Repository", false);
        this.addIssuesIfNotNull(this.swapProperties);
    }

    @Override
    public Map<String, Object> toMap() {
        Map result = (Map)this.mapSupplier.get();
        result.put(FLOWFILE_REPOSITORY_IMPLEMENTATION, this.flowFileRepository);
        result.put(PARTITIONS_KEY, this.partitions);
        result.put(CHECKPOINT_INTERVAL_KEY, this.checkpointInterval);
        result.put("always sync", this.alwaysSync);
        FlowFileRepositorySchema.putIfNotNull(result, "Swap", this.swapProperties);
        return result;
    }

    public String getFlowFileRepository() {
        return this.flowFileRepository;
    }

    public Number getPartitions() {
        return this.partitions;
    }

    public String getCheckpointInterval() {
        return this.checkpointInterval;
    }

    public boolean getAlwaysSync() {
        return this.alwaysSync;
    }

    public SwapSchema getSwapProperties() {
        return this.swapProperties;
    }
}

