/*
 * Decompiled with CFR 0.152.
 */
package nbjavac;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.stream.Collectors;

public class StringWrapper {
    public static String stripIndent(String str) {
        String[] lines = StringWrapper.lines(str);
        int indent = Arrays.stream(lines).mapToInt(s -> {
            int at;
            for (at = 0; at < s.length() && Character.isWhitespace(s.charAt(at)); ++at) {
            }
            if (at == s.length()) {
                return Integer.MAX_VALUE;
            }
            return at;
        }).min().orElse(Integer.MAX_VALUE);
        if (lines.length > 0 && StringWrapper.isBlank(lines[lines.length - 1])) {
            indent = Math.min(indent, lines[lines.length - 1].length());
        }
        int indentFin = indent;
        return Arrays.stream(lines).map(line -> {
            int at;
            if (line.length() <= indentFin) {
                return "";
            }
            String l = line.substring(indentFin);
            for (at = l.length() - 1; at >= 0 && Character.isWhitespace(l.charAt(at)); --at) {
            }
            return l.substring(0, at + 1);
        }).collect(Collectors.joining("\n"));
    }

    public static String stripTrailing(String str) {
        int end;
        for (end = str.length(); end > 0 && Character.isWhitespace(str.charAt(end - 1)); --end) {
        }
        return str.substring(0, end);
    }

    public static boolean isBlank(String s) {
        int at;
        for (at = 0; at < s.length() && Character.isWhitespace(s.charAt(at)); ++at) {
        }
        return at == s.length();
    }

    public static String translateEscapes(String str) {
        if (str.isEmpty()) {
            return "";
        }
        char[] chars = str.toCharArray();
        int length = chars.length;
        int from = 0;
        int to = 0;
        block11: while (from < length) {
            char ch;
            if ((ch = chars[from++]) == '\\') {
                ch = from < length ? chars[from++] : (char)'\u0000';
                switch (ch) {
                    case 'b': {
                        ch = '\b';
                        break;
                    }
                    case 'f': {
                        ch = '\f';
                        break;
                    }
                    case 'n': {
                        ch = '\n';
                        break;
                    }
                    case 'r': {
                        ch = '\r';
                        break;
                    }
                    case 't': {
                        ch = '\t';
                        break;
                    }
                    case 's': {
                        ch = ' ';
                        break;
                    }
                    case '\"': 
                    case '\'': 
                    case '\\': {
                        break;
                    }
                    case '0': 
                    case '1': 
                    case '2': 
                    case '3': 
                    case '4': 
                    case '5': 
                    case '6': 
                    case '7': {
                        int limit = Integer.min(from + (ch <= '3' ? 2 : 1), length);
                        int code = ch - 48;
                        while (from < limit && (ch = chars[from]) >= '0' && '7' >= ch) {
                            ++from;
                            code = code << 3 | ch - 48;
                        }
                        ch = (char)code;
                        break;
                    }
                    case '\n': {
                        continue block11;
                    }
                    default: {
                        String msg = String.format("Invalid escape sequence: \\%c \\\\u%04X", Character.valueOf(ch), (int)ch);
                        throw new IllegalArgumentException(msg);
                    }
                }
            }
            chars[to++] = ch;
        }
        return new String(chars, 0, to);
    }

    private static String[] lines(String txt) {
        ArrayList<String> arr = new ArrayList<String>();
        int at = 0;
        while (true) {
            int next;
            if ((next = txt.indexOf(10, at)) == -1) break;
            arr.add(txt.substring(at, next));
            at = next + 1;
        }
        arr.add(txt.substring(at));
        return arr.toArray(new String[0]);
    }
}

