/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.internal.component;

import jakarta.el.ELContext;
import jakarta.el.MethodExpression;
import jakarta.el.ValueExpression;
import jakarta.faces.component.UIColumn;
import jakarta.faces.component.UIComponent;
import jakarta.faces.component.UINamingContainer;
import jakarta.faces.component.behavior.AjaxBehavior;
import jakarta.faces.component.behavior.ClientBehaviorHolder;
import jakarta.faces.component.visit.VisitCallback;
import jakarta.faces.component.visit.VisitContext;
import jakarta.faces.component.visit.VisitHint;
import jakarta.faces.component.visit.VisitResult;
import jakarta.faces.context.FacesContext;
import jakarta.faces.event.AbortProcessingException;
import jakarta.faces.event.ComponentSystemEvent;
import jakarta.faces.event.ComponentSystemEventListener;
import jakarta.faces.event.FacesEvent;
import jakarta.faces.event.ListenerFor;
import jakarta.faces.event.PhaseId;
import jakarta.faces.event.PreRenderComponentEvent;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.BiConsumer;
import org.apache.myfaces.tobago.component.Attributes;
import org.apache.myfaces.tobago.component.Visual;
import org.apache.myfaces.tobago.event.PageActionEvent;
import org.apache.myfaces.tobago.event.SheetAction;
import org.apache.myfaces.tobago.event.SheetStateChangeEvent;
import org.apache.myfaces.tobago.event.SheetStateChangeListener;
import org.apache.myfaces.tobago.event.SheetStateChangeSource;
import org.apache.myfaces.tobago.event.SortActionEvent;
import org.apache.myfaces.tobago.event.SortActionSource;
import org.apache.myfaces.tobago.internal.component.AbstractUIColumnBase;
import org.apache.myfaces.tobago.internal.component.AbstractUIData;
import org.apache.myfaces.tobago.internal.component.AbstractUIRow;
import org.apache.myfaces.tobago.internal.layout.Grid;
import org.apache.myfaces.tobago.internal.layout.OriginCell;
import org.apache.myfaces.tobago.internal.util.SortingUtils;
import org.apache.myfaces.tobago.layout.Measure;
import org.apache.myfaces.tobago.layout.MeasureList;
import org.apache.myfaces.tobago.layout.PaginatorMode;
import org.apache.myfaces.tobago.layout.ShowPosition;
import org.apache.myfaces.tobago.model.ExpandedState;
import org.apache.myfaces.tobago.model.ScrollPosition;
import org.apache.myfaces.tobago.model.SelectedState;
import org.apache.myfaces.tobago.model.SheetState;
import org.apache.myfaces.tobago.util.ComponentUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ListenerFor(systemEventClass=PreRenderComponentEvent.class)
public abstract class AbstractUISheet
extends AbstractUIData
implements SheetStateChangeSource,
SortActionSource,
ClientBehaviorHolder,
Visual,
ComponentSystemEventListener {
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    @Deprecated(since="4.4.0", forRemoval=true)
    public static final String COMPONENT_TYPE = "org.apache.myfaces.tobago.Data";
    public static final String SORTER_ID = "sorter";
    public static final String NOT_SORTABLE_COL_MESSAGE_ID = "org.apache.myfaces.tobago.UISheet.SORTING_COL";
    public static final String NOT_SORTABLE_MESSAGE_ID = "org.apache.myfaces.tobago.UISheet.SORTING";
    private SheetState state;
    private transient MeasureList columnLayout;
    private transient boolean autoLayout;
    private transient boolean lazyUpdate;
    private transient int lazyFirstRow;
    private transient Grid headerGrid;

    public void encodeAll(FacesContext facesContext) throws IOException {
        if (this.isLazy() && this.getRows() > 0) {
            LOG.warn("Sheet id={} has lazy=true AND the rows attribute set. Use 'lazyRows' instead.", (Object)this.getClientId(facesContext));
            if (this.getShowRowRange() != ShowPosition.none) {
                LOG.warn("Sheet id={} has lazy=true set, but also set showRowRange!=none!", (Object)this.getClientId(facesContext));
            }
            if (this.getShowPageRange() != ShowPosition.none) {
                LOG.warn("Sheet id={} has lazy=true set, but also set showPageRange!=none!", (Object)this.getClientId(facesContext));
            }
            if (this.getShowDirectLinks() != ShowPosition.none) {
                LOG.warn("Sheet id={} has lazy=true set, but also set showDirectLinks!=none!", (Object)this.getClientId(facesContext));
            }
        }
        super.encodeAll(facesContext);
    }

    @Override
    public void encodeBegin(FacesContext facesContext) throws IOException {
        SheetState theState = this.getSheetState(facesContext);
        int first = theState.getFirst();
        if (!(first <= -1 || this.hasRowCount() && first >= this.getRowCount())) {
            ValueExpression expression = this.getValueExpression(Attributes.first.getName());
            if (expression != null) {
                expression.setValue(facesContext.getELContext(), (Object)first);
            } else {
                this.setFirst(first);
            }
        }
        if (this.isLazy() && !this.getLazyUpdate()) {
            this.setLazyFirstRow(theState.getLazyScrollPosition().getFirstVisibleRow());
        }
        super.encodeBegin(facesContext);
    }

    public void setState(SheetState state) {
        this.state = state;
    }

    public SheetState getState() {
        return this.getSheetState(FacesContext.getCurrentInstance());
    }

    public SheetState getSheetState(FacesContext facesContext) {
        if (this.state != null) {
            return this.state;
        }
        ValueExpression expression = this.getValueExpression(Attributes.state.getName());
        if (expression != null) {
            ELContext elContext = facesContext.getELContext();
            SheetState sheetState = (SheetState)expression.getValue(elContext);
            if (sheetState == null) {
                sheetState = new SheetState(this.getMaxSortColumns());
                expression.setValue(elContext, (Object)sheetState);
            }
            return sheetState;
        }
        this.state = new SheetState(this.getMaxSortColumns());
        return this.state;
    }

    public abstract String getColumns();

    public void processEvent(ComponentSystemEvent event) throws AbortProcessingException {
        super.processEvent(event);
        if (event instanceof PreRenderComponentEvent) {
            String columns = this.getColumns();
            if (columns != null) {
                this.columnLayout = MeasureList.parse(columns);
            }
            this.autoLayout = true;
            if (this.columnLayout != null) {
                for (Measure token : this.columnLayout) {
                    if (token == Measure.AUTO) continue;
                    this.autoLayout = false;
                    break;
                }
            }
            LOG.debug("autoLayout={}", (Object)this.autoLayout);
        }
    }

    public MeasureList getColumnLayout() {
        return this.columnLayout;
    }

    public boolean isAutoLayout() {
        return this.autoLayout;
    }

    public int getLastRowIndexOfCurrentPage() {
        if (!this.hasRowCount()) {
            throw new IllegalArgumentException("Can't determine the last row, because the row count of the model is unknown.");
        }
        if (this.isRowsUnlimited()) {
            return this.getRowCount();
        }
        int last = this.getFirst() + this.getRows();
        return Math.min(last, this.getRowCount());
    }

    public int getCurrentPage() {
        int rows = this.getRows();
        if (rows == 0) {
            return 0;
        }
        int first = this.getFirst();
        if (this.hasRowCount() && first >= this.getRowCount()) {
            return this.getPages() - 1;
        }
        return first / rows;
    }

    public int getPages() {
        if (this.isRowsUnlimited()) {
            return 1;
        }
        if (!this.hasRowCount()) {
            throw new IllegalArgumentException("Can't determine the number of pages, because the row count of the model is unknown.");
        }
        return (this.getRowCount() - 1) / this.getRows() + 1;
    }

    public List<UIComponent> getRenderedChildrenOf(UIColumn column) {
        ArrayList<UIComponent> children = new ArrayList<UIComponent>();
        for (UIComponent kid : column.getChildren()) {
            if (!kid.isRendered()) continue;
            children.add(kid);
        }
        return children;
    }

    public boolean isAtBeginning() {
        return this.getFirst() == 0;
    }

    public boolean hasRowCount() {
        return this.getRowCount() != -1;
    }

    public boolean isPagingVisible() {
        return this.isShowPagingAlways() || this.needMoreThanOnePage();
    }

    public boolean needMoreThanOnePage() {
        if (this.isRowsUnlimited()) {
            return false;
        }
        if (!this.hasRowCount()) {
            return true;
        }
        return this.getRowCount() > this.getRows();
    }

    public abstract boolean isShowPagingAlways();

    public boolean isAtEnd() {
        if (!this.hasRowCount()) {
            int old = this.getRowIndex();
            this.setRowIndex(this.getFirst() + this.getRows() + 1);
            boolean atEnd = !this.isRowAvailable();
            this.setRowIndex(old);
            return atEnd;
        }
        return this.getFirst() >= this.getFirstRowIndexOfLastPage();
    }

    public int getFirstRowIndexOfLastPage() {
        int rowCount;
        if (this.isRowsUnlimited()) {
            return 0;
        }
        if (!this.hasRowCount()) {
            throw new IllegalArgumentException("Can't determine the last page, because the row count of the model is unknown.");
        }
        int rows = this.getRows();
        int tail = (rowCount = this.getRowCount()) % rows;
        return rowCount - (tail != 0 ? tail : rows);
    }

    public void processDecodes(FacesContext context) {
        this.process(context, this.isReadonlyRows(), (fc, uic) -> uic.processDecodes(fc));
    }

    public void processValidators(FacesContext context) {
        this.process(context, this.isReadonlyRows(), (fc, uic) -> uic.processValidators(fc));
    }

    public void processUpdates(FacesContext context) {
        this.process(context, this.isReadonlyRows() || this.isLazyUpdate(context), (fc, uic) -> uic.processUpdates(fc));
        SheetState sheetState = this.getSheetState(context);
        if (sheetState != null) {
            List<Integer> list = (List<Integer>)ComponentUtils.getAttribute((UIComponent)this, Attributes.selectedListString);
            sheetState.setSelectedRows(list != null ? list : Collections.emptyList());
            ComponentUtils.removeAttribute((UIComponent)this, Attributes.selectedListString);
            ComponentUtils.removeAttribute((UIComponent)this, Attributes.scrollPosition);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void process(FacesContext context, boolean skipColumnChildren, BiConsumer<FacesContext, UIComponent> consumer) {
        block17: {
            try {
                this.pushComponentToEL(context, (UIComponent)this);
                if (!this.isRendered()) {
                    return;
                }
                this.setRowIndex(-1);
                if (this.getFacetCount() > 0) {
                    for (UIComponent facet : this.getFacets().values()) {
                        consumer.accept(context, facet);
                    }
                }
                boolean[] columnRendered = new boolean[this.getChildCount()];
                int childCount = this.getChildCount();
                for (int i = 0; i < childCount; ++i) {
                    UIComponent child = (UIComponent)this.getChildren().get(i);
                    if (!(child instanceof UIColumn)) continue;
                    try {
                        child.pushComponentToEL(context, child);
                        if (!child.isRendered()) continue;
                        columnRendered[i] = true;
                    }
                    finally {
                        child.popComponentFromEL(context);
                    }
                    if (child.getFacetCount() <= 0) continue;
                    for (UIComponent facet : child.getFacets().values()) {
                        consumer.accept(context, facet);
                    }
                }
                if (skipColumnChildren) {
                    int rowIndex = this.getRowFromActionSource(context);
                    this.processRow(context, columnRendered, consumer, rowIndex);
                } else {
                    this.processColumnChildren(context, columnRendered, consumer);
                }
                this.setRowIndex(-1);
                if (!PhaseId.APPLY_REQUEST_VALUES.equals(context.getCurrentPhaseId())) break block17;
                try {
                    this.decode(context);
                }
                catch (RuntimeException e) {
                    context.renderResponse();
                    throw e;
                }
            }
            finally {
                this.popComponentFromEL(context);
            }
        }
    }

    private void processColumnChildren(FacesContext context, boolean[] childRendered, BiConsumer<FacesContext, UIComponent> consumer) {
        int first = this.getFirst();
        int rows = this.getRows();
        int last = rows == 0 ? this.getRowCount() : first + rows;
        for (int rowIndex = first; !(last != -1 && rowIndex >= last || this.processRow(context, childRendered, consumer, rowIndex)); ++rowIndex) {
        }
    }

    private boolean processRow(FacesContext context, boolean[] childRendered, BiConsumer<FacesContext, UIComponent> consumer, int rowIndex) {
        this.setRowIndex(rowIndex);
        if (!this.isRowAvailable()) {
            return true;
        }
        int childCount = this.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            if (!childRendered[i]) continue;
            UIComponent child = (UIComponent)this.getChildren().get(i);
            if (child instanceof AbstractUIRow) {
                consumer.accept(context, child);
                continue;
            }
            int columnChildCount = child.getChildCount();
            for (int j = 0; j < columnChildCount; ++j) {
                UIComponent columnChild = (UIComponent)child.getChildren().get(j);
                consumer.accept(context, columnChild);
            }
        }
        return false;
    }

    private int getRowFromActionSource(FacesContext facesContext) {
        String clientId = this.getClientId(facesContext);
        int clientIdLengthPlusOne = clientId.length() + 1;
        char separatorChar = UINamingContainer.getSeparatorChar((FacesContext)facesContext);
        String sourceId = (String)facesContext.getExternalContext().getRequestParameterMap().get("jakarta.faces.source");
        if (sourceId != null && sourceId.startsWith(clientId)) {
            return this.getRowIndexFromSubtreeId(sourceId, separatorChar, clientIdLengthPlusOne);
        }
        return -1;
    }

    public Object saveState(FacesContext context) {
        Object[] saveState = new Object[]{super.saveState(context), this.state};
        return saveState;
    }

    public void restoreState(FacesContext context, Object savedState) {
        Object[] values = (Object[])savedState;
        super.restoreState(context, values[0]);
        this.state = (SheetState)values[1];
    }

    public List<AbstractUIColumnBase> getAllColumns() {
        ArrayList<AbstractUIColumnBase> result = new ArrayList<AbstractUIColumnBase>();
        this.findColumns((UIComponent)this, result, true);
        return result;
    }

    private void findColumns(UIComponent component, List<AbstractUIColumnBase> result, boolean all) {
        for (UIComponent child : component.getChildren()) {
            if (!all && !child.isRendered()) continue;
            if (child instanceof AbstractUIColumnBase) {
                result.add((AbstractUIColumnBase)child);
                continue;
            }
            if (child instanceof AbstractUIData) continue;
            this.findColumns(child, result, all);
        }
    }

    public void queueEvent(FacesEvent facesEvent) {
        UIComponent parent = this.getParent();
        if (parent == null) {
            throw new IllegalStateException("Component is not a descendant of a UIViewRoot");
        }
        if (facesEvent.getComponent() == this && (facesEvent instanceof SheetStateChangeEvent || facesEvent instanceof PageActionEvent)) {
            facesEvent.setPhaseId(PhaseId.INVOKE_APPLICATION);
            parent.queueEvent(facesEvent);
        } else {
            super.queueEvent(facesEvent);
        }
    }

    public void broadcast(FacesEvent facesEvent) throws AbortProcessingException {
        super.broadcast(facesEvent);
        if (facesEvent instanceof SheetStateChangeEvent) {
            MethodExpression listener = this.getStateChangeListenerExpression();
            listener.invoke(this.getFacesContext().getELContext(), new Object[]{facesEvent});
        } else if (facesEvent instanceof PageActionEvent) {
            if (facesEvent.getComponent() == this) {
                MethodExpression listener = this.getStateChangeListenerExpression();
                if (listener != null) {
                    listener.invoke(this.getFacesContext().getELContext(), new Object[]{facesEvent});
                }
                this.performPaging((PageActionEvent)facesEvent);
            }
        } else if (facesEvent instanceof SortActionEvent) {
            this.getSheetState(this.getFacesContext()).updateSortState(((SortActionEvent)facesEvent).getColumn().getId());
            this.sort(this.getFacesContext(), (SortActionEvent)facesEvent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean visitTree(VisitContext context, VisitCallback callback) {
        block38: {
            boolean skipIterationHint = context.getHints().contains(VisitHint.SKIP_ITERATION);
            if (skipIterationHint) {
                return super.visitTree(context, callback);
            }
            FacesContext facesContext = context.getFacesContext();
            this.pushComponentToEL(facesContext, (UIComponent)this);
            if (!this.isVisitable(context)) {
                return false;
            }
            int oldRowIndex = this.getRowIndex();
            try {
                boolean doVisitChildren;
                this.setRowIndex(-1);
                VisitResult visitResult = context.invokeVisitCallback((UIComponent)this, callback);
                switch (visitResult) {
                    case COMPLETE: {
                        boolean bl = true;
                        return bl;
                    }
                    case REJECT: {
                        boolean bl = false;
                        return bl;
                    }
                }
                Collection subtreeIdsToVisit = context.getSubtreeIdsToVisit((UIComponent)this);
                boolean bl = doVisitChildren = subtreeIdsToVisit != null && !subtreeIdsToVisit.isEmpty();
                if (!doVisitChildren) break block38;
                if (this.getFacetCount() > 0) {
                    for (UIComponent facet : this.getFacets().values()) {
                        if (!facet.visitTree(context, callback)) continue;
                        boolean bl2 = true;
                        return bl2;
                    }
                }
                int childCount = this.getChildCount();
                for (int i = 0; i < childCount; ++i) {
                    UIComponent child = (UIComponent)this.getChildren().get(i);
                    if (!(child instanceof UIColumn)) continue;
                    VisitResult columnResult = context.invokeVisitCallback(child, callback);
                    if (columnResult == VisitResult.COMPLETE) {
                        boolean bl3 = true;
                        return bl3;
                    }
                    if (child.getFacetCount() <= 0) continue;
                    for (UIComponent facet : child.getFacets().values()) {
                        if (!facet.visitTree(context, callback)) continue;
                        boolean bl4 = true;
                        return bl4;
                    }
                }
                if (VisitContext.ALL_IDS == subtreeIdsToVisit) {
                    int rowsToProcess = this.getRows();
                    if (rowsToProcess == 0) {
                        rowsToProcess = this.getRowCount();
                    }
                    int rowIndex = this.getFirst();
                    int rowsProcessed = 0;
                    while (rowsProcessed < rowsToProcess) {
                        this.setRowIndex(rowIndex);
                        if (!this.isRowAvailable()) {
                            boolean columnResult = false;
                            return columnResult;
                        }
                        int childCount2 = this.getChildCount();
                        for (int i = 0; i < childCount2; ++i) {
                            child = (UIComponent)this.getChildren().get(i);
                            if (!(child instanceof UIColumn)) continue;
                            int grandChildCount = child.getChildCount();
                            for (int j = 0; j < grandChildCount; ++j) {
                                UIComponent grandchild = (UIComponent)child.getChildren().get(j);
                                if (!grandchild.visitTree(context, callback)) continue;
                                boolean bl5 = true;
                                return bl5;
                            }
                        }
                        ++rowsProcessed;
                        ++rowIndex;
                    }
                } else {
                    Set<Integer> rowsToVisit = this.getRowsToVisit(facesContext, subtreeIdsToVisit);
                    if (rowsToVisit.isEmpty()) {
                        boolean bl6 = false;
                        return bl6;
                    }
                    for (Integer rowIndex : rowsToVisit) {
                        this.setRowIndex(rowIndex);
                        if (!this.isRowAvailable()) {
                            boolean i = false;
                            return i;
                        }
                        int childCount3 = this.getChildCount();
                        for (int i = 0; i < childCount3; ++i) {
                            int j;
                            child = (UIComponent)this.getChildren().get(i);
                            if (!(child instanceof UIColumn)) continue;
                            if (child instanceof AbstractUIRow) {
                                if (!child.visitTree(context, callback)) continue;
                                j = 1;
                                return j != 0;
                            }
                            int grandChildCount = child.getChildCount();
                            for (j = 0; j < grandChildCount; ++j) {
                                UIComponent grandchild = (UIComponent)child.getChildren().get(j);
                                if (!grandchild.visitTree(context, callback)) continue;
                                boolean bl7 = true;
                                return bl7;
                            }
                        }
                    }
                }
            }
            finally {
                this.popComponentFromEL(facesContext);
                this.setRowIndex(oldRowIndex);
            }
        }
        return false;
    }

    private Set<Integer> getRowsToVisit(FacesContext facesContext, Collection<String> subtreeIdsToVisit) {
        HashSet<Integer> rowsToVisit = new HashSet<Integer>();
        String clientId = this.getClientId(facesContext);
        int clientIdLengthPlusOne = clientId.length() + 1;
        char separatorChar = UINamingContainer.getSeparatorChar((FacesContext)facesContext);
        for (String subtreeId : subtreeIdsToVisit) {
            int rowIndex = this.getRowIndexFromSubtreeId(subtreeId, separatorChar, clientIdLengthPlusOne);
            if (rowIndex == -1) continue;
            rowsToVisit.add(rowIndex);
        }
        return rowsToVisit;
    }

    private int getRowIndexFromSubtreeId(String sourceId, char separatorChar, int clientIdLengthPlusOne) {
        int index = sourceId.indexOf(separatorChar, clientIdLengthPlusOne);
        if (index != -1) {
            String possibleRowIndex = sourceId.substring(clientIdLengthPlusOne, index);
            try {
                return Integer.parseInt(possibleRowIndex);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return -1;
    }

    public boolean isLazyUpdate(FacesContext facesContext) {
        String sourceId = (String)facesContext.getExternalContext().getRequestParameterMap().get("jakarta.faces.source");
        String clientId = this.getClientId(facesContext);
        String sheetClientIdWithAction = clientId + UINamingContainer.getSeparatorChar((FacesContext)facesContext) + "pageAction" + String.valueOf((Object)SheetAction.lazy);
        return sheetClientIdWithAction.equals(sourceId);
    }

    public void init(FacesContext facesContext) {
        this.sort(facesContext, null);
        this.layoutHeader();
    }

    private void layoutHeader() {
        UIComponent header = this.getHeader();
        if (header == null) {
            LOG.warn("This should not happen. Please file a bug in the issue tracker to reproduce this case.");
            return;
        }
        MeasureList tokens = new MeasureList();
        List<AbstractUIColumnBase> columns = this.getAllColumns();
        for (UIColumn uIColumn : columns) {
            if (uIColumn instanceof AbstractUIRow) continue;
            tokens.add(Measure.FRACTION1);
        }
        MeasureList rows = new MeasureList();
        rows.add(Measure.AUTO);
        Grid grid = new Grid(tokens, rows);
        for (UIComponent child : header.getChildren()) {
            if (!child.isRendered()) continue;
            int columnSpan = ComponentUtils.getIntAttribute(child, Attributes.columnSpan, 1);
            int rowSpan = ComponentUtils.getIntAttribute(child, Attributes.rowSpan, 1);
            grid.add(new OriginCell(child), columnSpan, rowSpan);
        }
        this.setHeaderGrid(grid);
    }

    protected void sort(FacesContext facesContext, SortActionEvent event) {
        SheetState sheetState = this.getSheetState(this.getFacesContext());
        if (sheetState.getToBeSortedLevel() > 0) {
            MethodExpression expression = this.getSortActionListenerExpression();
            if (expression != null) {
                try {
                    expression.invoke(facesContext.getELContext(), new Object[]{event != null ? event : new SortActionEvent(this, (UIColumn)this.findComponent(this.getSheetState(facesContext).getSortedColumnId()))});
                }
                catch (Exception e) {
                    LOG.warn("Sorting not possible!", (Throwable)e);
                }
            } else {
                SortingUtils.sort(this, null);
            }
            sheetState.sorted();
        }
    }

    @Override
    public void addStateChangeListener(SheetStateChangeListener listener) {
        this.addFacesListener(listener);
    }

    @Override
    public SheetStateChangeListener[] getStateChangeListeners() {
        return (SheetStateChangeListener[])this.getFacesListeners(SheetStateChangeListener.class);
    }

    @Override
    public void removeStateChangeListener(SheetStateChangeListener listener) {
        this.removeFacesListener(listener);
    }

    public void performPaging(PageActionEvent pageEvent) {
        int first;
        if (LOG.isDebugEnabled()) {
            LOG.debug("action = '" + pageEvent.getAction().name() + "'");
        }
        ScrollPosition scrollPosition = this.getState().getScrollPosition();
        scrollPosition.setTop(0);
        switch (pageEvent.getAction()) {
            case first: {
                first = 0;
                break;
            }
            case prev: {
                first = this.getFirst() - this.getRows();
                first = Math.max(first, 0);
                scrollPosition.setTop(Integer.MAX_VALUE);
                break;
            }
            case next: {
                if (this.hasRowCount()) {
                    first = this.getFirst() + this.getRows();
                    first = first > this.getRowCount() ? this.getFirstRowIndexOfLastPage() : first;
                    break;
                }
                if (this.isAtEnd()) {
                    first = this.getFirst();
                    break;
                }
                first = this.getFirst() + this.getRows();
                break;
            }
            case last: {
                first = this.getFirstRowIndexOfLastPage();
                break;
            }
            case toRow: {
                first = this.getToRow(pageEvent);
                break;
            }
            case lazy: {
                first = this.getToRow(pageEvent);
                this.setLazyUpdate(true);
                break;
            }
            case toPage: {
                int pageIndex = pageEvent.getValue() - 1;
                first = pageIndex * this.getRows();
                if (this.hasRowCount() && first > this.getFirstRowIndexOfLastPage()) {
                    first = this.getFirstRowIndexOfLastPage();
                    break;
                }
                if (first >= 0) break;
                first = 0;
                break;
            }
            default: {
                first = -1;
            }
        }
        ValueExpression expression = this.getValueExpression(Attributes.first.getName());
        if (expression != null) {
            expression.setValue(this.getFacesContext().getELContext(), (Object)first);
        } else {
            this.setFirst(first);
        }
        this.getState().setFirst(first);
    }

    private int getToRow(PageActionEvent pageEvent) {
        int first = pageEvent.getValue() - 1;
        if (this.hasRowCount() && first > this.getFirstRowIndexOfLastPage()) {
            first = this.getFirstRowIndexOfLastPage();
        } else if (first < 0) {
            first = 0;
        }
        return first;
    }

    public boolean getLazyUpdate() {
        return this.lazyUpdate;
    }

    public void setLazyUpdate(boolean lazyUpdate) {
        this.lazyUpdate = lazyUpdate;
    }

    public int getLazyFirstRow() {
        return this.lazyFirstRow;
    }

    public void setLazyFirstRow(int lazyFirstRow) {
        this.lazyFirstRow = lazyFirstRow;
    }

    public AjaxBehavior createReloadBehavior(AbstractUISheet sheet) {
        AjaxBehavior reloadBehavior = this.findReloadBehavior(sheet);
        ArrayList<String> renderIds = new ArrayList<String>();
        renderIds.add(sheet.getId());
        if (reloadBehavior != null) {
            renderIds.addAll(reloadBehavior.getRender());
        }
        ArrayList<String> executeIds = new ArrayList<String>();
        executeIds.add(sheet.getId());
        if (reloadBehavior != null) {
            executeIds.addAll(reloadBehavior.getExecute());
        }
        AjaxBehavior behavior = new AjaxBehavior();
        behavior.setExecute(executeIds);
        behavior.setRender(renderIds);
        behavior.setTransient(true);
        return behavior;
    }

    private AjaxBehavior findReloadBehavior(ClientBehaviorHolder holder) {
        List reload = (List)holder.getClientBehaviors().get("reload");
        if (reload != null && !reload.isEmpty() && reload.get(0) instanceof AjaxBehavior) {
            return (AjaxBehavior)reload.get(0);
        }
        return null;
    }

    @Override
    public boolean isRendersRowContainer() {
        return true;
    }

    public abstract boolean isShowHeader();

    @Override
    public ExpandedState getExpandedState() {
        return this.getState().getExpandedState();
    }

    @Override
    public SelectedState getSelectedState() {
        return this.getState().getSelectedState();
    }

    public Grid getHeaderGrid() {
        return this.headerGrid;
    }

    public void setHeaderGrid(Grid headerGrid) {
        this.headerGrid = headerGrid;
    }

    @Deprecated(since="5.15.0, 6.7.0", forRemoval=true)
    public abstract boolean isShowDirectLinksArrows();

    @Deprecated(since="5.15.0, 6.7.0", forRemoval=true)
    public abstract boolean isShowPageRangeArrows();

    @Deprecated(since="5.15.0, 6.7.0", forRemoval=true)
    public abstract ShowPosition getShowRowRange();

    @Deprecated(since="5.15.0, 6.7.0", forRemoval=true)
    public abstract ShowPosition getShowPageRange();

    @Deprecated(since="5.15.0, 6.7.0", forRemoval=true)
    public abstract ShowPosition getShowDirectLinks();

    @Deprecated(since="5.15.0, 6.7.0", forRemoval=true)
    public abstract Integer getDirectLinkCount();

    public abstract boolean isLazy();

    public abstract Integer getMaxSortColumns();

    public abstract Integer getLazyRows();

    public abstract PaginatorMode getPaginator();

    public abstract boolean isReadonlyRows();
}

