/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.cli.internal;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.maven.RepositoryUtils;
import org.apache.maven.cli.internal.ExtensionResolutionException;
import org.apache.maven.cli.internal.extension.model.CoreExtension;
import org.apache.maven.execution.MavenExecutionRequest;
import org.apache.maven.extension.internal.CoreExports;
import org.apache.maven.extension.internal.CoreExtensionEntry;
import org.apache.maven.internal.aether.DefaultRepositorySystemSessionFactory;
import org.apache.maven.model.Plugin;
import org.apache.maven.plugin.PluginResolutionException;
import org.apache.maven.plugin.internal.DefaultPluginDependenciesResolver;
import org.codehaus.plexus.DefaultPlexusContainer;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.classworlds.ClassWorld;
import org.codehaus.plexus.classworlds.realm.ClassRealm;
import org.codehaus.plexus.interpolation.InterpolationException;
import org.codehaus.plexus.interpolation.Interpolator;
import org.codehaus.plexus.interpolation.MapBasedValueSource;
import org.codehaus.plexus.interpolation.StringSearchInterpolator;
import org.codehaus.plexus.interpolation.ValueSource;
import org.codehaus.plexus.logging.Logger;
import org.eclipse.aether.DefaultRepositorySystemSession;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.graph.DependencyFilter;
import org.eclipse.aether.graph.DependencyNode;
import org.eclipse.aether.graph.DependencyVisitor;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.util.filter.ExclusionsDependencyFilter;
import org.eclipse.aether.util.graph.visitor.PreorderNodeListGenerator;

@Named
public class BootstrapCoreExtensionManager {
    public static final String STRATEGY_PARENT_FIRST = "parent-first";
    public static final String STRATEGY_PLUGIN = "plugin";
    public static final String STRATEGY_SELF_FIRST = "self-first";
    private final Logger log;
    private final DefaultPluginDependenciesResolver pluginDependenciesResolver;
    private final DefaultRepositorySystemSessionFactory repositorySystemSessionFactory;
    private final CoreExports coreExports;
    private final ClassWorld classWorld;
    private final ClassRealm parentRealm;

    @Inject
    public BootstrapCoreExtensionManager(Logger log, DefaultPluginDependenciesResolver pluginDependenciesResolver, DefaultRepositorySystemSessionFactory repositorySystemSessionFactory, CoreExports coreExports, PlexusContainer container) {
        this.log = log;
        this.pluginDependenciesResolver = pluginDependenciesResolver;
        this.repositorySystemSessionFactory = repositorySystemSessionFactory;
        this.coreExports = coreExports;
        this.classWorld = ((DefaultPlexusContainer)container).getClassWorld();
        this.parentRealm = container.getContainerRealm();
    }

    public List<CoreExtensionEntry> loadCoreExtensions(MavenExecutionRequest request, Set<String> providedArtifacts, List<CoreExtension> extensions) throws Exception {
        DefaultRepositorySystemSession repoSession = this.repositorySystemSessionFactory.newRepositorySession(request);
        List repositories = RepositoryUtils.toRepos((List)request.getPluginArtifactRepositories());
        Interpolator interpolator = BootstrapCoreExtensionManager.createInterpolator(request);
        return this.resolveCoreExtensions((RepositorySystemSession)repoSession, repositories, providedArtifacts, extensions, interpolator);
    }

    private List<CoreExtensionEntry> resolveCoreExtensions(RepositorySystemSession repoSession, List<RemoteRepository> repositories, Set<String> providedArtifacts, List<CoreExtension> configuration, Interpolator interpolator) throws Exception {
        ArrayList<CoreExtensionEntry> extensions = new ArrayList<CoreExtensionEntry>();
        ExclusionsDependencyFilter dependencyFilter = new ExclusionsDependencyFilter(providedArtifacts);
        for (CoreExtension extension : configuration) {
            List<Artifact> artifacts = this.resolveExtension(extension, repoSession, repositories, (DependencyFilter)dependencyFilter, interpolator);
            if (artifacts.isEmpty()) continue;
            extensions.add(this.createExtension(extension, artifacts));
        }
        return Collections.unmodifiableList(extensions);
    }

    private CoreExtensionEntry createExtension(CoreExtension extension, List<Artifact> artifacts) throws Exception {
        String realmId = "coreExtension>" + extension.getGroupId() + ":" + extension.getArtifactId() + ":" + extension.getVersion();
        ClassRealm realm = this.classWorld.newRealm(realmId, null);
        Set providedArtifacts = Collections.emptySet();
        String classLoadingStrategy = extension.getClassLoadingStrategy();
        if (STRATEGY_PARENT_FIRST.equals(classLoadingStrategy)) {
            realm.importFrom((ClassLoader)this.parentRealm, "");
        } else if (STRATEGY_PLUGIN.equals(classLoadingStrategy)) {
            for (Map.Entry entry : this.coreExports.getExportedPackages().entrySet()) {
                realm.importFrom((ClassLoader)entry.getValue(), (String)entry.getKey());
            }
            providedArtifacts = this.coreExports.getExportedArtifacts();
        } else if (STRATEGY_SELF_FIRST.equals(classLoadingStrategy)) {
            realm.setParentRealm(this.parentRealm);
        } else {
            throw new IllegalArgumentException("Unsupported class-loading strategy '" + classLoadingStrategy + "'. Supported values are: " + STRATEGY_PARENT_FIRST + ", " + STRATEGY_PLUGIN + " and " + STRATEGY_SELF_FIRST);
        }
        this.log.debug("Populating class realm " + realm.getId());
        for (Artifact artifact : artifacts) {
            String id = artifact.getGroupId() + ":" + artifact.getArtifactId();
            if (providedArtifacts.contains(id)) {
                this.log.debug("  Excluded " + id);
                continue;
            }
            File file = artifact.getFile();
            this.log.debug("  Included " + id + " located at " + file);
            realm.addURL(file.toURI().toURL());
        }
        return CoreExtensionEntry.discoverFrom((ClassRealm)realm, Collections.singleton(artifacts.get(0).getFile()));
    }

    private List<Artifact> resolveExtension(CoreExtension extension, RepositorySystemSession repoSession, List<RemoteRepository> repositories, DependencyFilter dependencyFilter, Interpolator interpolator) throws ExtensionResolutionException {
        try {
            Plugin plugin = new Plugin();
            plugin.setGroupId(interpolator.interpolate(extension.getGroupId()));
            plugin.setArtifactId(interpolator.interpolate(extension.getArtifactId()));
            plugin.setVersion(interpolator.interpolate(extension.getVersion()));
            DependencyNode root = this.pluginDependenciesResolver.resolveCoreExtension(plugin, dependencyFilter, repositories, repoSession);
            PreorderNodeListGenerator nlg = new PreorderNodeListGenerator();
            root.accept((DependencyVisitor)nlg);
            List artifacts = nlg.getArtifacts(false);
            return artifacts;
        }
        catch (PluginResolutionException e) {
            throw new ExtensionResolutionException(extension, e.getCause());
        }
        catch (InterpolationException e) {
            throw new ExtensionResolutionException(extension, (Throwable)e);
        }
    }

    private static Interpolator createInterpolator(MavenExecutionRequest request) {
        StringSearchInterpolator interpolator = new StringSearchInterpolator();
        interpolator.addValueSource((ValueSource)new MapBasedValueSource((Map)request.getUserProperties()));
        interpolator.addValueSource((ValueSource)new MapBasedValueSource((Map)request.getSystemProperties()));
        return interpolator;
    }
}

