/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.server.shared;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.Key;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.CipherOutputStream;
import javax.crypto.KeyGenerator;
import javax.crypto.spec.IvParameterSpec;
import org.apache.chemistry.opencmis.commons.exceptions.CmisConstraintException;
import org.apache.chemistry.opencmis.commons.server.TempStoreOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThresholdOutputStream
extends TempStoreOutputStream {
    private static final Logger LOG = LoggerFactory.getLogger(ThresholdOutputStream.class);
    private static final int MAX_GROW = 0xA00000;
    private static final int DEFAULT_THRESHOLD = 0x400000;
    private static final String ALGORITHM = "AES";
    private static final String MODE = "CTR";
    private static final String PADDING = "PKCS5Padding";
    private static final String TRANSFORMATION = "AES/CTR/PKCS5Padding";
    private static final int KEY_SIZE = 128;
    private final File tempDir;
    private final int memoryThreshold;
    private final int initSize;
    private final long maxContentSize;
    private final boolean encrypt;
    private byte[] buf = null;
    private int bufSize = 0;
    private long length = 0L;
    private File tempFile;
    private OutputStream tmpStream;
    private Key key;
    private byte[] iv;
    private String mimeType;
    private String filename;

    public ThresholdOutputStream(File tempDir, int memoryThreshold, long maxContentSize) {
        this(65536, tempDir, memoryThreshold, maxContentSize, false);
    }

    public ThresholdOutputStream(File tempDir, int memoryThreshold, long maxContentSize, boolean encrypt) {
        this(65536, tempDir, memoryThreshold, maxContentSize, encrypt);
    }

    public ThresholdOutputStream(int initSize, File tempDir, int memoryThreshold, long maxContentSize, boolean encrypt) {
        if (initSize < 0) {
            throw new IllegalArgumentException("Negative initial size: " + initSize);
        }
        this.initSize = initSize;
        this.tempDir = tempDir;
        this.memoryThreshold = memoryThreshold < 0 ? 0x400000 : memoryThreshold;
        this.maxContentSize = maxContentSize;
        this.encrypt = encrypt;
        this.buf = new byte[initSize];
    }

    private void expand(int nextBufferSize) throws IOException {
        if (this.bufSize + nextBufferSize <= this.buf.length) {
            return;
        }
        if (this.bufSize + nextBufferSize > this.memoryThreshold) {
            if (this.tmpStream == null) {
                this.openTempFile();
            }
            this.tmpStream.write(this.buf, 0, this.bufSize);
            if (this.buf.length != this.memoryThreshold) {
                if (this.memoryThreshold >= this.initSize) {
                    this.buf = new byte[this.memoryThreshold];
                } else if (this.buf.length != this.initSize) {
                    this.buf = new byte[this.initSize];
                }
            }
            if (this.buf.length < nextBufferSize) {
                this.buf = new byte[nextBufferSize];
            }
            this.bufSize = 0;
            return;
        }
        int newSize = (this.bufSize + nextBufferSize) * 2 < 0xA00000 ? (this.bufSize + nextBufferSize) * 2 : this.buf.length + nextBufferSize + 0xA00000;
        byte[] newbuf = new byte[newSize];
        System.arraycopy(this.buf, 0, newbuf, 0, this.bufSize);
        this.buf = newbuf;
    }

    private void openTempFile() throws IOException {
        block8: {
            this.tempFile = File.createTempFile("opencmis", null, this.tempDir);
            try {
                if (this.encrypt) {
                    Cipher cipher;
                    try {
                        KeyGenerator keyGenerator = KeyGenerator.getInstance(ALGORITHM);
                        keyGenerator.init(128);
                        this.key = keyGenerator.generateKey();
                        cipher = Cipher.getInstance(TRANSFORMATION);
                        cipher.init(1, this.key);
                        this.iv = cipher.getIV();
                    }
                    catch (Exception e) {
                        if (LOG.isErrorEnabled()) {
                            LOG.error("Cannot initialize encryption cipher: {}", (Object)e.toString(), (Object)e);
                        }
                        throw new IOException("Cannot initialize encryption cipher!", e);
                    }
                    this.tmpStream = new BufferedOutputStream(new CipherOutputStream(new FileOutputStream(this.tempFile), cipher));
                    break block8;
                }
                this.tmpStream = new BufferedOutputStream(new FileOutputStream(this.tempFile));
            }
            catch (IOException ioe) {
                if (this.tempFile.exists() && !this.tempFile.delete() && LOG.isErrorEnabled()) {
                    LOG.error("Temp file {} could not be deleted!", (Object)this.tempFile.getAbsolutePath());
                }
                throw ioe;
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Created temp file: {}", (Object)this.tempFile.getAbsolutePath());
        }
    }

    public void setMimeType(String mimeType) {
        this.mimeType = mimeType;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public void setFileName(String filename) {
        this.filename = filename;
    }

    public String getFileName() {
        return this.filename;
    }

    public long getLength() {
        return this.length;
    }

    public void write(byte[] buffer) throws IOException {
        this.write(buffer, 0, buffer.length);
    }

    public void write(byte[] buffer, int offset, int len) throws IOException {
        try {
            if (len == 0) {
                return;
            }
            if (this.maxContentSize > -1L && this.length + (long)len > this.maxContentSize) {
                this.destroy(null);
                throw new CmisConstraintException("Content too big!");
            }
            this.expand(len);
            System.arraycopy(buffer, offset, this.buf, this.bufSize, len);
            this.bufSize += len;
            this.length += (long)len;
        }
        catch (IOException ioe) {
            this.destroy(ioe);
            if (LOG.isErrorEnabled()) {
                if (this.tempFile != null) {
                    LOG.error("Writing to temp file {} failed: {}", new Object[]{this.tempFile.getAbsolutePath(), ioe.toString(), ioe});
                } else {
                    LOG.error("Writing to temp buffer failed: {}", (Object)ioe.toString(), (Object)ioe);
                }
            }
            throw ioe;
        }
    }

    public void write(int oneByte) throws IOException {
        try {
            if (this.maxContentSize > -1L && this.length + 1L > this.maxContentSize) {
                this.destroy(null);
                throw new CmisConstraintException("Content too big!");
            }
            if (this.bufSize == this.buf.length) {
                this.expand(1);
            }
            this.buf[this.bufSize++] = (byte)oneByte;
            ++this.length;
        }
        catch (IOException ioe) {
            this.destroy(ioe);
            if (LOG.isErrorEnabled()) {
                if (this.tempFile != null) {
                    LOG.error("Writing to temp file {} failed: {}", new Object[]{this.tempFile.getAbsolutePath(), ioe.toString(), ioe});
                } else {
                    LOG.error("Writing to temp buffer failed: {}", (Object)ioe.toString(), (Object)ioe);
                }
            }
            throw ioe;
        }
    }

    public void flush() throws IOException {
        if (this.tmpStream == null && this.memoryThreshold < this.bufSize) {
            this.openTempFile();
        }
        if (this.tmpStream != null) {
            try {
                if (this.bufSize > 0) {
                    this.tmpStream.write(this.buf, 0, this.bufSize);
                    this.bufSize = 0;
                }
                this.tmpStream.flush();
            }
            catch (IOException ioe) {
                this.destroy(ioe);
                if (LOG.isErrorEnabled()) {
                    LOG.error("Flushing the temp file {} failed: {}", new Object[]{this.tempFile.getAbsolutePath(), ioe.toString(), ioe});
                }
                throw ioe;
            }
        }
    }

    public void close() throws IOException {
        this.flush();
        if (this.tmpStream != null) {
            this.tmpStream.close();
        }
    }

    public void destroy(Throwable cause) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("ThresholdOutputStream destroyed." + (cause == null ? "" : " Cause: " + cause.toString()), cause);
        }
        if (this.tmpStream != null) {
            block12: {
                block11: {
                    try {
                        this.tmpStream.flush();
                    }
                    catch (Exception e) {
                        if (!LOG.isDebugEnabled()) break block11;
                        LOG.debug("Flushing the temp file {} failed: {}", new Object[]{this.tempFile.getAbsolutePath(), e.toString(), e});
                    }
                }
                try {
                    this.tmpStream.close();
                }
                catch (Exception e) {
                    if (!LOG.isDebugEnabled()) break block12;
                    LOG.debug("Closing the temp file {} failed: {}", new Object[]{this.tempFile.getAbsolutePath(), e.toString(), e});
                }
            }
            this.tmpStream = null;
        }
        if (this.tempFile != null && this.tempFile.exists()) {
            boolean isDeleted = this.tempFile.delete();
            if (!isDeleted) {
                if (LOG.isErrorEnabled()) {
                    LOG.error("Temp file {} could not be deleted!", (Object)this.tempFile.getAbsolutePath());
                }
            } else if (LOG.isDebugEnabled()) {
                LOG.debug("Deleted temp file: {}", (Object)this.tempFile.getAbsolutePath());
            }
        }
        this.buf = null;
    }

    public InputStream getInputStream() throws IOException {
        if (this.tmpStream != null) {
            this.close();
            this.buf = null;
            return new InternalTempFileInputStream();
        }
        return new InternalBufferInputStream();
    }

    static /* synthetic */ byte[] access$402(ThresholdOutputStream x0, byte[] x1) {
        x0.buf = x1;
        return x1;
    }

    private final class InternalTempFileInputStream
    extends ThresholdInputStream {
        private final Cipher cipher;
        private BufferedInputStream stream;
        private boolean isDeleted;
        private boolean isClosed;

        public InternalTempFileInputStream() throws IOException {
            this.isDeleted = false;
            this.isClosed = false;
            if (ThresholdOutputStream.this.encrypt) {
                try {
                    this.cipher = Cipher.getInstance(ThresholdOutputStream.TRANSFORMATION);
                    this.cipher.init(2, ThresholdOutputStream.this.key, new IvParameterSpec(ThresholdOutputStream.this.iv));
                }
                catch (Exception e) {
                    this.delete();
                    if (LOG.isErrorEnabled()) {
                        LOG.error("Cannot initialize decryption cipher: {}", (Object)e.toString(), (Object)e);
                    }
                    throw new IOException("Cannot initialize decryption cipher!", e);
                }
            } else {
                this.cipher = null;
            }
            this.openStream();
        }

        protected void openStream() throws FileNotFoundException {
            int bufferSize = ThresholdOutputStream.this.memoryThreshold < 4096 ? 4096 : ThresholdOutputStream.this.memoryThreshold;
            this.stream = ThresholdOutputStream.this.encrypt ? new BufferedInputStream(new CipherInputStream(new FileInputStream(ThresholdOutputStream.this.tempFile), this.cipher), bufferSize) : new BufferedInputStream(new FileInputStream(ThresholdOutputStream.this.tempFile), bufferSize);
        }

        @Override
        public boolean isInMemory() {
            return false;
        }

        @Override
        public File getTemporaryFile() {
            if (this.isDeleted) {
                throw new IllegalStateException("Temporary file is already deleted!");
            }
            return ThresholdOutputStream.this.tempFile;
        }

        @Override
        public void rewind() throws IOException {
            if (this.isClosed) {
                throw new IOException("Stream is already closed!");
            }
            this.stream.close();
            this.openStream();
        }

        @Override
        public int available() throws IOException {
            if (this.isClosed) {
                return 0;
            }
            return this.stream.available();
        }

        @Override
        public boolean markSupported() {
            return true;
        }

        @Override
        public void mark(int readlimit) {
            if (!this.isClosed) {
                this.stream.mark(readlimit);
            }
        }

        @Override
        public void reset() throws IOException {
            if (this.isClosed) {
                throw new IOException("Stream is already closed!");
            }
            this.stream.reset();
        }

        @Override
        public long skip(long n) throws IOException {
            if (this.isClosed) {
                return -1L;
            }
            return this.stream.skip(n);
        }

        @Override
        public int read() throws IOException {
            if (this.isClosed) {
                return -1;
            }
            int b = this.stream.read();
            return b;
        }

        @Override
        public int read(byte[] b) throws IOException {
            return this.read(b, 0, b.length);
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            if (this.isClosed) {
                return -1;
            }
            int n = super.read(b, off, len);
            return n;
        }

        @Override
        public void close() throws IOException {
            this.delete();
        }

        protected void delete() {
            block8: {
                if (!this.isClosed) {
                    try {
                        this.stream.close();
                        this.isClosed = true;
                        this.stream = null;
                    }
                    catch (Exception e) {
                        if (!LOG.isDebugEnabled()) break block8;
                        LOG.debug("Closing the temp file {} failed: {}", new Object[]{ThresholdOutputStream.this.tempFile.getAbsolutePath(), e.toString(), e});
                    }
                }
            }
            if (!this.isDeleted) {
                this.isDeleted = ThresholdOutputStream.this.tempFile.delete();
                if (!this.isDeleted) {
                    if (LOG.isErrorEnabled()) {
                        LOG.error("Temp file {} could not be deleted!", (Object)ThresholdOutputStream.this.tempFile.getAbsolutePath());
                    }
                } else if (LOG.isDebugEnabled()) {
                    LOG.debug("Deleted temp file: {}", (Object)ThresholdOutputStream.this.tempFile.getAbsolutePath());
                }
            }
        }
    }

    private final class InternalBufferInputStream
    extends ThresholdInputStream {
        private int pos;
        private int mark;

        private InternalBufferInputStream() {
            this.pos = 0;
            this.mark = -1;
        }

        @Override
        public boolean isInMemory() {
            return true;
        }

        @Override
        public byte[] getBytes() {
            if (ThresholdOutputStream.this.buf == null) {
                throw new IllegalStateException("Stream is already closed!");
            }
            return ThresholdOutputStream.this.buf;
        }

        @Override
        public void rewind() throws IOException {
            if (ThresholdOutputStream.this.buf == null) {
                throw new IOException("Stream is already closed!");
            }
            this.pos = 0;
            this.mark = -1;
        }

        @Override
        public boolean markSupported() {
            return true;
        }

        @Override
        public void mark(int readlimit) {
            if (ThresholdOutputStream.this.buf != null) {
                this.mark = this.pos;
            }
        }

        @Override
        public void reset() throws IOException {
            if (this.mark < 0) {
                throw new IOException("Reset not possible.");
            }
            this.pos = this.mark;
        }

        @Override
        public int available() {
            if (ThresholdOutputStream.this.buf == null) {
                return 0;
            }
            return ThresholdOutputStream.this.bufSize - this.pos;
        }

        @Override
        public int read() {
            return this.pos < ThresholdOutputStream.this.bufSize && ThresholdOutputStream.this.buf != null ? ThresholdOutputStream.this.buf[this.pos++] & 0xFF : -1;
        }

        @Override
        public int read(byte[] b) throws IOException {
            return this.read(b, 0, b.length);
        }

        @Override
        public int read(byte[] b, int off, int len) {
            if (this.pos >= ThresholdOutputStream.this.bufSize || ThresholdOutputStream.this.buf == null) {
                return -1;
            }
            if (len == 0) {
                return 0;
            }
            if (this.pos + len > ThresholdOutputStream.this.bufSize) {
                len = ThresholdOutputStream.this.bufSize - this.pos;
            }
            System.arraycopy(ThresholdOutputStream.this.buf, this.pos, b, off, len);
            this.pos += len;
            return len;
        }

        @Override
        public long skip(long n) {
            if (ThresholdOutputStream.this.buf == null) {
                return -1L;
            }
            if (n <= 0L) {
                return 0L;
            }
            if ((long)this.pos + n > (long)ThresholdOutputStream.this.bufSize) {
                n = ThresholdOutputStream.this.bufSize - this.pos;
            }
            this.pos = (int)((long)this.pos + n);
            return n;
        }

        @Override
        public void close() throws IOException {
            ThresholdOutputStream.access$402(ThresholdOutputStream.this, null);
            this.mark = -1;
        }
    }

    public abstract class ThresholdInputStream
    extends InputStream {
        public abstract boolean isInMemory();

        public File getTemporaryFile() {
            return null;
        }

        public byte[] getBytes() {
            return null;
        }

        public String getMimeType() {
            return ThresholdOutputStream.this.mimeType;
        }

        public String getFileName() {
            return ThresholdOutputStream.this.filename;
        }

        public long getLength() {
            return ThresholdOutputStream.this.length;
        }

        public abstract void rewind() throws IOException;
    }
}

