/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.backward_codecs.lucene95;

import java.io.IOException;
import org.apache.lucene.backward_codecs.lucene95.Lucene95HnswVectorsReader;
import org.apache.lucene.codecs.KnnVectorsFormat;
import org.apache.lucene.codecs.KnnVectorsReader;
import org.apache.lucene.codecs.KnnVectorsWriter;
import org.apache.lucene.index.SegmentReadState;
import org.apache.lucene.index.SegmentWriteState;

public class Lucene95HnswVectorsFormat
extends KnnVectorsFormat {
    static final String META_CODEC_NAME = "Lucene95HnswVectorsFormatMeta";
    static final String VECTOR_DATA_CODEC_NAME = "Lucene95HnswVectorsFormatData";
    static final String VECTOR_INDEX_CODEC_NAME = "Lucene95HnswVectorsFormatIndex";
    static final String META_EXTENSION = "vem";
    static final String VECTOR_DATA_EXTENSION = "vec";
    static final String VECTOR_INDEX_EXTENSION = "vex";
    static final int VERSION_START = 0;
    static final int VERSION_CURRENT = 1;
    private static final int MAXIMUM_MAX_CONN = 512;
    public static final int DEFAULT_MAX_CONN = 16;
    private static final int MAXIMUM_BEAM_WIDTH = 3200;
    public static final int DEFAULT_BEAM_WIDTH = 100;
    static final int DIRECT_MONOTONIC_BLOCK_SHIFT = 16;
    final int maxConn;
    final int beamWidth;

    public Lucene95HnswVectorsFormat() {
        this(16, 100);
    }

    public Lucene95HnswVectorsFormat(int maxConn, int beamWidth) {
        super("Lucene95HnswVectorsFormat");
        if (maxConn <= 0 || maxConn > 512) {
            throw new IllegalArgumentException("maxConn must be positive and less than or equal to 512; maxConn=" + maxConn);
        }
        if (beamWidth <= 0 || beamWidth > 3200) {
            throw new IllegalArgumentException("beamWidth must be positive and less than or equal to 3200; beamWidth=" + beamWidth);
        }
        this.maxConn = maxConn;
        this.beamWidth = beamWidth;
    }

    public KnnVectorsWriter fieldsWriter(SegmentWriteState state) throws IOException {
        throw new UnsupportedOperationException("Old codecs may only be used for reading");
    }

    public KnnVectorsReader fieldsReader(SegmentReadState state) throws IOException {
        return new Lucene95HnswVectorsReader(state);
    }

    public int getMaxDimensions(String fieldName) {
        return 1024;
    }

    public String toString() {
        return "Lucene95HnswVectorsFormat(name=Lucene95HnswVectorsFormat, maxConn=" + this.maxConn + ", beamWidth=" + this.beamWidth + ")";
    }
}

