/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.networking.v1;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.fabric8.kubernetes.api.builder.Editable;
import io.fabric8.kubernetes.api.model.KubernetesResource;
import io.fabric8.kubernetes.api.model.networking.v1.IngressBackend;
import io.fabric8.kubernetes.api.model.networking.v1.IngressRule;
import io.fabric8.kubernetes.api.model.networking.v1.IngressSpecBuilder;
import io.fabric8.kubernetes.api.model.networking.v1.IngressTLS;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

@JsonDeserialize(using=JsonDeserializer.None.class)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"defaultBackend", "ingressClassName", "rules", "tls"})
public class IngressSpec
implements Editable<IngressSpecBuilder>,
KubernetesResource {
    @JsonProperty(value="defaultBackend")
    private IngressBackend defaultBackend;
    @JsonProperty(value="ingressClassName")
    private String ingressClassName;
    @JsonProperty(value="rules")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private List<IngressRule> rules = new ArrayList<IngressRule>();
    @JsonProperty(value="tls")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private List<IngressTLS> tls = new ArrayList<IngressTLS>();
    @JsonIgnore
    private Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();

    public IngressSpec() {
    }

    public IngressSpec(IngressBackend defaultBackend, String ingressClassName, List<IngressRule> rules, List<IngressTLS> tls) {
        this.defaultBackend = defaultBackend;
        this.ingressClassName = ingressClassName;
        this.rules = rules;
        this.tls = tls;
    }

    @JsonProperty(value="defaultBackend")
    public IngressBackend getDefaultBackend() {
        return this.defaultBackend;
    }

    @JsonProperty(value="defaultBackend")
    public void setDefaultBackend(IngressBackend defaultBackend) {
        this.defaultBackend = defaultBackend;
    }

    @JsonProperty(value="ingressClassName")
    public String getIngressClassName() {
        return this.ingressClassName;
    }

    @JsonProperty(value="ingressClassName")
    public void setIngressClassName(String ingressClassName) {
        this.ingressClassName = ingressClassName;
    }

    @JsonProperty(value="rules")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public List<IngressRule> getRules() {
        return this.rules;
    }

    @JsonProperty(value="rules")
    public void setRules(List<IngressRule> rules) {
        this.rules = rules;
    }

    @JsonProperty(value="tls")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public List<IngressTLS> getTls() {
        return this.tls;
    }

    @JsonProperty(value="tls")
    public void setTls(List<IngressTLS> tls) {
        this.tls = tls;
    }

    @JsonIgnore
    public IngressSpecBuilder edit() {
        return new IngressSpecBuilder(this);
    }

    @JsonIgnore
    public IngressSpecBuilder toBuilder() {
        return this.edit();
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public void setAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
    }

    public String toString() {
        return "IngressSpec(defaultBackend=" + this.getDefaultBackend() + ", ingressClassName=" + this.getIngressClassName() + ", rules=" + this.getRules() + ", tls=" + this.getTls() + ", additionalProperties=" + this.getAdditionalProperties() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof IngressSpec)) {
            return false;
        }
        IngressSpec other = (IngressSpec)o;
        if (!other.canEqual(this)) {
            return false;
        }
        IngressBackend this$defaultBackend = this.getDefaultBackend();
        IngressBackend other$defaultBackend = other.getDefaultBackend();
        if (this$defaultBackend == null ? other$defaultBackend != null : !((Object)this$defaultBackend).equals(other$defaultBackend)) {
            return false;
        }
        String this$ingressClassName = this.getIngressClassName();
        String other$ingressClassName = other.getIngressClassName();
        if (this$ingressClassName == null ? other$ingressClassName != null : !this$ingressClassName.equals(other$ingressClassName)) {
            return false;
        }
        List<IngressRule> this$rules = this.getRules();
        List<IngressRule> other$rules = other.getRules();
        if (this$rules == null ? other$rules != null : !((Object)this$rules).equals(other$rules)) {
            return false;
        }
        List<IngressTLS> this$tls = this.getTls();
        List<IngressTLS> other$tls = other.getTls();
        if (this$tls == null ? other$tls != null : !((Object)this$tls).equals(other$tls)) {
            return false;
        }
        Map<String, Object> this$additionalProperties = this.getAdditionalProperties();
        Map<String, Object> other$additionalProperties = other.getAdditionalProperties();
        return !(this$additionalProperties == null ? other$additionalProperties != null : !((Object)this$additionalProperties).equals(other$additionalProperties));
    }

    protected boolean canEqual(Object other) {
        return other instanceof IngressSpec;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        IngressBackend $defaultBackend = this.getDefaultBackend();
        result = result * 59 + ($defaultBackend == null ? 43 : ((Object)$defaultBackend).hashCode());
        String $ingressClassName = this.getIngressClassName();
        result = result * 59 + ($ingressClassName == null ? 43 : $ingressClassName.hashCode());
        List<IngressRule> $rules = this.getRules();
        result = result * 59 + ($rules == null ? 43 : ((Object)$rules).hashCode());
        List<IngressTLS> $tls = this.getTls();
        result = result * 59 + ($tls == null ? 43 : ((Object)$tls).hashCode());
        Map<String, Object> $additionalProperties = this.getAdditionalProperties();
        result = result * 59 + ($additionalProperties == null ? 43 : ((Object)$additionalProperties).hashCode());
        return result;
    }
}

