/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.consumer.internals;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.kafka.clients.consumer.AcknowledgeType;
import org.apache.kafka.clients.consumer.internals.AcknowledgementBatch;
import org.apache.kafka.common.protocol.Errors;

public class Acknowledgements {
    public static final byte ACKNOWLEDGE_TYPE_GAP = 0;
    public static final int MAX_RECORDS_WITH_SAME_ACKNOWLEDGE_TYPE = 10;
    private final Map<Long, AcknowledgeType> acknowledgements;
    private Errors acknowledgeErrorCode;

    public static Acknowledgements empty() {
        return new Acknowledgements(new TreeMap<Long, AcknowledgeType>());
    }

    private Acknowledgements(Map<Long, AcknowledgeType> acknowledgements) {
        this.acknowledgements = acknowledgements;
    }

    public void add(long offset, AcknowledgeType type) {
        this.acknowledgements.put(offset, type);
    }

    public boolean addIfAbsent(long offset, AcknowledgeType type) {
        return this.acknowledgements.putIfAbsent(offset, type) == null;
    }

    public void addGap(long offset) {
        this.acknowledgements.put(offset, null);
    }

    public AcknowledgeType get(long offset) {
        return this.acknowledgements.get(offset);
    }

    public boolean isEmpty() {
        return this.acknowledgements.isEmpty();
    }

    public int size() {
        return this.acknowledgements.size();
    }

    public boolean isCompleted() {
        return this.acknowledgeErrorCode != null;
    }

    public void setAcknowledgeErrorCode(Errors acknowledgeErrorCode) {
        this.acknowledgeErrorCode = acknowledgeErrorCode;
    }

    public Errors getAcknowledgeErrorCode() {
        return this.acknowledgeErrorCode;
    }

    public Acknowledgements merge(Acknowledgements other) {
        this.acknowledgements.putAll(other.acknowledgements);
        return this;
    }

    public Map<Long, AcknowledgeType> getAcknowledgementsTypeMap() {
        return this.acknowledgements;
    }

    public List<AcknowledgementBatch> getAcknowledgementBatches() {
        ArrayList<AcknowledgementBatch> batches = new ArrayList<AcknowledgementBatch>();
        if (this.acknowledgements.isEmpty()) {
            return batches;
        }
        AcknowledgementBatch currentBatch = null;
        for (Map.Entry<Long, AcknowledgeType> entry : this.acknowledgements.entrySet()) {
            if (currentBatch == null) {
                currentBatch = new AcknowledgementBatch();
                currentBatch.setFirstOffset(entry.getKey());
            } else {
                currentBatch = this.maybeCreateNewBatch(currentBatch, entry.getKey(), batches);
            }
            currentBatch.setLastOffset(entry.getKey());
            if (entry.getValue() != null) {
                currentBatch.acknowledgeTypes().add(entry.getValue().id);
                continue;
            }
            currentBatch.acknowledgeTypes().add((byte)0);
        }
        List<AcknowledgementBatch> optimalBatches = this.maybeOptimiseAcknowledgementTypes(currentBatch);
        optimalBatches.forEach(batch -> {
            if (this.canOptimiseForSingleAcknowledgeType((AcknowledgementBatch)batch)) {
                batch.acknowledgeTypes().subList(1, batch.acknowledgeTypes().size()).clear();
            }
            batches.add((AcknowledgementBatch)batch);
        });
        return batches;
    }

    private AcknowledgementBatch maybeCreateNewBatch(AcknowledgementBatch currentBatch, Long nextOffset, List<AcknowledgementBatch> batches) {
        if (nextOffset != currentBatch.lastOffset() + 1L) {
            List<AcknowledgementBatch> optimalBatches = this.maybeOptimiseAcknowledgementTypes(currentBatch);
            optimalBatches.forEach(batch -> {
                if (this.canOptimiseForSingleAcknowledgeType((AcknowledgementBatch)batch)) {
                    batch.acknowledgeTypes().subList(1, batch.acknowledgeTypes().size()).clear();
                }
                batches.add((AcknowledgementBatch)batch);
            });
            currentBatch = new AcknowledgementBatch();
            currentBatch.setFirstOffset(nextOffset);
        }
        return currentBatch;
    }

    private List<AcknowledgementBatch> maybeOptimiseAcknowledgementTypes(AcknowledgementBatch currentAcknowledgeBatch) {
        ArrayList<AcknowledgementBatch> batches = new ArrayList<AcknowledgementBatch>();
        if (currentAcknowledgeBatch == null) {
            return batches;
        }
        long currentOffset = currentAcknowledgeBatch.firstOffset();
        int currentStartIndex = 0;
        int recordsWithSameAcknowledgeType = 1;
        for (int i = 1; i < currentAcknowledgeBatch.acknowledgeTypes().size(); ++i) {
            byte prevAcknowledgeType;
            byte acknowledgeType = currentAcknowledgeBatch.acknowledgeTypes().get(i);
            if (acknowledgeType == (prevAcknowledgeType = currentAcknowledgeBatch.acknowledgeTypes().get(i - 1).byteValue()) && recordsWithSameAcknowledgeType >= 10) {
                byte acknowledgeType2;
                while (i < currentAcknowledgeBatch.acknowledgeTypes().size() && (acknowledgeType2 = currentAcknowledgeBatch.acknowledgeTypes().get(i).byteValue()) == currentAcknowledgeBatch.acknowledgeTypes().get(i - 1)) {
                    ++i;
                    ++recordsWithSameAcknowledgeType;
                }
                AcknowledgementBatch batch1 = new AcknowledgementBatch();
                batch1.setFirstOffset(currentOffset);
                batch1.setLastOffset(currentOffset + (long)i - (long)recordsWithSameAcknowledgeType - (long)currentStartIndex - 1L);
                if (batch1.lastOffset() >= batch1.firstOffset()) {
                    batch1.setAcknowledgeTypes(new ArrayList<Byte>(currentAcknowledgeBatch.acknowledgeTypes().subList(currentStartIndex, i - recordsWithSameAcknowledgeType)));
                    batches.add(batch1);
                }
                AcknowledgementBatch batch2 = new AcknowledgementBatch();
                batch2.setFirstOffset(currentOffset + (long)i - (long)recordsWithSameAcknowledgeType - (long)currentStartIndex);
                batch2.setLastOffset(currentOffset + (long)i - (long)currentStartIndex - 1L);
                batch2.acknowledgeTypes().add(acknowledgeType);
                batches.add(batch2);
                recordsWithSameAcknowledgeType = 1;
                currentOffset = currentOffset + (long)i - (long)currentStartIndex;
                currentStartIndex = i;
                continue;
            }
            if (acknowledgeType == prevAcknowledgeType) {
                ++recordsWithSameAcknowledgeType;
                continue;
            }
            recordsWithSameAcknowledgeType = 1;
        }
        if (currentStartIndex < currentAcknowledgeBatch.acknowledgeTypes().size()) {
            AcknowledgementBatch batch = new AcknowledgementBatch();
            batch.setFirstOffset(currentOffset);
            batch.setLastOffset(currentOffset + (long)currentAcknowledgeBatch.acknowledgeTypes().size() - (long)currentStartIndex - 1L);
            batch.setAcknowledgeTypes(new ArrayList<Byte>(currentAcknowledgeBatch.acknowledgeTypes().subList(currentStartIndex, currentAcknowledgeBatch.acknowledgeTypes().size())));
            batches.add(batch);
        }
        return batches;
    }

    private boolean canOptimiseForSingleAcknowledgeType(AcknowledgementBatch acknowledgementBatch) {
        if (acknowledgementBatch == null || acknowledgementBatch.acknowledgeTypes().size() == 1) {
            return false;
        }
        byte firstAcknowledgeType = acknowledgementBatch.acknowledgeTypes().get(0);
        for (int i = 1; i < acknowledgementBatch.acknowledgeTypes().size(); ++i) {
            if (acknowledgementBatch.acknowledgeTypes().get(i) == firstAcknowledgeType) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Acknowledgements(");
        sb.append(this.acknowledgements);
        if (this.acknowledgeErrorCode != null) {
            sb.append(", errorCode=");
            sb.append(this.acknowledgeErrorCode.code());
        }
        sb.append(")");
        return sb.toString();
    }
}

