/*
 * Decompiled with CFR 0.152.
 */
package com.github.scribejava.apis.polar;

import com.fasterxml.jackson.databind.JsonNode;
import com.github.scribejava.apis.polar.PolarOAuth2AccessToken;
import com.github.scribejava.core.extractors.OAuth2AccessTokenJsonExtractor;
import com.github.scribejava.core.model.OAuth2AccessTokenErrorResponse;
import com.github.scribejava.core.oauth2.OAuth2Error;
import java.io.IOException;

public class PolarJsonTokenExtractor
extends OAuth2AccessTokenJsonExtractor {
    protected PolarJsonTokenExtractor() {
    }

    public static PolarJsonTokenExtractor instance() {
        return InstanceHolder.INSTANCE;
    }

    protected PolarOAuth2AccessToken createToken(String accessToken, String tokenType, Integer expiresIn, String refreshToken, String scope, JsonNode response, String rawResponse) {
        return new PolarOAuth2AccessToken(accessToken, tokenType, expiresIn, refreshToken, scope, response.get("x_user_id").asText(), rawResponse);
    }

    public void generateError(String rawResponse) throws IOException {
        OAuth2Error errorCode;
        JsonNode errorNode = OAuth2AccessTokenJsonExtractor.OBJECT_MAPPER.readTree(rawResponse).get("errors").get(0);
        try {
            errorCode = OAuth2Error.parseFrom((String)PolarJsonTokenExtractor.extractRequiredParameter((JsonNode)errorNode, (String)"errorType", (String)rawResponse).asText());
        }
        catch (IllegalArgumentException iaE) {
            errorCode = null;
        }
        throw new OAuth2AccessTokenErrorResponse(errorCode, errorNode.get("message").asText(), null, rawResponse);
    }

    private static class InstanceHolder {
        private static final PolarJsonTokenExtractor INSTANCE = new PolarJsonTokenExtractor();

        private InstanceHolder() {
        }
    }
}

