/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.jdbc;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import org.apache.log4j.Appender;
import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.helpers.LogLog;
import org.apache.log4j.jdbc.JdbcPatternParser;
import org.apache.log4j.spi.LoggingEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JDBCAppender
extends AppenderSkeleton
implements Appender {
    private static final IllegalArgumentException ILLEGAL_PATTERN_FOR_SECURE_EXEC = new IllegalArgumentException("Only org.apache.log4j.PatternLayout is supported for now due to CVE-2022-23305");
    protected String databaseURL = "jdbc:odbc:myDB";
    protected String databaseUser = "me";
    protected String databasePassword = "mypassword";
    protected Connection connection = null;
    protected String sqlStatement = "";
    private JdbcPatternParser preparedStatementParser;
    protected int bufferSize = 1;
    protected ArrayList<LoggingEvent> buffer = new ArrayList(this.bufferSize);
    private boolean locationInfo = false;
    private boolean isActive = false;

    @Override
    public void activateOptions() {
        if (this.getSql() == null || this.getSql().trim().length() == 0) {
            LogLog.error("JDBCAppender.sql parameter is mandatory. Skipping all futher processing");
            this.isActive = false;
            return;
        }
        LogLog.debug("JDBCAppender constructing internal pattern parser");
        this.preparedStatementParser = new JdbcPatternParser(this.getSql());
        this.isActive = true;
    }

    public boolean getLocationInfo() {
        return this.locationInfo;
    }

    public void setLocationInfo(boolean flag) {
        this.locationInfo = flag;
    }

    @Override
    public void append(LoggingEvent event) {
        if (!this.isActive) {
            return;
        }
        event.getNDC();
        event.getThreadName();
        event.getMDCCopy();
        if (this.locationInfo) {
            event.getLocationInformation();
        }
        event.getRenderedMessage();
        event.getThrowableStrRep();
        this.buffer.add(event);
        if (this.buffer.size() >= this.bufferSize) {
            this.flushBuffer();
        }
    }

    protected String getLogStatement(LoggingEvent event) {
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void execute(String sql) throws SQLException {
        Connection con = null;
        Statement stmt = null;
        try {
            con = this.getConnection();
            stmt = con.createStatement();
            stmt.executeUpdate(sql);
        }
        finally {
            if (stmt != null) {
                stmt.close();
            }
            this.closeConnection(con);
        }
    }

    protected void closeConnection(Connection con) {
    }

    protected Connection getConnection() throws SQLException {
        if (!DriverManager.getDrivers().hasMoreElements()) {
            this.setDriver("sun.jdbc.odbc.JdbcOdbcDriver");
        }
        if (this.connection == null) {
            this.connection = DriverManager.getConnection(this.databaseURL, this.databaseUser, this.databasePassword);
        }
        return this.connection;
    }

    @Override
    public void close() {
        this.flushBuffer();
        try {
            if (this.connection != null && !this.connection.isClosed()) {
                this.connection.close();
            }
        }
        catch (SQLException e) {
            this.errorHandler.error("Error closing connection", e, 0);
        }
        this.closed = true;
    }

    public void flushBuffer() {
        if (this.buffer.isEmpty()) {
            return;
        }
        this.flushBufferSecure();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flushBufferSecure() {
        ArrayList<LoggingEvent> removes = new ArrayList<LoggingEvent>(this.buffer);
        this.buffer.removeAll(removes);
        if (this.layout.getClass() != PatternLayout.class) {
            this.errorHandler.error("Failed to convert pattern " + this.layout + " to SQL", ILLEGAL_PATTERN_FOR_SECURE_EXEC, 5);
            return;
        }
        Connection con = null;
        boolean useBatch = removes.size() > 1;
        try {
            con = this.getConnection();
            PreparedStatement ps = con.prepareStatement(this.preparedStatementParser.getParameterizedSql());
            this.safelyInsertIntoDB(removes, useBatch, ps);
        }
        catch (SQLException e) {
            this.errorHandler.error("Failed to append messages sql", e, 2);
        }
        finally {
            if (con != null) {
                this.closeConnection(con);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void safelyInsertIntoDB(ArrayList<LoggingEvent> removes, boolean useBatch, PreparedStatement ps) throws SQLException {
        try {
            for (LoggingEvent logEvent : removes) {
                try {
                    this.preparedStatementParser.setParameters(ps, logEvent);
                    if (!useBatch) continue;
                    ps.addBatch();
                }
                catch (SQLException e) {
                    this.errorHandler.error("Failed to append parameters", e, 2);
                }
            }
            if (useBatch) {
                ps.executeBatch();
            } else {
                ps.execute();
            }
        }
        finally {
            try {
                ps.close();
            }
            catch (SQLException sQLException) {}
        }
    }

    @Override
    public void finalize() {
        this.close();
    }

    @Override
    public boolean requiresLayout() {
        return true;
    }

    public void setSql(String s) {
        this.sqlStatement = s;
        if (this.getLayout() == null) {
            this.setLayout(new PatternLayout(s));
        } else {
            ((PatternLayout)this.getLayout()).setConversionPattern(s);
        }
    }

    public String getSql() {
        return this.sqlStatement;
    }

    public void setUser(String user) {
        this.databaseUser = user;
    }

    public void setURL(String url) {
        this.databaseURL = url;
    }

    public void setPassword(String password) {
        this.databasePassword = password;
    }

    public void setBufferSize(int newBufferSize) {
        this.bufferSize = newBufferSize;
        this.buffer.ensureCapacity(this.bufferSize);
    }

    public String getUser() {
        return this.databaseUser;
    }

    public String getURL() {
        return this.databaseURL;
    }

    public String getPassword() {
        return this.databasePassword;
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public void setDriver(String driverClass) {
        try {
            Class.forName(driverClass);
        }
        catch (Exception e) {
            this.errorHandler.error("Failed to load driver", e, 0);
        }
    }
}

