/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.topology.discovery.ambari;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.knox.gateway.topology.discovery.ambari.AmbariCluster;
import org.apache.knox.gateway.topology.discovery.ambari.AmbariComponent;
import org.apache.knox.gateway.topology.discovery.ambari.ServiceURLCreator;

public class NiFiURLCreator
implements ServiceURLCreator {
    static final String COMPONENT_NAME = "NIFI_MASTER";
    static final String CONFIG_SERVICE = "NIFI";
    static final String CONFIG_TYPE = "nifi-ambari-config";
    static final String CONFIG_TYPE_SSL = "nifi-ambari-ssl-config";
    static final String SSL_ENABLED_PROPERTY = "nifi.node.ssl.isenabled";
    static final String SCHEME_HTTP = "http";
    static final String SCHEME_HTTPS = "https";
    static final String PORT_PROPERTY = "nifi.node.port";
    static final String SSL_PORT_PROPERTY = "nifi.node.ssl.port";
    private AmbariCluster cluster;

    @Override
    public String getTargetService() {
        return CONFIG_SERVICE;
    }

    @Override
    public void init(AmbariCluster cluster) {
        this.cluster = cluster;
    }

    @Override
    public List<String> create(String service, Map<String, String> serviceParams) {
        AmbariCluster.ServiceConfiguration sc;
        ArrayList<String> urls = new ArrayList<String>();
        AmbariComponent component = this.cluster.getComponent(COMPONENT_NAME);
        if (component != null && (sc = this.cluster.getServiceConfiguration(service, CONFIG_TYPE)) != null) {
            Map<String, String> configProps = sc.getProperties();
            boolean isSSLEnabled = this.isSSLEnabled(service);
            String scheme = isSSLEnabled ? SCHEME_HTTPS : SCHEME_HTTP;
            String port = isSSLEnabled ? configProps.get(SSL_PORT_PROPERTY) : configProps.get(PORT_PROPERTY);
            for (String hostName : component.getHostNames()) {
                urls.add(scheme + "://" + hostName + ":" + port);
            }
        }
        return urls;
    }

    private boolean isSSLEnabled(String service) {
        boolean isSSLEnabled = false;
        AmbariCluster.ServiceConfiguration config = this.cluster.getServiceConfiguration(service, CONFIG_TYPE_SSL);
        if (config != null) {
            isSSLEnabled = Boolean.valueOf(config.getProperties().getOrDefault(SSL_ENABLED_PROPERTY, "false"));
        }
        return isSSLEnabled;
    }
}

