/*
 * Decompiled with CFR 0.152.
 */
package com.thetransactioncompany.cors;

import com.thetransactioncompany.cors.CORSConfiguration;
import com.thetransactioncompany.cors.CORSException;
import com.thetransactioncompany.cors.CORSRequestType;
import com.thetransactioncompany.cors.HeaderName;
import com.thetransactioncompany.cors.HeaderUtils;
import com.thetransactioncompany.cors.Origin;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class CORSRequestHandler {
    private final CORSConfiguration config;
    private final String supportedMethods;
    private final String supportedHeaders;
    private final String exposedHeaders;

    public CORSRequestHandler(CORSConfiguration config) {
        this.config = config;
        this.supportedMethods = HeaderUtils.serialize(config.supportedMethods, ", ");
        this.supportedHeaders = !config.supportAnyHeader ? HeaderUtils.serialize(config.supportedHeaders, ", ") : null;
        this.exposedHeaders = HeaderUtils.serialize(config.exposedHeaders, ", ");
    }

    public void handleActualRequest(HttpServletRequest request, HttpServletResponse response) throws CORSException {
        if (CORSRequestType.detect(request) != CORSRequestType.ACTUAL) {
            throw CORSException.INVALID_ACTUAL_REQUEST;
        }
        Origin requestOrigin = new Origin(request.getHeader("Origin"));
        if (!this.config.isAllowedOrigin(requestOrigin)) {
            throw CORSException.ORIGIN_DENIED;
        }
        String method = request.getMethod().toUpperCase();
        if (!this.config.isSupportedMethod(method)) {
            throw CORSException.UNSUPPORTED_METHOD;
        }
        if (this.config.supportsCredentials) {
            response.addHeader("Access-Control-Allow-Credentials", "true");
            response.addHeader("Access-Control-Allow-Origin", requestOrigin.toString());
            response.addHeader("Vary", "Origin");
        } else if (this.config.allowAnyOrigin) {
            response.addHeader("Access-Control-Allow-Origin", "*");
        } else {
            response.addHeader("Access-Control-Allow-Origin", requestOrigin.toString());
            response.addHeader("Vary", "Origin");
        }
        if (!this.exposedHeaders.isEmpty()) {
            response.addHeader("Access-Control-Expose-Headers", this.exposedHeaders);
        }
    }

    public void handlePreflightRequest(HttpServletRequest request, HttpServletResponse response) throws CORSException {
        if (CORSRequestType.detect(request) != CORSRequestType.PREFLIGHT) {
            throw CORSException.INVALID_PREFLIGHT_REQUEST;
        }
        Origin requestOrigin = new Origin(request.getHeader("Origin"));
        if (!this.config.isAllowedOrigin(requestOrigin)) {
            throw CORSException.ORIGIN_DENIED;
        }
        String requestMethodHeader = request.getHeader("Access-Control-Request-Method");
        if (requestMethodHeader == null) {
            throw CORSException.MISSING_ACCESS_CONTROL_REQUEST_METHOD_HEADER;
        }
        String requestedMethod = requestMethodHeader.toUpperCase();
        String rawRequestHeadersString = request.getHeader("Access-Control-Request-Headers");
        String[] requestHeaderValues = HeaderUtils.parseMultipleHeaderValues(rawRequestHeadersString);
        String[] requestHeaders = new String[requestHeaderValues.length];
        for (int i = 0; i < requestHeaders.length; ++i) {
            try {
                requestHeaders[i] = HeaderName.formatCanonical(requestHeaderValues[i]);
                continue;
            }
            catch (IllegalArgumentException e) {
                throw CORSException.INVALID_HEADER_VALUE;
            }
        }
        if (!this.config.isSupportedMethod(requestedMethod)) {
            throw CORSException.UNSUPPORTED_METHOD;
        }
        if (!this.config.supportAnyHeader) {
            for (String requestHeader : requestHeaders) {
                if (this.config.supportedHeaders.contains(requestHeader)) continue;
                throw CORSException.UNSUPPORTED_REQUEST_HEADER;
            }
        }
        if (this.config.supportsCredentials) {
            response.addHeader("Access-Control-Allow-Origin", requestOrigin.toString());
            response.addHeader("Access-Control-Allow-Credentials", "true");
            response.addHeader("Vary", "Origin");
        } else if (this.config.allowAnyOrigin) {
            response.addHeader("Access-Control-Allow-Origin", "*");
        } else {
            response.addHeader("Access-Control-Allow-Origin", requestOrigin.toString());
            response.addHeader("Vary", "Origin");
        }
        if (this.config.maxAge > 0) {
            response.addHeader("Access-Control-Max-Age", Integer.toString(this.config.maxAge));
        }
        response.addHeader("Access-Control-Allow-Methods", this.supportedMethods);
        if (this.config.supportAnyHeader && rawRequestHeadersString != null) {
            response.addHeader("Access-Control-Allow-Headers", rawRequestHeadersString);
        } else if (this.supportedHeaders != null && !this.supportedHeaders.isEmpty()) {
            response.addHeader("Access-Control-Allow-Headers", this.supportedHeaders);
        }
    }
}

