/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.client.channel;

import java.io.IOException;
import java.util.Date;
import org.apache.sshd.client.channel.PtyCapableChannelSession;
import org.apache.sshd.common.session.Session;
import org.apache.sshd.common.util.buffer.Buffer;

public class ChannelShell
extends PtyCapableChannelSession {
    public static final String REQUEST_SHELL_REPLY = "channel-shell-want-reply";
    public static final boolean DEFAULT_REQUEST_SHELL_REPLY = false;

    public ChannelShell() {
        super(true);
    }

    @Override
    protected void doOpen() throws IOException {
        this.doOpenPty();
        if (this.log.isDebugEnabled()) {
            this.log.debug("doOpen({}) send SSH_MSG_CHANNEL_REQUEST shell", (Object)this);
        }
        Session session = this.getSession();
        boolean wantReply = this.getBooleanProperty(REQUEST_SHELL_REPLY, false);
        Buffer buffer = session.createBuffer((byte)98, 32);
        buffer.putInt(this.getRecipient());
        buffer.putString("shell");
        buffer.putBoolean(wantReply);
        this.addPendingRequest("shell", wantReply);
        this.writePacket(buffer);
        super.doOpen();
    }

    @Override
    public void handleSuccess() throws IOException {
        Date pending = this.removePendingRequest("shell");
        if (this.log.isDebugEnabled()) {
            this.log.debug("handleSuccess({}) pending={}", (Object)this, (Object)pending);
        }
    }

    @Override
    public void handleFailure() throws IOException {
        Date pending = this.removePendingRequest("shell");
        if (pending != null) {
            this.log.warn("handleFailure({}) pending={}", (Object)this, (Object)pending);
            this.close(true);
        }
    }
}

