/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jms;

import javax.jms.TemporaryQueue;
import javax.jms.TemporaryTopic;
import org.springframework.jms.core.JmsOperations;

public class JmsProviderMetadata {
    private Class<? extends TemporaryQueue> temporaryQueueType;
    private Class<? extends TemporaryTopic> temporaryTopicType;

    public Class<? extends TemporaryQueue> getTemporaryQueueType(JmsOperations template) {
        Class<? extends TemporaryQueue> answer = this.getTemporaryQueueType();
        if (answer == null) {
            this.loadTemporaryDestinationTypes(template);
            answer = this.getTemporaryQueueType();
        }
        return answer;
    }

    public Class<? extends TemporaryTopic> getTemporaryTopicType(JmsOperations template) {
        Class<? extends TemporaryTopic> answer = this.getTemporaryTopicType();
        if (answer == null) {
            this.loadTemporaryDestinationTypes(template);
            answer = this.getTemporaryTopicType();
        }
        return answer;
    }

    public Class<? extends TemporaryQueue> getTemporaryQueueType() {
        return this.temporaryQueueType;
    }

    public void setTemporaryQueueType(Class<? extends TemporaryQueue> temporaryQueueType) {
        this.temporaryQueueType = temporaryQueueType;
    }

    public Class<? extends TemporaryTopic> getTemporaryTopicType() {
        return this.temporaryTopicType;
    }

    public void setTemporaryTopicType(Class<? extends TemporaryTopic> temporaryTopicType) {
        this.temporaryTopicType = temporaryTopicType;
    }

    protected void loadTemporaryDestinationTypes(JmsOperations template) {
        if (template == null) {
            throw new IllegalArgumentException("No JmsTemplate supplied!");
        }
        template.execute(session -> {
            TemporaryQueue queue = session.createTemporaryQueue();
            this.setTemporaryQueueType(queue.getClass());
            TemporaryTopic topic = session.createTemporaryTopic();
            this.setTemporaryTopicType(topic.getClass());
            queue.delete();
            topic.delete();
            return null;
        });
    }
}

