/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.util.json;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.camel.util.json.Jsonable;
import org.apache.camel.util.json.Jsoner;

public class JsonObject
extends LinkedHashMap<String, Object>
implements Jsonable {
    private static final long serialVersionUID = 1L;

    public JsonObject() {
    }

    public JsonObject(Map<String, ?> map) {
        super(map);
    }

    public BigDecimal getBigDecimal(String key) {
        Object returnable = this.get(key);
        if (!(returnable instanceof BigDecimal)) {
            if (returnable instanceof Number) {
                returnable = new BigDecimal(returnable.toString());
            } else if (returnable instanceof String) {
                returnable = new BigDecimal((String)returnable);
            }
        }
        return (BigDecimal)returnable;
    }

    public BigDecimal getBigDecimalOrDefault(String key, BigDecimal defaultValue) {
        if (!this.containsKey(key)) {
            return defaultValue;
        }
        Object returnable = this.get(key);
        if (!(returnable instanceof BigDecimal)) {
            if (returnable instanceof Number) {
                returnable = new BigDecimal(returnable.toString());
            } else if (returnable instanceof String) {
                returnable = new BigDecimal((String)returnable);
            }
        }
        return (BigDecimal)returnable;
    }

    public Boolean getBoolean(String key) {
        Object returnable = this.get(key);
        if (returnable instanceof String) {
            returnable = Boolean.valueOf((String)returnable);
        }
        return (Boolean)returnable;
    }

    public Boolean getBooleanOrDefault(String key, boolean defaultValue) {
        if (!this.containsKey(key)) {
            return defaultValue;
        }
        Object returnable = this.get(key);
        if (returnable instanceof String) {
            returnable = Boolean.valueOf((String)returnable);
        }
        return (Boolean)returnable;
    }

    public Byte getByte(String key) {
        Object returnable = this.get(key);
        if (returnable == null) {
            return null;
        }
        if (returnable instanceof String) {
            returnable = new BigDecimal((String)returnable);
        }
        return ((Number)returnable).byteValue();
    }

    public Byte getByteOrDefault(String key, byte defaultValue) {
        if (!this.containsKey(key)) {
            return defaultValue;
        }
        Object returnable = this.get(key);
        if (returnable == null) {
            return null;
        }
        if (returnable instanceof String) {
            returnable = new BigDecimal((String)returnable);
        }
        return ((Number)returnable).byteValue();
    }

    public <T extends Collection<?>> T getCollection(String key) {
        return (T)((Collection)this.get(key));
    }

    public <T extends Collection<?>> T getCollectionOrDefault(String key, T defaultValue) {
        if (!this.containsKey(key)) {
            return defaultValue;
        }
        Object returnable = this.get(key);
        return (T)((Collection)returnable);
    }

    public Double getDouble(String key) {
        Object returnable = this.get(key);
        if (returnable == null) {
            return null;
        }
        if (returnable instanceof String) {
            returnable = new BigDecimal((String)returnable);
        }
        return ((Number)returnable).doubleValue();
    }

    public Double getDoubleOrDefault(String key, double defaultValue) {
        if (!this.containsKey(key)) {
            return defaultValue;
        }
        Object returnable = this.get(key);
        if (returnable == null) {
            return null;
        }
        if (returnable instanceof String) {
            returnable = new BigDecimal((String)returnable);
        }
        return ((Number)returnable).doubleValue();
    }

    public <T extends Enum<T>> T getEnum(String key) throws ClassNotFoundException {
        String value = this.getStringOrDefault(key, "");
        if (value == null) {
            return null;
        }
        String[] splitValues = value.split("\\.");
        int numberOfSplitValues = splitValues.length;
        StringBuilder returnTypeName = new StringBuilder();
        StringBuilder enumName = new StringBuilder();
        for (int i = 0; i < numberOfSplitValues; ++i) {
            if (i == numberOfSplitValues - 1) {
                enumName.append(splitValues[i]);
                continue;
            }
            if (i == numberOfSplitValues - 2) {
                returnTypeName.append(splitValues[i]);
                continue;
            }
            returnTypeName.append(splitValues[i]);
            returnTypeName.append(".");
        }
        Class<?> returnType = Class.forName(returnTypeName.toString());
        Object returnable = Enum.valueOf(returnType, enumName.toString());
        return (T)returnable;
    }

    public <T extends Enum<T>> T getEnumOrDefault(String key, T defaultValue) throws ClassNotFoundException {
        StringBuilder enumName;
        StringBuilder returnTypeName;
        if (this.containsKey(key)) {
            String value = this.getStringOrDefault(key, "");
            if (value == null) {
                return null;
            }
            String[] splitValues = value.split("\\.");
            int numberOfSplitValues = splitValues.length;
            returnTypeName = new StringBuilder();
            enumName = new StringBuilder();
            for (int i = 0; i < numberOfSplitValues; ++i) {
                if (i == numberOfSplitValues - 1) {
                    enumName.append(splitValues[i]);
                    continue;
                }
                if (i == numberOfSplitValues - 2) {
                    returnTypeName.append(splitValues[i]);
                    continue;
                }
                returnTypeName.append(splitValues[i]);
                returnTypeName.append(".");
            }
        } else {
            return defaultValue;
        }
        Class<?> returnType = Class.forName(returnTypeName.toString());
        Object returnable = Enum.valueOf(returnType, enumName.toString());
        return (T)returnable;
    }

    public Float getFloat(String key) {
        Object returnable = this.get(key);
        if (returnable == null) {
            return null;
        }
        if (returnable instanceof String) {
            returnable = new BigDecimal((String)returnable);
        }
        return Float.valueOf(((Number)returnable).floatValue());
    }

    public Float getFloatOrDefault(String key, float defaultValue) {
        if (!this.containsKey(key)) {
            return Float.valueOf(defaultValue);
        }
        Object returnable = this.get(key);
        if (returnable == null) {
            return null;
        }
        if (returnable instanceof String) {
            returnable = new BigDecimal((String)returnable);
        }
        return Float.valueOf(((Number)returnable).floatValue());
    }

    public Integer getInteger(String key) {
        Object returnable = this.get(key);
        if (returnable == null) {
            return null;
        }
        if (returnable instanceof String) {
            returnable = new BigDecimal((String)returnable);
        }
        return ((Number)returnable).intValue();
    }

    public Integer getIntegerOrDefault(String key, int defaultValue) {
        if (!this.containsKey(key)) {
            return defaultValue;
        }
        Object returnable = this.get(key);
        if (returnable == null) {
            return null;
        }
        if (returnable instanceof String) {
            returnable = new BigDecimal((String)returnable);
        }
        return ((Number)returnable).intValue();
    }

    public Long getLong(String key) {
        Object returnable = this.get(key);
        if (returnable == null) {
            return null;
        }
        if (returnable instanceof String) {
            returnable = new BigDecimal((String)returnable);
        }
        return ((Number)returnable).longValue();
    }

    public Long getLongOrDefault(String key, long defaultValue) {
        if (!this.containsKey(key)) {
            return defaultValue;
        }
        Object returnable = this.get(key);
        if (returnable == null) {
            return null;
        }
        if (returnable instanceof String) {
            returnable = new BigDecimal((String)returnable);
        }
        return ((Number)returnable).longValue();
    }

    public <T extends Map<?, ?>> T getMap(String key) {
        return (T)((Map)this.get(key));
    }

    public <T extends Map<?, ?>> T getMapOrDefault(String key, T defaultValue) {
        Object returnable = this.containsKey(key) ? this.get(key) : defaultValue;
        return returnable;
    }

    public Short getShort(String key) {
        Object returnable = this.get(key);
        if (returnable == null) {
            return null;
        }
        if (returnable instanceof String) {
            returnable = new BigDecimal((String)returnable);
        }
        return ((Number)returnable).shortValue();
    }

    public Short getShortOrDefault(String key, short defaultValue) {
        if (!this.containsKey(key)) {
            return defaultValue;
        }
        Object returnable = this.get(key);
        if (returnable == null) {
            return null;
        }
        if (returnable instanceof String) {
            returnable = new BigDecimal((String)returnable);
        }
        return ((Number)returnable).shortValue();
    }

    public String getString(String key) {
        Object returnable = this.get(key);
        if (returnable instanceof Boolean) {
            returnable = returnable.toString();
        } else if (returnable instanceof Number) {
            returnable = returnable.toString();
        }
        return (String)returnable;
    }

    public String getStringOrDefault(String key, String defaultValue) {
        if (!this.containsKey(key)) {
            return defaultValue;
        }
        Object returnable = this.get(key);
        if (returnable instanceof Boolean) {
            returnable = returnable.toString();
        } else if (returnable instanceof Number) {
            returnable = returnable.toString();
        }
        return (String)returnable;
    }

    @Override
    public String toJson() {
        StringWriter writable = new StringWriter();
        try {
            this.toJson(writable);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return writable.toString();
    }

    @Override
    public void toJson(Writer writable) throws IOException {
        boolean isFirstEntry = true;
        Iterator entries = this.entrySet().iterator();
        writable.write(123);
        while (entries.hasNext()) {
            if (isFirstEntry) {
                isFirstEntry = false;
            } else {
                writable.write(44);
            }
            Map.Entry entry = entries.next();
            writable.write(Jsoner.serialize(entry.getKey()));
            writable.write(58);
            writable.write(Jsoner.serialize(entry.getValue()));
        }
        writable.write(125);
    }
}

