/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.storage.internals.log;

import java.util.Objects;
import java.util.Optional;
import org.apache.kafka.common.errors.ApiException;
import org.apache.kafka.common.record.FileRecords;
import org.apache.kafka.storage.internals.log.AsyncOffsetReadFutureHolder;

public class OffsetResultHolder {
    private Optional<FileRecords.TimestampAndOffset> timestampAndOffsetOpt;
    private final Optional<AsyncOffsetReadFutureHolder<FileRecordsOrError>> futureHolderOpt;
    private Optional<ApiException> maybeOffsetsError = Optional.empty();
    private Optional<Long> lastFetchableOffset = Optional.empty();

    public OffsetResultHolder() {
        this(Optional.empty(), Optional.empty());
    }

    public OffsetResultHolder(Optional<FileRecords.TimestampAndOffset> timestampAndOffsetOpt, Optional<AsyncOffsetReadFutureHolder<FileRecordsOrError>> futureHolderOpt) {
        this.timestampAndOffsetOpt = timestampAndOffsetOpt;
        this.futureHolderOpt = futureHolderOpt;
    }

    public OffsetResultHolder(Optional<FileRecords.TimestampAndOffset> timestampAndOffsetOpt) {
        this(timestampAndOffsetOpt, Optional.empty());
    }

    public OffsetResultHolder(FileRecords.TimestampAndOffset timestampAndOffsetOpt) {
        this(Optional.of(timestampAndOffsetOpt), Optional.empty());
    }

    public Optional<FileRecords.TimestampAndOffset> timestampAndOffsetOpt() {
        return this.timestampAndOffsetOpt;
    }

    public Optional<AsyncOffsetReadFutureHolder<FileRecordsOrError>> futureHolderOpt() {
        return this.futureHolderOpt;
    }

    public Optional<ApiException> maybeOffsetsError() {
        return this.maybeOffsetsError;
    }

    public Optional<Long> lastFetchableOffset() {
        return this.lastFetchableOffset;
    }

    public void timestampAndOffsetOpt(Optional<FileRecords.TimestampAndOffset> timestampAndOffsetOpt) {
        this.timestampAndOffsetOpt = timestampAndOffsetOpt;
    }

    public void maybeOffsetsError(Optional<ApiException> maybeOffsetsError) {
        this.maybeOffsetsError = maybeOffsetsError;
    }

    public void lastFetchableOffset(Optional<Long> lastFetchableOffset) {
        this.lastFetchableOffset = lastFetchableOffset;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OffsetResultHolder that = (OffsetResultHolder)o;
        return Objects.equals(this.timestampAndOffsetOpt, that.timestampAndOffsetOpt) && Objects.equals(this.futureHolderOpt, that.futureHolderOpt) && Objects.equals(this.maybeOffsetsError, that.maybeOffsetsError) && Objects.equals(this.lastFetchableOffset, that.lastFetchableOffset);
    }

    public int hashCode() {
        int result = Objects.hashCode(this.timestampAndOffsetOpt);
        result = 31 * result + Objects.hashCode(this.futureHolderOpt);
        result = 31 * result + Objects.hashCode(this.maybeOffsetsError);
        result = 31 * result + Objects.hashCode(this.lastFetchableOffset);
        return result;
    }

    public record FileRecordsOrError(Optional<Exception> exception, Optional<FileRecords.TimestampAndOffset> timestampAndOffset) {
        public FileRecordsOrError {
            if (exception.isPresent() && timestampAndOffset.isPresent()) {
                throw new IllegalArgumentException("Either exception or timestampAndOffset should be present, but not both");
            }
        }

        public boolean hasException() {
            return this.exception.isPresent();
        }

        public boolean hasTimestampAndOffset() {
            return this.timestampAndOffset.isPresent();
        }
    }
}

