/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.tools.consumer.group;

import java.io.IOException;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import joptsimple.OptionException;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import org.apache.kafka.clients.admin.AbstractOptions;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.AlterShareGroupOffsetsOptions;
import org.apache.kafka.clients.admin.DeleteShareGroupOffsetsOptions;
import org.apache.kafka.clients.admin.DeleteShareGroupOffsetsResult;
import org.apache.kafka.clients.admin.DeleteShareGroupsOptions;
import org.apache.kafka.clients.admin.DescribeShareGroupsOptions;
import org.apache.kafka.clients.admin.GroupListing;
import org.apache.kafka.clients.admin.ListGroupsOptions;
import org.apache.kafka.clients.admin.ListGroupsResult;
import org.apache.kafka.clients.admin.ListShareGroupOffsetsOptions;
import org.apache.kafka.clients.admin.ListShareGroupOffsetsSpec;
import org.apache.kafka.clients.admin.ShareGroupDescription;
import org.apache.kafka.clients.admin.ShareMemberAssignment;
import org.apache.kafka.clients.admin.ShareMemberDescription;
import org.apache.kafka.clients.admin.SharePartitionOffsetInfo;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.common.GroupState;
import org.apache.kafka.common.GroupType;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.GroupIdNotFoundException;
import org.apache.kafka.common.errors.GroupNotEmptyException;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.server.util.CommandDefaultOptions;
import org.apache.kafka.server.util.CommandLineUtils;
import org.apache.kafka.tools.OffsetsUtils;
import org.apache.kafka.tools.consumer.group.ShareGroupCommandOptions;

public class ShareGroupCommand {
    static final String MISSING_COLUMN_VALUE = "-";

    public static void main(String[] args) {
        ShareGroupCommandOptions opts = new ShareGroupCommandOptions(args);
        try {
            opts.checkArgs();
            CommandLineUtils.maybePrintHelpOrVersion((CommandDefaultOptions)opts, (String)"This tool helps to list all share groups, describe a share group, delete share group info, or reset share group offsets.");
            long actions = Stream.of(opts.listOpt, opts.describeOpt, opts.deleteOpt, opts.resetOffsetsOpt, opts.deleteOffsetsOpt).filter(arg_0 -> ((OptionSet)opts.options).has(arg_0)).count();
            if (actions != 1L) {
                CommandLineUtils.printUsageAndExit((OptionParser)opts.parser, (String)"Command must include exactly one action: --list, --describe, --delete, --reset-offsets, --delete-offsets.");
            }
            ShareGroupCommand.run(opts);
        }
        catch (OptionException e) {
            CommandLineUtils.printUsageAndExit((OptionParser)opts.parser, (String)e.getMessage());
        }
    }

    public static void run(ShareGroupCommandOptions opts) {
        try (ShareGroupService shareGroupService = new ShareGroupService(opts, Map.of());){
            if (opts.options.has(opts.listOpt)) {
                shareGroupService.listGroups();
            } else if (opts.options.has(opts.describeOpt)) {
                shareGroupService.describeGroups();
            } else if (opts.options.has(opts.deleteOpt)) {
                shareGroupService.deleteShareGroups();
            } else if (opts.options.has(opts.resetOffsetsOpt)) {
                shareGroupService.resetOffsets();
            } else if (opts.options.has(opts.deleteOffsetsOpt)) {
                shareGroupService.deleteOffsets();
            }
        }
        catch (IllegalArgumentException e) {
            CommandLineUtils.printUsageAndExit((OptionParser)opts.parser, (String)e.getMessage());
        }
        catch (Throwable e) {
            ShareGroupCommand.printError("Executing share group command failed due to " + e.getMessage(), Optional.of(e));
        }
    }

    static Set<GroupState> groupStatesFromString(String input) {
        Set<GroupState> parsedStates = Arrays.stream(input.split(",")).map(s -> GroupState.parse((String)s.trim())).collect(Collectors.toSet());
        Set validStates = GroupState.groupStatesForType((GroupType)GroupType.SHARE);
        if (!validStates.containsAll(parsedStates)) {
            throw new IllegalArgumentException("Invalid state list '" + input + "'. Valid states are: " + validStates.stream().map(GroupState::toString).collect(Collectors.joining(", ")));
        }
        return parsedStates;
    }

    public static void printError(String msg, Optional<Throwable> e) {
        System.out.println("\nError: " + msg);
        e.ifPresent(Throwable::printStackTrace);
    }

    static class ShareGroupService
    implements AutoCloseable {
        final ShareGroupCommandOptions opts;
        private final Admin adminClient;
        private final OffsetsUtils offsetsUtils;

        public ShareGroupService(ShareGroupCommandOptions opts, Map<String, String> configOverrides) {
            this.opts = opts;
            try {
                this.adminClient = this.createAdminClient(configOverrides);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            this.offsetsUtils = new OffsetsUtils(this.adminClient, opts.parser, this.getOffsetsUtilsOptions(opts));
        }

        public ShareGroupService(ShareGroupCommandOptions opts, Admin adminClient) {
            this.opts = opts;
            this.adminClient = adminClient;
            this.offsetsUtils = new OffsetsUtils(adminClient, opts.parser, this.getOffsetsUtilsOptions(opts));
        }

        private OffsetsUtils.OffsetsUtilsOptions getOffsetsUtilsOptions(ShareGroupCommandOptions opts) {
            return new OffsetsUtils.OffsetsUtilsOptions(opts.options.valuesOf(opts.groupOpt), opts.options.valuesOf(opts.resetToDatetimeOpt), (Long)opts.options.valueOf(opts.timeoutMsOpt));
        }

        public void listGroups() throws ExecutionException, InterruptedException {
            if (this.opts.options.has(this.opts.stateOpt)) {
                String stateValue = (String)this.opts.options.valueOf(this.opts.stateOpt);
                Set<GroupState> states = stateValue == null || stateValue.isEmpty() ? Set.of() : ShareGroupCommand.groupStatesFromString(stateValue);
                List<GroupListing> listings = this.listShareGroupsInStates(states);
                this.printGroupInfo(listings);
            } else {
                this.listShareGroups().forEach(System.out::println);
            }
        }

        List<String> listShareGroups() {
            try {
                ListGroupsResult result = this.adminClient.listGroups((ListGroupsOptions)ListGroupsOptions.forShareGroups().timeoutMs(Integer.valueOf(((Long)this.opts.options.valueOf(this.opts.timeoutMsOpt)).intValue())));
                Collection listings = (Collection)result.all().get();
                return listings.stream().map(GroupListing::groupId).collect(Collectors.toList());
            }
            catch (InterruptedException | ExecutionException e) {
                throw new RuntimeException(e);
            }
        }

        List<GroupListing> listDetailedShareGroups() {
            try {
                ListGroupsResult result = this.adminClient.listGroups((ListGroupsOptions)ListGroupsOptions.forShareGroups().timeoutMs(Integer.valueOf(((Long)this.opts.options.valueOf(this.opts.timeoutMsOpt)).intValue())));
                Collection listings = (Collection)result.all().get();
                return listings.stream().toList();
            }
            catch (InterruptedException | ExecutionException e) {
                throw new RuntimeException(e);
            }
        }

        List<GroupListing> listShareGroupsInStates(Set<GroupState> states) throws ExecutionException, InterruptedException {
            ListGroupsResult result = this.adminClient.listGroups(((ListGroupsOptions)ListGroupsOptions.forShareGroups().timeoutMs(Integer.valueOf(((Long)this.opts.options.valueOf(this.opts.timeoutMsOpt)).intValue()))).inGroupStates(states));
            return new ArrayList<GroupListing>((Collection)result.all().get());
        }

        private void printGroupInfo(List<GroupListing> groups) {
            int maxGroupLen = 15;
            for (GroupListing group : groups) {
                maxGroupLen = Math.max(maxGroupLen, group.groupId().length());
            }
            System.out.printf("%" + -maxGroupLen + "s %s\n", "GROUP", "STATE");
            for (GroupListing group : groups) {
                String groupId = group.groupId();
                String state = group.groupState().orElse(GroupState.UNKNOWN).toString();
                System.out.printf("%" + -maxGroupLen + "s %s\n", groupId, state);
            }
        }

        public static boolean maybePrintEmptyGroupState(String group, GroupState state, int numRows) {
            if (state == GroupState.DEAD) {
                ShareGroupCommand.printError("Share group '" + group + "' does not exist.", Optional.empty());
            } else if (state == GroupState.EMPTY) {
                System.err.println("\nShare group '" + group + "' has no active members.");
            }
            return !state.equals((Object)GroupState.DEAD) && numRows > 0;
        }

        public void describeGroups() throws ExecutionException, InterruptedException {
            List groupIds;
            List list = groupIds = this.opts.options.has(this.opts.allGroupsOpt) ? this.listShareGroups() : this.opts.options.valuesOf(this.opts.groupOpt);
            if (this.opts.options.has(this.opts.membersOpt)) {
                TreeMap<String, ShareGroupDescription> members = this.collectGroupsDescription(groupIds);
                this.printMembers(members, this.opts.options.has(this.opts.verboseOpt));
            } else if (this.opts.options.has(this.opts.stateOpt)) {
                TreeMap<String, ShareGroupDescription> states = this.collectGroupsDescription(groupIds);
                this.printStates(states, this.opts.options.has(this.opts.verboseOpt));
            } else {
                TreeMap<String, Map.Entry<ShareGroupDescription, Collection<SharePartitionOffsetInformation>>> offsets = this.collectGroupsOffsets(groupIds);
                this.printOffsets(offsets, this.opts.options.has(this.opts.verboseOpt));
            }
        }

        Map<String, Throwable> deleteShareGroups() {
            List<GroupListing> shareGroupIds = this.listDetailedShareGroups();
            List groupIds = this.opts.options.has(this.opts.allGroupsOpt) ? shareGroupIds.stream().map(GroupListing::groupId).toList() : this.opts.options.valuesOf(this.opts.groupOpt);
            LinkedHashSet groupIdSet = new LinkedHashSet(groupIds);
            HashMap<String, IllegalArgumentException> errGroups = new HashMap<String, IllegalArgumentException>();
            for (String groupId : groupIdSet) {
                Optional<GroupListing> listing = shareGroupIds.stream().filter(item -> item.groupId().equals(groupId)).findAny();
                if (listing.isEmpty()) {
                    errGroups.put(groupId, new IllegalArgumentException("Group '" + groupId + "' is not a share group."));
                    continue;
                }
                Optional groupState = listing.get().groupState();
                groupState.ifPresent(state -> {
                    if (state == GroupState.DEAD) {
                        errGroups.put(groupId, (IllegalArgumentException)((Object)new IllegalStateException("Share group '" + groupId + "' group state is DEAD.")));
                    } else if (state != GroupState.EMPTY) {
                        errGroups.put(groupId, (IllegalArgumentException)new GroupNotEmptyException("Share group '" + groupId + "' is not EMPTY."));
                    }
                });
            }
            groupIdSet.removeAll(errGroups.keySet());
            Map groupsToDelete = groupIdSet.isEmpty() ? Map.of() : this.adminClient.deleteShareGroups(groupIdSet.stream().toList(), this.withTimeoutMs(new DeleteShareGroupsOptions())).deletedGroups();
            HashMap success = new HashMap();
            HashMap<String, Throwable> failed = new HashMap<String, Throwable>(errGroups);
            groupsToDelete.forEach((g, f) -> {
                try {
                    f.get();
                    success.put(g, null);
                }
                catch (InterruptedException ie) {
                    failed.put((String)g, ie);
                }
                catch (ExecutionException e) {
                    failed.put((String)g, e.getCause());
                }
            });
            if (failed.isEmpty()) {
                System.out.println("Deletion of requested share groups (" + success.keySet().stream().map(group -> "'" + group + "'").collect(Collectors.joining(", ")) + ") was successful.");
            } else {
                ShareGroupCommand.printError("Deletion of some share groups failed:", Optional.empty());
                failed.forEach((group, error) -> System.out.println("* Group '" + group + "' could not be deleted due to: " + String.valueOf(error)));
                if (!success.isEmpty()) {
                    System.out.println("\nThese share groups were deleted successfully: " + success.keySet().stream().map(group -> "'" + group + "'").collect(Collectors.joining(", ")));
                }
            }
            failed.putAll(success);
            return failed;
        }

        void deleteOffsets() {
            String groupId = (String)this.opts.options.valueOf(this.opts.groupOpt);
            List topics = this.opts.options.valuesOf(this.opts.topicOpt);
            Map.Entry<Throwable, Map<String, Throwable>> res = this.sendDeleteShareGroupOffsetsRequest(groupId, new HashSet<String>(topics));
            Throwable topLevelResult = res.getKey();
            Map<String, Throwable> topicLevelResult = res.getValue();
            if (topLevelResult != null) {
                Errors topLevelError = Errors.forException((Throwable)topLevelResult);
                switch (topLevelError) {
                    case INVALID_GROUP_ID: 
                    case GROUP_ID_NOT_FOUND: 
                    case GROUP_AUTHORIZATION_FAILED: 
                    case NON_EMPTY_GROUP: {
                        ShareGroupCommand.printError(topLevelResult.getMessage(), Optional.empty());
                        break;
                    }
                    case TOPIC_AUTHORIZATION_FAILED: 
                    case UNKNOWN_TOPIC_OR_PARTITION: {
                        break;
                    }
                    default: {
                        ShareGroupCommand.printError("Encounter some unknown error: " + String.valueOf(topLevelResult), Optional.empty());
                    }
                }
            }
            if (topicLevelResult != null && !topicLevelResult.isEmpty()) {
                int maxTopicLen = 15;
                for (String topic : topicLevelResult.keySet()) {
                    maxTopicLen = Math.max(maxTopicLen, topic.length());
                }
                String format = "%n%" + -maxTopicLen + "s %s";
                System.out.printf(format, "TOPIC", "STATUS");
                topicLevelResult.entrySet().stream().sorted(Map.Entry.comparingByKey()).forEach(e -> {
                    String topic = (String)e.getKey();
                    Throwable error = (Throwable)e.getValue();
                    System.out.printf(format, topic, error != null ? "Error: " + error.getMessage() : "Successful");
                });
            }
            System.out.println();
        }

        Map.Entry<Throwable, Map<String, Throwable>> sendDeleteShareGroupOffsetsRequest(String groupId, Set<String> topics) {
            HashMap topicLevelResult = new HashMap();
            DeleteShareGroupOffsetsResult deleteResult = this.adminClient.deleteShareGroupOffsets(groupId, new HashSet<String>(topics), this.withTimeoutMs(new DeleteShareGroupOffsetsOptions()));
            Throwable topLevelException = null;
            try {
                deleteResult.all().get();
            }
            catch (InterruptedException | ExecutionException e) {
                topLevelException = e.getCause();
            }
            topics.forEach(topic -> {
                try {
                    deleteResult.topicResult(topic).get();
                    topicLevelResult.put(topic, null);
                }
                catch (InterruptedException | ExecutionException e) {
                    topicLevelResult.put(topic, e.getCause());
                }
            });
            return new AbstractMap.SimpleImmutableEntry<Throwable, Map<String, Throwable>>(topLevelException, topicLevelResult);
        }

        void resetOffsets() {
            String groupId = (String)this.opts.options.valueOf(this.opts.groupOpt);
            try {
                ShareGroupDescription shareGroupDescription = this.describeShareGroups(List.of(groupId)).get(groupId);
                if (!GroupState.EMPTY.equals((Object)shareGroupDescription.groupState()) && !GroupState.DEAD.equals((Object)shareGroupDescription.groupState())) {
                    CommandLineUtils.printErrorAndExit((String)String.format("Share group '%s' is not empty.", groupId));
                }
                this.resetOffsetsForInactiveGroup(groupId);
            }
            catch (InterruptedException ie) {
                throw new RuntimeException(ie);
            }
            catch (ExecutionException ee) {
                Throwable cause = ee.getCause();
                if (cause instanceof GroupIdNotFoundException) {
                    this.resetOffsetsForInactiveGroup(groupId);
                }
                if (cause instanceof KafkaException) {
                    CommandLineUtils.printErrorAndExit((String)cause.getMessage());
                }
                throw new RuntimeException(cause);
            }
        }

        private void resetOffsetsForInactiveGroup(String groupId) {
            try {
                boolean dryRun;
                Collection<TopicPartition> partitionsToReset = this.getPartitionsToReset(groupId);
                Map<TopicPartition, OffsetAndMetadata> offsetsToReset = this.prepareOffsetsToReset(partitionsToReset);
                boolean bl = dryRun = this.opts.options.has(this.opts.dryRunOpt) || !this.opts.options.has(this.opts.executeOpt);
                if (!dryRun) {
                    this.adminClient.alterShareGroupOffsets(groupId, offsetsToReset.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ((OffsetAndMetadata)entry.getValue()).offset())), this.withTimeoutMs(new AlterShareGroupOffsetsOptions())).all().get();
                }
                OffsetsUtils.printOffsetsToReset(Map.of(groupId, offsetsToReset));
            }
            catch (InterruptedException ie) {
                throw new RuntimeException(ie);
            }
            catch (ExecutionException ee) {
                Throwable cause = ee.getCause();
                if (cause instanceof KafkaException) {
                    throw (KafkaException)cause;
                }
                throw new RuntimeException(cause);
            }
        }

        private Collection<TopicPartition> getPartitionsToReset(String groupId) throws ExecutionException, InterruptedException {
            Collection<Object> partitionsToReset;
            if (this.opts.options.has(this.opts.topicOpt)) {
                partitionsToReset = this.offsetsUtils.parseTopicPartitionsToReset(this.opts.options.valuesOf(this.opts.topicOpt));
            } else {
                Map<String, ListShareGroupOffsetsSpec> groupSpecs = Map.of(groupId, new ListShareGroupOffsetsSpec());
                Map offsetsByTopicPartitions = (Map)((Map)this.adminClient.listShareGroupOffsets(groupSpecs, this.withTimeoutMs(new ListShareGroupOffsetsOptions())).all().get()).get(groupId);
                partitionsToReset = offsetsByTopicPartitions.keySet();
            }
            return partitionsToReset;
        }

        private Map<TopicPartition, OffsetAndMetadata> prepareOffsetsToReset(Collection<TopicPartition> partitionsToReset) {
            this.offsetsUtils.checkAllTopicPartitionsValid(partitionsToReset);
            if (this.opts.options.has(this.opts.resetToEarliestOpt)) {
                return this.offsetsUtils.resetToEarliest(partitionsToReset);
            }
            if (this.opts.options.has(this.opts.resetToLatestOpt)) {
                return this.offsetsUtils.resetToLatest(partitionsToReset);
            }
            if (this.opts.options.has(this.opts.resetToDatetimeOpt)) {
                return this.offsetsUtils.resetToDateTime(partitionsToReset);
            }
            CommandLineUtils.printUsageAndExit((OptionParser)this.opts.parser, (String)String.format("Option '%s' requires one of the following scenarios: %s", this.opts.resetOffsetsOpt, this.opts.allResetOffsetScenarioOpts));
            return null;
        }

        private <T extends AbstractOptions<T>> T withTimeoutMs(T options) {
            int t = ((Long)this.opts.options.valueOf(this.opts.timeoutMsOpt)).intValue();
            return (T)options.timeoutMs(Integer.valueOf(t));
        }

        Map<String, ShareGroupDescription> describeShareGroups(Collection<String> groupIds) throws ExecutionException, InterruptedException {
            HashMap<String, ShareGroupDescription> res = new HashMap<String, ShareGroupDescription>();
            Map stringKafkaFutureMap = this.adminClient.describeShareGroups(groupIds, (DescribeShareGroupsOptions)new DescribeShareGroupsOptions().timeoutMs(Integer.valueOf(((Long)this.opts.options.valueOf(this.opts.timeoutMsOpt)).intValue()))).describedGroups();
            for (Map.Entry e : stringKafkaFutureMap.entrySet()) {
                res.put((String)e.getKey(), (ShareGroupDescription)((KafkaFuture)e.getValue()).get());
            }
            return res;
        }

        TreeMap<String, ShareGroupDescription> collectGroupsDescription(Collection<String> groupIds) throws ExecutionException, InterruptedException {
            Map<String, ShareGroupDescription> shareGroups = this.describeShareGroups(groupIds);
            TreeMap<String, ShareGroupDescription> res = new TreeMap<String, ShareGroupDescription>();
            res.putAll(shareGroups);
            return res;
        }

        TreeMap<String, Map.Entry<ShareGroupDescription, Collection<SharePartitionOffsetInformation>>> collectGroupsOffsets(Collection<String> groupIds) throws ExecutionException, InterruptedException {
            Map<String, ShareGroupDescription> shareGroups = this.describeShareGroups(groupIds);
            TreeMap<String, Map.Entry<ShareGroupDescription, Collection<SharePartitionOffsetInformation>>> groupOffsets = new TreeMap<String, Map.Entry<ShareGroupDescription, Collection<SharePartitionOffsetInformation>>>();
            shareGroups.forEach((groupId, shareGroup) -> {
                Map<String, ListShareGroupOffsetsSpec> groupSpecs = Map.of(groupId, new ListShareGroupOffsetsSpec());
                try {
                    Map offsetInfoMap = (Map)((Map)this.adminClient.listShareGroupOffsets(groupSpecs, this.withTimeoutMs(new ListShareGroupOffsetsOptions())).all().get()).get(groupId);
                    Set<SharePartitionOffsetInformation> partitionOffsets = ShareGroupService.mapOffsetInfoToSharePartitionInformation(groupId, offsetInfoMap);
                    groupOffsets.put((String)groupId, (Map.Entry<ShareGroupDescription, Collection<SharePartitionOffsetInformation>>)new AbstractMap.SimpleImmutableEntry<ShareGroupDescription, Set<SharePartitionOffsetInformation>>((ShareGroupDescription)shareGroup, partitionOffsets));
                }
                catch (InterruptedException | ExecutionException e) {
                    throw new RuntimeException(e);
                }
            });
            return groupOffsets;
        }

        private static Set<SharePartitionOffsetInformation> mapOffsetInfoToSharePartitionInformation(String groupId, Map<TopicPartition, SharePartitionOffsetInfo> offsetInfoMap) {
            HashSet<SharePartitionOffsetInformation> partitionOffsets = new HashSet<SharePartitionOffsetInformation>();
            offsetInfoMap.forEach((tp, offsetInfo) -> {
                if (offsetInfo != null) {
                    partitionOffsets.add(new SharePartitionOffsetInformation(groupId, tp.topic(), tp.partition(), Optional.of(offsetInfo.startOffset()), offsetInfo.leaderEpoch(), offsetInfo.lag()));
                } else {
                    partitionOffsets.add(new SharePartitionOffsetInformation(groupId, tp.topic(), tp.partition(), Optional.empty(), Optional.empty(), Optional.empty()));
                }
            });
            return partitionOffsets;
        }

        private void printOffsets(TreeMap<String, Map.Entry<ShareGroupDescription, Collection<SharePartitionOffsetInformation>>> offsets, boolean verbose) {
            offsets.forEach((groupId, tuple) -> {
                List<SharePartitionOffsetInformation> offsetsInfo = ((Collection)tuple.getValue()).stream().sorted(Comparator.comparing(info -> info.topic).thenComparingInt(info -> info.partition)).toList();
                if (offsetsInfo.isEmpty()) {
                    System.out.println("\nShare group '" + groupId + "' has no offset information.");
                } else {
                    String fmt = ShareGroupService.printOffsetFormat(groupId, offsetsInfo, verbose);
                    if (verbose) {
                        System.out.printf(fmt, "GROUP", "TOPIC", "PARTITION", "LEADER-EPOCH", "START-OFFSET", "LAG");
                    } else {
                        System.out.printf(fmt, "GROUP", "TOPIC", "PARTITION", "START-OFFSET", "LAG");
                    }
                    for (SharePartitionOffsetInformation info2 : offsetsInfo) {
                        if (verbose) {
                            System.out.printf(fmt, groupId, info2.topic, info2.partition, info2.leaderEpoch.map(Object::toString).orElse(ShareGroupCommand.MISSING_COLUMN_VALUE), info2.offset.map(Object::toString).orElse(ShareGroupCommand.MISSING_COLUMN_VALUE), info2.lag.map(Object::toString).orElse(ShareGroupCommand.MISSING_COLUMN_VALUE));
                            continue;
                        }
                        System.out.printf(fmt, groupId, info2.topic, info2.partition, info2.offset.map(Object::toString).orElse(ShareGroupCommand.MISSING_COLUMN_VALUE), info2.lag.map(Object::toString).orElse(ShareGroupCommand.MISSING_COLUMN_VALUE));
                    }
                    System.out.println();
                }
            });
        }

        private static String printOffsetFormat(String groupId, Collection<SharePartitionOffsetInformation> offsetsInfo, boolean verbose) {
            int groupLen = Math.max(15, groupId.length());
            int maxTopicLen = 15;
            for (SharePartitionOffsetInformation info : offsetsInfo) {
                maxTopicLen = Math.max(maxTopicLen, info.topic.length());
            }
            if (verbose) {
                return "\n%" + -groupLen + "s %" + -maxTopicLen + "s %-10s %-13s %-13s %s";
            }
            return "\n%" + -groupLen + "s %" + -maxTopicLen + "s %-10s %-13s %s";
        }

        private void printStates(Map<String, ShareGroupDescription> descriptions, boolean verbose) {
            descriptions.forEach((groupId, description) -> {
                ShareGroupService.maybePrintEmptyGroupState(groupId, description.groupState(), 1);
                int groupLen = Math.max(15, groupId.length());
                String coordinator = description.coordinator().host() + ":" + description.coordinator().port() + "  (" + description.coordinator().idString() + ")";
                int coordinatorLen = Math.max(25, coordinator.length());
                if (verbose) {
                    String fmt = "\n%" + -groupLen + "s %" + -coordinatorLen + "s %-15s %-12s %-17s %s";
                    System.out.printf(fmt, "GROUP", "COORDINATOR (ID)", "STATE", "GROUP-EPOCH", "ASSIGNMENT-EPOCH", "#MEMBERS");
                    System.out.printf(fmt, groupId, coordinator, description.groupState().toString(), description.groupEpoch(), description.targetAssignmentEpoch(), description.members().size());
                } else {
                    String fmt = "\n%" + -groupLen + "s %" + -coordinatorLen + "s %-15s %s";
                    System.out.printf(fmt, "GROUP", "COORDINATOR (ID)", "STATE", "#MEMBERS");
                    System.out.printf(fmt, groupId, coordinator, description.groupState().toString(), description.members().size());
                }
                System.out.println();
            });
        }

        private void printMembers(TreeMap<String, ShareGroupDescription> descriptions, boolean verbose) {
            descriptions.forEach((groupId, description) -> {
                int groupLen = Math.max(15, groupId.length());
                int maxConsumerIdLen = 15;
                int maxHostLen = 15;
                int maxClientIdLen = 15;
                List<ShareMemberDescription> members = description.members().stream().sorted(Comparator.comparing(ShareMemberDescription::consumerId)).toList();
                if (ShareGroupService.maybePrintEmptyGroupState(groupId, description.groupState(), description.members().size())) {
                    for (ShareMemberDescription member : members) {
                        maxConsumerIdLen = Math.max(maxConsumerIdLen, member.consumerId().length());
                        maxHostLen = Math.max(maxHostLen, member.host().length());
                        maxClientIdLen = Math.max(maxClientIdLen, member.clientId().length());
                    }
                    if (verbose) {
                        fmt = "\n%" + -groupLen + "s %" + -maxConsumerIdLen + "s %" + -maxHostLen + "s %" + -maxClientIdLen + "s %-12s %-13s %s";
                        System.out.printf(fmt, "GROUP", "CONSUMER-ID", "HOST", "CLIENT-ID", "#PARTITIONS", "MEMBER-EPOCH", "ASSIGNMENT");
                        for (ShareMemberDescription member : members) {
                            System.out.printf(fmt, groupId, member.consumerId(), member.host(), member.clientId(), member.assignment().topicPartitions().size(), member.memberEpoch(), this.getAssignmentString(member.assignment()));
                        }
                    } else {
                        fmt = "\n%" + -groupLen + "s %" + -maxConsumerIdLen + "s %" + -maxHostLen + "s %" + -maxClientIdLen + "s %-12s %s";
                        System.out.printf(fmt, "GROUP", "CONSUMER-ID", "HOST", "CLIENT-ID", "#PARTITIONS", "ASSIGNMENT");
                        for (ShareMemberDescription member : members) {
                            System.out.printf(fmt, groupId, member.consumerId(), member.host(), member.clientId(), member.assignment().topicPartitions().size(), this.getAssignmentString(member.assignment()));
                        }
                    }
                    System.out.println();
                }
            });
        }

        private String getAssignmentString(ShareMemberAssignment assignment) {
            HashMap grouped = new HashMap();
            assignment.topicPartitions().forEach(tp -> grouped.computeIfAbsent(tp.topic(), key -> new ArrayList()).add(tp));
            return grouped.entrySet().stream().map(entry -> {
                String topicName = (String)entry.getKey();
                List topicPartitions = (List)entry.getValue();
                return topicPartitions.stream().map(TopicPartition::partition).sorted().map(Object::toString).collect(Collectors.joining(",", topicName + ":", ""));
            }).sorted().collect(Collectors.joining(";"));
        }

        @Override
        public void close() {
            this.adminClient.close();
        }

        protected Admin createAdminClient(Map<String, String> configOverrides) throws IOException {
            Properties props = this.opts.options.has(this.opts.commandConfigOpt) ? Utils.loadProps((String)((String)this.opts.options.valueOf(this.opts.commandConfigOpt))) : new Properties();
            props.put("bootstrap.servers", this.opts.options.valueOf(this.opts.bootstrapServerOpt));
            props.putAll(configOverrides);
            return Admin.create((Properties)props);
        }
    }

    record SharePartitionOffsetInformation(String group, String topic, int partition, Optional<Long> offset, Optional<Integer> leaderEpoch, Optional<Long> lag) {
    }
}

