/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.server.util.timer;

import java.util.concurrent.DelayQueue;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.kafka.server.util.timer.TimerTaskEntry;
import org.apache.kafka.server.util.timer.TimerTaskList;

public class TimingWheel {
    private final long tickMs;
    private final int wheelSize;
    private final AtomicInteger taskCounter;
    private final DelayQueue<TimerTaskList> queue;
    private final long interval;
    private final TimerTaskList[] buckets;
    private long currentTimeMs;
    private volatile TimingWheel overflowWheel = null;

    TimingWheel(long tickMs, int wheelSize, long startMs, AtomicInteger taskCounter, DelayQueue<TimerTaskList> queue) {
        this.tickMs = tickMs;
        this.wheelSize = wheelSize;
        this.taskCounter = taskCounter;
        this.queue = queue;
        this.buckets = new TimerTaskList[wheelSize];
        this.interval = tickMs * (long)wheelSize;
        this.currentTimeMs = startMs - startMs % tickMs;
        for (int i = 0; i < this.buckets.length; ++i) {
            this.buckets[i] = new TimerTaskList(taskCounter);
        }
    }

    private synchronized void addOverflowWheel() {
        if (this.overflowWheel == null) {
            this.overflowWheel = new TimingWheel(this.interval, this.wheelSize, this.currentTimeMs, this.taskCounter, this.queue);
        }
    }

    public boolean add(TimerTaskEntry timerTaskEntry) {
        long expiration = timerTaskEntry.expirationMs;
        if (timerTaskEntry.cancelled()) {
            return false;
        }
        if (expiration < this.currentTimeMs + this.tickMs) {
            return false;
        }
        if (expiration < this.currentTimeMs + this.interval) {
            long virtualId = expiration / this.tickMs;
            int bucketId = (int)(virtualId % (long)this.wheelSize);
            TimerTaskList bucket = this.buckets[bucketId];
            bucket.add(timerTaskEntry);
            if (bucket.setExpiration(virtualId * this.tickMs)) {
                this.queue.offer(bucket);
            }
            return true;
        }
        if (this.overflowWheel == null) {
            this.addOverflowWheel();
        }
        return this.overflowWheel.add(timerTaskEntry);
    }

    public void advanceClock(long timeMs) {
        if (timeMs >= this.currentTimeMs + this.tickMs) {
            this.currentTimeMs = timeMs - timeMs % this.tickMs;
            if (this.overflowWheel != null) {
                this.overflowWheel.advanceClock(this.currentTimeMs);
            }
        }
    }

    TimingWheel overflowWheel() {
        return this.overflowWheel;
    }

    long currentTimeMs() {
        return this.currentTimeMs;
    }
}

