/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream.internals;

import java.time.Duration;
import java.util.Objects;
import java.util.Optional;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.streams.kstream.KeyValueMapper;
import org.apache.kafka.streams.kstream.ValueJoinerWithKey;
import org.apache.kafka.streams.kstream.internals.KStreamKTableJoin;
import org.apache.kafka.streams.kstream.internals.KTableValueGetter;
import org.apache.kafka.streams.processor.api.ContextualProcessor;
import org.apache.kafka.streams.processor.api.ProcessorContext;
import org.apache.kafka.streams.processor.api.Record;
import org.apache.kafka.streams.processor.api.RecordMetadata;
import org.apache.kafka.streams.processor.internals.InternalProcessorContext;
import org.apache.kafka.streams.processor.internals.ProcessorContextUtils;
import org.apache.kafka.streams.processor.internals.ProcessorRecordContext;
import org.apache.kafka.streams.processor.internals.SerdeGetter;
import org.apache.kafka.streams.processor.internals.metrics.StreamsMetricsImpl;
import org.apache.kafka.streams.processor.internals.metrics.TaskMetrics;
import org.apache.kafka.streams.state.ValueAndTimestamp;
import org.apache.kafka.streams.state.internals.TimeOrderedKeyValueBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class KStreamKTableJoinProcessor<StreamKey, StreamValue, TableKey, TableValue, VOut>
extends ContextualProcessor<StreamKey, StreamValue, StreamKey, VOut> {
    private static final Logger LOG = LoggerFactory.getLogger(KStreamKTableJoin.class);
    private final KTableValueGetter<TableKey, TableValue> valueGetter;
    private final KeyValueMapper<? super StreamKey, ? super StreamValue, ? extends TableKey> keyMapper;
    private final ValueJoinerWithKey<? super StreamKey, ? super StreamValue, ? super TableValue, ? extends VOut> joiner;
    private final boolean leftJoin;
    private Sensor droppedRecordsSensor;
    private final Optional<Duration> gracePeriod;
    private TimeOrderedKeyValueBuffer<StreamKey, StreamValue, StreamValue> buffer;
    protected long observedStreamTime = -1L;
    private InternalProcessorContext<StreamKey, VOut> internalProcessorContext;
    private final boolean useBuffer;
    private final String storeName;

    KStreamKTableJoinProcessor(KTableValueGetter<TableKey, TableValue> valueGetter, KeyValueMapper<? super StreamKey, ? super StreamValue, ? extends TableKey> keyMapper, ValueJoinerWithKey<? super StreamKey, ? super StreamValue, ? super TableValue, ? extends VOut> joiner, boolean leftJoin, Optional<Duration> gracePeriod, Optional<String> storeName) {
        this.valueGetter = valueGetter;
        this.keyMapper = keyMapper;
        this.joiner = joiner;
        this.leftJoin = leftJoin;
        this.useBuffer = gracePeriod.isPresent();
        this.gracePeriod = gracePeriod;
        this.storeName = storeName.orElse("");
    }

    @Override
    public void init(ProcessorContext<StreamKey, VOut> context) {
        super.init(context);
        StreamsMetricsImpl metrics = (StreamsMetricsImpl)context.metrics();
        this.droppedRecordsSensor = TaskMetrics.droppedRecordsSensor(Thread.currentThread().getName(), context.taskId().toString(), metrics);
        this.valueGetter.init(context);
        this.internalProcessorContext = ProcessorContextUtils.asInternalProcessorContext(context);
        if (this.useBuffer) {
            if (!this.valueGetter.isVersioned() && this.gracePeriod.isPresent()) {
                throw new IllegalArgumentException("KTable must be versioned to use a grace period in a stream table join.");
            }
            this.buffer = Objects.requireNonNull((TimeOrderedKeyValueBuffer)context.getStateStore(this.storeName));
            this.buffer.setSerdesIfNull(new SerdeGetter(context));
        }
    }

    @Override
    public void process(Record<StreamKey, StreamValue> record) {
        this.updateObservedStreamTime(record.timestamp());
        if (this.maybeDropRecord(record)) {
            return;
        }
        if (!this.useBuffer) {
            this.doJoin(record);
        } else if (!this.buffer.put(this.observedStreamTime, record, this.internalProcessorContext.recordContext())) {
            this.doJoin(record);
        } else {
            this.buffer.evictWhile(() -> true, this::emit);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void emit(TimeOrderedKeyValueBuffer.Eviction<StreamKey, StreamValue> toEmit) {
        Record<StreamKey, StreamValue> record = new Record<StreamKey, StreamValue>(toEmit.key(), toEmit.value(), toEmit.recordContext().timestamp()).withHeaders(toEmit.recordContext().headers());
        ProcessorRecordContext prevRecordContext = this.internalProcessorContext.recordContext();
        try {
            this.internalProcessorContext.setRecordContext(toEmit.recordContext());
            this.doJoin(record);
        }
        finally {
            this.internalProcessorContext.setRecordContext(prevRecordContext);
        }
    }

    protected void updateObservedStreamTime(long timestamp) {
        this.observedStreamTime = Math.max(this.observedStreamTime, timestamp);
    }

    private void doJoin(Record<StreamKey, StreamValue> record) {
        TableKey mappedKey = this.keyMapper.apply(record.key(), record.value());
        TableValue value2 = this.getTableValue(record, mappedKey);
        if (this.leftJoin || value2 != null) {
            this.internalProcessorContext.forward(record.withValue(this.joiner.apply(record.key(), record.value(), value2)));
        }
    }

    private TableValue getTableValue(Record<StreamKey, StreamValue> record, TableKey mappedKey) {
        if (mappedKey == null) {
            return null;
        }
        ValueAndTimestamp<TableValue> valueAndTimestamp = this.valueGetter.isVersioned() ? this.valueGetter.get(mappedKey, record.timestamp()) : this.valueGetter.get(mappedKey);
        return ValueAndTimestamp.getValueOrNull(valueAndTimestamp);
    }

    private boolean maybeDropRecord(Record<StreamKey, StreamValue> record) {
        TableKey mappedKey = this.keyMapper.apply(record.key(), record.value());
        if (this.leftJoin && mappedKey == null && record.value() != null) {
            return false;
        }
        if (mappedKey == null || record.value() == null) {
            if (this.context().recordMetadata().isPresent()) {
                RecordMetadata recordMetadata = this.context().recordMetadata().get();
                LOG.warn("Skipping record due to null join key or value. topic=[{}] partition=[{}] offset=[{}]", new Object[]{recordMetadata.topic(), recordMetadata.partition(), recordMetadata.offset()});
            } else {
                LOG.warn("Skipping record due to null join key or value. Topic, partition, and offset not known.");
            }
            this.droppedRecordsSensor.record();
            return true;
        }
        return false;
    }

    @Override
    public void close() {
        this.valueGetter.close();
    }
}

