/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.facet.sortedset;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicIntegerArray;
import org.apache.lucene.facet.FacetUtils;
import org.apache.lucene.facet.FacetsCollector;
import org.apache.lucene.facet.sortedset.AbstractSortedSetDocValueFacetCounts;
import org.apache.lucene.facet.sortedset.SortedSetDocValuesReaderState;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.DocValuesIterator;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.MultiDocValues;
import org.apache.lucene.index.OrdinalMap;
import org.apache.lucene.index.ReaderUtil;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.search.ConjunctionUtils;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.IOUtils;
import org.apache.lucene.util.LongValues;

public class ConcurrentSortedSetDocValuesFacetCounts
extends AbstractSortedSetDocValueFacetCounts {
    final ExecutorService exec;
    final AtomicIntegerArray counts;

    public ConcurrentSortedSetDocValuesFacetCounts(SortedSetDocValuesReaderState state, ExecutorService exec) throws IOException, InterruptedException {
        this(state, null, exec);
    }

    public ConcurrentSortedSetDocValuesFacetCounts(SortedSetDocValuesReaderState state, FacetsCollector hits, ExecutorService exec) throws IOException, InterruptedException {
        super(state);
        this.exec = exec;
        this.counts = new AtomicIntegerArray(state.getSize());
        if (hits == null) {
            this.countAll();
        } else {
            this.count(hits.getMatchingDocs());
        }
    }

    @Override
    boolean hasCounts() {
        return true;
    }

    @Override
    int getCount(int ord) {
        return this.counts.get(ord);
    }

    private void count(List<FacetsCollector.MatchingDocs> matchingDocs) throws IOException, InterruptedException {
        OrdinalMap ordinalMap = this.dv instanceof MultiDocValues.MultiSortedSetDocValues && matchingDocs.size() > 1 ? ((MultiDocValues.MultiSortedSetDocValues)this.dv).mapping : null;
        IndexReader reader = this.state.getReader();
        ArrayList<Future<Void>> results = new ArrayList<Future<Void>>();
        for (FacetsCollector.MatchingDocs matchingDocs2 : matchingDocs) {
            if (ReaderUtil.getTopLevelContext(matchingDocs2.context()).reader() != reader) {
                throw new IllegalStateException("the SortedSetDocValuesReaderState provided to this class does not match the reader being searched; you must create a new SortedSetDocValuesReaderState every time you open a new IndexReader");
            }
            results.add(this.exec.submit(new CountOneSegment(matchingDocs2.context().reader(), matchingDocs2, ordinalMap, matchingDocs2.context().ord)));
        }
        for (Future future : results) {
            try {
                future.get();
            }
            catch (ExecutionException ee) {
                Throwable cause = ee.getCause();
                throw IOUtils.rethrowAlways(cause != null ? cause : ee);
            }
        }
    }

    private void countAll() throws IOException, InterruptedException {
        OrdinalMap ordinalMap = this.dv instanceof MultiDocValues.MultiSortedSetDocValues ? ((MultiDocValues.MultiSortedSetDocValues)this.dv).mapping : null;
        ArrayList<Future<Void>> results = new ArrayList<Future<Void>>();
        for (LeafReaderContext leafReaderContext : this.state.getReader().leaves()) {
            results.add(this.exec.submit(new CountOneSegment(leafReaderContext.reader(), null, ordinalMap, leafReaderContext.ord)));
        }
        for (Future future : results) {
            try {
                future.get();
            }
            catch (ExecutionException ee) {
                Throwable cause = ee.getCause();
                throw IOUtils.rethrowAlways(cause != null ? cause : ee);
            }
        }
    }

    private class CountOneSegment
    implements Callable<Void> {
        final LeafReader leafReader;
        final FacetsCollector.MatchingDocs hits;
        final OrdinalMap ordinalMap;
        final int segOrd;

        public CountOneSegment(LeafReader leafReader, FacetsCollector.MatchingDocs hits, OrdinalMap ordinalMap, int segOrd) {
            assert (leafReader != null);
            this.leafReader = leafReader;
            this.hits = hits;
            this.ordinalMap = ordinalMap;
            this.segOrd = segOrd;
        }

        @Override
        public Void call() throws IOException {
            Bits liveDocs;
            DocValuesIterator valuesIt;
            if (this.hits != null && this.hits.totalHits() == 0) {
                return null;
            }
            SortedSetDocValues multiValues = DocValues.getSortedSet(this.leafReader, ConcurrentSortedSetDocValuesFacetCounts.this.field);
            if (multiValues == null) {
                return null;
            }
            SortedDocValues singleValues = DocValues.unwrapSingleton(multiValues);
            DocValuesIterator docValuesIterator = valuesIt = singleValues != null ? singleValues : multiValues;
            DocIdSetIterator it = this.hits == null ? ((liveDocs = this.leafReader.getLiveDocs()) != null ? FacetUtils.liveDocsDISI(valuesIt, liveDocs) : valuesIt) : ConjunctionUtils.intersectIterators(Arrays.asList(this.hits.bits().iterator(), valuesIt));
            if (this.ordinalMap != null) {
                LongValues ordMap = this.ordinalMap.getGlobalOrds(this.segOrd);
                int numSegOrds = (int)multiValues.getValueCount();
                if (this.hits != null && this.hits.totalHits() < numSegOrds / 10) {
                    if (singleValues != null) {
                        if (singleValues == it) {
                            int doc = singleValues.nextDoc();
                            while (doc != Integer.MAX_VALUE) {
                                ConcurrentSortedSetDocValuesFacetCounts.this.counts.incrementAndGet((int)ordMap.get(singleValues.ordValue()));
                                doc = singleValues.nextDoc();
                            }
                        } else {
                            int doc = it.nextDoc();
                            while (doc != Integer.MAX_VALUE) {
                                ConcurrentSortedSetDocValuesFacetCounts.this.counts.incrementAndGet((int)ordMap.get(singleValues.ordValue()));
                                doc = it.nextDoc();
                            }
                        }
                    } else if (multiValues == it) {
                        int doc = multiValues.nextDoc();
                        while (doc != Integer.MAX_VALUE) {
                            for (int i = 0; i < multiValues.docValueCount(); ++i) {
                                int term = (int)multiValues.nextOrd();
                                ConcurrentSortedSetDocValuesFacetCounts.this.counts.incrementAndGet((int)ordMap.get(term));
                            }
                            doc = multiValues.nextDoc();
                        }
                    } else {
                        int doc = it.nextDoc();
                        while (doc != Integer.MAX_VALUE) {
                            for (int i = 0; i < multiValues.docValueCount(); ++i) {
                                int term = (int)multiValues.nextOrd();
                                ConcurrentSortedSetDocValuesFacetCounts.this.counts.incrementAndGet((int)ordMap.get(term));
                            }
                            doc = it.nextDoc();
                        }
                    }
                } else {
                    int[] segCounts = new int[numSegOrds];
                    if (singleValues != null) {
                        if (singleValues == it) {
                            doc = singleValues.nextDoc();
                            while (doc != Integer.MAX_VALUE) {
                                int n = singleValues.ordValue();
                                segCounts[n] = segCounts[n] + 1;
                                doc = singleValues.nextDoc();
                            }
                        } else {
                            doc = it.nextDoc();
                            while (doc != Integer.MAX_VALUE) {
                                int n = singleValues.ordValue();
                                segCounts[n] = segCounts[n] + 1;
                                doc = it.nextDoc();
                            }
                        }
                    } else if (multiValues == it) {
                        doc = multiValues.nextDoc();
                        while (doc != Integer.MAX_VALUE) {
                            for (i = 0; i < multiValues.docValueCount(); ++i) {
                                int n = term = (int)multiValues.nextOrd();
                                segCounts[n] = segCounts[n] + 1;
                            }
                            doc = multiValues.nextDoc();
                        }
                    } else {
                        doc = it.nextDoc();
                        while (doc != Integer.MAX_VALUE) {
                            for (i = 0; i < multiValues.docValueCount(); ++i) {
                                int n = term = (int)multiValues.nextOrd();
                                segCounts[n] = segCounts[n] + 1;
                            }
                            doc = it.nextDoc();
                        }
                    }
                    for (int ord = 0; ord < numSegOrds; ++ord) {
                        int count = segCounts[ord];
                        if (count == 0) continue;
                        ConcurrentSortedSetDocValuesFacetCounts.this.counts.addAndGet((int)ordMap.get(ord), count);
                    }
                }
            } else if (singleValues != null) {
                if (singleValues == it) {
                    int doc = singleValues.nextDoc();
                    while (doc != Integer.MAX_VALUE) {
                        ConcurrentSortedSetDocValuesFacetCounts.this.counts.incrementAndGet(singleValues.ordValue());
                        doc = singleValues.nextDoc();
                    }
                } else {
                    int doc = it.nextDoc();
                    while (doc != Integer.MAX_VALUE) {
                        ConcurrentSortedSetDocValuesFacetCounts.this.counts.incrementAndGet(singleValues.ordValue());
                        doc = it.nextDoc();
                    }
                }
            } else if (multiValues == it) {
                int doc = multiValues.nextDoc();
                while (doc != Integer.MAX_VALUE) {
                    for (int i = 0; i < multiValues.docValueCount(); ++i) {
                        int term = (int)multiValues.nextOrd();
                        ConcurrentSortedSetDocValuesFacetCounts.this.counts.incrementAndGet(term);
                    }
                    doc = multiValues.nextDoc();
                }
            } else {
                int doc = it.nextDoc();
                while (doc != Integer.MAX_VALUE) {
                    for (int i = 0; i < multiValues.docValueCount(); ++i) {
                        int term = (int)multiValues.nextOrd();
                        ConcurrentSortedSetDocValuesFacetCounts.this.counts.incrementAndGet(term);
                    }
                    doc = it.nextDoc();
                }
            }
            return null;
        }
    }
}

