/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.fuseki.access;

import org.apache.jena.assembler.Assembler;
import org.apache.jena.assembler.Mode;
import org.apache.jena.assembler.assemblers.AssemblerBase;
import org.apache.jena.assembler.exceptions.AssemblerException;
import org.apache.jena.fuseki.access.AuthorizationService;
import org.apache.jena.fuseki.access.DatasetGraphAccessControl;
import org.apache.jena.fuseki.access.VocabSecurity;
import org.apache.jena.query.Dataset;
import org.apache.jena.query.DatasetFactory;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.util.graph.GraphUtils;

public class AssemblerAccessDataset
extends AssemblerBase {
    @Override
    public Dataset open(Assembler a, Resource root2, Mode mode) {
        if (!GraphUtils.exactlyOneProperty(root2, VocabSecurity.pSecurityRegistry)) {
            throw new AssemblerException(root2, "Expected exactly one access:registry property");
        }
        if (!GraphUtils.exactlyOneProperty(root2, VocabSecurity.pDataset)) {
            throw new AssemblerException(root2, "Expected exactly one access:dataset property");
        }
        RDFNode rnRegistry = root2.getProperty(VocabSecurity.pSecurityRegistry).getObject();
        RDFNode rnDataset = root2.getProperty(VocabSecurity.pDataset).getObject();
        AuthorizationService sr = (AuthorizationService)a.open(rnRegistry.asResource());
        DatasetGraph dsgBase = ((Dataset)a.open(rnDataset.asResource())).asDatasetGraph();
        DatasetGraphAccessControl dsg = new DatasetGraphAccessControl(dsgBase, sr);
        return DatasetFactory.wrap(dsg);
    }
}

