/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.session;

import java.util.concurrent.TimeUnit;
import org.eclipse.jetty.io.CyclicTimeout;
import org.eclipse.jetty.session.ManagedSession;
import org.eclipse.jetty.session.SessionManager;
import org.eclipse.jetty.util.thread.AutoLock;
import org.eclipse.jetty.util.thread.Scheduler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SessionInactivityTimer {
    private static final Logger LOG = LoggerFactory.getLogger(SessionInactivityTimer.class);
    private final SessionManager _sessionManager;
    private final Scheduler _scheduler;
    private final CyclicTimeout _timer;
    private final ManagedSession _session;

    public SessionInactivityTimer(SessionManager sessionManager, ManagedSession session, Scheduler scheduler) {
        this._sessionManager = sessionManager;
        this._session = session;
        this._scheduler = scheduler;
        this._timer = new CyclicTimeout(this._scheduler){

            @Override
            public void onTimeoutExpired() {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Timer expired for session {}", (Object)SessionInactivityTimer.this._session.getId());
                }
                long now2 = System.currentTimeMillis();
                try (AutoLock lock = SessionInactivityTimer.this._session.lock();){
                    if (SessionInactivityTimer.this._session.getRequests() > 0L) {
                        return;
                    }
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Inspecting session {}, valid={}", (Object)SessionInactivityTimer.this._session.getId(), (Object)SessionInactivityTimer.this._session.isValid());
                    }
                    if (!SessionInactivityTimer.this._session.isValid()) {
                        return;
                    }
                    SessionInactivityTimer.this._sessionManager.sessionTimerExpired(SessionInactivityTimer.this._session, now2);
                    if (SessionInactivityTimer.this._session.isResident() && SessionInactivityTimer.this._session.getRequests() <= 0L && SessionInactivityTimer.this._session.isValid() && !SessionInactivityTimer.this._session.isExpiredAt(now2)) {
                        SessionInactivityTimer.this.schedule(SessionInactivityTimer.this._session.calculateInactivityTimeout(now2));
                    }
                }
            }
        };
    }

    public void schedule(long time) {
        if (time >= 0L) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("(Re)starting timer for session {} at {}ms", (Object)this._session.getId(), (Object)time);
            }
            this._timer.schedule(time, TimeUnit.MILLISECONDS);
        } else if (LOG.isDebugEnabled()) {
            LOG.debug("Not starting timer for session {}", (Object)this._session.getId());
        }
    }

    public void cancel() {
        this._timer.cancel();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Cancelled timer for session {}", (Object)this._session.getId());
        }
    }

    public void destroy() {
        this._timer.destroy();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Destroyed timer for session {}", (Object)this._session.getId());
        }
    }
}

