/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.converter;

import java.lang.reflect.Array;
import java.util.EnumSet;
import java.util.Set;
import org.apache.sis.converter.SystemConverter;
import org.apache.sis.math.FunctionProperty;
import org.apache.sis.util.Numbers;
import org.apache.sis.util.ObjectConverter;
import org.apache.sis.util.UnconvertibleObjectException;

final class ArrayConverter<S, T>
extends SystemConverter<S, T> {
    private static final long serialVersionUID = 7108976709306360737L;
    private static final EnumSet<FunctionProperty> PROPERTIES = EnumSet.of(FunctionProperty.INVERTIBLE, FunctionProperty.INJECTIVE, FunctionProperty.SURJECTIVE);
    private final ObjectConverter<?, ?> converter;

    ArrayConverter(Class<S> sourceClass, Class<T> targetClass, ObjectConverter<?, ?> converter) {
        super(sourceClass, targetClass);
        assert (converter.getSourceClass().isAssignableFrom(Numbers.primitiveToWrapper(sourceClass.getComponentType()))) : sourceClass;
        assert (Numbers.primitiveToWrapper(targetClass.getComponentType()).isAssignableFrom(converter.getTargetClass())) : targetClass;
        this.converter = converter;
    }

    @Override
    public Set<FunctionProperty> properties() {
        EnumSet<FunctionProperty> properties = EnumSet.copyOf(this.converter.properties());
        properties.retainAll(PROPERTIES);
        return properties;
    }

    @Override
    public T apply(S source) throws UnconvertibleObjectException {
        if (source == null) {
            return null;
        }
        int length = Array.getLength(source);
        Object target = Array.newInstance(this.targetClass.getComponentType(), length);
        for (int i = 0; i < length; ++i) {
            Array.set(target, i, this.converter.apply(Array.get(source, i)));
        }
        return (T)target;
    }
}

