/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.engine.optimizer.reorder;

import org.apache.jena.atlas.logging.Log;
import org.apache.jena.graph.Triple;
import org.apache.jena.sparql.ARQException;
import org.apache.jena.sparql.core.BasicPattern;
import org.apache.jena.sparql.engine.optimizer.reorder.ReorderProc;

public class ReorderProcIndexes
implements ReorderProc {
    private int[] indexes;

    public ReorderProcIndexes(int[] indexes) {
        this.indexes = indexes;
    }

    @Override
    public BasicPattern reorder(BasicPattern bgp) {
        if (this.indexes.length != bgp.size()) {
            String str2 = String.format("Expected size = %d : actual basic pattern size = %d", this.indexes.length, bgp.size());
            Log.error((Object)this, (String)str2);
            throw new ARQException(str2);
        }
        BasicPattern bgp2 = new BasicPattern();
        for (int idx : this.indexes) {
            Triple t = bgp.get(idx);
            bgp2.add(t);
        }
        return bgp2;
    }

    public String toString() {
        Object x = "";
        String sep = "";
        for (int idx : this.indexes) {
            x = (String)x + sep + idx;
            sep = ", ";
        }
        return x;
    }
}

